import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeGlobalAddressConfig extends cdktf.TerraformMetaArguments {
    /**
     * The IP address or beginning of the address range represented by this resource.
     *
     * This can be supplied as an input to reserve a specific
     * address or omitted to allow GCP to choose a valid one for you.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#address ComputeGlobalAddress#address}
     *
     * @stability stable
     */
    readonly address?: string;
    /**
     * The type of the address to reserve.
     *
     * EXTERNAL indicates public/external single IP address.
     * INTERNAL indicates internal IP ranges belonging to some network. Default value: "EXTERNAL" Possible values: ["EXTERNAL", "INTERNAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#address_type ComputeGlobalAddress#address_type}
     *
     * @stability stable
     */
    readonly addressType?: string;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#description ComputeGlobalAddress#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The IP Version that will be used by this address. The default value is 'IPV4'. Possible values: ["IPV4", "IPV6"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#ip_version ComputeGlobalAddress#ip_version}
     *
     * @stability stable
     */
    readonly ipVersion?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#name ComputeGlobalAddress#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The URL of the network in which to reserve the IP range.
     *
     * The IP range
     * must be in RFC1918 space. The network cannot be deleted if there are
     * any reserved IP ranges referring to it.
     *
     * This should only be set when using an Internal address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#network ComputeGlobalAddress#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * The prefix length of the IP range. If not present, it means the address field is a single IP address.
     *
     * This field is not applicable to addresses with addressType=EXTERNAL,
     * or addressType=INTERNAL when purpose=PRIVATE_SERVICE_CONNECT
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#prefix_length ComputeGlobalAddress#prefix_length}
     *
     * @stability stable
     */
    readonly prefixLength?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#project ComputeGlobalAddress#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The purpose of the resource. Possible values include:.
     *
     * VPC_PEERING - for peer networks
     *
     * PRIVATE_SERVICE_CONNECT - for ([Beta](https://terraform.io/docs/providers/google/guides/provider_versions.html) only) Private Service Connect networks
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#purpose ComputeGlobalAddress#purpose}
     *
     * @stability stable
     */
    readonly purpose?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#timeouts ComputeGlobalAddress#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeGlobalAddressTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeGlobalAddressTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#create ComputeGlobalAddress#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address#delete ComputeGlobalAddress#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeGlobalAddressTimeoutsToTerraform(struct?: ComputeGlobalAddressTimeoutsOutputReference | ComputeGlobalAddressTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeGlobalAddressTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeGlobalAddressTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeGlobalAddressTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_global_address google_compute_global_address}.
 *
 * @stability stable
 */
export declare class ComputeGlobalAddress extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_global_address google_compute_global_address} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeGlobalAddressConfig);
    private _address?;
    /**
     * @stability stable
     */
    get address(): string;
    /**
     * @stability stable
     */
    set address(value: string);
    /**
     * @stability stable
     */
    resetAddress(): void;
    /**
     * @stability stable
     */
    get addressInput(): string | undefined;
    private _addressType?;
    /**
     * @stability stable
     */
    get addressType(): string;
    /**
     * @stability stable
     */
    set addressType(value: string);
    /**
     * @stability stable
     */
    resetAddressType(): void;
    /**
     * @stability stable
     */
    get addressTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipVersion?;
    /**
     * @stability stable
     */
    get ipVersion(): string;
    /**
     * @stability stable
     */
    set ipVersion(value: string);
    /**
     * @stability stable
     */
    resetIpVersion(): void;
    /**
     * @stability stable
     */
    get ipVersionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _prefixLength?;
    /**
     * @stability stable
     */
    get prefixLength(): number;
    /**
     * @stability stable
     */
    set prefixLength(value: number);
    /**
     * @stability stable
     */
    resetPrefixLength(): void;
    /**
     * @stability stable
     */
    get prefixLengthInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _purpose?;
    /**
     * @stability stable
     */
    get purpose(): string;
    /**
     * @stability stable
     */
    set purpose(value: string);
    /**
     * @stability stable
     */
    resetPurpose(): void;
    /**
     * @stability stable
     */
    get purposeInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeGlobalAddressTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeGlobalAddressTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeGlobalAddressTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
