import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether to allow sending and receiving of packets with non-matching source or destination IPs. This defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#can_ip_forward ComputeInstanceTemplate#can_ip_forward}
     *
     * @stability stable
     */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
     * A brief description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#description ComputeInstanceTemplate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Enable Virtual Displays on this instance. Note: allow_stopping_for_update must be set to true in order to update this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#enable_display ComputeInstanceTemplate#enable_display}
     *
     * @stability stable
     */
    readonly enableDisplay?: boolean | cdktf.IResolvable;
    /**
     * A description of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#instance_description ComputeInstanceTemplate#instance_description}
     *
     * @stability stable
     */
    readonly instanceDescription?: string;
    /**
     * A set of key/value label pairs to assign to instances created from this template,.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#labels ComputeInstanceTemplate#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The machine type to create.
     *
     * To create a machine with a custom type (such as extended memory), format the value like custom-VCPUS-MEM_IN_MB like custom-6-20480 for 6 vCPU and 20GB of RAM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#machine_type ComputeInstanceTemplate#machine_type}
     *
     * @stability stable
     */
    readonly machineType: string;
    /**
     * Metadata key/value pairs to make available from within instances created from this template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#metadata ComputeInstanceTemplate#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * An alternative to using the startup-script metadata key, mostly to match the compute_instance resource.
     *
     * This replaces the startup-script metadata key on the created instance and thus the two mechanisms are not allowed to be used simultaneously.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#metadata_startup_script ComputeInstanceTemplate#metadata_startup_script}
     *
     * @stability stable
     */
    readonly metadataStartupScript?: string;
    /**
     * Specifies a minimum CPU platform.
     *
     * Applicable values are the friendly names of CPU platforms, such as Intel Haswell or Intel Skylake.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#min_cpu_platform ComputeInstanceTemplate#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * The name of the instance template. If you leave this blank, Terraform will auto-generate a unique name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#name ComputeInstanceTemplate#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#name_prefix ComputeInstanceTemplate#name_prefix}
     *
     * @stability stable
     */
    readonly namePrefix?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#project ComputeInstanceTemplate#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * An instance template is a global resource that is not bound to a zone or a region.
     *
     * However, you can still specify some regional resources in an instance template, which restricts the template to the region where that resource resides. For example, a custom subnetwork resource is tied to a specific region. Defaults to the region of the Provider if no value is given.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#region ComputeInstanceTemplate#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Tags to attach to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#tags ComputeInstanceTemplate#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * advanced_machine_features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#advanced_machine_features ComputeInstanceTemplate#advanced_machine_features}
     *
     * @stability stable
     */
    readonly advancedMachineFeatures?: ComputeInstanceTemplateAdvancedMachineFeatures;
    /**
     * confidential_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#confidential_instance_config ComputeInstanceTemplate#confidential_instance_config}
     *
     * @stability stable
     */
    readonly confidentialInstanceConfig?: ComputeInstanceTemplateConfidentialInstanceConfig;
    /**
     * disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#disk ComputeInstanceTemplate#disk}
     *
     * @stability stable
     */
    readonly disk: ComputeInstanceTemplateDisk[];
    /**
     * guest_accelerator block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#guest_accelerator ComputeInstanceTemplate#guest_accelerator}
     *
     * @stability stable
     */
    readonly guestAccelerator?: ComputeInstanceTemplateGuestAccelerator[];
    /**
     * network_interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#network_interface ComputeInstanceTemplate#network_interface}
     *
     * @stability stable
     */
    readonly networkInterface?: ComputeInstanceTemplateNetworkInterface[];
    /**
     * reservation_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#reservation_affinity ComputeInstanceTemplate#reservation_affinity}
     *
     * @stability stable
     */
    readonly reservationAffinity?: ComputeInstanceTemplateReservationAffinity;
    /**
     * scheduling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#scheduling ComputeInstanceTemplate#scheduling}
     *
     * @stability stable
     */
    readonly scheduling?: ComputeInstanceTemplateScheduling;
    /**
     * service_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#service_account ComputeInstanceTemplate#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: ComputeInstanceTemplateServiceAccount;
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#shielded_instance_config ComputeInstanceTemplate#shielded_instance_config}
     *
     * @stability stable
     */
    readonly shieldedInstanceConfig?: ComputeInstanceTemplateShieldedInstanceConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#timeouts ComputeInstanceTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeInstanceTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateAdvancedMachineFeatures {
    /**
     * Whether to enable nested virtualization or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#enable_nested_virtualization ComputeInstanceTemplate#enable_nested_virtualization}
     *
     * @stability stable
     */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
     * The number of threads per physical core.
     *
     * To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#threads_per_core ComputeInstanceTemplate#threads_per_core}
     *
     * @stability stable
     */
    readonly threadsPerCore?: number;
}
export declare function computeInstanceTemplateAdvancedMachineFeaturesToTerraform(struct?: ComputeInstanceTemplateAdvancedMachineFeaturesOutputReference | ComputeInstanceTemplateAdvancedMachineFeatures): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceTemplateAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceTemplateAdvancedMachineFeatures | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceTemplateAdvancedMachineFeatures | undefined);
    private _enableNestedVirtualization?;
    /**
     * @stability stable
     */
    get enableNestedVirtualization(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableNestedVirtualization(): void;
    /**
     * @stability stable
     */
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    /**
     * @stability stable
     */
    get threadsPerCore(): number;
    /**
     * @stability stable
     */
    set threadsPerCore(value: number);
    /**
     * @stability stable
     */
    resetThreadsPerCore(): void;
    /**
     * @stability stable
     */
    get threadsPerCoreInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateConfidentialInstanceConfig {
    /**
     * Defines whether the instance should have confidential compute enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#enable_confidential_compute ComputeInstanceTemplate#enable_confidential_compute}
     *
     * @stability stable
     */
    readonly enableConfidentialCompute: boolean | cdktf.IResolvable;
}
export declare function computeInstanceTemplateConfidentialInstanceConfigToTerraform(struct?: ComputeInstanceTemplateConfidentialInstanceConfigOutputReference | ComputeInstanceTemplateConfidentialInstanceConfig): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceTemplateConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceTemplateConfidentialInstanceConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceTemplateConfidentialInstanceConfig | undefined);
    private _enableConfidentialCompute?;
    /**
     * @stability stable
     */
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateDiskDiskEncryptionKey {
    /**
     * The self link of the encryption key that is stored in Google Cloud KMS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#kms_key_self_link ComputeInstanceTemplate#kms_key_self_link}
     *
     * @stability stable
     */
    readonly kmsKeySelfLink: string;
}
export declare function computeInstanceTemplateDiskDiskEncryptionKeyToTerraform(struct?: ComputeInstanceTemplateDiskDiskEncryptionKeyOutputReference | ComputeInstanceTemplateDiskDiskEncryptionKey): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceTemplateDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceTemplateDiskDiskEncryptionKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceTemplateDiskDiskEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    /**
     * @stability stable
     */
    get kmsKeySelfLink(): string;
    /**
     * @stability stable
     */
    set kmsKeySelfLink(value: string);
    /**
     * @stability stable
     */
    get kmsKeySelfLinkInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateDisk {
    /**
     * Whether or not the disk should be auto-deleted. This defaults to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#auto_delete ComputeInstanceTemplate#auto_delete}
     *
     * @stability stable
     */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
     * Indicates that this is a boot disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#boot ComputeInstanceTemplate#boot}
     *
     * @stability stable
     */
    readonly boot?: boolean | cdktf.IResolvable;
    /**
     * A unique device name that is reflected into the /dev/ tree of a Linux operating system running within the instance.
     *
     * If not specified, the server chooses a default device name to apply to this disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#device_name ComputeInstanceTemplate#device_name}
     *
     * @stability stable
     */
    readonly deviceName?: string;
    /**
     * Name of the disk. When not provided, this defaults to the name of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#disk_name ComputeInstanceTemplate#disk_name}
     *
     * @stability stable
     */
    readonly diskName?: string;
    /**
     * The size of the image in gigabytes.
     *
     * If not specified, it will inherit the size of its base image. For SCRATCH disks, the size must be exactly 375GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#disk_size_gb ComputeInstanceTemplate#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * The Google Compute Engine disk type. Can be either "pd-ssd", "local-ssd", "pd-balanced" or "pd-standard".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#disk_type ComputeInstanceTemplate#disk_type}
     *
     * @stability stable
     */
    readonly diskType?: string;
    /**
     * Specifies the disk interface to use for attaching this disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#interface ComputeInstanceTemplate#interface}
     *
     * @stability stable
     */
    readonly interface?: string;
    /**
     * A set of key/value label pairs to assign to disks,.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#labels ComputeInstanceTemplate#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
     *
     * If you are attaching or creating a boot disk, this must read-write mode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#mode ComputeInstanceTemplate#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * A list (short name or id) of resource policies to attach to this disk.
     *
     * Currently a max of 1 resource policy is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#resource_policies ComputeInstanceTemplate#resource_policies}
     *
     * @stability stable
     */
    readonly resourcePolicies?: string[];
    /**
     * The name (not self_link) of the disk (such as those managed by google_compute_disk) to attach.
     *
     * ~> Note: Either source or source_image is required when creating a new instance except for when creating a local SSD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#source ComputeInstanceTemplate#source}
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * The image from which to initialize this disk.
     *
     * This can be one of: the image's self_link, projects/{project}/global/images/{image}, projects/{project}/global/images/family/{family}, global/images/{image}, global/images/family/{family}, family/{family}, {project}/{family}, {project}/{image}, {family}, or {image}. ~> Note: Either source or source_image is required when creating a new instance except for when creating a local SSD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#source_image ComputeInstanceTemplate#source_image}
     *
     * @stability stable
     */
    readonly sourceImage?: string;
    /**
     * The type of Google Compute Engine disk, can be either "SCRATCH" or "PERSISTENT".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#type ComputeInstanceTemplate#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * disk_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#disk_encryption_key ComputeInstanceTemplate#disk_encryption_key}
     *
     * @stability stable
     */
    readonly diskEncryptionKey?: ComputeInstanceTemplateDiskDiskEncryptionKey;
}
export declare function computeInstanceTemplateDiskToTerraform(struct?: ComputeInstanceTemplateDisk): any;
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateGuestAccelerator {
    /**
     * The number of the guest accelerator cards exposed to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#count ComputeInstanceTemplate#count}
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * The accelerator type resource to expose to this instance. E.g. nvidia-tesla-k80.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#type ComputeInstanceTemplate#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function computeInstanceTemplateGuestAcceleratorToTerraform(struct?: ComputeInstanceTemplateGuestAccelerator): any;
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateNetworkInterfaceAccessConfig {
    /**
     * The IP address that will be 1:1 mapped to the instance's network ip.
     *
     * If not given, one will be generated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#nat_ip ComputeInstanceTemplate#nat_ip}
     *
     * @stability stable
     */
    readonly natIp?: string;
    /**
     * The networking tier used for configuring this instance template.
     *
     * This field can take the following values: PREMIUM or STANDARD. If this field is not specified, it is assumed to be PREMIUM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#network_tier ComputeInstanceTemplate#network_tier}
     *
     * @stability stable
     */
    readonly networkTier?: string;
}
export declare function computeInstanceTemplateNetworkInterfaceAccessConfigToTerraform(struct?: ComputeInstanceTemplateNetworkInterfaceAccessConfig): any;
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateNetworkInterfaceAliasIpRange {
    /**
     * The IP CIDR range represented by this alias IP range.
     *
     * This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. At the time of writing only a netmask (e.g. /24) may be supplied, with a CIDR format resulting in an API error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#ip_cidr_range ComputeInstanceTemplate#ip_cidr_range}
     *
     * @stability stable
     */
    readonly ipCidrRange: string;
    /**
     * The subnetwork secondary range name specifying the secondary range from which to allocate the IP CIDR range for this alias IP range.
     *
     * If left unspecified, the primary range of the subnetwork will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#subnetwork_range_name ComputeInstanceTemplate#subnetwork_range_name}
     *
     * @stability stable
     */
    readonly subnetworkRangeName?: string;
}
export declare function computeInstanceTemplateNetworkInterfaceAliasIpRangeToTerraform(struct?: ComputeInstanceTemplateNetworkInterfaceAliasIpRange): any;
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig {
    /**
     * The service-level to be provided for IPv6 traffic when the subnet has an external subnet.
     *
     * Only PREMIUM tier is valid for IPv6
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#network_tier ComputeInstanceTemplate#network_tier}
     *
     * @stability stable
     */
    readonly networkTier: string;
}
export declare function computeInstanceTemplateNetworkInterfaceIpv6AccessConfigToTerraform(struct?: ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig): any;
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateNetworkInterface {
    /**
     * The name or self_link of the network to attach this interface to.
     *
     * Use network attribute for Legacy or Auto subnetted networks and subnetwork for custom subnetted networks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#network ComputeInstanceTemplate#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * The private IP address to assign to the instance. If empty, the address will be automatically assigned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#network_ip ComputeInstanceTemplate#network_ip}
     *
     * @stability stable
     */
    readonly networkIp?: string;
    /**
     * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#nic_type ComputeInstanceTemplate#nic_type}
     *
     * @stability stable
     */
    readonly nicType?: string;
    /**
     * The stack type for this network interface to identify whether the IPv6 feature is enabled or not.
     *
     * If not specified, IPV4_ONLY will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#stack_type ComputeInstanceTemplate#stack_type}
     *
     * @stability stable
     */
    readonly stackType?: string;
    /**
     * The name of the subnetwork to attach this interface to.
     *
     * The subnetwork must exist in the same region this instance will be created in. Either network or subnetwork must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#subnetwork ComputeInstanceTemplate#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * The ID of the project in which the subnetwork belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#subnetwork_project ComputeInstanceTemplate#subnetwork_project}
     *
     * @stability stable
     */
    readonly subnetworkProject?: string;
    /**
     * access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#access_config ComputeInstanceTemplate#access_config}
     *
     * @stability stable
     */
    readonly accessConfig?: ComputeInstanceTemplateNetworkInterfaceAccessConfig[];
    /**
     * alias_ip_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#alias_ip_range ComputeInstanceTemplate#alias_ip_range}
     *
     * @stability stable
     */
    readonly aliasIpRange?: ComputeInstanceTemplateNetworkInterfaceAliasIpRange[];
    /**
     * ipv6_access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#ipv6_access_config ComputeInstanceTemplate#ipv6_access_config}
     *
     * @stability stable
     */
    readonly ipv6AccessConfig?: ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig[];
}
export declare function computeInstanceTemplateNetworkInterfaceToTerraform(struct?: ComputeInstanceTemplateNetworkInterface): any;
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateReservationAffinitySpecificReservation {
    /**
     * Corresponds to the label key of a reservation resource.
     *
     * To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#key ComputeInstanceTemplate#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Corresponds to the label values of a reservation resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#values ComputeInstanceTemplate#values}
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function computeInstanceTemplateReservationAffinitySpecificReservationToTerraform(struct?: ComputeInstanceTemplateReservationAffinitySpecificReservationOutputReference | ComputeInstanceTemplateReservationAffinitySpecificReservation): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceTemplateReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceTemplateReservationAffinitySpecificReservation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceTemplateReservationAffinitySpecificReservation | undefined);
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateReservationAffinity {
    /**
     * The type of reservation from which this instance can consume resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#type ComputeInstanceTemplate#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * specific_reservation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#specific_reservation ComputeInstanceTemplate#specific_reservation}
     *
     * @stability stable
     */
    readonly specificReservation?: ComputeInstanceTemplateReservationAffinitySpecificReservation;
}
export declare function computeInstanceTemplateReservationAffinityToTerraform(struct?: ComputeInstanceTemplateReservationAffinityOutputReference | ComputeInstanceTemplateReservationAffinity): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceTemplateReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceTemplateReservationAffinity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceTemplateReservationAffinity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _specificReservation;
    /**
     * @stability stable
     */
    get specificReservation(): ComputeInstanceTemplateReservationAffinitySpecificReservationOutputReference;
    /**
     * @stability stable
     */
    putSpecificReservation(value: ComputeInstanceTemplateReservationAffinitySpecificReservation): void;
    /**
     * @stability stable
     */
    resetSpecificReservation(): void;
    /**
     * @stability stable
     */
    get specificReservationInput(): ComputeInstanceTemplateReservationAffinitySpecificReservation | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateSchedulingNodeAffinities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#key ComputeInstanceTemplate#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#operator ComputeInstanceTemplate#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#values ComputeInstanceTemplate#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function computeInstanceTemplateSchedulingNodeAffinitiesToTerraform(struct?: ComputeInstanceTemplateSchedulingNodeAffinities): any;
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateScheduling {
    /**
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user).
     *
     * This defaults to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#automatic_restart ComputeInstanceTemplate#automatic_restart}
     *
     * @stability stable
     */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
     * Minimum number of cpus for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#min_node_cpus ComputeInstanceTemplate#min_node_cpus}
     *
     * @stability stable
     */
    readonly minNodeCpus?: number;
    /**
     * Defines the maintenance behavior for this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#on_host_maintenance ComputeInstanceTemplate#on_host_maintenance}
     *
     * @stability stable
     */
    readonly onHostMaintenance?: string;
    /**
     * Allows instance to be preempted. This defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#preemptible ComputeInstanceTemplate#preemptible}
     *
     * @stability stable
     */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
     * node_affinities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#node_affinities ComputeInstanceTemplate#node_affinities}
     *
     * @stability stable
     */
    readonly nodeAffinities?: ComputeInstanceTemplateSchedulingNodeAffinities[];
}
export declare function computeInstanceTemplateSchedulingToTerraform(struct?: ComputeInstanceTemplateSchedulingOutputReference | ComputeInstanceTemplateScheduling): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceTemplateSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceTemplateScheduling | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceTemplateScheduling | undefined);
    private _automaticRestart?;
    /**
     * @stability stable
     */
    get automaticRestart(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set automaticRestart(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutomaticRestart(): void;
    /**
     * @stability stable
     */
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _minNodeCpus?;
    /**
     * @stability stable
     */
    get minNodeCpus(): number;
    /**
     * @stability stable
     */
    set minNodeCpus(value: number);
    /**
     * @stability stable
     */
    resetMinNodeCpus(): void;
    /**
     * @stability stable
     */
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    /**
     * @stability stable
     */
    get onHostMaintenance(): string;
    /**
     * @stability stable
     */
    set onHostMaintenance(value: string);
    /**
     * @stability stable
     */
    resetOnHostMaintenance(): void;
    /**
     * @stability stable
     */
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    /**
     * @stability stable
     */
    get preemptible(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preemptible(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreemptible(): void;
    /**
     * @stability stable
     */
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _nodeAffinities?;
    /**
     * @stability stable
     */
    get nodeAffinities(): ComputeInstanceTemplateSchedulingNodeAffinities[];
    /**
     * @stability stable
     */
    set nodeAffinities(value: ComputeInstanceTemplateSchedulingNodeAffinities[]);
    /**
     * @stability stable
     */
    resetNodeAffinities(): void;
    /**
     * @stability stable
     */
    get nodeAffinitiesInput(): ComputeInstanceTemplateSchedulingNodeAffinities[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateServiceAccount {
    /**
     * The service account e-mail address. If not given, the default Google Compute Engine service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#email ComputeInstanceTemplate#email}
     *
     * @stability stable
     */
    readonly email?: string;
    /**
     * A list of service scopes.
     *
     * Both OAuth2 URLs and gcloud short names are supported. To allow full access to all Cloud APIs, use the cloud-platform scope.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#scopes ComputeInstanceTemplate#scopes}
     *
     * @stability stable
     */
    readonly scopes: string[];
}
export declare function computeInstanceTemplateServiceAccountToTerraform(struct?: ComputeInstanceTemplateServiceAccountOutputReference | ComputeInstanceTemplateServiceAccount): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceTemplateServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceTemplateServiceAccount | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceTemplateServiceAccount | undefined);
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    resetEmail(): void;
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateShieldedInstanceConfig {
    /**
     * Compare the most recent boot measurements to the integrity policy baseline and return a pair of pass/fail results depending on whether they match or not.
     *
     * Defaults to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#enable_integrity_monitoring ComputeInstanceTemplate#enable_integrity_monitoring}
     *
     * @stability stable
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Verify the digital signature of all boot components, and halt the boot process if signature verification fails.
     *
     * Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#enable_secure_boot ComputeInstanceTemplate#enable_secure_boot}
     *
     * @stability stable
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
     * Use a virtualized trusted platform module, which is a specialized computer chip you can use to encrypt objects like keys and certificates.
     *
     * Defaults to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#enable_vtpm ComputeInstanceTemplate#enable_vtpm}
     *
     * @stability stable
     */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function computeInstanceTemplateShieldedInstanceConfigToTerraform(struct?: ComputeInstanceTemplateShieldedInstanceConfigOutputReference | ComputeInstanceTemplateShieldedInstanceConfig): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceTemplateShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceTemplateShieldedInstanceConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceTemplateShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableIntegrityMonitoring(): void;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    /**
     * @stability stable
     */
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableSecureBoot(): void;
    /**
     * @stability stable
     */
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    /**
     * @stability stable
     */
    get enableVtpm(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableVtpm(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableVtpm(): void;
    /**
     * @stability stable
     */
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#create ComputeInstanceTemplate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#delete ComputeInstanceTemplate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeInstanceTemplateTimeoutsToTerraform(struct?: ComputeInstanceTemplateTimeoutsOutputReference | ComputeInstanceTemplateTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceTemplateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template google_compute_instance_template}.
 *
 * @stability stable
 */
export declare class ComputeInstanceTemplate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template google_compute_instance_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeInstanceTemplateConfig);
    private _canIpForward?;
    /**
     * @stability stable
     */
    get canIpForward(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set canIpForward(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCanIpForward(): void;
    /**
     * @stability stable
     */
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableDisplay?;
    /**
     * @stability stable
     */
    get enableDisplay(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableDisplay(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableDisplay(): void;
    /**
     * @stability stable
     */
    get enableDisplayInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceDescription?;
    /**
     * @stability stable
     */
    get instanceDescription(): string;
    /**
     * @stability stable
     */
    set instanceDescription(value: string);
    /**
     * @stability stable
     */
    resetInstanceDescription(): void;
    /**
     * @stability stable
     */
    get instanceDescriptionInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    /**
     * @stability stable
     */
    get metadataStartupScript(): string;
    /**
     * @stability stable
     */
    set metadataStartupScript(value: string);
    /**
     * @stability stable
     */
    resetMetadataStartupScript(): void;
    /**
     * @stability stable
     */
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    set minCpuPlatform(value: string);
    /**
     * @stability stable
     */
    resetMinCpuPlatform(): void;
    /**
     * @stability stable
     */
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namePrefix?;
    /**
     * @stability stable
     */
    get namePrefix(): string;
    /**
     * @stability stable
     */
    set namePrefix(value: string);
    /**
     * @stability stable
     */
    resetNamePrefix(): void;
    /**
     * @stability stable
     */
    get namePrefixInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get tagsFingerprint(): string;
    private _advancedMachineFeatures;
    /**
     * @stability stable
     */
    get advancedMachineFeatures(): ComputeInstanceTemplateAdvancedMachineFeaturesOutputReference;
    /**
     * @stability stable
     */
    putAdvancedMachineFeatures(value: ComputeInstanceTemplateAdvancedMachineFeatures): void;
    /**
     * @stability stable
     */
    resetAdvancedMachineFeatures(): void;
    /**
     * @stability stable
     */
    get advancedMachineFeaturesInput(): ComputeInstanceTemplateAdvancedMachineFeatures | undefined;
    private _confidentialInstanceConfig;
    /**
     * @stability stable
     */
    get confidentialInstanceConfig(): ComputeInstanceTemplateConfidentialInstanceConfigOutputReference;
    /**
     * @stability stable
     */
    putConfidentialInstanceConfig(value: ComputeInstanceTemplateConfidentialInstanceConfig): void;
    /**
     * @stability stable
     */
    resetConfidentialInstanceConfig(): void;
    /**
     * @stability stable
     */
    get confidentialInstanceConfigInput(): ComputeInstanceTemplateConfidentialInstanceConfig | undefined;
    private _disk?;
    /**
     * @stability stable
     */
    get disk(): ComputeInstanceTemplateDisk[];
    /**
     * @stability stable
     */
    set disk(value: ComputeInstanceTemplateDisk[]);
    /**
     * @stability stable
     */
    get diskInput(): ComputeInstanceTemplateDisk[] | undefined;
    private _guestAccelerator?;
    /**
     * @stability stable
     */
    get guestAccelerator(): ComputeInstanceTemplateGuestAccelerator[];
    /**
     * @stability stable
     */
    set guestAccelerator(value: ComputeInstanceTemplateGuestAccelerator[]);
    /**
     * @stability stable
     */
    resetGuestAccelerator(): void;
    /**
     * @stability stable
     */
    get guestAcceleratorInput(): ComputeInstanceTemplateGuestAccelerator[] | undefined;
    private _networkInterface?;
    /**
     * @stability stable
     */
    get networkInterface(): ComputeInstanceTemplateNetworkInterface[];
    /**
     * @stability stable
     */
    set networkInterface(value: ComputeInstanceTemplateNetworkInterface[]);
    /**
     * @stability stable
     */
    resetNetworkInterface(): void;
    /**
     * @stability stable
     */
    get networkInterfaceInput(): ComputeInstanceTemplateNetworkInterface[] | undefined;
    private _reservationAffinity;
    /**
     * @stability stable
     */
    get reservationAffinity(): ComputeInstanceTemplateReservationAffinityOutputReference;
    /**
     * @stability stable
     */
    putReservationAffinity(value: ComputeInstanceTemplateReservationAffinity): void;
    /**
     * @stability stable
     */
    resetReservationAffinity(): void;
    /**
     * @stability stable
     */
    get reservationAffinityInput(): ComputeInstanceTemplateReservationAffinity | undefined;
    private _scheduling;
    /**
     * @stability stable
     */
    get scheduling(): ComputeInstanceTemplateSchedulingOutputReference;
    /**
     * @stability stable
     */
    putScheduling(value: ComputeInstanceTemplateScheduling): void;
    /**
     * @stability stable
     */
    resetScheduling(): void;
    /**
     * @stability stable
     */
    get schedulingInput(): ComputeInstanceTemplateScheduling | undefined;
    private _serviceAccount;
    /**
     * @stability stable
     */
    get serviceAccount(): ComputeInstanceTemplateServiceAccountOutputReference;
    /**
     * @stability stable
     */
    putServiceAccount(value: ComputeInstanceTemplateServiceAccount): void;
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): ComputeInstanceTemplateServiceAccount | undefined;
    private _shieldedInstanceConfig;
    /**
     * @stability stable
     */
    get shieldedInstanceConfig(): ComputeInstanceTemplateShieldedInstanceConfigOutputReference;
    /**
     * @stability stable
     */
    putShieldedInstanceConfig(value: ComputeInstanceTemplateShieldedInstanceConfig): void;
    /**
     * @stability stable
     */
    resetShieldedInstanceConfig(): void;
    /**
     * @stability stable
     */
    get shieldedInstanceConfigInput(): ComputeInstanceTemplateShieldedInstanceConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeInstanceTemplateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeInstanceTemplateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeInstanceTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
