import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataCatalogTagTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * The display name for this template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#display_name DataCatalogTagTemplate#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * This confirms the deletion of any possible tags using this template.
     *
     * Must be set to true in order to delete the tag template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#force_delete DataCatalogTagTemplate#force_delete}
     *
     * @stability stable
     */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#project DataCatalogTagTemplate#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Template location region.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#region DataCatalogTagTemplate#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The id of the tag template to create.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#tag_template_id DataCatalogTagTemplate#tag_template_id}
     *
     * @stability stable
     */
    readonly tagTemplateId: string;
    /**
     * fields block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#fields DataCatalogTagTemplate#fields}
     *
     * @stability stable
     */
    readonly fields: DataCatalogTagTemplateFields[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#timeouts DataCatalogTagTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataCatalogTagTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues {
    /**
     * The display name of the enum value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#display_name DataCatalogTagTemplate#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
}
export declare function dataCatalogTagTemplateFieldsTypeEnumTypeAllowedValuesToTerraform(struct?: DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues): any;
/**
 * @stability stable
 */
export interface DataCatalogTagTemplateFieldsTypeEnumType {
    /**
     * allowed_values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#allowed_values DataCatalogTagTemplate#allowed_values}
     *
     * @stability stable
     */
    readonly allowedValues: DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[];
}
export declare function dataCatalogTagTemplateFieldsTypeEnumTypeToTerraform(struct?: DataCatalogTagTemplateFieldsTypeEnumTypeOutputReference | DataCatalogTagTemplateFieldsTypeEnumType): any;
/**
 * @stability stable
 */
export declare class DataCatalogTagTemplateFieldsTypeEnumTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataCatalogTagTemplateFieldsTypeEnumType | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataCatalogTagTemplateFieldsTypeEnumType | undefined);
    private _allowedValues?;
    /**
     * @stability stable
     */
    get allowedValues(): DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[];
    /**
     * @stability stable
     */
    set allowedValues(value: DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[]);
    /**
     * @stability stable
     */
    get allowedValuesInput(): DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[] | undefined;
}
/**
 * @stability stable
 */
export interface DataCatalogTagTemplateFieldsType {
    /**
     * Represents primitive types - string, bool etc.
     *
     * Exactly one of 'primitive_type' or 'enum_type' must be set Possible values: ["DOUBLE", "STRING", "BOOL", "TIMESTAMP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#primitive_type DataCatalogTagTemplate#primitive_type}
     *
     * @stability stable
     */
    readonly primitiveType?: string;
    /**
     * enum_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#enum_type DataCatalogTagTemplate#enum_type}
     *
     * @stability stable
     */
    readonly enumType?: DataCatalogTagTemplateFieldsTypeEnumType;
}
export declare function dataCatalogTagTemplateFieldsTypeToTerraform(struct?: DataCatalogTagTemplateFieldsTypeOutputReference | DataCatalogTagTemplateFieldsType): any;
/**
 * @stability stable
 */
export declare class DataCatalogTagTemplateFieldsTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataCatalogTagTemplateFieldsType | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataCatalogTagTemplateFieldsType | undefined);
    private _primitiveType?;
    /**
     * @stability stable
     */
    get primitiveType(): string;
    /**
     * @stability stable
     */
    set primitiveType(value: string);
    /**
     * @stability stable
     */
    resetPrimitiveType(): void;
    /**
     * @stability stable
     */
    get primitiveTypeInput(): string | undefined;
    private _enumType;
    /**
     * @stability stable
     */
    get enumType(): DataCatalogTagTemplateFieldsTypeEnumTypeOutputReference;
    /**
     * @stability stable
     */
    putEnumType(value: DataCatalogTagTemplateFieldsTypeEnumType): void;
    /**
     * @stability stable
     */
    resetEnumType(): void;
    /**
     * @stability stable
     */
    get enumTypeInput(): DataCatalogTagTemplateFieldsTypeEnumType | undefined;
}
/**
 * @stability stable
 */
export interface DataCatalogTagTemplateFields {
    /**
     * A description for this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#description DataCatalogTagTemplate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The display name for this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#display_name DataCatalogTagTemplate#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#field_id DataCatalogTagTemplate#field_id}.
     *
     * @stability stable
     */
    readonly fieldId: string;
    /**
     * Whether this is a required field. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#is_required DataCatalogTagTemplate#is_required}
     *
     * @stability stable
     */
    readonly isRequired?: boolean | cdktf.IResolvable;
    /**
     * The order of this field with respect to other fields in this tag template.
     *
     * A higher value indicates a more important field. The value can be negative.
     * Multiple fields can have the same order, and field orders within a tag do not have to be sequential.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#order DataCatalogTagTemplate#order}
     *
     * @stability stable
     */
    readonly order?: number;
    /**
     * type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#type DataCatalogTagTemplate#type}
     *
     * @stability stable
     */
    readonly type: DataCatalogTagTemplateFieldsType;
}
export declare function dataCatalogTagTemplateFieldsToTerraform(struct?: DataCatalogTagTemplateFields): any;
/**
 * @stability stable
 */
export interface DataCatalogTagTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#create DataCatalogTagTemplate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#delete DataCatalogTagTemplate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#update DataCatalogTagTemplate#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataCatalogTagTemplateTimeoutsToTerraform(struct?: DataCatalogTagTemplateTimeoutsOutputReference | DataCatalogTagTemplateTimeouts): any;
/**
 * @stability stable
 */
export declare class DataCatalogTagTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataCatalogTagTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataCatalogTagTemplateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template google_data_catalog_tag_template}.
 *
 * @stability stable
 */
export declare class DataCatalogTagTemplate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template google_data_catalog_tag_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataCatalogTagTemplateConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _forceDelete?;
    /**
     * @stability stable
     */
    get forceDelete(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set forceDelete(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetForceDelete(): void;
    /**
     * @stability stable
     */
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _tagTemplateId?;
    /**
     * @stability stable
     */
    get tagTemplateId(): string;
    /**
     * @stability stable
     */
    set tagTemplateId(value: string);
    /**
     * @stability stable
     */
    get tagTemplateIdInput(): string | undefined;
    private _fields?;
    /**
     * @stability stable
     */
    get fields(): DataCatalogTagTemplateFields[];
    /**
     * @stability stable
     */
    set fields(value: DataCatalogTagTemplateFields[]);
    /**
     * @stability stable
     */
    get fieldsInput(): DataCatalogTagTemplateFields[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataCatalogTagTemplateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataCatalogTagTemplateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataCatalogTagTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
