import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleCloudIdentityGroupMembershipsConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Group to get memberships from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_group_memberships#group DataGoogleCloudIdentityGroupMemberships#group}
     *
     * @stability stable
     */
    readonly group: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudIdentityGroupMembershipsMembershipsPreferredMemberKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get namespace(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudIdentityGroupMembershipsMembershipsRoles extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudIdentityGroupMembershipsMemberships extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get group(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get preferredMemberKey(): any;
    /**
     * @stability stable
     */
    get roles(): any;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_group_memberships google_cloud_identity_group_memberships}.
 *
 * @stability stable
 */
export declare class DataGoogleCloudIdentityGroupMemberships extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_group_memberships google_cloud_identity_group_memberships} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleCloudIdentityGroupMembershipsConfig);
    private _group?;
    /**
     * @stability stable
     */
    get group(): string;
    /**
     * @stability stable
     */
    set group(value: string);
    /**
     * @stability stable
     */
    get groupInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    memberships(index: string): DataGoogleCloudIdentityGroupMembershipsMemberships;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
