import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleFolderOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folder_organization_policy#constraint DataGoogleFolderOrganizationPolicy#constraint}
     *
     * @stability stable
     */
    readonly constraint: string;
    /**
     * The resource name of the folder to set the policy for. Its format is folders/{folder_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folder_organization_policy#folder DataGoogleFolderOrganizationPolicy#folder}
     *
     * @stability stable
     */
    readonly folder: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleFolderOrganizationPolicyBooleanPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enforced(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleFolderOrganizationPolicyListPolicyAllow extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get all(): any;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleFolderOrganizationPolicyListPolicyDeny extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get all(): any;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleFolderOrganizationPolicyListPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allow(): any;
    /**
     * @stability stable
     */
    get deny(): any;
    /**
     * @stability stable
     */
    get inheritFromParent(): any;
    /**
     * @stability stable
     */
    get suggestedValue(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleFolderOrganizationPolicyRestorePolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get default(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/folder_organization_policy google_folder_organization_policy}.
 *
 * @stability stable
 */
export declare class DataGoogleFolderOrganizationPolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/folder_organization_policy google_folder_organization_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleFolderOrganizationPolicyConfig);
    /**
     * @stability stable
     */
    booleanPolicy(index: string): DataGoogleFolderOrganizationPolicyBooleanPolicy;
    private _constraint?;
    /**
     * @stability stable
     */
    get constraint(): string;
    /**
     * @stability stable
     */
    set constraint(value: string);
    /**
     * @stability stable
     */
    get constraintInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    private _folder?;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    get folderInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    listPolicy(index: string): DataGoogleFolderOrganizationPolicyListPolicy;
    /**
     * @stability stable
     */
    restorePolicy(index: string): DataGoogleFolderOrganizationPolicyRestorePolicy;
    /**
     * @stability stable
     */
    get updateTime(): string;
    /**
     * @stability stable
     */
    get version(): number;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
