import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleFolderConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folder#folder DataGoogleFolder#folder}.
     *
     * @stability stable
     */
    readonly folder: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folder#lookup_organization DataGoogleFolder#lookup_organization}.
     *
     * @stability stable
     */
    readonly lookupOrganization?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/folder google_folder}.
 *
 * @stability stable
 */
export declare class DataGoogleFolder extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/folder google_folder} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleFolderConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    private _folder?;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    get folderInput(): string | undefined;
    /**
     * @stability stable
     */
    get folderId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lifecycleState(): string;
    private _lookupOrganization?;
    /**
     * @stability stable
     */
    get lookupOrganization(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set lookupOrganization(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLookupOrganization(): void;
    /**
     * @stability stable
     */
    get lookupOrganizationInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
