import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleProjectOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy#constraint DataGoogleProjectOrganizationPolicy#constraint}
     *
     * @stability stable
     */
    readonly constraint: string;
    /**
     * The project ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy#project DataGoogleProjectOrganizationPolicy#project}
     *
     * @stability stable
     */
    readonly project: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleProjectOrganizationPolicyBooleanPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enforced(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleProjectOrganizationPolicyListPolicyAllow extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get all(): any;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleProjectOrganizationPolicyListPolicyDeny extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get all(): any;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleProjectOrganizationPolicyListPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allow(): any;
    /**
     * @stability stable
     */
    get deny(): any;
    /**
     * @stability stable
     */
    get inheritFromParent(): any;
    /**
     * @stability stable
     */
    get suggestedValue(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleProjectOrganizationPolicyRestorePolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get default(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy google_project_organization_policy}.
 *
 * @stability stable
 */
export declare class DataGoogleProjectOrganizationPolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy google_project_organization_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleProjectOrganizationPolicyConfig);
    /**
     * @stability stable
     */
    booleanPolicy(index: string): DataGoogleProjectOrganizationPolicyBooleanPolicy;
    private _constraint?;
    /**
     * @stability stable
     */
    get constraint(): string;
    /**
     * @stability stable
     */
    set constraint(value: string);
    /**
     * @stability stable
     */
    get constraintInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    listPolicy(index: string): DataGoogleProjectOrganizationPolicyListPolicy;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    restorePolicy(index: string): DataGoogleProjectOrganizationPolicyRestorePolicy;
    /**
     * @stability stable
     */
    get updateTime(): string;
    /**
     * @stability stable
     */
    get version(): number;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
