import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleRedisInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of the instance or a fully qualified identifier for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance#name DataGoogleRedisInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance#project DataGoogleRedisInstance#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The name of the Redis region of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance#region DataGoogleRedisInstance#region}
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleRedisInstanceServerCaCerts extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cert(): string;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get expireTime(): string;
    /**
     * @stability stable
     */
    get serialNumber(): string;
    /**
     * @stability stable
     */
    get sha1Fingerprint(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/redis_instance google_redis_instance}.
 *
 * @stability stable
 */
export declare class DataGoogleRedisInstance extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/redis_instance google_redis_instance} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleRedisInstanceConfig);
    /**
     * @stability stable
     */
    get alternativeLocationId(): string;
    /**
     * @stability stable
     */
    get authEnabled(): any;
    /**
     * @stability stable
     */
    get authString(): string;
    /**
     * @stability stable
     */
    get authorizedNetwork(): string;
    /**
     * @stability stable
     */
    get connectMode(): string;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get currentLocationId(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    labels(key: string): string;
    /**
     * @stability stable
     */
    get locationId(): string;
    /**
     * @stability stable
     */
    get memorySizeGb(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get persistenceIamIdentity(): string;
    /**
     * @stability stable
     */
    get port(): number;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    redisConfigs(key: string): string;
    /**
     * @stability stable
     */
    get redisVersion(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get reservedIpRange(): string;
    /**
     * @stability stable
     */
    serverCaCerts(index: string): DataGoogleRedisInstanceServerCaCerts;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    get transitEncryptionMode(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
