import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FirestoreDocumentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The collection ID, relative to database. For example: chatrooms or chatrooms/my-document/private-messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#collection FirestoreDocument#collection}
     *
     * @stability stable
     */
    readonly collection: string;
    /**
     * The Firestore database id. Defaults to '"(default)"'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#database FirestoreDocument#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * The client-assigned document ID to use for this document during creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#document_id FirestoreDocument#document_id}
     *
     * @stability stable
     */
    readonly documentId: string;
    /**
     * The document's [fields](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases.documents) formated as a json string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#fields FirestoreDocument#fields}
     *
     * @stability stable
     */
    readonly fields: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#project FirestoreDocument#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#timeouts FirestoreDocument#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FirestoreDocumentTimeouts;
}
/**
 * @stability stable
 */
export interface FirestoreDocumentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#create FirestoreDocument#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#delete FirestoreDocument#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#update FirestoreDocument#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function firestoreDocumentTimeoutsToTerraform(struct?: FirestoreDocumentTimeoutsOutputReference | FirestoreDocumentTimeouts): any;
/**
 * @stability stable
 */
export declare class FirestoreDocumentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirestoreDocumentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirestoreDocumentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/firestore_document google_firestore_document}.
 *
 * @stability stable
 */
export declare class FirestoreDocument extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/firestore_document google_firestore_document} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FirestoreDocumentConfig);
    private _collection?;
    /**
     * @stability stable
     */
    get collection(): string;
    /**
     * @stability stable
     */
    set collection(value: string);
    /**
     * @stability stable
     */
    get collectionInput(): string | undefined;
    /**
     * @stability stable
     */
    get createTime(): string;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    resetDatabase(): void;
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _documentId?;
    /**
     * @stability stable
     */
    get documentId(): string;
    /**
     * @stability stable
     */
    set documentId(value: string);
    /**
     * @stability stable
     */
    get documentIdInput(): string | undefined;
    private _fields?;
    /**
     * @stability stable
     */
    get fields(): string;
    /**
     * @stability stable
     */
    set fields(value: string);
    /**
     * @stability stable
     */
    get fieldsInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get path(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FirestoreDocumentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FirestoreDocumentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FirestoreDocumentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
