import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KmsKeyRingIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_policy#key_ring_id KmsKeyRingIamPolicy#key_ring_id}.
     *
     * @stability stable
     */
    readonly keyRingId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_policy#policy_data KmsKeyRingIamPolicy#policy_data}.
     *
     * @stability stable
     */
    readonly policyData: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_policy google_kms_key_ring_iam_policy}.
 *
 * @stability stable
 */
export declare class KmsKeyRingIamPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_policy google_kms_key_ring_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KmsKeyRingIamPolicyConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyRingId?;
    /**
     * @stability stable
     */
    get keyRingId(): string;
    /**
     * @stability stable
     */
    set keyRingId(value: string);
    /**
     * @stability stable
     */
    get keyRingIdInput(): string | undefined;
    private _policyData?;
    /**
     * @stability stable
     */
    get policyData(): string;
    /**
     * @stability stable
     */
    set policyData(value: string);
    /**
     * @stability stable
     */
    get policyDataInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
