import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Optional. A human-readable description of scenarios this template is intended for.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#description PrivatecaCertificateTemplate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Optional. Labels with user-defined metadata.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#labels PrivatecaCertificateTemplate#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The location for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#location PrivatecaCertificateTemplate#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The resource name for this CertificateTemplate in the format `projects/*\/locations/*\/certificateTemplates/*`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#name PrivatecaCertificateTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The project for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#project PrivatecaCertificateTemplate#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * identity_constraints block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#identity_constraints PrivatecaCertificateTemplate#identity_constraints}
     *
     * @stability stable
     */
    readonly identityConstraints?: PrivatecaCertificateTemplateIdentityConstraints;
    /**
     * passthrough_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#passthrough_extensions PrivatecaCertificateTemplate#passthrough_extensions}
     *
     * @stability stable
     */
    readonly passthroughExtensions?: PrivatecaCertificateTemplatePassthroughExtensions;
    /**
     * predefined_values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#predefined_values PrivatecaCertificateTemplate#predefined_values}
     *
     * @stability stable
     */
    readonly predefinedValues?: PrivatecaCertificateTemplatePredefinedValues;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#timeouts PrivatecaCertificateTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PrivatecaCertificateTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplateIdentityConstraintsCelExpression {
    /**
     * Optional.
     *
     * Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#description PrivatecaCertificateTemplate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#expression PrivatecaCertificateTemplate#expression}
     *
     * @stability stable
     */
    readonly expression?: string;
    /**
     * Optional.
     *
     * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#location PrivatecaCertificateTemplate#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Optional.
     *
     * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#title PrivatecaCertificateTemplate#title}
     *
     * @stability stable
     */
    readonly title?: string;
}
export declare function privatecaCertificateTemplateIdentityConstraintsCelExpressionToTerraform(struct?: PrivatecaCertificateTemplateIdentityConstraintsCelExpressionOutputReference | PrivatecaCertificateTemplateIdentityConstraintsCelExpression): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateTemplateIdentityConstraintsCelExpressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateTemplateIdentityConstraintsCelExpression | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateTemplateIdentityConstraintsCelExpression | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    resetExpression(): void;
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplateIdentityConstraints {
    /**
     * Required.
     *
     * If this is true, the SubjectAltNames extension may be copied from a certificate request into the signed certificate. Otherwise, the requested SubjectAltNames will be discarded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#allow_subject_alt_names_passthrough PrivatecaCertificateTemplate#allow_subject_alt_names_passthrough}
     *
     * @stability stable
     */
    readonly allowSubjectAltNamesPassthrough: boolean | cdktf.IResolvable;
    /**
     * Required.
     *
     * If this is true, the Subject field may be copied from a certificate request into the signed certificate. Otherwise, the requested Subject will be discarded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#allow_subject_passthrough PrivatecaCertificateTemplate#allow_subject_passthrough}
     *
     * @stability stable
     */
    readonly allowSubjectPassthrough: boolean | cdktf.IResolvable;
    /**
     * cel_expression block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#cel_expression PrivatecaCertificateTemplate#cel_expression}
     *
     * @stability stable
     */
    readonly celExpression?: PrivatecaCertificateTemplateIdentityConstraintsCelExpression;
}
export declare function privatecaCertificateTemplateIdentityConstraintsToTerraform(struct?: PrivatecaCertificateTemplateIdentityConstraintsOutputReference | PrivatecaCertificateTemplateIdentityConstraints): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateTemplateIdentityConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateTemplateIdentityConstraints | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateTemplateIdentityConstraints | undefined);
    private _allowSubjectAltNamesPassthrough?;
    /**
     * @stability stable
     */
    get allowSubjectAltNamesPassthrough(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowSubjectAltNamesPassthrough(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get allowSubjectAltNamesPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _allowSubjectPassthrough?;
    /**
     * @stability stable
     */
    get allowSubjectPassthrough(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowSubjectPassthrough(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get allowSubjectPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _celExpression;
    /**
     * @stability stable
     */
    get celExpression(): PrivatecaCertificateTemplateIdentityConstraintsCelExpressionOutputReference;
    /**
     * @stability stable
     */
    putCelExpression(value: PrivatecaCertificateTemplateIdentityConstraintsCelExpression): void;
    /**
     * @stability stable
     */
    resetCelExpression(): void;
    /**
     * @stability stable
     */
    get celExpressionInput(): PrivatecaCertificateTemplateIdentityConstraintsCelExpression | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplatePassthroughExtensionsAdditionalExtensions {
    /**
     * Required. The parts of an OID path. The most significant parts of the path come first.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#object_id_path PrivatecaCertificateTemplate#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
export declare function privatecaCertificateTemplatePassthroughExtensionsAdditionalExtensionsToTerraform(struct?: PrivatecaCertificateTemplatePassthroughExtensionsAdditionalExtensions): any;
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplatePassthroughExtensions {
    /**
     * Optional.
     *
     * A set of named X.509 extensions. Will be combined with additional_extensions to determine the full set of X.509 extensions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#known_extensions PrivatecaCertificateTemplate#known_extensions}
     *
     * @stability stable
     */
    readonly knownExtensions?: string[];
    /**
     * additional_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#additional_extensions PrivatecaCertificateTemplate#additional_extensions}
     *
     * @stability stable
     */
    readonly additionalExtensions?: PrivatecaCertificateTemplatePassthroughExtensionsAdditionalExtensions[];
}
export declare function privatecaCertificateTemplatePassthroughExtensionsToTerraform(struct?: PrivatecaCertificateTemplatePassthroughExtensionsOutputReference | PrivatecaCertificateTemplatePassthroughExtensions): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateTemplatePassthroughExtensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateTemplatePassthroughExtensions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateTemplatePassthroughExtensions | undefined);
    private _knownExtensions?;
    /**
     * @stability stable
     */
    get knownExtensions(): string[];
    /**
     * @stability stable
     */
    set knownExtensions(value: string[]);
    /**
     * @stability stable
     */
    resetKnownExtensions(): void;
    /**
     * @stability stable
     */
    get knownExtensionsInput(): string[] | undefined;
    private _additionalExtensions?;
    /**
     * @stability stable
     */
    get additionalExtensions(): PrivatecaCertificateTemplatePassthroughExtensionsAdditionalExtensions[];
    /**
     * @stability stable
     */
    set additionalExtensions(value: PrivatecaCertificateTemplatePassthroughExtensionsAdditionalExtensions[]);
    /**
     * @stability stable
     */
    resetAdditionalExtensions(): void;
    /**
     * @stability stable
     */
    get additionalExtensionsInput(): PrivatecaCertificateTemplatePassthroughExtensionsAdditionalExtensions[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensionsObjectId {
    /**
     * Required. The parts of an OID path. The most significant parts of the path come first.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#object_id_path PrivatecaCertificateTemplate#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
export declare function privatecaCertificateTemplatePredefinedValuesAdditionalExtensionsObjectIdToTerraform(struct?: PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensionsObjectIdOutputReference | PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensionsObjectId): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensionsObjectId | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensionsObjectId | undefined);
    private _objectIdPath?;
    /**
     * @stability stable
     */
    get objectIdPath(): number[];
    /**
     * @stability stable
     */
    set objectIdPath(value: number[]);
    /**
     * @stability stable
     */
    get objectIdPathInput(): number[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensions {
    /**
     * Optional.
     *
     * Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#critical PrivatecaCertificateTemplate#critical}
     *
     * @stability stable
     */
    readonly critical?: boolean | cdktf.IResolvable;
    /**
     * Required. The value of this X.509 extension.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#value PrivatecaCertificateTemplate#value}
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * object_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#object_id PrivatecaCertificateTemplate#object_id}
     *
     * @stability stable
     */
    readonly objectId: PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensionsObjectId;
}
export declare function privatecaCertificateTemplatePredefinedValuesAdditionalExtensionsToTerraform(struct?: PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensions): any;
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplatePredefinedValuesCaOptions {
    /**
     * Optional.
     *
     * Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#is_ca PrivatecaCertificateTemplate#is_ca}
     *
     * @stability stable
     */
    readonly isCa?: boolean | cdktf.IResolvable;
    /**
     * Optional.
     *
     * Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#max_issuer_path_length PrivatecaCertificateTemplate#max_issuer_path_length}
     *
     * @stability stable
     */
    readonly maxIssuerPathLength?: number;
}
export declare function privatecaCertificateTemplatePredefinedValuesCaOptionsToTerraform(struct?: PrivatecaCertificateTemplatePredefinedValuesCaOptionsOutputReference | PrivatecaCertificateTemplatePredefinedValuesCaOptions): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateTemplatePredefinedValuesCaOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateTemplatePredefinedValuesCaOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateTemplatePredefinedValuesCaOptions | undefined);
    private _isCa?;
    /**
     * @stability stable
     */
    get isCa(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isCa(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsCa(): void;
    /**
     * @stability stable
     */
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    /**
     * @stability stable
     */
    get maxIssuerPathLength(): number;
    /**
     * @stability stable
     */
    set maxIssuerPathLength(value: number);
    /**
     * @stability stable
     */
    resetMaxIssuerPathLength(): void;
    /**
     * @stability stable
     */
    get maxIssuerPathLengthInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage {
    /**
     * The key may be used to sign certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#cert_sign PrivatecaCertificateTemplate#cert_sign}
     *
     * @stability stable
     */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#content_commitment PrivatecaCertificateTemplate#content_commitment}
     *
     * @stability stable
     */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used sign certificate revocation lists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#crl_sign PrivatecaCertificateTemplate#crl_sign}
     *
     * @stability stable
     */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#data_encipherment PrivatecaCertificateTemplate#data_encipherment}
     *
     * @stability stable
     */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to decipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#decipher_only PrivatecaCertificateTemplate#decipher_only}
     *
     * @stability stable
     */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for digital signatures.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#digital_signature PrivatecaCertificateTemplate#digital_signature}
     *
     * @stability stable
     */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#encipher_only PrivatecaCertificateTemplate#encipher_only}
     *
     * @stability stable
     */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used in a key agreement protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#key_agreement PrivatecaCertificateTemplate#key_agreement}
     *
     * @stability stable
     */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher other keys.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#key_encipherment PrivatecaCertificateTemplate#key_encipherment}
     *
     * @stability stable
     */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare function privatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsageToTerraform(struct?: PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsageOutputReference | PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage | undefined);
    private _certSign?;
    /**
     * @stability stable
     */
    get certSign(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set certSign(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCertSign(): void;
    /**
     * @stability stable
     */
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    /**
     * @stability stable
     */
    get contentCommitment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set contentCommitment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetContentCommitment(): void;
    /**
     * @stability stable
     */
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    /**
     * @stability stable
     */
    get crlSign(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set crlSign(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCrlSign(): void;
    /**
     * @stability stable
     */
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    /**
     * @stability stable
     */
    get dataEncipherment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dataEncipherment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDataEncipherment(): void;
    /**
     * @stability stable
     */
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    /**
     * @stability stable
     */
    get decipherOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set decipherOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDecipherOnly(): void;
    /**
     * @stability stable
     */
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    /**
     * @stability stable
     */
    get digitalSignature(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set digitalSignature(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDigitalSignature(): void;
    /**
     * @stability stable
     */
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    /**
     * @stability stable
     */
    get encipherOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encipherOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncipherOnly(): void;
    /**
     * @stability stable
     */
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    /**
     * @stability stable
     */
    get keyAgreement(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set keyAgreement(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetKeyAgreement(): void;
    /**
     * @stability stable
     */
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    /**
     * @stability stable
     */
    get keyEncipherment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set keyEncipherment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetKeyEncipherment(): void;
    /**
     * @stability stable
     */
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage {
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#client_auth PrivatecaCertificateTemplate#client_auth}
     *
     * @stability stable
     */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#code_signing PrivatecaCertificateTemplate#code_signing}
     *
     * @stability stable
     */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#email_protection PrivatecaCertificateTemplate#email_protection}
     *
     * @stability stable
     */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#ocsp_signing PrivatecaCertificateTemplate#ocsp_signing}
     *
     * @stability stable
     */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#server_auth PrivatecaCertificateTemplate#server_auth}
     *
     * @stability stable
     */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#time_stamping PrivatecaCertificateTemplate#time_stamping}
     *
     * @stability stable
     */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare function privatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsageToTerraform(struct?: PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsageOutputReference | PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage | undefined);
    private _clientAuth?;
    /**
     * @stability stable
     */
    get clientAuth(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientAuth(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientAuth(): void;
    /**
     * @stability stable
     */
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    /**
     * @stability stable
     */
    get codeSigning(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set codeSigning(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCodeSigning(): void;
    /**
     * @stability stable
     */
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    /**
     * @stability stable
     */
    get emailProtection(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emailProtection(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmailProtection(): void;
    /**
     * @stability stable
     */
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    /**
     * @stability stable
     */
    get ocspSigning(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ocspSigning(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOcspSigning(): void;
    /**
     * @stability stable
     */
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    /**
     * @stability stable
     */
    get serverAuth(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set serverAuth(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetServerAuth(): void;
    /**
     * @stability stable
     */
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    /**
     * @stability stable
     */
    get timeStamping(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set timeStamping(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTimeStamping(): void;
    /**
     * @stability stable
     */
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsages {
    /**
     * Required. The parts of an OID path. The most significant parts of the path come first.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#object_id_path PrivatecaCertificateTemplate#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
export declare function privatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsagesToTerraform(struct?: PrivatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsages): any;
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplatePredefinedValuesKeyUsage {
    /**
     * base_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#base_key_usage PrivatecaCertificateTemplate#base_key_usage}
     *
     * @stability stable
     */
    readonly baseKeyUsage?: PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage;
    /**
     * extended_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#extended_key_usage PrivatecaCertificateTemplate#extended_key_usage}
     *
     * @stability stable
     */
    readonly extendedKeyUsage?: PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage;
    /**
     * unknown_extended_key_usages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#unknown_extended_key_usages PrivatecaCertificateTemplate#unknown_extended_key_usages}
     *
     * @stability stable
     */
    readonly unknownExtendedKeyUsages?: PrivatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsages[];
}
export declare function privatecaCertificateTemplatePredefinedValuesKeyUsageToTerraform(struct?: PrivatecaCertificateTemplatePredefinedValuesKeyUsageOutputReference | PrivatecaCertificateTemplatePredefinedValuesKeyUsage): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateTemplatePredefinedValuesKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateTemplatePredefinedValuesKeyUsage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateTemplatePredefinedValuesKeyUsage | undefined);
    private _baseKeyUsage;
    /**
     * @stability stable
     */
    get baseKeyUsage(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putBaseKeyUsage(value: PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage): void;
    /**
     * @stability stable
     */
    resetBaseKeyUsage(): void;
    /**
     * @stability stable
     */
    get baseKeyUsageInput(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage;
    /**
     * @stability stable
     */
    get extendedKeyUsage(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putExtendedKeyUsage(value: PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage): void;
    /**
     * @stability stable
     */
    resetExtendedKeyUsage(): void;
    /**
     * @stability stable
     */
    get extendedKeyUsageInput(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages?;
    /**
     * @stability stable
     */
    get unknownExtendedKeyUsages(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsages[];
    /**
     * @stability stable
     */
    set unknownExtendedKeyUsages(value: PrivatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsages[]);
    /**
     * @stability stable
     */
    resetUnknownExtendedKeyUsages(): void;
    /**
     * @stability stable
     */
    get unknownExtendedKeyUsagesInput(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplatePredefinedValuesPolicyIds {
    /**
     * Required. The parts of an OID path. The most significant parts of the path come first.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#object_id_path PrivatecaCertificateTemplate#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
export declare function privatecaCertificateTemplatePredefinedValuesPolicyIdsToTerraform(struct?: PrivatecaCertificateTemplatePredefinedValuesPolicyIds): any;
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplatePredefinedValues {
    /**
     * Optional.
     *
     * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#aia_ocsp_servers PrivatecaCertificateTemplate#aia_ocsp_servers}
     *
     * @stability stable
     */
    readonly aiaOcspServers?: string[];
    /**
     * additional_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#additional_extensions PrivatecaCertificateTemplate#additional_extensions}
     *
     * @stability stable
     */
    readonly additionalExtensions?: PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensions[];
    /**
     * ca_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#ca_options PrivatecaCertificateTemplate#ca_options}
     *
     * @stability stable
     */
    readonly caOptions?: PrivatecaCertificateTemplatePredefinedValuesCaOptions;
    /**
     * key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#key_usage PrivatecaCertificateTemplate#key_usage}
     *
     * @stability stable
     */
    readonly keyUsage?: PrivatecaCertificateTemplatePredefinedValuesKeyUsage;
    /**
     * policy_ids block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#policy_ids PrivatecaCertificateTemplate#policy_ids}
     *
     * @stability stable
     */
    readonly policyIds?: PrivatecaCertificateTemplatePredefinedValuesPolicyIds[];
}
export declare function privatecaCertificateTemplatePredefinedValuesToTerraform(struct?: PrivatecaCertificateTemplatePredefinedValuesOutputReference | PrivatecaCertificateTemplatePredefinedValues): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateTemplatePredefinedValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateTemplatePredefinedValues | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateTemplatePredefinedValues | undefined);
    private _aiaOcspServers?;
    /**
     * @stability stable
     */
    get aiaOcspServers(): string[];
    /**
     * @stability stable
     */
    set aiaOcspServers(value: string[]);
    /**
     * @stability stable
     */
    resetAiaOcspServers(): void;
    /**
     * @stability stable
     */
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions?;
    /**
     * @stability stable
     */
    get additionalExtensions(): PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensions[];
    /**
     * @stability stable
     */
    set additionalExtensions(value: PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensions[]);
    /**
     * @stability stable
     */
    resetAdditionalExtensions(): void;
    /**
     * @stability stable
     */
    get additionalExtensionsInput(): PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensions[] | undefined;
    private _caOptions;
    /**
     * @stability stable
     */
    get caOptions(): PrivatecaCertificateTemplatePredefinedValuesCaOptionsOutputReference;
    /**
     * @stability stable
     */
    putCaOptions(value: PrivatecaCertificateTemplatePredefinedValuesCaOptions): void;
    /**
     * @stability stable
     */
    resetCaOptions(): void;
    /**
     * @stability stable
     */
    get caOptionsInput(): PrivatecaCertificateTemplatePredefinedValuesCaOptions | undefined;
    private _keyUsage;
    /**
     * @stability stable
     */
    get keyUsage(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putKeyUsage(value: PrivatecaCertificateTemplatePredefinedValuesKeyUsage): void;
    /**
     * @stability stable
     */
    resetKeyUsage(): void;
    /**
     * @stability stable
     */
    get keyUsageInput(): PrivatecaCertificateTemplatePredefinedValuesKeyUsage | undefined;
    private _policyIds?;
    /**
     * @stability stable
     */
    get policyIds(): PrivatecaCertificateTemplatePredefinedValuesPolicyIds[];
    /**
     * @stability stable
     */
    set policyIds(value: PrivatecaCertificateTemplatePredefinedValuesPolicyIds[]);
    /**
     * @stability stable
     */
    resetPolicyIds(): void;
    /**
     * @stability stable
     */
    get policyIdsInput(): PrivatecaCertificateTemplatePredefinedValuesPolicyIds[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#create PrivatecaCertificateTemplate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#delete PrivatecaCertificateTemplate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template#update PrivatecaCertificateTemplate#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function privatecaCertificateTemplateTimeoutsToTerraform(struct?: PrivatecaCertificateTemplateTimeoutsOutputReference | PrivatecaCertificateTemplateTimeouts): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateTemplateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template google_privateca_certificate_template}.
 *
 * @stability stable
 */
export declare class PrivatecaCertificateTemplate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template google_privateca_certificate_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivatecaCertificateTemplateConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _identityConstraints;
    /**
     * @stability stable
     */
    get identityConstraints(): PrivatecaCertificateTemplateIdentityConstraintsOutputReference;
    /**
     * @stability stable
     */
    putIdentityConstraints(value: PrivatecaCertificateTemplateIdentityConstraints): void;
    /**
     * @stability stable
     */
    resetIdentityConstraints(): void;
    /**
     * @stability stable
     */
    get identityConstraintsInput(): PrivatecaCertificateTemplateIdentityConstraints | undefined;
    private _passthroughExtensions;
    /**
     * @stability stable
     */
    get passthroughExtensions(): PrivatecaCertificateTemplatePassthroughExtensionsOutputReference;
    /**
     * @stability stable
     */
    putPassthroughExtensions(value: PrivatecaCertificateTemplatePassthroughExtensions): void;
    /**
     * @stability stable
     */
    resetPassthroughExtensions(): void;
    /**
     * @stability stable
     */
    get passthroughExtensionsInput(): PrivatecaCertificateTemplatePassthroughExtensions | undefined;
    private _predefinedValues;
    /**
     * @stability stable
     */
    get predefinedValues(): PrivatecaCertificateTemplatePredefinedValuesOutputReference;
    /**
     * @stability stable
     */
    putPredefinedValues(value: PrivatecaCertificateTemplatePredefinedValues): void;
    /**
     * @stability stable
     */
    resetPredefinedValues(): void;
    /**
     * @stability stable
     */
    get predefinedValuesInput(): PrivatecaCertificateTemplatePredefinedValues | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PrivatecaCertificateTemplateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PrivatecaCertificateTemplateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PrivatecaCertificateTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
