import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceNetworkingConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of VPC network connected with service producers using VPC peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection#network ServiceNetworkingConnection#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * Named IP address range(s) of PEERING type reserved for this service provider.
     *
     * Note that invoking this method with a different range when connection is already established will not reallocate already provisioned service producer subnetworks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection#reserved_peering_ranges ServiceNetworkingConnection#reserved_peering_ranges}
     *
     * @stability stable
     */
    readonly reservedPeeringRanges: string[];
    /**
     * Provider peering service that is managing peering connectivity for a service provider organization.
     *
     * For Google services that support this functionality it is 'servicenetworking.googleapis.com'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection#service ServiceNetworkingConnection#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection#timeouts ServiceNetworkingConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServiceNetworkingConnectionTimeouts;
}
/**
 * @stability stable
 */
export interface ServiceNetworkingConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection#create ServiceNetworkingConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection#delete ServiceNetworkingConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection#update ServiceNetworkingConnection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function serviceNetworkingConnectionTimeoutsToTerraform(struct?: ServiceNetworkingConnectionTimeoutsOutputReference | ServiceNetworkingConnectionTimeouts): any;
/**
 * @stability stable
 */
export declare class ServiceNetworkingConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceNetworkingConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceNetworkingConnectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection google_service_networking_connection}.
 *
 * @stability stable
 */
export declare class ServiceNetworkingConnection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection google_service_networking_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceNetworkingConnectionConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    /**
     * @stability stable
     */
    get peering(): string;
    private _reservedPeeringRanges?;
    /**
     * @stability stable
     */
    get reservedPeeringRanges(): string[];
    /**
     * @stability stable
     */
    set reservedPeeringRanges(value: string[]);
    /**
     * @stability stable
     */
    get reservedPeeringRangesInput(): string[] | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServiceNetworkingConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServiceNetworkingConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServiceNetworkingConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
