import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SpannerDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional list of DDL statements to run inside the newly created database.
     *
     * Statements can create tables, indexes, etc. These statements
     * execute atomically with the creation of the database: if there is an
     * error in any statement, the database is not created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#ddl SpannerDatabase#ddl}
     *
     * @stability stable
     */
    readonly ddl?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#deletion_protection SpannerDatabase#deletion_protection}.
     *
     * @stability stable
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * The instance to create the database on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#instance SpannerDatabase#instance}
     *
     * @stability stable
     */
    readonly instance: string;
    /**
     * A unique identifier for the database, which cannot be changed after the instance is created.
     *
     * Values are of the form [a-z][-a-z0-9]*[a-z0-9].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#name SpannerDatabase#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#project SpannerDatabase#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * encryption_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#encryption_config SpannerDatabase#encryption_config}
     *
     * @stability stable
     */
    readonly encryptionConfig?: SpannerDatabaseEncryptionConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#timeouts SpannerDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SpannerDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface SpannerDatabaseEncryptionConfig {
    /**
     * Fully qualified name of the KMS key to use to encrypt this database.
     *
     * This key must exist
     * in the same location as the Spanner Database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#kms_key_name SpannerDatabase#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
export declare function spannerDatabaseEncryptionConfigToTerraform(struct?: SpannerDatabaseEncryptionConfigOutputReference | SpannerDatabaseEncryptionConfig): any;
/**
 * @stability stable
 */
export declare class SpannerDatabaseEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpannerDatabaseEncryptionConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpannerDatabaseEncryptionConfig | undefined);
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string);
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SpannerDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#create SpannerDatabase#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#delete SpannerDatabase#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database#update SpannerDatabase#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function spannerDatabaseTimeoutsToTerraform(struct?: SpannerDatabaseTimeoutsOutputReference | SpannerDatabaseTimeouts): any;
/**
 * @stability stable
 */
export declare class SpannerDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpannerDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpannerDatabaseTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/spanner_database google_spanner_database}.
 *
 * @stability stable
 */
export declare class SpannerDatabase extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/spanner_database google_spanner_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SpannerDatabaseConfig);
    private _ddl?;
    /**
     * @stability stable
     */
    get ddl(): string[];
    /**
     * @stability stable
     */
    set ddl(value: string[]);
    /**
     * @stability stable
     */
    resetDdl(): void;
    /**
     * @stability stable
     */
    get ddlInput(): string[] | undefined;
    private _deletionProtection?;
    /**
     * @stability stable
     */
    get deletionProtection(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deletionProtection(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeletionProtection(): void;
    /**
     * @stability stable
     */
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instance?;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    get instanceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get state(): string;
    private _encryptionConfig;
    /**
     * @stability stable
     */
    get encryptionConfig(): SpannerDatabaseEncryptionConfigOutputReference;
    /**
     * @stability stable
     */
    putEncryptionConfig(value: SpannerDatabaseEncryptionConfig): void;
    /**
     * @stability stable
     */
    resetEncryptionConfig(): void;
    /**
     * @stability stable
     */
    get encryptionConfigInput(): SpannerDatabaseEncryptionConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SpannerDatabaseTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SpannerDatabaseTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SpannerDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
