# Generated by Django 3.1.14 on 2022-05-08 18:42

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("stores", "0008_order_status"),
    ]

    operations = [
        migrations.CreateModel(
            name="ShippingMethod",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "shipping_fee_option",
                    models.IntegerField(
                        choices=[(1, "Fixed"), (2, "per distance"), (3, "per weight")],
                        default=1,
                    ),
                ),
                ("name", models.CharField(help_text="Name", max_length=200)),
                ("description", models.TextField(blank=True, null=True)),
                ("is_active", models.BooleanField(default=True)),
                ("shipping_fee", models.DecimalField(decimal_places=4, max_digits=10)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Shipping Method",
                "verbose_name_plural": "Shipping Methods",
            },
        ),
        migrations.AddField(
            model_name="store",
            name="shipping_methods",
            field=models.ManyToManyField(
                blank=True,
                help_text="Shipping methods within the store",
                related_name="shipping_methods",
                to="stores.ShippingMethod",
            ),
        ),
    ]
