# Generated by Django 3.1.14 on 2022-06-08 14:02

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("stores", "0022_order_pickup_time"),
    ]

    operations = [
        migrations.CreateModel(
            name="Feedback",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "review",
                    models.CharField(
                        choices=[
                            ("GOOD", "Good"),
                            ("BAD", "Bad"),
                            ("NOT_AVAILABLE", "not available"),
                        ],
                        default="NOT_AVAILABLE",
                        max_length=100,
                    ),
                ),
                ("notes", models.TextField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "order",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="feedback",
                        to="stores.order",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="feedback",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="FeedbackConfig",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("attribute", models.CharField(max_length=100, unique=True)),
                (
                    "attribute_label",
                    models.CharField(blank=True, max_length=200, null=True),
                ),
                ("values", models.JSONField()),
            ],
        ),
        migrations.CreateModel(
            name="FeedbackAttribute",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("value", models.CharField(blank=True, max_length=100)),
                (
                    "review",
                    models.CharField(
                        choices=[
                            ("GOOD", "Good"),
                            ("BAD", "Bad"),
                            ("NOT_AVAILABLE", "not available"),
                        ],
                        max_length=100,
                    ),
                ),
                (
                    "config",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="stores.feedbackconfig",
                    ),
                ),
                (
                    "feedback",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attributes",
                        to="stores.feedback",
                    ),
                ),
            ],
        ),
    ]
