# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlEndpointArgs', 'SqlEndpoint']

@pulumi.input_type
class SqlEndpointArgs:
    def __init__(__self__, *,
                 cluster_size: pulumi.Input[str],
                 auto_stop_mins: Optional[pulumi.Input[int]] = None,
                 channel: Optional[pulumi.Input['SqlEndpointChannelArgs']] = None,
                 data_source_id: Optional[pulumi.Input[str]] = None,
                 enable_photon: Optional[pulumi.Input[bool]] = None,
                 enable_serverless_compute: Optional[pulumi.Input[bool]] = None,
                 instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 jdbc_url: Optional[pulumi.Input[str]] = None,
                 max_num_clusters: Optional[pulumi.Input[int]] = None,
                 min_num_clusters: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_clusters: Optional[pulumi.Input[int]] = None,
                 odbc_params: Optional[pulumi.Input['SqlEndpointOdbcParamsArgs']] = None,
                 spot_instance_policy: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input['SqlEndpointTagsArgs']] = None):
        """
        The set of arguments for constructing a SqlEndpoint resource.
        :param pulumi.Input[str] cluster_size: The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        :param pulumi.Input[int] auto_stop_mins: Time in minutes until an idle SQL endpoint terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        :param pulumi.Input['SqlEndpointChannelArgs'] channel: block, consisting of following fields:
        :param pulumi.Input[str] data_source_id: ID of the data source for this endpoint. This is used to bind an SQLA query to an endpoint.
        :param pulumi.Input[bool] enable_photon: Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        :param pulumi.Input[bool] enable_serverless_compute: Whether this SQL endpoint is a Serverless endpoint. To use a Serverless SQL endpoint, you must enable Serverless SQL endpoints for the workspace.
        :param pulumi.Input[str] jdbc_url: JDBC connection string.
        :param pulumi.Input[int] max_num_clusters: Maximum number of clusters available when a SQL endpoint is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        :param pulumi.Input[int] min_num_clusters: Minimum number of clusters available when a SQL endpoint is running. The default is `1`.
        :param pulumi.Input[str] name: Name of the Databricks SQL release channel. Possible values are: `CHANNEL_NAME_PREVIEW` and `CHANNEL_NAME_CURRENT`. Default is `CHANNEL_NAME_CURRENT`.
        :param pulumi.Input['SqlEndpointOdbcParamsArgs'] odbc_params: ODBC connection params: `odbc_params.hostname`, `odbc_params.path`, `odbc_params.protocol`, and `odbc_params.port`.
        :param pulumi.Input[str] spot_instance_policy: The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        :param pulumi.Input['SqlEndpointTagsArgs'] tags: Databricks tags all endpoint resources with these tags.
        """
        pulumi.set(__self__, "cluster_size", cluster_size)
        if auto_stop_mins is not None:
            pulumi.set(__self__, "auto_stop_mins", auto_stop_mins)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if enable_photon is not None:
            pulumi.set(__self__, "enable_photon", enable_photon)
        if enable_serverless_compute is not None:
            pulumi.set(__self__, "enable_serverless_compute", enable_serverless_compute)
        if instance_profile_arn is not None:
            pulumi.set(__self__, "instance_profile_arn", instance_profile_arn)
        if jdbc_url is not None:
            pulumi.set(__self__, "jdbc_url", jdbc_url)
        if max_num_clusters is not None:
            pulumi.set(__self__, "max_num_clusters", max_num_clusters)
        if min_num_clusters is not None:
            pulumi.set(__self__, "min_num_clusters", min_num_clusters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_clusters is not None:
            pulumi.set(__self__, "num_clusters", num_clusters)
        if odbc_params is not None:
            pulumi.set(__self__, "odbc_params", odbc_params)
        if spot_instance_policy is not None:
            pulumi.set(__self__, "spot_instance_policy", spot_instance_policy)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Input[str]:
        """
        The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter(name="autoStopMins")
    def auto_stop_mins(self) -> Optional[pulumi.Input[int]]:
        """
        Time in minutes until an idle SQL endpoint terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        """
        return pulumi.get(self, "auto_stop_mins")

    @auto_stop_mins.setter
    def auto_stop_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_stop_mins", value)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input['SqlEndpointChannelArgs']]:
        """
        block, consisting of following fields:
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input['SqlEndpointChannelArgs']]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the data source for this endpoint. This is used to bind an SQLA query to an endpoint.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source_id", value)

    @property
    @pulumi.getter(name="enablePhoton")
    def enable_photon(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        """
        return pulumi.get(self, "enable_photon")

    @enable_photon.setter
    def enable_photon(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_photon", value)

    @property
    @pulumi.getter(name="enableServerlessCompute")
    def enable_serverless_compute(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this SQL endpoint is a Serverless endpoint. To use a Serverless SQL endpoint, you must enable Serverless SQL endpoints for the workspace.
        """
        return pulumi.get(self, "enable_serverless_compute")

    @enable_serverless_compute.setter
    def enable_serverless_compute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_serverless_compute", value)

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_profile_arn")

    @instance_profile_arn.setter
    def instance_profile_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_profile_arn", value)

    @property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> Optional[pulumi.Input[str]]:
        """
        JDBC connection string.
        """
        return pulumi.get(self, "jdbc_url")

    @jdbc_url.setter
    def jdbc_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jdbc_url", value)

    @property
    @pulumi.getter(name="maxNumClusters")
    def max_num_clusters(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of clusters available when a SQL endpoint is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        """
        return pulumi.get(self, "max_num_clusters")

    @max_num_clusters.setter
    def max_num_clusters(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_num_clusters", value)

    @property
    @pulumi.getter(name="minNumClusters")
    def min_num_clusters(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of clusters available when a SQL endpoint is running. The default is `1`.
        """
        return pulumi.get(self, "min_num_clusters")

    @min_num_clusters.setter
    def min_num_clusters(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_num_clusters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Databricks SQL release channel. Possible values are: `CHANNEL_NAME_PREVIEW` and `CHANNEL_NAME_CURRENT`. Default is `CHANNEL_NAME_CURRENT`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numClusters")
    def num_clusters(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "num_clusters")

    @num_clusters.setter
    def num_clusters(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_clusters", value)

    @property
    @pulumi.getter(name="odbcParams")
    def odbc_params(self) -> Optional[pulumi.Input['SqlEndpointOdbcParamsArgs']]:
        """
        ODBC connection params: `odbc_params.hostname`, `odbc_params.path`, `odbc_params.protocol`, and `odbc_params.port`.
        """
        return pulumi.get(self, "odbc_params")

    @odbc_params.setter
    def odbc_params(self, value: Optional[pulumi.Input['SqlEndpointOdbcParamsArgs']]):
        pulumi.set(self, "odbc_params", value)

    @property
    @pulumi.getter(name="spotInstancePolicy")
    def spot_instance_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        """
        return pulumi.get(self, "spot_instance_policy")

    @spot_instance_policy.setter
    def spot_instance_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_instance_policy", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['SqlEndpointTagsArgs']]:
        """
        Databricks tags all endpoint resources with these tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['SqlEndpointTagsArgs']]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SqlEndpointState:
    def __init__(__self__, *,
                 auto_stop_mins: Optional[pulumi.Input[int]] = None,
                 channel: Optional[pulumi.Input['SqlEndpointChannelArgs']] = None,
                 cluster_size: Optional[pulumi.Input[str]] = None,
                 data_source_id: Optional[pulumi.Input[str]] = None,
                 enable_photon: Optional[pulumi.Input[bool]] = None,
                 enable_serverless_compute: Optional[pulumi.Input[bool]] = None,
                 instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 jdbc_url: Optional[pulumi.Input[str]] = None,
                 max_num_clusters: Optional[pulumi.Input[int]] = None,
                 min_num_clusters: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_clusters: Optional[pulumi.Input[int]] = None,
                 odbc_params: Optional[pulumi.Input['SqlEndpointOdbcParamsArgs']] = None,
                 spot_instance_policy: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input['SqlEndpointTagsArgs']] = None):
        """
        Input properties used for looking up and filtering SqlEndpoint resources.
        :param pulumi.Input[int] auto_stop_mins: Time in minutes until an idle SQL endpoint terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        :param pulumi.Input['SqlEndpointChannelArgs'] channel: block, consisting of following fields:
        :param pulumi.Input[str] cluster_size: The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        :param pulumi.Input[str] data_source_id: ID of the data source for this endpoint. This is used to bind an SQLA query to an endpoint.
        :param pulumi.Input[bool] enable_photon: Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        :param pulumi.Input[bool] enable_serverless_compute: Whether this SQL endpoint is a Serverless endpoint. To use a Serverless SQL endpoint, you must enable Serverless SQL endpoints for the workspace.
        :param pulumi.Input[str] jdbc_url: JDBC connection string.
        :param pulumi.Input[int] max_num_clusters: Maximum number of clusters available when a SQL endpoint is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        :param pulumi.Input[int] min_num_clusters: Minimum number of clusters available when a SQL endpoint is running. The default is `1`.
        :param pulumi.Input[str] name: Name of the Databricks SQL release channel. Possible values are: `CHANNEL_NAME_PREVIEW` and `CHANNEL_NAME_CURRENT`. Default is `CHANNEL_NAME_CURRENT`.
        :param pulumi.Input['SqlEndpointOdbcParamsArgs'] odbc_params: ODBC connection params: `odbc_params.hostname`, `odbc_params.path`, `odbc_params.protocol`, and `odbc_params.port`.
        :param pulumi.Input[str] spot_instance_policy: The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        :param pulumi.Input['SqlEndpointTagsArgs'] tags: Databricks tags all endpoint resources with these tags.
        """
        if auto_stop_mins is not None:
            pulumi.set(__self__, "auto_stop_mins", auto_stop_mins)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if enable_photon is not None:
            pulumi.set(__self__, "enable_photon", enable_photon)
        if enable_serverless_compute is not None:
            pulumi.set(__self__, "enable_serverless_compute", enable_serverless_compute)
        if instance_profile_arn is not None:
            pulumi.set(__self__, "instance_profile_arn", instance_profile_arn)
        if jdbc_url is not None:
            pulumi.set(__self__, "jdbc_url", jdbc_url)
        if max_num_clusters is not None:
            pulumi.set(__self__, "max_num_clusters", max_num_clusters)
        if min_num_clusters is not None:
            pulumi.set(__self__, "min_num_clusters", min_num_clusters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_clusters is not None:
            pulumi.set(__self__, "num_clusters", num_clusters)
        if odbc_params is not None:
            pulumi.set(__self__, "odbc_params", odbc_params)
        if spot_instance_policy is not None:
            pulumi.set(__self__, "spot_instance_policy", spot_instance_policy)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoStopMins")
    def auto_stop_mins(self) -> Optional[pulumi.Input[int]]:
        """
        Time in minutes until an idle SQL endpoint terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        """
        return pulumi.get(self, "auto_stop_mins")

    @auto_stop_mins.setter
    def auto_stop_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_stop_mins", value)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input['SqlEndpointChannelArgs']]:
        """
        block, consisting of following fields:
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input['SqlEndpointChannelArgs']]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the data source for this endpoint. This is used to bind an SQLA query to an endpoint.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source_id", value)

    @property
    @pulumi.getter(name="enablePhoton")
    def enable_photon(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        """
        return pulumi.get(self, "enable_photon")

    @enable_photon.setter
    def enable_photon(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_photon", value)

    @property
    @pulumi.getter(name="enableServerlessCompute")
    def enable_serverless_compute(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this SQL endpoint is a Serverless endpoint. To use a Serverless SQL endpoint, you must enable Serverless SQL endpoints for the workspace.
        """
        return pulumi.get(self, "enable_serverless_compute")

    @enable_serverless_compute.setter
    def enable_serverless_compute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_serverless_compute", value)

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_profile_arn")

    @instance_profile_arn.setter
    def instance_profile_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_profile_arn", value)

    @property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> Optional[pulumi.Input[str]]:
        """
        JDBC connection string.
        """
        return pulumi.get(self, "jdbc_url")

    @jdbc_url.setter
    def jdbc_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jdbc_url", value)

    @property
    @pulumi.getter(name="maxNumClusters")
    def max_num_clusters(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of clusters available when a SQL endpoint is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        """
        return pulumi.get(self, "max_num_clusters")

    @max_num_clusters.setter
    def max_num_clusters(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_num_clusters", value)

    @property
    @pulumi.getter(name="minNumClusters")
    def min_num_clusters(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of clusters available when a SQL endpoint is running. The default is `1`.
        """
        return pulumi.get(self, "min_num_clusters")

    @min_num_clusters.setter
    def min_num_clusters(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_num_clusters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Databricks SQL release channel. Possible values are: `CHANNEL_NAME_PREVIEW` and `CHANNEL_NAME_CURRENT`. Default is `CHANNEL_NAME_CURRENT`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numClusters")
    def num_clusters(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "num_clusters")

    @num_clusters.setter
    def num_clusters(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_clusters", value)

    @property
    @pulumi.getter(name="odbcParams")
    def odbc_params(self) -> Optional[pulumi.Input['SqlEndpointOdbcParamsArgs']]:
        """
        ODBC connection params: `odbc_params.hostname`, `odbc_params.path`, `odbc_params.protocol`, and `odbc_params.port`.
        """
        return pulumi.get(self, "odbc_params")

    @odbc_params.setter
    def odbc_params(self, value: Optional[pulumi.Input['SqlEndpointOdbcParamsArgs']]):
        pulumi.set(self, "odbc_params", value)

    @property
    @pulumi.getter(name="spotInstancePolicy")
    def spot_instance_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        """
        return pulumi.get(self, "spot_instance_policy")

    @spot_instance_policy.setter
    def spot_instance_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_instance_policy", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['SqlEndpointTagsArgs']]:
        """
        Databricks tags all endpoint resources with these tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['SqlEndpointTagsArgs']]):
        pulumi.set(self, "tags", value)


class SqlEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_stop_mins: Optional[pulumi.Input[int]] = None,
                 channel: Optional[pulumi.Input[pulumi.InputType['SqlEndpointChannelArgs']]] = None,
                 cluster_size: Optional[pulumi.Input[str]] = None,
                 data_source_id: Optional[pulumi.Input[str]] = None,
                 enable_photon: Optional[pulumi.Input[bool]] = None,
                 enable_serverless_compute: Optional[pulumi.Input[bool]] = None,
                 instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 jdbc_url: Optional[pulumi.Input[str]] = None,
                 max_num_clusters: Optional[pulumi.Input[int]] = None,
                 min_num_clusters: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_clusters: Optional[pulumi.Input[int]] = None,
                 odbc_params: Optional[pulumi.Input[pulumi.InputType['SqlEndpointOdbcParamsArgs']]] = None,
                 spot_instance_policy: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[pulumi.InputType['SqlEndpointTagsArgs']]] = None,
                 __props__=None):
        """
        This resource is used to manage [Databricks SQL Endpoints](https://docs.databricks.com/sql/admin/sql-endpoints.html). To create [SQL endpoints](https://docs.databricks.com/sql/get-started/concepts.html) you must have `databricks_sql_access` on your Group or databricks_user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.get_current_user()
        this = databricks.SqlEndpoint("this",
            cluster_size="Small",
            max_num_clusters=1,
            tags=databricks.SqlEndpointTagsArgs(
                custom_tags=[databricks.SqlEndpointTagsCustomTagArgs(
                    key="City",
                    value="Amsterdam",
                )],
            ))
        ```
        ## Access Control

        * Permissions can control which groups or individual users can *Can Use* or *Can Manage* SQL endpoints.
        * `databricks_sql_access` on Group or databricks_user.

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * InstanceProfile to manage AWS EC2 instance profiles that users can launch Cluster and access data, like databricks_mount.
        * SqlDashboard to manage Databricks SQL [Dashboards](https://docs.databricks.com/sql/user/dashboards/index.html).
        * SqlGlobalConfig to configure the security policy, databricks_instance_profile, and [data access properties](https://docs.databricks.com/sql/admin/data-access-configuration.html) for all SqlEndpoint of workspace.
        * SqlPermissions to manage data object access control lists in Databricks workspaces for things like tables, views, databases, and [more](https://docs.databricks.com/security/access-control/table-acls/object-privileges.html).

        ## Import

        You can import a `databricks_sql_endpoint` resource with ID like the followingbash

        ```sh
         $ pulumi import databricks:index/sqlEndpoint:SqlEndpoint this <endpoint-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] auto_stop_mins: Time in minutes until an idle SQL endpoint terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        :param pulumi.Input[pulumi.InputType['SqlEndpointChannelArgs']] channel: block, consisting of following fields:
        :param pulumi.Input[str] cluster_size: The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        :param pulumi.Input[str] data_source_id: ID of the data source for this endpoint. This is used to bind an SQLA query to an endpoint.
        :param pulumi.Input[bool] enable_photon: Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        :param pulumi.Input[bool] enable_serverless_compute: Whether this SQL endpoint is a Serverless endpoint. To use a Serverless SQL endpoint, you must enable Serverless SQL endpoints for the workspace.
        :param pulumi.Input[str] jdbc_url: JDBC connection string.
        :param pulumi.Input[int] max_num_clusters: Maximum number of clusters available when a SQL endpoint is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        :param pulumi.Input[int] min_num_clusters: Minimum number of clusters available when a SQL endpoint is running. The default is `1`.
        :param pulumi.Input[str] name: Name of the Databricks SQL release channel. Possible values are: `CHANNEL_NAME_PREVIEW` and `CHANNEL_NAME_CURRENT`. Default is `CHANNEL_NAME_CURRENT`.
        :param pulumi.Input[pulumi.InputType['SqlEndpointOdbcParamsArgs']] odbc_params: ODBC connection params: `odbc_params.hostname`, `odbc_params.path`, `odbc_params.protocol`, and `odbc_params.port`.
        :param pulumi.Input[str] spot_instance_policy: The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        :param pulumi.Input[pulumi.InputType['SqlEndpointTagsArgs']] tags: Databricks tags all endpoint resources with these tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource is used to manage [Databricks SQL Endpoints](https://docs.databricks.com/sql/admin/sql-endpoints.html). To create [SQL endpoints](https://docs.databricks.com/sql/get-started/concepts.html) you must have `databricks_sql_access` on your Group or databricks_user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.get_current_user()
        this = databricks.SqlEndpoint("this",
            cluster_size="Small",
            max_num_clusters=1,
            tags=databricks.SqlEndpointTagsArgs(
                custom_tags=[databricks.SqlEndpointTagsCustomTagArgs(
                    key="City",
                    value="Amsterdam",
                )],
            ))
        ```
        ## Access Control

        * Permissions can control which groups or individual users can *Can Use* or *Can Manage* SQL endpoints.
        * `databricks_sql_access` on Group or databricks_user.

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * InstanceProfile to manage AWS EC2 instance profiles that users can launch Cluster and access data, like databricks_mount.
        * SqlDashboard to manage Databricks SQL [Dashboards](https://docs.databricks.com/sql/user/dashboards/index.html).
        * SqlGlobalConfig to configure the security policy, databricks_instance_profile, and [data access properties](https://docs.databricks.com/sql/admin/data-access-configuration.html) for all SqlEndpoint of workspace.
        * SqlPermissions to manage data object access control lists in Databricks workspaces for things like tables, views, databases, and [more](https://docs.databricks.com/security/access-control/table-acls/object-privileges.html).

        ## Import

        You can import a `databricks_sql_endpoint` resource with ID like the followingbash

        ```sh
         $ pulumi import databricks:index/sqlEndpoint:SqlEndpoint this <endpoint-id>
        ```

        :param str resource_name: The name of the resource.
        :param SqlEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_stop_mins: Optional[pulumi.Input[int]] = None,
                 channel: Optional[pulumi.Input[pulumi.InputType['SqlEndpointChannelArgs']]] = None,
                 cluster_size: Optional[pulumi.Input[str]] = None,
                 data_source_id: Optional[pulumi.Input[str]] = None,
                 enable_photon: Optional[pulumi.Input[bool]] = None,
                 enable_serverless_compute: Optional[pulumi.Input[bool]] = None,
                 instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 jdbc_url: Optional[pulumi.Input[str]] = None,
                 max_num_clusters: Optional[pulumi.Input[int]] = None,
                 min_num_clusters: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_clusters: Optional[pulumi.Input[int]] = None,
                 odbc_params: Optional[pulumi.Input[pulumi.InputType['SqlEndpointOdbcParamsArgs']]] = None,
                 spot_instance_policy: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[pulumi.InputType['SqlEndpointTagsArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlEndpointArgs.__new__(SqlEndpointArgs)

            __props__.__dict__["auto_stop_mins"] = auto_stop_mins
            __props__.__dict__["channel"] = channel
            if cluster_size is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_size'")
            __props__.__dict__["cluster_size"] = cluster_size
            __props__.__dict__["data_source_id"] = data_source_id
            __props__.__dict__["enable_photon"] = enable_photon
            __props__.__dict__["enable_serverless_compute"] = enable_serverless_compute
            __props__.__dict__["instance_profile_arn"] = instance_profile_arn
            __props__.__dict__["jdbc_url"] = jdbc_url
            __props__.__dict__["max_num_clusters"] = max_num_clusters
            __props__.__dict__["min_num_clusters"] = min_num_clusters
            __props__.__dict__["name"] = name
            __props__.__dict__["num_clusters"] = num_clusters
            __props__.__dict__["odbc_params"] = odbc_params
            __props__.__dict__["spot_instance_policy"] = spot_instance_policy
            __props__.__dict__["state"] = state
            __props__.__dict__["tags"] = tags
        super(SqlEndpoint, __self__).__init__(
            'databricks:index/sqlEndpoint:SqlEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_stop_mins: Optional[pulumi.Input[int]] = None,
            channel: Optional[pulumi.Input[pulumi.InputType['SqlEndpointChannelArgs']]] = None,
            cluster_size: Optional[pulumi.Input[str]] = None,
            data_source_id: Optional[pulumi.Input[str]] = None,
            enable_photon: Optional[pulumi.Input[bool]] = None,
            enable_serverless_compute: Optional[pulumi.Input[bool]] = None,
            instance_profile_arn: Optional[pulumi.Input[str]] = None,
            jdbc_url: Optional[pulumi.Input[str]] = None,
            max_num_clusters: Optional[pulumi.Input[int]] = None,
            min_num_clusters: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            num_clusters: Optional[pulumi.Input[int]] = None,
            odbc_params: Optional[pulumi.Input[pulumi.InputType['SqlEndpointOdbcParamsArgs']]] = None,
            spot_instance_policy: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[pulumi.InputType['SqlEndpointTagsArgs']]] = None) -> 'SqlEndpoint':
        """
        Get an existing SqlEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] auto_stop_mins: Time in minutes until an idle SQL endpoint terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        :param pulumi.Input[pulumi.InputType['SqlEndpointChannelArgs']] channel: block, consisting of following fields:
        :param pulumi.Input[str] cluster_size: The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        :param pulumi.Input[str] data_source_id: ID of the data source for this endpoint. This is used to bind an SQLA query to an endpoint.
        :param pulumi.Input[bool] enable_photon: Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        :param pulumi.Input[bool] enable_serverless_compute: Whether this SQL endpoint is a Serverless endpoint. To use a Serverless SQL endpoint, you must enable Serverless SQL endpoints for the workspace.
        :param pulumi.Input[str] jdbc_url: JDBC connection string.
        :param pulumi.Input[int] max_num_clusters: Maximum number of clusters available when a SQL endpoint is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        :param pulumi.Input[int] min_num_clusters: Minimum number of clusters available when a SQL endpoint is running. The default is `1`.
        :param pulumi.Input[str] name: Name of the Databricks SQL release channel. Possible values are: `CHANNEL_NAME_PREVIEW` and `CHANNEL_NAME_CURRENT`. Default is `CHANNEL_NAME_CURRENT`.
        :param pulumi.Input[pulumi.InputType['SqlEndpointOdbcParamsArgs']] odbc_params: ODBC connection params: `odbc_params.hostname`, `odbc_params.path`, `odbc_params.protocol`, and `odbc_params.port`.
        :param pulumi.Input[str] spot_instance_policy: The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        :param pulumi.Input[pulumi.InputType['SqlEndpointTagsArgs']] tags: Databricks tags all endpoint resources with these tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlEndpointState.__new__(_SqlEndpointState)

        __props__.__dict__["auto_stop_mins"] = auto_stop_mins
        __props__.__dict__["channel"] = channel
        __props__.__dict__["cluster_size"] = cluster_size
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["enable_photon"] = enable_photon
        __props__.__dict__["enable_serverless_compute"] = enable_serverless_compute
        __props__.__dict__["instance_profile_arn"] = instance_profile_arn
        __props__.__dict__["jdbc_url"] = jdbc_url
        __props__.__dict__["max_num_clusters"] = max_num_clusters
        __props__.__dict__["min_num_clusters"] = min_num_clusters
        __props__.__dict__["name"] = name
        __props__.__dict__["num_clusters"] = num_clusters
        __props__.__dict__["odbc_params"] = odbc_params
        __props__.__dict__["spot_instance_policy"] = spot_instance_policy
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        return SqlEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoStopMins")
    def auto_stop_mins(self) -> pulumi.Output[Optional[int]]:
        """
        Time in minutes until an idle SQL endpoint terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        """
        return pulumi.get(self, "auto_stop_mins")

    @property
    @pulumi.getter
    def channel(self) -> pulumi.Output[Optional['outputs.SqlEndpointChannel']]:
        """
        block, consisting of following fields:
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Output[str]:
        """
        The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        """
        return pulumi.get(self, "cluster_size")

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[str]:
        """
        ID of the data source for this endpoint. This is used to bind an SQLA query to an endpoint.
        """
        return pulumi.get(self, "data_source_id")

    @property
    @pulumi.getter(name="enablePhoton")
    def enable_photon(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        """
        return pulumi.get(self, "enable_photon")

    @property
    @pulumi.getter(name="enableServerlessCompute")
    def enable_serverless_compute(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether this SQL endpoint is a Serverless endpoint. To use a Serverless SQL endpoint, you must enable Serverless SQL endpoints for the workspace.
        """
        return pulumi.get(self, "enable_serverless_compute")

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "instance_profile_arn")

    @property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> pulumi.Output[str]:
        """
        JDBC connection string.
        """
        return pulumi.get(self, "jdbc_url")

    @property
    @pulumi.getter(name="maxNumClusters")
    def max_num_clusters(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of clusters available when a SQL endpoint is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        """
        return pulumi.get(self, "max_num_clusters")

    @property
    @pulumi.getter(name="minNumClusters")
    def min_num_clusters(self) -> pulumi.Output[Optional[int]]:
        """
        Minimum number of clusters available when a SQL endpoint is running. The default is `1`.
        """
        return pulumi.get(self, "min_num_clusters")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Databricks SQL release channel. Possible values are: `CHANNEL_NAME_PREVIEW` and `CHANNEL_NAME_CURRENT`. Default is `CHANNEL_NAME_CURRENT`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numClusters")
    def num_clusters(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "num_clusters")

    @property
    @pulumi.getter(name="odbcParams")
    def odbc_params(self) -> pulumi.Output['outputs.SqlEndpointOdbcParams']:
        """
        ODBC connection params: `odbc_params.hostname`, `odbc_params.path`, `odbc_params.protocol`, and `odbc_params.port`.
        """
        return pulumi.get(self, "odbc_params")

    @property
    @pulumi.getter(name="spotInstancePolicy")
    def spot_instance_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        """
        return pulumi.get(self, "spot_instance_policy")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional['outputs.SqlEndpointTags']]:
        """
        Databricks tags all endpoint resources with these tags.
        """
        return pulumi.get(self, "tags")

