# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/retraitement_erfs-fpr/modules/copules_03_add_var.ipynb (unless otherwise specified).

__all__ = [
    "config",
    "aggregats",
    "tc",
    "integration_data_ff",
    "liste_des_variables_csg",
    "get_ratios",
    "convert_to_openfisca",
]

# Cell
import json
import unittest

import pandas as pd
from leximpact_socio_fisca_simu_etat.aggregates_read import Aggregate
from leximpact_socio_fisca_simu_etat.config import Configuration

from .monte_carlo import apply_Monte_Carlo

config = Configuration(project_folder="leximpact-prepare-data")
aggregats = Aggregate(config.get("AGREGATS"))
tc = unittest.TestCase()

# Cell


def integration_data_ff(sample_pop_ff, data_to_process, nb_tirage):
    for data in data_to_process:
        # On charge les copules
        with open(config.get("COPULES") + data["file"]) as fichier:
            dict_copules_RFR_Data = json.load(fichier)
        print(
            f"Nombre de bucket : {len(dict_copules_RFR_Data)} Nombre de sous-bucket : {len(dict_copules_RFR_Data[1]['buckets'])}"
        )
        # Chercher la distribution optimale
        # On ajoute une distribution de data dans notre échantillon de population
        # Pour chaque ligne de l'ERFS-FPR on appel calcul_distrib_from_copules en lui donnant le RFR de la ligne en cours.
        df, errors = apply_Monte_Carlo(
            df=sample_pop_ff,
            copules=dict_copules_RFR_Data,
            bucket_level_col_name="rfr",
            out_col=data["column_name"],
            nb_tirage=nb_tirage,
            use_force_mean_with_factor=True,
            debug=True,
        )

    return sample_pop_ff, data_to_process


# Cell
liste_des_variables_csg = pd.read_csv(
    config.get("CALIB") + "agregats_des_variables_csg-POTE_2019.csv"
)
pd.set_option("display.max_colwidth", 80)
pd.options.display.float_format = "{:,.7f}".format

# Cell
# avec le get_agregate de simu-etat


def get_ratios(year: str):
    variable_type = "sum"

    pote_rev_capital = (
        aggregats.get_aggregate(
            year,
            "revenus_capitaux_prelevement_bareme",
            "POTE",
            variable_type,
        )
        + aggregats.get_aggregate(
            year,
            "revenus_capitaux_prelevement_liberatoire",
            "POTE",
            variable_type,
        )
        + aggregats.get_aggregate(
            year,
            "revenus_capitaux_prelevement_forfaitaire_unique_ir",
            "POTE",
            variable_type,
        )
    )
    return {
        "ratio_revenus_capitaux_prelevement_bareme": aggregats.get_aggregate(
            year,
            "revenus_capitaux_prelevement_bareme",
            "POTE",
            variable_type,
        )
        / pote_rev_capital,
        "ratio_revenus_capitaux_prelevement_liberatoire": aggregats.get_aggregate(
            year,
            "revenus_capitaux_prelevement_liberatoire",
            "POTE",
            variable_type,
        )
        / pote_rev_capital,
        "ratio_revenus_capitaux_prelevement_forfaitaire_unique_ir": aggregats.get_aggregate(
            year,
            "revenus_capitaux_prelevement_forfaitaire_unique_ir",
            "POTE",
            variable_type,
        )
        / pote_rev_capital,
    }


# Cell


def convert_to_openfisca(data, year):
    # On voudrait faire: dummy_data_csg['revenus_capital'] = dummy_data_final_rk['rk']
    revenus_capital = data["pote_rev_capital"]

    # Dans OpenFisca, on calcule rk ainsi: rk = revenus_capitaux_prelevement_bareme + revenus_capitaux_prelevement_liberatoire + revenus_capitaux_prelevement_forfaitaire_unique_ir
    ratios = get_ratios(year)
    data["revenus_capitaux_prelevement_bareme"] = (
        revenus_capital * ratios["ratio_revenus_capitaux_prelevement_bareme"]
    )
    data["revenus_capitaux_prelevement_liberatoire"] = (
        revenus_capital * ratios["ratio_revenus_capitaux_prelevement_liberatoire"]
    )
    data["revenus_capitaux_prelevement_forfaitaire_unique_ir"] = (
        revenus_capital
        * ratios["ratio_revenus_capitaux_prelevement_forfaitaire_unique_ir"]
    )
    #     # Rentes Viageres
    #     data["rente_viagere_titre_onereux_net"] = data["pote_rente_viagere"]
    #     # Revenu catégoriel foncier
    #     data["revenu_categoriel_foncier"] = data["pote_rev_categ_foncier"]
    #     # Plus-values
    #     data["assiette_csg_plus_values"] = data["pote_plus_values"]

    # On n'ajoute pas chomage_brut ni  retraite_brute car déjà présent dans ERFS_FPR
    #     data["chomage_brut"] = data[
    #         "pote_chomage"
    #     ]  # À vérifier : est-ce que c'est bien chomage brut qu'on calcule a partir de POTE ? OU : y etait-il deja avant, dans l'ERFS-FPR ?
    #     data["retraite_brute"] = data[
    #         "pote_retraite"
    #     ]  # À vérifier : est-ce que c'est bien retraite brute qu'on calcule a partir de POTE ?

    return data
