# Code generated by lark_sdk_gen. DO NOT EDIT.

import typing
from pylark.lark_request import Response

from pylark.api_service_message_send import (
    SendRawMessageReq,
    SendRawMessageResp,
    _gen_send_raw_message_req,
)
from pylark.api_service_message_send_old import (
    SendRawMessageOldReq,
    SendRawMessageOldResp,
    _gen_send_raw_message_old_req,
)
from pylark.api_service_message_reply import (
    ReplyRawMessageReq,
    ReplyRawMessageResp,
    _gen_reply_raw_message_req,
)
from pylark.api_service_message_delete import (
    DeleteMessageReq,
    DeleteMessageResp,
    _gen_delete_message_req,
)
from pylark.api_service_message_update import (
    UpdateMessageReq,
    UpdateMessageResp,
    _gen_update_message_req,
)
from pylark.api_service_message_get_read_user_list import (
    GetMessageReadUserListReq,
    GetMessageReadUserListResp,
    _gen_get_message_read_user_list_req,
)
from pylark.api_service_message_list import (
    GetMessageListReq,
    GetMessageListResp,
    _gen_get_message_list_req,
)
from pylark.api_service_message_get_file import (
    GetMessageFileReq,
    GetMessageFileResp,
    _gen_get_message_file_req,
)
from pylark.api_service_message_get import (
    GetMessageReq,
    GetMessageResp,
    _gen_get_message_req,
)
from pylark.api_service_message_ephemeral_delete import (
    DeleteEphemeralMessageReq,
    DeleteEphemeralMessageResp,
    _gen_delete_ephemeral_message_req,
)


if typing.TYPE_CHECKING:
    from lark import Lark


class LarkMessageService(object):
    cli: "Lark"

    def __init__(self, cli: "Lark"):
        self.cli = cli

    def send_raw_message(
        self, request: SendRawMessageReq, options: typing.List[str] = None
    ) -> typing.Tuple[SendRawMessageResp, Response]:
        return self.cli.raw_request(_gen_send_raw_message_req(request, options))

    def send_raw_message_old(
        self, request: SendRawMessageOldReq, options: typing.List[str] = None
    ) -> typing.Tuple[SendRawMessageOldResp, Response]:
        return self.cli.raw_request(_gen_send_raw_message_old_req(request, options))

    def reply_raw_message(
        self, request: ReplyRawMessageReq, options: typing.List[str] = None
    ) -> typing.Tuple[ReplyRawMessageResp, Response]:
        return self.cli.raw_request(_gen_reply_raw_message_req(request, options))

    def delete_message(
        self, request: DeleteMessageReq, options: typing.List[str] = None
    ) -> typing.Tuple[DeleteMessageResp, Response]:
        return self.cli.raw_request(_gen_delete_message_req(request, options))

    def update_message(
        self, request: UpdateMessageReq, options: typing.List[str] = None
    ) -> typing.Tuple[UpdateMessageResp, Response]:
        return self.cli.raw_request(_gen_update_message_req(request, options))

    def get_message_read_user_list(
        self, request: GetMessageReadUserListReq, options: typing.List[str] = None
    ) -> typing.Tuple[GetMessageReadUserListResp, Response]:
        return self.cli.raw_request(
            _gen_get_message_read_user_list_req(request, options)
        )

    def get_message_list(
        self, request: GetMessageListReq, options: typing.List[str] = None
    ) -> typing.Tuple[GetMessageListResp, Response]:
        return self.cli.raw_request(_gen_get_message_list_req(request, options))

    def get_message_file(
        self, request: GetMessageFileReq, options: typing.List[str] = None
    ) -> typing.Tuple[GetMessageFileResp, Response]:
        return self.cli.raw_request(_gen_get_message_file_req(request, options))

    def get_message(
        self, request: GetMessageReq, options: typing.List[str] = None
    ) -> typing.Tuple[GetMessageResp, Response]:
        return self.cli.raw_request(_gen_get_message_req(request, options))

    def delete_ephemeral_message(
        self, request: DeleteEphemeralMessageReq, options: typing.List[str] = None
    ) -> typing.Tuple[DeleteEphemeralMessageResp, Response]:
        return self.cli.raw_request(_gen_delete_ephemeral_message_req(request, options))
