import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [kafka-cluster](https://docs.aws.amazon.com/service-authorization/latest/reference/list_apachekafkaapisforamazonmskclusters.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class KafkaCluster extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [kafka-cluster](https://docs.aws.amazon.com/service-authorization/latest/reference/list_apachekafkaapisforamazonmskclusters.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to alter various aspects of the cluster, equivalent to Apache Kafka's ALTER CLUSTER ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeCluster
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterCluster(): this;
    /**
     * Grants permission to alter the dynamic configuration of a cluster, equivalent to Apache Kafka's ALTER_CONFIGS CLUSTER ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeClusterDynamicConfiguration
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterClusterDynamicConfiguration(): this;
    /**
     * Grants permission to join groups on a cluster, equivalent to Apache Kafka's READ GROUP ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeGroup
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterGroup(): this;
    /**
     * Grants permission to alter topics on a cluster, equivalent to Apache Kafka's ALTER TOPIC ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTopic
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterTopic(): this;
    /**
     * Grants permission to alter the dynamic configuration of topics on a cluster, equivalent to Apache Kafka's ALTER_CONFIGS TOPIC ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTopicDynamicConfiguration
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterTopicDynamicConfiguration(): this;
    /**
     * Grants permission to alter transactional IDs on a cluster, equivalent to Apache Kafka's WRITE TRANSACTIONAL_ID ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTransactionalId
     * - kafka-cluster:WriteData
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterTransactionalId(): this;
    /**
     * Grants permission to connect and authenticate to the cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toConnect(): this;
    /**
     * Grants permission to create topics on a cluster, equivalent to Apache Kafka's CREATE CLUSTER/TOPIC ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toCreateTopic(): this;
    /**
     * Grants permission to delete groups on a cluster, equivalent to Apache Kafka's DELETE GROUP ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeGroup
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDeleteGroup(): this;
    /**
     * Grants permission to delete topics on a cluster, equivalent to Apache Kafka's DELETE TOPIC ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTopic
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDeleteTopic(): this;
    /**
     * Grants permission to describe various aspects of the cluster, equivalent to Apache Kafka's DESCRIBE CLUSTER ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeCluster(): this;
    /**
     * Grants permission to describe the dynamic configuration of a cluster, equivalent to Apache Kafka's DESCRIBE_CONFIGS CLUSTER ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeClusterDynamicConfiguration(): this;
    /**
     * Grants permission to describe groups on a cluster, equivalent to Apache Kafka's DESCRIBE GROUP ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeGroup(): this;
    /**
     * Grants permission to describe topics on a cluster, equivalent to Apache Kafka's DESCRIBE TOPIC ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeTopic(): this;
    /**
     * Grants permission to describe the dynamic configuration of topics on a cluster, equivalent to Apache Kafka's DESCRIBE_CONFIGS TOPIC ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeTopicDynamicConfiguration(): this;
    /**
     * Grants permission to describe transactional IDs on a cluster, equivalent to Apache Kafka's DESCRIBE TRANSACTIONAL_ID ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeTransactionalId(): this;
    /**
     * Grants permission to read data from topics on a cluster, equivalent to Apache Kafka's READ TOPIC ACL
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - kafka-cluster:AlterGroup
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTopic
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toReadData(): this;
    /**
     * Grants permission to write data to topics on a cluster, equivalent to Apache Kafka's WRITE TOPIC ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTopic
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toWriteData(): this;
    /**
     * Grants permission to write data idempotently on a cluster, equivalent to Apache Kafka's IDEMPOTENT_WRITE CLUSTER ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:WriteData
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toWriteDataIdempotently(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type cluster to the statement
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#msk-iam-resources
     *
     * @param clusterName - Identifier for the clusterName.
     * @param clusterUuid - Identifier for the clusterUuid.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCluster(clusterName: string, clusterUuid: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type topic to the statement
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#msk-iam-resources
     *
     * @param clusterName - Identifier for the clusterName.
     * @param clusterUuid - Identifier for the clusterUuid.
     * @param topicName - Identifier for the topicName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onTopic(clusterName: string, clusterUuid: string, topicName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type group to the statement
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#msk-iam-resources
     *
     * @param clusterName - Identifier for the clusterName.
     * @param clusterUuid - Identifier for the clusterUuid.
     * @param groupName - Identifier for the groupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onGroup(clusterName: string, clusterUuid: string, groupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type transactional-id to the statement
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#msk-iam-resources
     *
     * @param clusterName - Identifier for the clusterName.
     * @param clusterUuid - Identifier for the clusterUuid.
     * @param transactionalId - Identifier for the transactionalId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onTransactionalId(clusterName: string, clusterUuid: string, transactionalId: string, account?: string, region?: string, partition?: string): this;
}
