"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Apprunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [apprunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapprunner.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Apprunner extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [apprunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapprunner.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'apprunner';
        this.accessLevelList = {
            Write: [
                'AssociateCustomDomain',
                'CreateAutoScalingConfiguration',
                'CreateConnection',
                'CreateService',
                'CreateVpcConnector',
                'DeleteAutoScalingConfiguration',
                'DeleteConnection',
                'DeleteService',
                'DeleteVpcConnector',
                'DisassociateCustomDomain',
                'PauseService',
                'ResumeService',
                'StartDeployment',
                'UpdateService'
            ],
            Read: [
                'DescribeAutoScalingConfiguration',
                'DescribeCustomDomains',
                'DescribeOperation',
                'DescribeService',
                'DescribeVpcConnector',
                'ListTagsForResource'
            ],
            List: [
                'ListAutoScalingConfigurations',
                'ListConnections',
                'ListOperations',
                'ListServices',
                'ListVpcConnectors'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate your own domain name with the AWS App Runner subdomain URL of your App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_AssociateCustomDomain.html
     */
    toAssociateCustomDomain() {
        return this.to('AssociateCustomDomain');
    }
    /**
     * Grants permission to create an AWS App Runner automatic scaling configuration resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateAutoScalingConfiguration.html
     */
    toCreateAutoScalingConfiguration() {
        return this.to('CreateAutoScalingConfiguration');
    }
    /**
     * Grants permission to create an AWS App Runner connection resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateConnection.html
     */
    toCreateConnection() {
        return this.to('CreateConnection');
    }
    /**
     * Grants permission to create an AWS App Runner service resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifConnectionArn()
     * - .ifAutoScalingConfigurationArn()
     * - .ifVpcConnectorArn()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html
     */
    toCreateService() {
        return this.to('CreateService');
    }
    /**
     * Grants permission to create an AWS App Runner VPC connector resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateVpcConnector.html
     */
    toCreateVpcConnector() {
        return this.to('CreateVpcConnector');
    }
    /**
     * Grants permission to delete an AWS App Runner automatic scaling configuration resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteAutoScalingConfiguration.html
     */
    toDeleteAutoScalingConfiguration() {
        return this.to('DeleteAutoScalingConfiguration');
    }
    /**
     * Grants permission to delete an AWS App Runner connection resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteConnection.html
     */
    toDeleteConnection() {
        return this.to('DeleteConnection');
    }
    /**
     * Grants permission to delete an AWS App Runner service resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html
     */
    toDeleteService() {
        return this.to('DeleteService');
    }
    /**
     * Grants permission to delete an AWS App Runner VPC connector resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteVpcConnector.html
     */
    toDeleteVpcConnector() {
        return this.to('DeleteVpcConnector');
    }
    /**
     * Grants permission to retrieve the description of an AWS App Runner automatic scaling configuration resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeAutoScalingConfiguration.html
     */
    toDescribeAutoScalingConfiguration() {
        return this.to('DescribeAutoScalingConfiguration');
    }
    /**
     * Grants permission to retrieve descriptions of custom domain names associated with an AWS App Runner service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeCustomDomains.html
     */
    toDescribeCustomDomains() {
        return this.to('DescribeCustomDomains');
    }
    /**
     * Grants permission to retrieve the description of an operation that occurred on an AWS App Runner service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeOperation.html
     */
    toDescribeOperation() {
        return this.to('DescribeOperation');
    }
    /**
     * Grants permission to retrieve the description of an AWS App Runner service resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html
     */
    toDescribeService() {
        return this.to('DescribeService');
    }
    /**
     * Grants permission to retrieve the description of an AWS App Runner VPC connector resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeVpcConnector.html
     */
    toDescribeVpcConnector() {
        return this.to('DescribeVpcConnector');
    }
    /**
     * Grants permission to disassociate a custom domain name from an AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DisassociateCustomDomain.html
     */
    toDisassociateCustomDomain() {
        return this.to('DisassociateCustomDomain');
    }
    /**
     * Grants permission to retrieve a list of AWS App Runner automatic scaling configurations in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListAutoScalingConfigurations.html
     */
    toListAutoScalingConfigurations() {
        return this.to('ListAutoScalingConfigurations');
    }
    /**
     * Grants permission to retrieve a list of AWS App Runner connections in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListConnections.html
     */
    toListConnections() {
        return this.to('ListConnections');
    }
    /**
     * Grants permission to retrieve a list of operations that occurred on an AWS App Runner service resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html
     */
    toListOperations() {
        return this.to('ListOperations');
    }
    /**
     * Grants permission to retrieve a list of running AWS App Runner services in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html
     */
    toListServices() {
        return this.to('ListServices');
    }
    /**
     * Grants permission to list tags associated with an AWS App Runner resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to retrieve a list of AWS App Runner VPC connectors in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListVpcConnectors.html
     */
    toListVpcConnectors() {
        return this.to('ListVpcConnectors');
    }
    /**
     * Grants permission to pause an active AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_PauseService.html
     */
    toPauseService() {
        return this.to('PauseService');
    }
    /**
     * Grants permission to resume an active AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ResumeService.html
     */
    toResumeService() {
        return this.to('ResumeService');
    }
    /**
     * Grants permission to initiate a manual deployemnt to an AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_StartDeployment.html
     */
    toStartDeployment() {
        return this.to('StartDeployment');
    }
    /**
     * Grants permission to add tags to, or update tag values of, an AWS App Runner resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from an AWS App Runner resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update an AWS App Runner service resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifConnectionArn()
     * - .ifAutoScalingConfigurationArn()
     * - .ifVpcConnectorArn()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_UpdateService.html
     */
    toUpdateService() {
        return this.to('UpdateService');
    }
    /**
     * Adds a resource of type service to the statement
     *
     * @param serviceName - Identifier for the serviceName.
     * @param serviceId - Identifier for the serviceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onService(serviceName, serviceId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:apprunner:${region || '*'}:${account || '*'}:service/${serviceName}/${serviceId}`);
    }
    /**
     * Adds a resource of type connection to the statement
     *
     * @param connectionName - Identifier for the connectionName.
     * @param connectionId - Identifier for the connectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnection(connectionName, connectionId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:apprunner:${region || '*'}:${account || '*'}:connection/${connectionName}/${connectionId}`);
    }
    /**
     * Adds a resource of type autoscalingconfiguration to the statement
     *
     * @param autoscalingConfigurationName - Identifier for the autoscalingConfigurationName.
     * @param autoscalingConfigurationVersion - Identifier for the autoscalingConfigurationVersion.
     * @param autoscalingConfigurationId - Identifier for the autoscalingConfigurationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAutoscalingconfiguration(autoscalingConfigurationName, autoscalingConfigurationVersion, autoscalingConfigurationId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:apprunner:${region || '*'}:${account || '*'}:autoscalingconfiguration/${autoscalingConfigurationName}/${autoscalingConfigurationVersion}/${autoscalingConfigurationId}`);
    }
    /**
     * Adds a resource of type vpcconnector to the statement
     *
     * @param vpcConnectorName - Identifier for the vpcConnectorName.
     * @param vpcConnectorVersion - Identifier for the vpcConnectorVersion.
     * @param vpcConnectorId - Identifier for the vpcConnectorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVpcconnector(vpcConnectorName, vpcConnectorVersion, vpcConnectorId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:apprunner:${region || '*'}:${account || '*'}:vpcconnector/${vpcConnectorName}/${vpcConnectorVersion}/${vpcConnectorId}`);
    }
    /**
     * Filters access by the CreateService and UpdateService actions based on the ARN of an associated AutoScalingConfiguration resource
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifAutoScalingConfigurationArn(value, operator) {
        return this.if(`AutoScalingConfigurationArn`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the CreateService and UpdateService actions based on the ARN of an associated Connection resource
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifConnectionArn(value, operator) {
        return this.if(`ConnectionArn`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the CreateService and UpdateService actions based on the ARN of an associated VpcConnector resource
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifVpcConnectorArn(value, operator) {
        return this.if(`VpcConnectorArn`, value, operator || 'ArnLike');
    }
}
exports.Apprunner = Apprunner;
_a = JSII_RTTI_SYMBOL_1;
Apprunner[_a] = { fqn: "iam-floyd.Apprunner", version: "0.325.0" };
//# sourceMappingURL=data:application/json;base64,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