"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Evidently = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [evidently](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchevidently.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Evidently extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [evidently](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchevidently.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'evidently';
        this.accessLevelList = {
            Write: [
                'CreateExperiment',
                'CreateFeature',
                'CreateLaunch',
                'CreateProject',
                'DeleteExperiment',
                'DeleteFeature',
                'DeleteLaunch',
                'DeleteProject',
                'StartExperiment',
                'StartLaunch',
                'StopExperiment',
                'StopLaunch',
                'UpdateExperiment',
                'UpdateFeature',
                'UpdateLaunch',
                'UpdateProject',
                'UpdateProjectDataDelivery'
            ],
            Read: [
                'GetExperiment',
                'GetExperimentResults',
                'GetFeature',
                'GetLaunch',
                'GetProject',
                'ListExperiments',
                'ListFeatures',
                'ListLaunches',
                'ListProjects',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create an experiment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_CreateExperiment.html
     */
    toCreateExperiment() {
        return this.to('CreateExperiment');
    }
    /**
     * Grants permission to create a feature
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_CreateFeature.html
     */
    toCreateFeature() {
        return this.to('CreateFeature');
    }
    /**
     * Grants permission to create a launch
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_CreateLaunch.html
     */
    toCreateLaunch() {
        return this.to('CreateLaunch');
    }
    /**
     * Grants permission to create a project
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_CreateProject.html
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Grants permission to delete an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_DeleteExperiment.html
     */
    toDeleteExperiment() {
        return this.to('DeleteExperiment');
    }
    /**
     * Grants permission to delete a feature
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_DeleteFeature.html
     */
    toDeleteFeature() {
        return this.to('DeleteFeature');
    }
    /**
     * Grants permission to delete a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_DeleteLaunch.html
     */
    toDeleteLaunch() {
        return this.to('DeleteLaunch');
    }
    /**
     * Grants permission to delete a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_DeleteProject.html
     */
    toDeleteProject() {
        return this.to('DeleteProject');
    }
    /**
     * Grants permission to get experiment details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_GetExperiment.html
     */
    toGetExperiment() {
        return this.to('GetExperiment');
    }
    /**
     * Grants permission to get experiment result
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_GetExperimentResults.html
     */
    toGetExperimentResults() {
        return this.to('GetExperimentResults');
    }
    /**
     * Grants permission to get feature details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_GetFeature.html
     */
    toGetFeature() {
        return this.to('GetFeature');
    }
    /**
     * Grants permission to get launch details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_GetLaunch.html
     */
    toGetLaunch() {
        return this.to('GetLaunch');
    }
    /**
     * Grants permission to get project details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_GetProject.html
     */
    toGetProject() {
        return this.to('GetProject');
    }
    /**
     * Grants permission to list experiments
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_ListExperiments.html
     */
    toListExperiments() {
        return this.to('ListExperiments');
    }
    /**
     * Grants permission to list features
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_ListFeatures.html
     */
    toListFeatures() {
        return this.to('ListFeatures');
    }
    /**
     * Grants permission to list launches
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_ListLaunches.html
     */
    toListLaunches() {
        return this.to('ListLaunches');
    }
    /**
     * Grants permission to list projects
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_ListProjects.html
     */
    toListProjects() {
        return this.to('ListProjects');
    }
    /**
     * Grants permission to list tags for resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to start an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_StartExperiment.html
     */
    toStartExperiment() {
        return this.to('StartExperiment');
    }
    /**
     * Grants permission to start a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_StartLaunch.html
     */
    toStartLaunch() {
        return this.to('StartLaunch');
    }
    /**
     * Grants permission to stop an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_StopExperiment.html
     */
    toStopExperiment() {
        return this.to('StopExperiment');
    }
    /**
     * Grants permission to stop a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_StopLaunch.html
     */
    toStopLaunch() {
        return this.to('StopLaunch');
    }
    /**
     * Grants permission to tag resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_UpdateExperiment.html
     */
    toUpdateExperiment() {
        return this.to('UpdateExperiment');
    }
    /**
     * Grants permission to update feature
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_UpdateFeature.html
     */
    toUpdateFeature() {
        return this.to('UpdateFeature');
    }
    /**
     * Grants permission to update a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_UpdateLaunch.html
     */
    toUpdateLaunch() {
        return this.to('UpdateLaunch');
    }
    /**
     * Grants permission to update project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_UpdateProject.html
     */
    toUpdateProject() {
        return this.to('UpdateProject');
    }
    /**
     * Grants permission to update project data delivery
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_UpdateProjectDataDelivery.html
     */
    toUpdateProjectDataDelivery() {
        return this.to('UpdateProjectDataDelivery');
    }
    /**
     * Adds a resource of type Project to the statement
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/projects.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProject(ownerAccountId, projectName, region, partition) {
        return this.on(`arn:${partition || 'aws'}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}`);
    }
    /**
     * Adds a resource of type Feature to the statement
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/features.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param featureName - Identifier for the featureName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFeature(ownerAccountId, projectName, featureName, region, partition) {
        return this.on(`arn:${partition || 'aws'}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}/feature/${featureName}`);
    }
    /**
     * Adds a resource of type Experiment to the statement
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/experiments.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param experimentName - Identifier for the experimentName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExperiment(ownerAccountId, projectName, experimentName, region, partition) {
        return this.on(`arn:${partition || 'aws'}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}/experiment/${experimentName}`);
    }
    /**
     * Adds a resource of type Launch to the statement
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/launches.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param launchName - Identifier for the launchName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLaunch(ownerAccountId, projectName, launchName, region, partition) {
        return this.on(`arn:${partition || 'aws'}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}/launch/${launchName}`);
    }
}
exports.Evidently = Evidently;
_a = JSII_RTTI_SYMBOL_1;
Evidently[_a] = { fqn: "iam-floyd.Evidently", version: "0.325.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xvdWR3YXRjaGV2aWRlbnRseS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNsb3Vkd2F0Y2hldmlkZW50bHkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSxzQ0FBNEM7QUFFNUM7Ozs7R0FJRztBQUNILE1BQWEsU0FBVSxTQUFRLHdCQUFlO0lBRzVDOzs7O09BSUc7SUFDSCxZQUFZLEdBQVk7UUFDdEIsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBUk4sa0JBQWEsR0FBRyxXQUFXLENBQUM7UUEwVnpCLG9CQUFlLEdBQW9CO1lBQzNDLEtBQUssRUFBRTtnQkFDTCxrQkFBa0I7Z0JBQ2xCLGVBQWU7Z0JBQ2YsY0FBYztnQkFDZCxlQUFlO2dCQUNmLGtCQUFrQjtnQkFDbEIsZUFBZTtnQkFDZixjQUFjO2dCQUNkLGVBQWU7Z0JBQ2YsaUJBQWlCO2dCQUNqQixhQUFhO2dCQUNiLGdCQUFnQjtnQkFDaEIsWUFBWTtnQkFDWixrQkFBa0I7Z0JBQ2xCLGVBQWU7Z0JBQ2YsY0FBYztnQkFDZCxlQUFlO2dCQUNmLDJCQUEyQjthQUM1QjtZQUNELElBQUksRUFBRTtnQkFDSixlQUFlO2dCQUNmLHNCQUFzQjtnQkFDdEIsWUFBWTtnQkFDWixXQUFXO2dCQUNYLFlBQVk7Z0JBQ1osaUJBQWlCO2dCQUNqQixjQUFjO2dCQUNkLGNBQWM7Z0JBQ2QsY0FBYztnQkFDZCxxQkFBcUI7YUFDdEI7WUFDRCxPQUFPLEVBQUU7Z0JBQ1AsYUFBYTtnQkFDYixlQUFlO2FBQ2hCO1NBQ0YsQ0FBQztJQXJYRixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksY0FBYztRQUNuQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakMsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksY0FBYztRQUNuQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxZQUFZO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksV0FBVztRQUNoQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUIsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFlBQVk7UUFDakIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxjQUFjO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksY0FBYztRQUNuQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUJBQWlCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxZQUFZO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksYUFBYTtRQUNsQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxjQUFjO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDJCQUEyQjtRQUNoQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBd0NEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLFNBQVMsQ0FBQyxjQUFzQixFQUFFLFdBQW1CLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQy9GLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxLQUFNLGNBQWUsTUFBTSxJQUFJLEdBQUksSUFBSyxjQUFlLFlBQWEsV0FBWSxFQUFFLENBQUMsQ0FBQztJQUMxSCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7T0FhRztJQUNJLFNBQVMsQ0FBQyxjQUFzQixFQUFFLFdBQW1CLEVBQUUsV0FBbUIsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDcEgsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sY0FBZSxNQUFNLElBQUksR0FBSSxJQUFLLGNBQWUsWUFBYSxXQUFZLFlBQWEsV0FBWSxFQUFFLENBQUMsQ0FBQztJQUNuSixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7T0FhRztJQUNJLFlBQVksQ0FBQyxjQUFzQixFQUFFLFdBQW1CLEVBQUUsY0FBc0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDMUgsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sY0FBZSxNQUFNLElBQUksR0FBSSxJQUFLLGNBQWUsWUFBYSxXQUFZLGVBQWdCLGNBQWUsRUFBRSxDQUFDLENBQUM7SUFDekosQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7O09BYUc7SUFDSSxRQUFRLENBQUMsY0FBc0IsRUFBRSxXQUFtQixFQUFFLFVBQWtCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ2xILE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxLQUFNLGNBQWUsTUFBTSxJQUFJLEdBQUksSUFBSyxjQUFlLFlBQWEsV0FBWSxXQUFZLFVBQVcsRUFBRSxDQUFDLENBQUM7SUFDakosQ0FBQzs7QUF0Y0gsOEJBdWNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWNjZXNzTGV2ZWxMaXN0IH0gZnJvbSAnLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbCc7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICcuLi9zaGFyZWQnO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbZXZpZGVudGx5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hbWF6b25jbG91ZHdhdGNoZXZpZGVudGx5Lmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgRXZpZGVudGx5IGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnZXZpZGVudGx5JztcblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtldmlkZW50bHldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2FtYXpvbmNsb3Vkd2F0Y2hldmlkZW50bHkuaHRtbCkuXG4gICAqXG4gICAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICAgKi9cbiAgY29uc3RydWN0b3Ioc2lkPzogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2lkKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYW4gZXhwZXJpbWVudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9ldmlkZW50bHkvbGF0ZXN0L2RnL0FQSV9DcmVhdGVFeHBlcmltZW50Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUV4cGVyaW1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUV4cGVyaW1lbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBmZWF0dXJlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvQVBJX0NyZWF0ZUZlYXR1cmUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlRmVhdHVyZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlRmVhdHVyZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIGxhdW5jaFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9ldmlkZW50bHkvbGF0ZXN0L2RnL0FQSV9DcmVhdGVMYXVuY2guaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlTGF1bmNoKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVMYXVuY2gnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBwcm9qZWN0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvQVBJX0NyZWF0ZVByb2plY3QuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlUHJvamVjdCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlUHJvamVjdCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhbiBleHBlcmltZW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvQVBJX0RlbGV0ZUV4cGVyaW1lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlRXhwZXJpbWVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlRXhwZXJpbWVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIGZlYXR1cmVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9BUElfRGVsZXRlRmVhdHVyZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVGZWF0dXJlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVGZWF0dXJlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGEgbGF1bmNoXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvQVBJX0RlbGV0ZUxhdW5jaC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVMYXVuY2goKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUxhdW5jaCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIHByb2plY3RcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9BUElfRGVsZXRlUHJvamVjdC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVQcm9qZWN0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVQcm9qZWN0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGV4cGVyaW1lbnQgZGV0YWlsc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvQVBJX0dldEV4cGVyaW1lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RXhwZXJpbWVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0RXhwZXJpbWVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBleHBlcmltZW50IHJlc3VsdFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvQVBJX0dldEV4cGVyaW1lbnRSZXN1bHRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEV4cGVyaW1lbnRSZXN1bHRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRFeHBlcmltZW50UmVzdWx0cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBmZWF0dXJlIGRldGFpbHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9ldmlkZW50bHkvbGF0ZXN0L2RnL0FQSV9HZXRGZWF0dXJlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEZlYXR1cmUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEZlYXR1cmUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgbGF1bmNoIGRldGFpbHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9ldmlkZW50bHkvbGF0ZXN0L2RnL0FQSV9HZXRMYXVuY2guaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0TGF1bmNoKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRMYXVuY2gnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgcHJvamVjdCBkZXRhaWxzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9BUElfR2V0UHJvamVjdC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRQcm9qZWN0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRQcm9qZWN0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBleHBlcmltZW50c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvQVBJX0xpc3RFeHBlcmltZW50cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RXhwZXJpbWVudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RFeHBlcmltZW50cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgZmVhdHVyZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9ldmlkZW50bHkvbGF0ZXN0L2RnL0FQSV9MaXN0RmVhdHVyZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEZlYXR1cmVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RmVhdHVyZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGxhdW5jaGVzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9BUElfTGlzdExhdW5jaGVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RMYXVuY2hlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdExhdW5jaGVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBwcm9qZWN0c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvQVBJX0xpc3RQcm9qZWN0cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0UHJvamVjdHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RQcm9qZWN0cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGFncyBmb3IgcmVzb3VyY2VzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9BUElfTGlzdFRhZ3NGb3JSZXNvdXJjZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0VGFnc0ZvclJlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0VGFnc0ZvclJlc291cmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc3RhcnQgYW4gZXhwZXJpbWVudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9ldmlkZW50bHkvbGF0ZXN0L2RnL0FQSV9TdGFydEV4cGVyaW1lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU3RhcnRFeHBlcmltZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydEV4cGVyaW1lbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzdGFydCBhIGxhdW5jaFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9ldmlkZW50bHkvbGF0ZXN0L2RnL0FQSV9TdGFydExhdW5jaC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TdGFydExhdW5jaCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU3RhcnRMYXVuY2gnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzdG9wIGFuIGV4cGVyaW1lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9BUElfU3RvcEV4cGVyaW1lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU3RvcEV4cGVyaW1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N0b3BFeHBlcmltZW50Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc3RvcCBhIGxhdW5jaFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9ldmlkZW50bHkvbGF0ZXN0L2RnL0FQSV9TdG9wTGF1bmNoLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0b3BMYXVuY2goKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N0b3BMYXVuY2gnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB0YWcgcmVzb3VyY2VzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9BUElfVGFnUmVzb3VyY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVGFnUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1RhZ1Jlc291cmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdW50YWcgcmVzb3VyY2VzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9BUElfVW50YWdSZXNvdXJjZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VbnRhZ1Jlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVbnRhZ1Jlc291cmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGV4cGVyaW1lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9BUElfVXBkYXRlRXhwZXJpbWVudC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVFeHBlcmltZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVFeHBlcmltZW50Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGZlYXR1cmVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9BUElfVXBkYXRlRmVhdHVyZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVGZWF0dXJlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVGZWF0dXJlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgbGF1bmNoXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvQVBJX1VwZGF0ZUxhdW5jaC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVMYXVuY2goKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUxhdW5jaCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBwcm9qZWN0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvQVBJX1VwZGF0ZVByb2plY3QuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlUHJvamVjdCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlUHJvamVjdCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBwcm9qZWN0IGRhdGEgZGVsaXZlcnlcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9BUElfVXBkYXRlUHJvamVjdERhdGFEZWxpdmVyeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVQcm9qZWN0RGF0YURlbGl2ZXJ5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVQcm9qZWN0RGF0YURlbGl2ZXJ5Jyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgV3JpdGU6IFtcbiAgICAgICdDcmVhdGVFeHBlcmltZW50JyxcbiAgICAgICdDcmVhdGVGZWF0dXJlJyxcbiAgICAgICdDcmVhdGVMYXVuY2gnLFxuICAgICAgJ0NyZWF0ZVByb2plY3QnLFxuICAgICAgJ0RlbGV0ZUV4cGVyaW1lbnQnLFxuICAgICAgJ0RlbGV0ZUZlYXR1cmUnLFxuICAgICAgJ0RlbGV0ZUxhdW5jaCcsXG4gICAgICAnRGVsZXRlUHJvamVjdCcsXG4gICAgICAnU3RhcnRFeHBlcmltZW50JyxcbiAgICAgICdTdGFydExhdW5jaCcsXG4gICAgICAnU3RvcEV4cGVyaW1lbnQnLFxuICAgICAgJ1N0b3BMYXVuY2gnLFxuICAgICAgJ1VwZGF0ZUV4cGVyaW1lbnQnLFxuICAgICAgJ1VwZGF0ZUZlYXR1cmUnLFxuICAgICAgJ1VwZGF0ZUxhdW5jaCcsXG4gICAgICAnVXBkYXRlUHJvamVjdCcsXG4gICAgICAnVXBkYXRlUHJvamVjdERhdGFEZWxpdmVyeSdcbiAgICBdLFxuICAgIFJlYWQ6IFtcbiAgICAgICdHZXRFeHBlcmltZW50JyxcbiAgICAgICdHZXRFeHBlcmltZW50UmVzdWx0cycsXG4gICAgICAnR2V0RmVhdHVyZScsXG4gICAgICAnR2V0TGF1bmNoJyxcbiAgICAgICdHZXRQcm9qZWN0JyxcbiAgICAgICdMaXN0RXhwZXJpbWVudHMnLFxuICAgICAgJ0xpc3RGZWF0dXJlcycsXG4gICAgICAnTGlzdExhdW5jaGVzJyxcbiAgICAgICdMaXN0UHJvamVjdHMnLFxuICAgICAgJ0xpc3RUYWdzRm9yUmVzb3VyY2UnXG4gICAgXSxcbiAgICBUYWdnaW5nOiBbXG4gICAgICAnVGFnUmVzb3VyY2UnLFxuICAgICAgJ1VudGFnUmVzb3VyY2UnXG4gICAgXVxuICB9O1xuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBQcm9qZWN0IHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvcHJvamVjdHMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gb3duZXJBY2NvdW50SWQgLSBJZGVudGlmaWVyIGZvciB0aGUgb3duZXJBY2NvdW50SWQuXG4gICAqIEBwYXJhbSBwcm9qZWN0TmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBwcm9qZWN0TmFtZS5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvblByb2plY3Qob3duZXJBY2NvdW50SWQ6IHN0cmluZywgcHJvamVjdE5hbWU6IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCAnYXdzJyB9OmV2aWRlbnRseTokeyByZWdpb24gfHwgJyonIH06JHsgb3duZXJBY2NvdW50SWQgfTpwcm9qZWN0LyR7IHByb2plY3ROYW1lIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBGZWF0dXJlIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvZmVhdHVyZXMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gb3duZXJBY2NvdW50SWQgLSBJZGVudGlmaWVyIGZvciB0aGUgb3duZXJBY2NvdW50SWQuXG4gICAqIEBwYXJhbSBwcm9qZWN0TmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBwcm9qZWN0TmFtZS5cbiAgICogQHBhcmFtIGZlYXR1cmVOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIGZlYXR1cmVOYW1lLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uRmVhdHVyZShvd25lckFjY291bnRJZDogc3RyaW5nLCBwcm9qZWN0TmFtZTogc3RyaW5nLCBmZWF0dXJlTmFtZTogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8ICdhd3MnIH06ZXZpZGVudGx5OiR7IHJlZ2lvbiB8fCAnKicgfTokeyBvd25lckFjY291bnRJZCB9OnByb2plY3QvJHsgcHJvamVjdE5hbWUgfS9mZWF0dXJlLyR7IGZlYXR1cmVOYW1lIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBFeHBlcmltZW50IHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2aWRlbnRseS9sYXRlc3QvZGcvZXhwZXJpbWVudHMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gb3duZXJBY2NvdW50SWQgLSBJZGVudGlmaWVyIGZvciB0aGUgb3duZXJBY2NvdW50SWQuXG4gICAqIEBwYXJhbSBwcm9qZWN0TmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBwcm9qZWN0TmFtZS5cbiAgICogQHBhcmFtIGV4cGVyaW1lbnROYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIGV4cGVyaW1lbnROYW1lLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uRXhwZXJpbWVudChvd25lckFjY291bnRJZDogc3RyaW5nLCBwcm9qZWN0TmFtZTogc3RyaW5nLCBleHBlcmltZW50TmFtZTogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8ICdhd3MnIH06ZXZpZGVudGx5OiR7IHJlZ2lvbiB8fCAnKicgfTokeyBvd25lckFjY291bnRJZCB9OnByb2plY3QvJHsgcHJvamVjdE5hbWUgfS9leHBlcmltZW50LyR7IGV4cGVyaW1lbnROYW1lIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBMYXVuY2ggdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZpZGVudGx5L2xhdGVzdC9kZy9sYXVuY2hlcy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBvd25lckFjY291bnRJZCAtIElkZW50aWZpZXIgZm9yIHRoZSBvd25lckFjY291bnRJZC5cbiAgICogQHBhcmFtIHByb2plY3ROYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIHByb2plY3ROYW1lLlxuICAgKiBAcGFyYW0gbGF1bmNoTmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBsYXVuY2hOYW1lLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uTGF1bmNoKG93bmVyQWNjb3VudElkOiBzdHJpbmcsIHByb2plY3ROYW1lOiBzdHJpbmcsIGxhdW5jaE5hbWU6IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCAnYXdzJyB9OmV2aWRlbnRseTokeyByZWdpb24gfHwgJyonIH06JHsgb3duZXJBY2NvdW50SWQgfTpwcm9qZWN0LyR7IHByb2plY3ROYW1lIH0vbGF1bmNoLyR7IGxhdW5jaE5hbWUgfWApO1xuICB9XG59XG4iXX0=