import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [transfer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstransferfamily.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Transfer extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [transfer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstransferfamily.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to add an access associated with a server
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateAccess.html
     */
    toCreateAccess(): this;
    /**
     * Grants permission to create a server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateServer.html
     */
    toCreateServer(): this;
    /**
     * Grants permission to add a user associated with a server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateUser.html
     */
    toCreateUser(): this;
    /**
     * Grants permission to create a workflow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateWorkflow.html
     */
    toCreateWorkflow(): this;
    /**
     * Grants permission to delete access
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteAccess.html
     */
    toDeleteAccess(): this;
    /**
     * Grants permission to delete a server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteServer.html
     */
    toDeleteServer(): this;
    /**
     * Grants permission to delete an SSH public key from a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteSshPublicKey.html
     */
    toDeleteSshPublicKey(): this;
    /**
     * Grants permission to delete a user associated with a server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteUser.html
     */
    toDeleteUser(): this;
    /**
     * Grants permission to delete a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteWorkflow.html
     */
    toDeleteWorkflow(): this;
    /**
     * Grants permission to describe an access assigned to a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeAccess.html
     */
    toDescribeAccess(): this;
    /**
     * Grants permission to describe an execution associated with a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeExecution.html
     */
    toDescribeExecution(): this;
    /**
     * Grants permission to describe a security policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeSecurityPolicy.html
     */
    toDescribeSecurityPolicy(): this;
    /**
     * Grants permission to describe a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeServer.html
     */
    toDescribeServer(): this;
    /**
     * Grants permission to describe a user associated with a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeUser.html
     */
    toDescribeUser(): this;
    /**
     * Grants permission to describe a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeWorkflow.html
     */
    toDescribeWorkflow(): this;
    /**
     * Grants permission to add an SSH public key to a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ImportSshPublicKey.html
     */
    toImportSshPublicKey(): this;
    /**
     * Grants permission to list accesses
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListAccesses.html
     */
    toListAccesses(): this;
    /**
     * Grants permission to list executions associated with a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListExecutions.html
     */
    toListExecutions(): this;
    /**
     * Grants permission to list security policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListSecurityPolicies.html
     */
    toListSecurityPolicies(): this;
    /**
     * Grants permission to list servers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListServers.html
     */
    toListServers(): this;
    /**
     * Grants permission to list tags for a server, a user, or a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list users associated with a server
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListUsers.html
     */
    toListUsers(): this;
    /**
     * Grants permission to list workflows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListWorkflows.html
     */
    toListWorkflows(): this;
    /**
     * Grants permission to send a callback for asynchronous custom steps
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_SendWorkflowStepState.html
     */
    toSendWorkflowStepState(): this;
    /**
     * Grants permission to start a server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_StartServer.html
     */
    toStartServer(): this;
    /**
     * Grants permission to stop a server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_StopServer.html
     */
    toStopServer(): this;
    /**
     * Grants permission to tag a server or a user
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to test a server's custom identity provider
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_TestIdentityProvider.html
     */
    toTestIdentityProvider(): this;
    /**
     * Grants permission to untag a server, a user, or a workflow
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update access
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateAccess.html
     */
    toUpdateAccess(): this;
    /**
     * Grants permission to update the configuration of a server
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html
     */
    toUpdateServer(): this;
    /**
     * Grants permission to update the configuration of a user
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateUser.html
     */
    toUpdateUser(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/create-user.html
     *
     * @param serverId - Identifier for the serverId.
     * @param username - Identifier for the username.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUser(serverId: string, username: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type server to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/configuring-servers.html
     *
     * @param serverId - Identifier for the serverId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServer(serverId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workflow to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/transfer-workflows.html
     *
     * @param workflowId - Identifier for the workflowId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkflow(workflowId: string, account?: string, region?: string, partition?: string): this;
}
