# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI_Pred.ipynb (unless otherwise specified).

__all__ = ["logger"]

# Cell

from typing import *

# Internal Cell

import os
import typer
from typer import echo
from tabulate import tabulate

from . import helper
from ..logger import get_logger, set_level

# Internal Cell

app = typer.Typer(
    help="A set of commands for managing and downloading the predictions."
)

# Cell

logger = get_logger(__name__)

# Internal Cell


@app.command()
@helper.requires_auth_token
def ls(
    offset: int = typer.Option(
        0,
        "--offset",
        "-o",
        help="The number of predictions to offset at the beginning. If None, then the default value **0** will be used.",
    ),
    limit: int = typer.Option(
        100,
        "--limit",
        "-l",
        help="The maximum number of predictions to return from the server. If None, "
        "then the default value **100** will be used.",
    ),
    disabled: bool = typer.Option(
        False,
        "--disabled",
        help="If set to **True**, then only the deleted predictions will be returned. Else, the default value "
        "**False** will be used to return only the list of active predictions.",
    ),
    completed: bool = typer.Option(
        False,
        "--completed",
        help="If set to **True**, then only the predictions that are successfully downloaded "
        "to the server will be returned. Else, the default value **False** will be used to "
        "return all the predictions.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output only ids of prediction separated by space.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Return the list of predictions available in the server."""

    from ..client import Prediction

    predx = Prediction.ls(
        offset=offset, limit=limit, disabled=disabled, completed=completed
    )

    df = Prediction.as_df(predx)

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        ids = df["id"].astype(str).to_list()
        typer.echo("\n".join(ids))
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def details(
    id: int = typer.Argument(
        ...,
        help="Prediction id in the server.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Return the details of a prediction."""

    from ..client import Prediction

    pred = Prediction(id=int(id))
    df = pred.details()

    df["created"] = helper.humanize_date(df["created"])

    typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def rm(
    id: int = typer.Argument(
        ...,
        help="Prediction id in the server.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output the deleted prediction id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Delete a prediction from the server."""

    from ..client import Prediction

    pred = Prediction(id=int(id))
    df = pred.delete()

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        typer.echo(df.iloc[0]["id"])
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command("to-pandas")
@helper.requires_auth_token
def to_pandas(
    id: int = typer.Argument(
        ...,
        help="Prediction id in the server.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Return the prediction results as a pandas DataFrame."""

    from ..client import Prediction

    pred = Prediction(id=int(id))

    df = pred.to_pandas()

    typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))
