# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI_Token.ipynb (unless otherwise specified).

__all__ = ["logger"]

# Cell

from typing import *

# Internal Cell

import os
import typer
import logging

from ..client import Client
from ..logger import get_logger, set_level

# Internal Cell

app = typer.Typer()

# Cell

logger = get_logger(__name__)

# Internal Cell


def token(
    username: Optional[str] = typer.Option(
        None,
        "--username",
        "-u",
        help="Username for the developer account. If None (default value), then the value from "
        "**AIRT_SERVICE_USERNAME** environment variable is used.",
    ),
    password: Optional[str] = typer.Option(
        None,
        "--password",
        "-p",
        help="Password for the developer account. If None (default value), then the value from "
        "**AIRT_SERVICE_PASSWORD** environment variable is used.",
    ),
    server: Optional[str] = typer.Option(
        None,
        "--server",
        "-s",
        help="The airt server uri. If None (default value), then the value from **AIRT_SERVER_URL** environment variable "
        "is used. If the variable is not set as well, then the default public server will be used. Please leave this "
        "setting to default unless you are running the service in your own server (please email us to info@airt.ai "
        "for that possibility).",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output authentication token only.",
    ),
    debug: bool = typer.Option(
        False, "--debug", "-d", help="Set logger level to DEBUG and output everything."
    ),
) -> None:
    """Get application token for airt service from a username/password pair.

    To access the airt service, you must create a developer account. Please contact us by email info@airt.ai to get one.

    Finally, you need an application token to access all the APIs in airt service. Please run the command **airt token**
    with the username/password to get one. You can either pass the username, password, and server address as command line
    arguments or store them in the **AIRT_SERVICE_USERNAME**, **AIRT_SERVICE_PASSWORD**, and **AIRT_SERVER_URL** environment variables.

    Upon receiving the application token, please set it in the environment variable **AIRT_SERVICE_TOKEN** for accessing the airt service.
    """
    try:
        if debug:
            set_level(logging.DEBUG)
        else:
            set_level(logging.WARNING)

        Client.get_token(username=username, password=password, server=server)

        if quiet:
            typer.echo(Client.auth_token)
        else:
            typer.echo(f"token: {Client.auth_token}")

    except KeyError as e:
        typer.echo(message=f"Error: {e}", err=True)
        typer.echo(f"\nTry 'airt token --help' for help.")
        raise typer.Exit(code=1)

    except Exception as e:
        typer.echo(message=f"Error: {e}", err=True)
        raise typer.Exit(code=1)


# Internal Cell


app.command()(token)
