from enum import Enum


class OrderAction(str, Enum):
    """
    CHECK: Check order and get SMS if it's finished.
    FINISH: Finish order, when you have obtained the SMS.
    CANCEL: Cancel an order, when you haven't obtained the SMS yet.
    BAN: Ban the number of the order.
    """
    CHECK = 'check'
    FINISH = 'finish'
    CANCEL = 'cancel'
    BAN = 'ban'


class Status(str, Enum):
    PENDING = 'preparation'
    RECEIVED = 'waiting of receipt of SMS'
    CANCELED = 'is cancelled'
    TIMEOUT = 'a timeout'
    FINISHED = 'is complete'
    BANNED = 'number banned, when number already used'
    INVALID = 'the status returned by the API is not defined'

    def get_description(self) -> str:
        """
        Get the description of the current status.
        """
        return self.value

    @classmethod
    def from_status_string(cls, status: str):
        """
        Create a new instance of the Status enum.
        :param status: the uppercase key
        """
        try:
            return cls[status]
        except:
            return Status.INVALID


class Language(str, Enum):
    ENGLISH = 'en'
    RUSSIAN = 'ru'


class Category(str, Enum):
    HOSTING = 'hosting'
    ACTIVATION = 'activation'


class VendorPaymentMethod(str, Enum):
    VISA = 'visa'
    QIWI = 'qiwi'
    YANDEX = 'yandex'


class VendorPaymentSystem(str, Enum):
    FKWALLET = 'fkwallet'
    PAYEER = 'payeer'
    UNITPAY = 'unitpay'


class Operator(str, Enum):
    ANY_OPERATOR = 'any'
    N_019 = '019'
    ACTIV = 'activ'
    ALTEL = 'altel'
    BEELINE = 'beeline'
    CLARO = 'claro'
    EE = 'ee'
    GLOBE = 'globe'
    KCELL = 'kcell'
    KYIVSTAR = 'kyivstar'
    LEBARA = 'lebara'
    LYCAMOBILE = 'lycamobile'
    MATRIX = 'matrix'
    MEGAFON = 'megafon'
    MTS = 'mts'
    ORANGE = 'orange'
    PILDYK = 'pildyk'
    PLAY = 'play'
    REDBULLMOBILE = 'redbullmobile'
    ROSTELECOM = 'rostelecom'
    SYMA = 'syma'
    SMART = 'smart'
    SUN = 'sun'
    TELE2 = 'tele2'
    THREE = 'three'
    TIGO = 'tigo'
    TMOBILE = 'tmobile'
    TNT = 'tnt'
    VIRGINMOBILE = 'virginmobile'
    VIRTUAL2 = 'virtual2'
    VIRTUAL4 = 'virtual4'
    VIRTUAL5 = 'virtual5'
    VIRTUAL7 = 'virtual7'
    VIRTUAL8 = 'virtual8'
    VIRTUAL11 = 'virtual11'
    VIRTUAL12 = 'virtual12'
    VIRTUAL15 = 'virtual15'
    VIRTUAL16 = 'virtual16'
    VIRTUAL17 = 'virtual17'
    VIRTUAL18 = 'virtual18'
    VIRTUAL19 = 'virtual19'
    VIRTUAL20 = 'virtual20'
    VIRTUAL21 = 'virtual21'
    VIRTUAL22 = 'virtual22'
    VIRTUAL23 = 'virtual23'
    VIRTUAL24 = 'virtual24'
    VIRTUAL25 = 'virtual25'
    VIRTUAL26 = 'virtual26'
    VIRTUAL27 = 'virtual27'
    VIRTUAL28 = 'virtual28'
    VIRTUAL29 = 'virtual29'
    VIRTUAL30 = 'virtual30'
    VIRTUAL31 = 'virtual31'
    VIRTUAL32 = 'virtual32'
    VODAFONE = 'vodafone'
    YOTA = 'yota'
    ZZ = 'zz'


class Country(str, Enum):
    ANY_COUNTRY = 'any'
    AFGHANISTAN = 'afghanistan'
    ALBANIA = 'albania'
    ALGERIA = 'algeria'
    ANGOLA = 'angola'
    ANGUILLA = 'anguilla'
    ANTIGUA_AND_BARBUDA = 'antiguaandbarbuda'
    ARGENTINA = 'argentina'
    ARMENIA = 'armenia'
    ARUBA = 'aruba'
    AUSTRALIA = 'australia'
    AUSTRIA = 'austria'
    AZERBAIJAN = 'azerbaijan'
    BAHAMAS = 'bahamas'
    BAHRAIN = 'bahrain'
    BANGLADESH = 'bangladesh'
    BARBADOS = 'barbados'
    BELARUS = 'belarus'
    BELGIUM = 'belgium'
    BELIZE = 'belize'
    BENIN = 'benin'
    BHUTANE = 'bhutane'
    BOSNIA_AND_HERZEGOVINA = 'bih'
    BOLIVIA = 'bolivia'
    BOTSWANA = 'botswana'
    BRAZIL = 'brazil'
    BULGARIA = 'bulgaria'
    BURKINA_FASO = 'burkinafaso'
    BURUNDI = 'burundi'
    CAMBODIA = 'cambodia'
    CAMEROON = 'cameroon'
    CANADA = 'canada'
    CAPE_VERDE = 'capeverde'
    CAYMAN_ISLANDS = 'caymanislands'
    CHAD = 'chad'
    CHILE = 'chile'
    CHINA = 'china'
    COLOMBIA = 'colombia'
    COMOROS = 'comoros'
    CONGO = 'congo'
    COSTA_RICA = 'costarica'
    CROATIA = 'croatia'
    CYPRUS = 'cyprus'
    CZECH = 'czech'
    DJIBOUTI = 'djibouti'
    DOMINICA = 'dominica'
    DOMINICAN_REPUBLIC = 'dominicana'
    EAST_TIMOR = 'easttimor'
    ECUADOR = 'ecuador'
    EGYPT = 'egypt'
    ENGLAND = 'england'
    EQUATORIAL_GUINEA = 'equatorialguinea'
    ERITREA = 'eritrea'
    ESTONIA = 'estonia'
    ETHIOPIA = 'ethiopia'
    FINLAND = 'finland'
    FRANCE = 'france'
    FRENCH_GUIANA = 'frenchguiana'
    GABON = 'gabon'
    GAMBIA = 'gambia'
    GEORGIA = 'georgia'
    GERMANY = 'germany'
    GHANA = 'ghana'
    GREECE = 'greece'
    GRENADA = 'grenada'
    GUADELOUPE = 'guadeloupe'
    GUATEMALA = 'guatemala'
    GUINEA = 'guinea'
    GUINEA_BISSAU = 'guineabissau'
    GUYANA = 'guyana'
    HAITI = 'haiti'
    HONDURAS = 'honduras'
    HONGKONG = 'hongkong'
    HUNGARY = 'hungary'
    INDIA = 'india'
    INDONESIA = 'indonesia'
    IRELAND = 'ireland'
    ISRAEL = 'israel'
    ITALY = 'italy'
    IVORY_COAST = 'ivorycoast'
    JAMAICA = 'jamaica'
    JAPAN = 'japan'
    JORDAN = 'jordan'
    KAZAKHSTAN = 'kazakhstan'
    KENYA = 'kenya'
    KUWAIT = 'kuwait'
    KYRGYZSTAN = 'kyrgyzstan'
    LAOS = 'laos'
    LATVIA = 'latvia'
    LESOTHO = 'lesotho'
    LIBERIA = 'liberia'
    LITHUANIA = 'lithuania'
    LUXEMBOURG = 'luxembourg'
    MACAU = 'macau'
    MADAGASCAR = 'madagascar'
    MALAWI = 'malawi'
    MALAYSIA = 'malaysia'
    MALDIVES = 'maldives'
    MAURITANIA = 'mauritania'
    MAURITIUS = 'mauritius'
    MEXICO = 'mexico'
    MOLDOVA = 'moldova'
    MONGOLIA = 'mongolia'
    MONTENEGRO = 'montenegro'
    MONTSERRAT = 'montserrat'
    MOROCCO = 'morocco'
    MOZAMBIQUE = 'mozambique'
    MYANMAR = 'myanmar'
    NAMIBIA = 'namibia'
    NEPAL = 'nepal'
    NETHERLANDS = 'netherlands'
    NEW_CALEDONIA = 'newcaledonia'
    NEW_ZEALAND = 'newzealand'
    NICARAGUA = 'nicaragua'
    NIGER = 'niger'
    NIGERIA = 'nigeria'
    NORTH_MACEDONIA = 'northmacedonia'
    NORWAY = 'norway'
    OMAN = 'oman'
    PAKISTAN = 'pakistan'
    PANAMA = 'panama'
    PAPUA_NEW_GUINEA = 'papuanewguinea'
    PARAGUAY = 'paraguay'
    PERU = 'peru'
    PHILIPPINES = 'philippines'
    POLAND = 'poland'
    PORTUGAL = 'portugal'
    PUERTORICO = 'puertorico'
    REUNION = 'reunion'
    ROMANIA = 'romania'
    RUSSIA = 'russia'
    RWANDA = 'rwanda'
    SAINT_KITTS_AND_NEVIS = 'saintkittsandnevis'
    SAINT_LUCIA = 'saintlucia'
    SAINT_VINCENT_AND_THE_GRENADINES = 'saintvincentandgrenadines'
    SALVADOR = 'salvador'
    SAMOA = 'samoa'
    SAO_TOME_AND_PRINCIPE = 'saotomeandprincipe'
    SAUDI_ARABIA = 'saudiarabia'
    SENEGAL = 'senegal'
    SERBIA = 'serbia'
    REPUBLIC_OF_SEYCHELLES = 'seychelles'
    SIERRA_LEONE = 'sierraleone'
    SINGAPORE = 'singapore'
    SLOVAKIA = 'slovakia'
    SLOVENIA = 'slovenia'
    SOLOMON_ISLANDS = 'solomonislands'
    SOUTH_AFRICA = 'southafrica'
    SPAIN = 'spain'
    SRI_LANKA = 'srilanka'
    SURINAME = 'suriname'
    SWAZILAND = 'swaziland'
    SWEDEN = 'sweden'
    SWITZERLAND = 'switzerland'
    TAIWAN = 'taiwan'
    TAJIKISTAN = 'tajikistan'
    TANZANIA = 'tanzania'
    THAILAND = 'thailand'
    TRINIDAD_AND_TOBAGO = 'tit'
    TOGO = 'togo'
    TONGA = 'tonga'
    TUNISIA = 'tunisia'
    TURKEY = 'turkey'
    TURKMENISTAN = 'turkmenistan'
    TURKS_AND_CAICOS_ISLAND = 'turksandcaicos'
    UGANDA = 'uganda'
    UKRAINE = 'ukraine'
    URUGUAY = 'uruguay'
    USA = 'usa'
    UZBEKISTAN = 'uzbekistan'
    VENEZUELA = 'venezuela'
    VIETNAM = 'vietnam'
    BRITISH_VIRGIN_ISLANDS = 'virginislands'
    ZAMBIA = 'zambia'
    ZIMBABWE = 'zimbabwe'

    def get_name(self) -> str:
        """ 
        Get the name of the country.
        """
        return self.name


class HostingProduct(str, Enum):
    THREE_HOURS = '3hours'
    ONE_DAY = '1day'
    TEN_DAYS = '10days'
    ONE_MONTH = '1month'

    def __str__(self) -> str:
        return self.value


class ActivationProduct(str, Enum):
    N_1688 = '1688'
    N_23RED = '23red'
    N_32RED = '32red'
    N_99APP = '99app'
    ACE2THREE = 'ace2three'
    ADIDAS = 'adidas'
    AGROINFORM = 'agroinform'
    AIRBNB = 'airbnb'
    AIRTEL = 'airtel'
    AITU = 'aitu'
    AKELNI = 'akelni'
    ALFA = 'alfa'
    ALGIDA = 'algida'
    ALIBABA = 'alibaba'
    ALIEXPRESS = 'aliexpress'
    ALIPAY = 'alipay'
    AMASIA = 'amasia'
    AMAZON = 'amazon'
    AOL = 'aol'
    APPLE = 'apple'
    ASTROPAY = 'astropay'
    AUCHAN = 'auchan'
    AVITO = 'avito'
    AVON = 'avon'
    AZINO = 'azino'
    B4UCABS = 'b4ucabs'
    BAIDU = 'baidu'
    BANQI = 'banqi'
    BIGOLIVE = 'bigolive'
    BILLMILL = 'billmill'
    BISU = 'bisu'
    BITAQATY = 'bitaqaty'
    BITCLOUT = 'bitclout'
    BITTUBE = 'bittube'
    BLABLACAR = 'blablacar'
    BLIZZARD = 'blizzard'
    BLOCKCHAIN = 'blockchain'
    BLUED = 'blued'
    BOLT = 'bolt'
    BRAND20UA = 'brand20ua'
    BURGERKING = 'burgerking'
    BYKEA = 'bykea'
    CAFEBAZAAR = 'cafebazaar'
    CAIXA = 'caixa'
    CAREEM = 'careem'
    CAROUSELL = 'carousell'
    CDKEYS = 'cdkeys'
    CEKKAZAN = 'cekkazan'
    CITAPREVIA = 'citaprevia'
    CITYMOBIL = 'citymobil'
    CLICKENTREGAS = 'clickentregas'
    CLIQQ = 'cliqq'
    CLUBHOUSE = 'clubhouse'
    CMTCUZDAN = 'cmtcuzdan'
    COINBASE = 'coinbase'
    COINFIELD = 'coinfield'
    CRAIGSLIST = 'craigslist'
    CRYPTOCOM = 'cryptocom'
    DBRUA = 'dbrua'
    DELIVEROO = 'deliveroo'
    DELIVERY = 'delivery'
    DENT = 'dent'
    DHANI = 'dhani'
    DIDI = 'didi'
    DIGIKALA = 'digikala'
    DISCORD = 'discord'
    DISNEYHOTSTAR = 'disneyhotstar'
    DIVAR = 'divar'
    DIXY = 'dixy'
    DODOPIZZA = 'dodopizza'
    DOMDARA = 'domdara'
    DOMINOSPIZZA = 'dominospizza'
    DOSTAVISTA = 'dostavista'
    DOUYU = 'douyu'
    DREAM11 = 'dream11'
    DROM = 'drom'
    DRUGVOKRUG = 'drugvokrug'
    DUKASCOPY = 'dukascopy'
    EASYPAY = 'easypay'
    EBAY = 'ebay'
    EBIKEGEWINNSPIEL = 'ebikegewinnspiel'
    EDGELESS = 'edgeless'
    ELECTRONEUM = 'electroneum'
    ENEBA = 'eneba'
    EZBUY = 'ezbuy'
    FABERLIC = 'faberlic'
    FACEBOOK = 'facebook'
    FIQSY = 'fiqsy'
    FIVERR = 'fiverr'
    FOODPANDA = 'foodpanda'
    FOODY = 'foody'
    FORWARDING = 'forwarding'
    FREECHARGE = 'freecharge'
    GALAXY = 'galaxy'
    GAMEARENA = 'gamearena'
    GAMEFLIP = 'gameflip'
    GAMEKIT = 'gamekit'
    GAMER = 'gamer'
    GCASH = 'gcash'
    GET = 'get'
    GETIR = 'getir'
    GETT = 'gett'
    GG = 'gg'
    GITTIGIDIYOR = 'gittigidiyor'
    GLOBAL24 = 'global24'
    GLOBALTEL = 'globaltel'
    GLOBUS = 'globus'
    GLOVO = 'glovo'
    GOOGLE = 'google'
    GRABTAXI = 'grabtaxi'
    GREEN = 'green'
    GRINDR = 'grindr'
    HAMRAHAVAL = 'hamrahaval'
    HAPPN = 'happn'
    HARAJ = 'haraj'
    HEPSIBURADACOM = 'hepsiburadacom'
    HEZZL = 'hezzl'
    HILY = 'hily'
    HOPI = 'hopi'
    HQTRIVIA = 'hqtrivia'
    HUMBLEBUNDLE = 'humblebundle'
    HUMTA = 'humta'
    HUYA = 'huya'
    ICARD = 'icard'
    ICQ = 'icq'
    ICRYPEX = 'icrypex'
    IFOOD = 'ifood'
    IMMOWELT = 'immowelt'
    IMO = 'imo'
    INBOXLV = 'inboxlv'
    INDRIVER = 'indriver'
    ININAL = 'ininal'
    INSTAGRAM = 'instagram'
    IOST = 'iost'
    IQOS = 'iqos'
    IVI = 'ivi'
    IYC = 'iyc'
    JD = 'jd'
    JKF = 'jkf'
    JUSTDATING = 'justdating'
    JUSTDIAL = 'justdial'
    KAKAOTALK = 'kakaotalk'
    KARUSEL = 'karusel'
    KEYBASE = 'keybase'
    KOMANDACARD = 'komandacard'
    KOTAK811 = 'kotak811'
    KUCOINPLAY = 'kucoinplay'
    KUFARBY = 'kufarby'
    KVARTPLATA = 'kvartplata'
    KWAI = 'kwai'
    LAZADA = 'lazada'
    LBRY = 'lbry'
    LENTA = 'lenta'
    LIANXIN = 'lianxin'
    LINE = 'line'
    LINKEDIN = 'linkedin'
    LIVESCORE = 'livescore'
    MAGNIT = 'magnit'
    MAGNOLIA = 'magnolia'
    MAILRU = 'mailru'
    MAMBA = 'mamba'
    MCDONALDS = 'mcdonalds'
    MEETME = 'meetme'
    MEGA = 'mega'
    MERCADO = 'mercado'
    MICHAT = 'michat'
    MICROSOFT = 'microsoft'
    MILOAN = 'miloan'
    MIRATORG = 'miratorg'
    MOBILE01 = 'mobile01'
    MOMO = 'momo'
    MONESE = 'monese'
    MONOBANK = 'monobank'
    MOSRU = 'mosru'
    MRGREEN = 'mrgreen'
    MTSCASHBACK = 'mtscashback'
    MYFISHKA = 'myfishka'
    MYGLO = 'myglo'
    MYLOVE = 'mylove'
    MYMUSICTASTE = 'mymusictaste'
    MZADQATAR = 'mzadqatar'
    NANA = 'nana'
    NAVER = 'naver'
    NCSOFT = 'ncsoft'
    NETFLIX = 'netflix'
    NHSEVEN = 'nhseven'
    NIFTY = 'nifty'
    NIKE = 'nike'
    NIMSES = 'nimses'
    NRJMUSICAWARDS = 'nrjmusicawards'
    NTTGAME = 'nttgame'
    ODNOKLASSNIKI = 'odnoklassniki'
    OFFERUP = 'offerup'
    OFFGAMERS = 'offgamers'
    OKCUPID = 'okcupid'
    OKEY = 'okey'
    OKTA = 'okta'
    OLACABS = 'olacabs'
    OLX = 'olx'
    ONLINERBY = 'onlinerby'
    OPENPOINT = 'openpoint'
    ORACLECLOUD = 'oraclecloud'
    ORIFLAME = 'oriflame'
    OTHER = 'other'
    OZON = 'ozon'
    PADDYPOWER = 'paddypower'
    PAIRS = 'pairs'
    PAPARA = 'papara'
    PAXFUL = 'paxful'
    PAYBERRY = 'payberry'
    PAYCELL = 'paycell'
    PAYMAYA = 'paymaya'
    PAYPAL = 'paypal'
    PAYSEND = 'paysend'
    PAYTM = 'paytm'
    PEOPLECOM = 'peoplecom'
    PEREKRESTOK = 'perekrestok'
    PGBONUS = 'pgbonus'
    PICPAY = 'picpay'
    POF = 'pof'
    POKEC = 'pokec'
    POKERMASTER = 'pokermaster'
    POTATO = 'potato'
    POWERKREDITE = 'powerkredite'
    PRAJMERIZ2020 = 'prajmeriz2020'
    PREMIUMONE = 'premiumone'
    PROM = 'prom'
    PROTON = 'proton'
    PROTONMAIL = 'protonmail'
    PROTP = 'protp'
    PUBG = 'pubg'
    PUREPLATFROM = 'pureplatfrom'
    PYATEROCHKA = 'pyaterochka'
    PYROMUSIC = 'pyromusic'
    Q12TRIVIA = 'q12trivia'
    QIWIWALLET = 'qiwiwallet'
    QUIPP = 'quipp'
    RAKUTEN = 'rakuten'
    RAMBLER = 'rambler'
    REDIFFMAIL = 'rediffmail'
    REUSE = 'reuse'
    RIPKORD = 'ripkord'
    ROSAKHUTOR = 'rosakhutor'
    RSA = 'rsa'
    RUTUBE = 'rutube'
    SAMOKAT = 'samokat'
    SEOSPRINT = 'seosprint'
    SHEERID = 'sheerid'
    SHOPEE = 'shopee'
    SIGNAL = 'signal'
    SIKAYETVAR = 'sikayetvar'
    SKOUT = 'skout'
    SNAPCHAT = 'snapchat'
    SNAPPFOOD = 'snappfood'
    SNEAKERSNSTUFF = 'sneakersnstuff'
    SOCIOS = 'socios'
    SPORTMASTER = 'sportmaster'
    SPOTHIT = 'spothit'
    SSOIDNET = 'ssoidnet'
    STEAM = 'steam'
    SURVEYTIME = 'surveytime'
    SWVL = 'swvl'
    TAKSHEEL = 'taksheel'
    TANGO = 'tango'
    TANTAN = 'tantan'
    TAOBAO = 'taobao'
    TELEGRAM = 'telegram'
    TENCENTQQ = 'tencentqq'
    TICKETMASTER = 'ticketmaster'
    TIKTOK = 'tiktok'
    TINDER = 'tinder'
    TOSLA = 'tosla'
    TOTALCOIN = 'totalcoin'
    TOUCHANCE = 'touchance'
    TRENDYOL = 'trendyol'
    TRUECALLER = 'truecaller'
    TWITCH = 'twitch'
    TWITTER = 'twitter'
    UBER = 'uber'
    UKRNET = 'ukrnet'
    UPLOADED = 'uploaded'
    VERNYI = 'vernyi'
    VERNYJ = 'vernyj'
    VIBER = 'viber'
    VITAJEKSPRESS = 'vitajekspress'
    VKONTAKTE = 'vkontakte'
    VOOPEE = 'voopee'
    WECHAT = 'wechat'
    WEIBO = 'weibo'
    WEKU = 'weku'
    WESTSTEIN = 'weststein'
    WHATSAPP = 'whatsapp'
    WILDBERRIES = 'wildberries'
    WINGMONEY = 'wingmoney'
    WINSTON = 'winston'
    WISH = 'wish'
    WMARACI = 'wmaraci'
    WOLT = 'wolt'
    YAAY = 'yaay'
    YAHOO = 'yahoo'
    YALLA = 'yalla'
    YANDEX = 'yandex'
    YEMEKSEPETI = 'yemeksepeti'
    YOUDO = 'youdo'
    YOULA = 'youla'
    YOUSTAR = 'youstar'
    ZALO = 'zalo'
    ZOHO = 'zoho'
    ZOMATO = 'zomato'
    N_163SOM = '163som'
    N_1KKIRANA = '1kkirana'
    N_1MG = '1mg'
    N_1XBET = '1xbet'
    N_888CASINO = '888casino'
    N_99ACRES = '99acres'
    ADDA52 = 'adda52'
    AKUDO = 'akudo'
    ALLEGRO = 'allegro'
    APOLLO = 'apollo'
    BAJAJFINSERV = 'bajajfinserv'
    BECCRIC = 'beccric'
    BETFAIR = 'betfair'
    BETVET = 'betvet'
    BIGBASKET = 'bigbasket'
    BIGBAZAAR = 'bigbazaar'
    BILIBILI = 'bilibili'
    BIP = 'bip'
    BITLO = 'bitlo'
    BODDESS = 'boddess'
    CADBURYPERK = 'cadburyperk'
    CARDEKHO = 'cardekho'
    CHAINGEFINANCE = 'chaingefinance'
    CITYBASE = 'citybase'
    CLASSICRUMMY = 'classicrummy'
    COINDCX = 'coindcx'
    COKFIIGHT = 'cokfiight'
    DEALSHARE = 'dealshare'
    DOMINATE11 = 'dominate11'
    DUNDLE = 'dundle'
    DUNZO = 'dunzo'
    EARNEASY = 'earneasy'
    EGOPENSOOQ = 'egopensooq'
    ELANTE = 'elante'
    ELDORADO = 'eldorado'
    EWARGAMES = 'ewargames'
    EZMALL = 'ezmall'
    FACEIT = 'faceit'
    FAN2PLAY = 'fan2play'
    FANFIGHT = 'fanfight'
    FARMCARE = 'farmcare'
    FIEGAME = 'fiegame'
    FIEWIN = 'fiewin'
    FLAM = 'flam'
    FLEXPAY = 'flexpay'
    FLIPKART = 'flipkart'
    FRIZZA = 'frizza'
    GABI = 'gabi'
    GALAXYWIN = 'galaxywin'
    GAMERJI = 'gamerji'
    GAMEZY = 'gamezy'
    GEMINI = 'gemini'
    GGHASIA = 'gghasia'
    GMNGJOURNEY = 'gmngjourney'
    GOFUNDME = 'gofundme'
    GOJEK = 'gojek'
    GOODS = 'goods'
    GROFERS = 'grofers'
    GROUPME = 'groupme'
    GULLYRUMMY = 'gullyrummy'
    GYFTR = 'gyftr'
    HANDYPICK = 'handypick'
    HEALTHANDGLOW = 'healthandglow'
    HERMES = 'hermes'
    HINGE = 'hinge'
    HOTLINE = 'hotline'
    HOTMAIL = 'hotmail'
    HOUSING = 'housing'
    HOWZAT = 'howzat'
    ICICIDIRECT = 'icicidirect'
    INDIAGOLD = 'indiagold'
    INDIAPLAYS = 'indiaplays'
    INFOMANIAK = 'infomaniak'
    IQIYI = 'iqiyi'
    IRANCELL = 'irancell'
    IRCTC = 'irctc'
    IWPLAY = 'iwplay'
    JAMESDELIVERY = 'jamesdelivery'
    JEET11 = 'jeet11'
    JIOMART = 'jiomart'
    JUNGLEERUMMY = 'jungleerummy'
    KAGGLE = 'kaggle'
    KAIDEE = 'kaidee'
    KAZANDIRIO = 'kazandirio'
    KEYPAY = 'keypay'
    KFC = 'kfc'
    KHELRAJA = 'khelraja'
    KISMA = 'kisma'
    KOLESAKZ = 'kolesakz'
    LAKME = 'lakme'
    LAMODA = 'lamoda'
    LAPOSTE = 'laposte'
    LIGHTCHAT = 'lightchat'
    LIKEE = 'likee'
    LOCOFF = 'locoff'
    LOVELOCAL = 'lovelocal'
    LYBRATE = 'lybrate'
    LYKA = 'lyka'
    MAGICBRICKS = 'magicbricks'
    MAGICPIN = 'magicpin'
    MAKEMONEY = 'makemoney'
    MANTRIMALL = 'mantrimall'
    MAPLESEA = 'maplesea'
    MEDIBUDDY = 'medibuddy'
    MEESHO = 'meesho'
    MEGOGO = 'megogo'
    META = 'meta'
    METRO = 'metro'
    MEWT = 'mewt'
    MINIMA = 'minima'
    MOBIKWIK = 'mobikwik'
    MOCOSPACE = 'mocospace'
    MONEYLION = 'moneylion'
    MONOAPP = 'monoapp'
    MPL = 'mpl'
    MRSOOL = 'mrsool'
    MVIDEO = 'mvideo'
    MY11CIRCLE = 'my11circle'
    MYFAB11 = 'myfab11'
    MYJAR = 'myjar'
    MYNTRA = 'myntra'
    NETEASE = 'netease'
    NOBROKER = 'nobroker'
    NOON = 'noon'
    NYKAA = 'nykaa'
    OKKO = 'okko'
    ONET = 'onet'
    ONTAXI = 'ontaxi'
    OTIPY = 'otipy'
    OYO = 'oyo'
    PANELSTATION = 'panelstation'
    PARIMATCH = 'parimatch'
    PAYSAFECARD = 'paysafecard'
    PAYZAPP = 'payzapp'
    PHABLE = 'phable'
    PHARMEASY = 'pharmeasy'
    PINGPONG = 'pingpong'
    PLAYERZPOT = 'playerzpot'
    PLAYSHIP = 'playship'
    POSHMARK = 'poshmark'
    PROBO = 'probo'
    QUACK = 'quack'
    QUIKR = 'quikr'
    RAINMAKER = 'rainmaker'
    RAPIDO = 'rapido'
    REDBOOK = 'redbook'
    ROYALWIN = 'royalwin'
    ROZETKA = 'rozetka'
    RUMMY = 'rummy'
    RUMMYCIRCLE = 'rummycircle'
    RUMMYCULTURE = 'rummyculture'
    RUMMYGOLD = 'rummygold'
    RUMMYWEALTH = 'rummywealth'
    RUSH = 'rush'
    SAHICOIN = 'sahicoin'
    SAMSUNGSHOP = 'samsungshop'
    SBERMARKET = 'sbermarket'
    SHELLBOX = 'shellbox'
    SIKKA = 'sikka'
    SIPLY = 'siply'
    SNACKVIDEO = 'snackvideo'
    SNEAKERBOY = 'sneakerboy'
    SPARTANPOKER = 'spartanpoker'
    SPORTGULLY = 'sportgully'
    STARCHATSITE = 'starchatsite'
    STEEMIT = 'steemit'
    STOLOTO = 'stoloto'
    SUNLIGHT = 'sunlight'
    SUPRDAILY = 'suprdaily'
    SURVEYJUNKIE = 'surveyjunkie'
    SWAGBUCKS = 'swagbucks'
    SWIGGY = 'swiggy'
    TALABAT = 'talabat'
    TAPTAPSEND = 'taptapsend'
    TATACLIQ = 'tatacliq'
    TATNEFT = 'tatneft'
    TEENPATTIRUMMY3 = 'teenpattirummy3'
    TIMESPRIME = 'timesprime'
    TRADINGVIEW = 'tradingview'
    TRIP = 'trip'
    TRUEFAN = 'truefan'
    TWELFTHMAN = 'twelfthman'
    TWILIO = 'twilio'
    UKLON = 'uklon'
    UNACADEMY = 'unacademy'
    VEDANTU = 'vedantu'
    VERSE = 'verse'
    VINOTA = 'vinota'
    VINTED = 'vinted'
    VKUSVILL = 'vkusvill'
    VSCRIC = 'vscric'
    WHIDE = 'whide'
    WHOOSH = 'whoosh'
    WINZO = 'winzo'
    WIZELY = 'wizely'
    XIAOMI = 'xiaomi'
    YOUGOTAGIFT = 'yougotagift'
    YUBO = 'yubo'
    ZCITY = 'zcity'
    ZEBPAY = 'zebpay'
    ZEPTO = 'zepto'
    ZIGLU = 'ziglu'
    ZUPEE = 'zupee'

    def __str__(self) -> str:
        return self.value
