import wx

from ..kernel import Module
from .icons import icons8_comments_50

_ = wx.GetTranslation


class Notes(wx.Frame, Module):
    def __init__(self, context, path, parent, *args, **kwds):
        # begin wxGlade: Notes.__init__
        wx.Frame.__init__(
            self,
            parent,
            -1,
            "",
            style=wx.DEFAULT_FRAME_STYLE | wx.FRAME_FLOAT_ON_PARENT | wx.TAB_TRAVERSAL,
        )
        Module.__init__(self, context, path)
        self.window_context = context.get_context(path)
        self.window_context.setting(int, "width", 730)
        self.window_context.setting(int, "height", 621)
        self.SetSize((self.window_context.width, self.window_context.height))

        self.check_auto_open_notes = wx.CheckBox(
            self, wx.ID_ANY, _("Automatically Open Notes")
        )
        self.text_notes = wx.TextCtrl(
            self, wx.ID_ANY, "", style=wx.TE_BESTWRAP | wx.TE_MULTILINE | wx.TE_WORDWRAP
        )

        self.__set_properties()
        self.__do_layout()

        x, y = self.GetPosition()
        self.window_context.setting(int, "x", x)
        self.window_context.setting(int, "y", y)
        self.SetPosition((self.window_context.x, self.window_context.y))

        self.Bind(
            wx.EVT_CHECKBOX, self.on_check_auto_note_open, self.check_auto_open_notes
        )
        self.Bind(wx.EVT_TEXT, self.on_text_notes, self.text_notes)
        self.Bind(wx.EVT_TEXT_ENTER, self.on_text_notes, self.text_notes)
        # end wxGlade

        self.Bind(wx.EVT_CLOSE, self.on_close, self)
        # OSX Window close
        if parent is not None:
            parent.accelerator_table(self)

    def on_close(self, event):
        if self.state == 5:
            event.Veto()
        else:
            self.state = 5
            self.context.close(self.name)
            event.Skip()  # Call destroy as regular.

    def initialize(self, *args, **kwargs):
        self.context.setting(bool, "auto_note", True)
        self.context.close(self.name)
        self.check_auto_open_notes.SetValue(self.context.auto_note)
        if self.context.elements.note is not None:
            self.text_notes.SetValue(self.context.elements.note)
        self.Show()

    def finalize(self, *args, **kwargs):
        self.window_context.width, self.window_context.height = self.Size
        self.window_context.x, self.window_context.y = self.GetPosition()
        try:
            self.Close()
        except RuntimeError:
            pass

    def __set_properties(self):
        _icon = wx.NullIcon
        _icon.CopyFromBitmap(icons8_comments_50.GetBitmap())
        self.SetIcon(_icon)
        self.SetTitle("Notes")
        self.check_auto_open_notes.SetToolTip(
            _("Automatically open notes if they exist when file is opened.")
        )
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: Notes.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_1.Add(self.check_auto_open_notes, 0, 0, 0)
        sizer_1.Add(self.text_notes, 1, wx.EXPAND, 0)
        self.SetSizer(sizer_1)
        self.Layout()
        # end wxGlade

    def on_check_auto_note_open(self, event):  # wxGlade: Notes.<event_handler>
        self.context.auto_note = self.check_auto_open_notes.GetValue()

    def on_text_notes(self, event):  # wxGlade: Notes.<event_handler>
        if len(self.text_notes.GetValue()) == 0:
            self.context.elements.note = None
        else:
            self.context.elements.note = self.text_notes.GetValue()
