"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowDashboard = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class MetaflowDashboard extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const dashboard = new cloudwatch.Dashboard(this, 'Dashboard', {
            dashboardName: props.dashboardName,
        });
        const bytesUploaded = new cloudwatch.Metric({
            metricName: 'BucketSizeBytes',
            namespace: 'AWS/S3',
            dimensions: {
                BucketName: props.bucketName,
                StorageType: 'StandardStorage',
            },
            period: cdk.Duration.minutes(props.period),
            statistic: cloudwatch.Statistic.SUM,
            unit: cloudwatch.Unit.BYTES,
        });
        const putRequests = new cloudwatch.Metric({
            metricName: 'NumberOfObjects',
            namespace: 'AWS/S3',
            dimensions: {
                BucketName: props.bucketName,
                StorageType: 'AllStorageTypes',
            },
            period: cdk.Duration.minutes(props.period),
            statistic: cloudwatch.Statistic.SUM,
            unit: cloudwatch.Unit.BYTES,
        });
        // row for S3 metrics
        dashboard.addWidgets(new cloudwatch.GraphWidget({
            left: [putRequests],
            right: [bytesUploaded],
            width: 12,
            title: 'Metaflow S3 Artifacts',
            leftYAxis: {
                min: 0,
            },
            rightYAxis: {
                min: 0,
            },
        }), new cloudwatch.GraphWidget({
            title: 'Metadata Service',
            left: [props.ecsService.metricCpuUtilization()],
            right: [props.ecsService.metricMemoryUtilization()],
            width: 12,
            period: cdk.Duration.minutes(props.period),
        }));
        this.dashboard = dashboard;
        new cdk.CfnOutput(this, 'dashboardUri', {
            exportName: 'metaflowDashboard',
            value: `https://console.aws.amazon.com/cloudwatch/home#dashboards:name=${props.dashboardName}`,
        });
    }
}
exports.MetaflowDashboard = MetaflowDashboard;
_a = JSII_RTTI_SYMBOL_1;
MetaflowDashboard[_a] = { fqn: "cdk-metaflow.MetaflowDashboard", version: "0.0.11" };
//# sourceMappingURL=data:application/json;base64,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