"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultRdsConfig = exports.ServiceInfo = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const rds = require("@aws-cdk/aws-rds");
const cdk = require("@aws-cdk/core");
var ServiceInfo;
(function (ServiceInfo) {
    ServiceInfo["SERVICE_NAME"] = "metadata-service-v2";
    ServiceInfo["IMAGE_URL"] = "netflixoss/metaflow_metadata_service";
    ServiceInfo["DB_USER"] = "master";
    ServiceInfo["DB_NAME"] = "metaflow";
    ServiceInfo["CONTAINER_PORT"] = "8080";
    ServiceInfo["CONTAINER_CPU"] = "512";
    ServiceInfo["CONTAINER_MEMORY"] = "1024";
    ServiceInfo["PATH"] = "*";
    ServiceInfo["PRIORITY"] = "1";
    ServiceInfo["DESIRED_COUNT"] = "1";
    ServiceInfo["ROLE"] = "";
})(ServiceInfo = exports.ServiceInfo || (exports.ServiceInfo = {}));
exports.DefaultRdsConfig = {
    removalPolicy: cdk.RemovalPolicy.DESTROY,
    engine: rds.DatabaseInstanceEngine.postgres({
        version: rds.PostgresEngineVersion.VER_11_5,
    }),
    instanceType: new ec2.InstanceType('t2.small'),
    deletionProtection: false,
    publiclyAccessible: false,
    backupRetention: cdk.Duration.days(7),
};
//# sourceMappingURL=data:application/json;base64,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