import * as s3 from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
/**
 * Default artifact bucket settings.
 */
export declare const DefaultBucketProps: s3.BucketProps;
/**
 * @experimental
 * @summary Metaflow S3 Bucket
 * S3 bucket for metaflow artifacts. Creates a standard bucket for holding
 * metaflow artifacts and with iam DENY policy for REST-HEADER auth.
 */
export declare class MetaflowBucket extends s3.Bucket {
    /**
     * (experimental) Constructs a new instance of the MetaflowBucket class.
     *
     * @experimental
     * @access public
     */
    readonly resource: s3.CfnBucket;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: s3.BucketProps);
}
