import * as apigw from '@aws-cdk/aws-apigateway';
import * as ddb from '@aws-cdk/aws-dynamodb';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as events from '@aws-cdk/aws-events';
import * as iam from '@aws-cdk/aws-iam';
import * as lambda from '@aws-cdk/aws-lambda';
import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
import { IMetaflowDatabase } from './constructs';
/**
 * @experimental
 */
export declare class Metaflow extends cdk.Construct {
    /**
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * @experimental
     */
    readonly cluster: ecs.ICluster;
    /**
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * @experimental
     */
    readonly table: ddb.ITable;
    /**
     * @experimental
     */
    readonly database: IMetaflowDatabase;
    /**
     * @experimental
     */
    readonly eventBus: events.IEventBus;
    /**
     * @experimental
     */
    readonly api: apigw.IRestApi;
    /**
     * @experimental
     */
    readonly dbMigrateLambda: lambda.IFunction;
    /**
     * @experimental
     */
    readonly batchExecutionRole: iam.IRole;
    /**
     * @experimental
     */
    readonly batchS3TaskRole: iam.IRole;
    /**
     * @experimental
     */
    readonly stepFunctionsRole: iam.IRole;
    /**
     * @experimental
     */
    readonly eventBridgeRole: iam.IRole;
    /**
     * @experimental
     */
    readonly ecsTaskRole: iam.IRole;
    /**
     * @experimental
     */
    readonly ecsRole: iam.IRole;
    /**
     * @experimental
     */
    readonly ecsExecutionRole: iam.IRole;
    /**
     * @experimental
     */
    readonly lambdaECSExecuteRole: iam.IRole;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string);
}
