from .fun import ispump

import IPython
import pandas as pd
import numpy as np
import os,time
import warnings
warnings.filterwarnings("ignore")

class check(object):

    def demo():
        demostr = '''
import clubear as cb
#clubear.csv is generated by cb.manager.demo()
pm=cb.pump('clubear.csv') #start a new pump
pm.keep #check the head lists
cb.check(pm).stats() #check the for stats
pm.qlist=['age','height','weight','price','logsales']
cb.check(pm).stats(niter=20,keep=['price']) 
cb.check(pm).corr() #check for correlation
cb.check(pm).hist(x='age')#make a histogram
cb.check(pm).table(tv=True) #check table
pm.subsize=10000 #check the subsize
df=pm.go #start to pump data
'''
        print(demostr)

    def __init__(self, pm):
        self.pm = pm
        
        '''check whether the input is a pump first'''
        pump_check=ispump(self.pm)
        if pump_check != 'YES': print(pump_check); return
        
        '''initialization'''
        self.Stats=[];self.Table=[]

    def stats(self,keep=[],niter=10):
        
        '''check carefully all the pre-conditions'''
        if not isinstance(niter,int): print('check.table: The niter must be an int.'); return
        if not isinstance(keep,list): print('check.stats: The keep list must be a list.'); return
        if niter<1: print('check.table: The niter must be no less than one.'); return
        
        '''check whether we have something to stats'''
        df=self.pm.go();
        heads = list(df.columns);ncolumns=len(heads)
        mylist=[each for each in heads if df.dtypes[each]!='object']
        if len(keep)>0: mylist=[each for each in mylist if each in keep]
        if len(mylist)==0: print('check.stats: No variable can be checked!'); return
        
        '''main part for computing statistics'''
        ncov = len(mylist)
        N = np.zeros(niter)
        MU = np.zeros([niter, ncov])
        Min = np.zeros([niter, ncov])
        Med = np.zeros([niter, ncov])
        Max = np.zeros([niter, ncov])
        SD = np.zeros([niter, ncov])
        Skew = np.zeros([niter, ncov])
        Kurt = np.zeros([niter, ncov])
        Prob = np.zeros([niter,ncov])
        start_time=time.time()
        for n in range(niter):
            '''get data and make it float'''
            df = self.pm.go()[mylist]
            
            '''create non-missing flag'''
            flag=(np.abs(df)<1.0e+15)*(np.abs(df)>=0)
            Prob[n]=np.mean(flag,axis=0)+1.0e-15
            
            '''The 1st bach of stat *without* central'''
            N[n] = df.shape[0]
            MU[n] = np.nanmean(df, axis=0)
            Min[n] = np.nanmin(df, axis=0)
            Med[n] = np.nanmedian(df, axis=0)
            Max[n] = np.nanmax(df, axis=0)

            '''The 2nd batch of stat *with* central'''
            df =df-MU[n]
            SD[n] = np.nanmean(df**2, axis=0)
            Skew[n] = np.nanmean(df**3, axis=0)
            Kurt[n] = np.nanmean(df**4, axis=0)
            

            '''organize for interactive output'''
            MyN = np.mean(N[:(n+1)])
            MyMU = np.mean(MU[:(n+1)], axis=0)
            MyMin = np.min(Min[:(n+1)], axis=0)
            MyMed = np.median(Med[:(n+1)], axis=0)
            MyMax = np.max(Max[:(n+1)], axis=0)
            MySD = np.sqrt(np.mean(SD[:(n+1)], axis=0))+1.0e-12
            MySkew = np.mean(Skew[:(n+1)], axis=0)/MySD**3
            MyKurt = np.mean(Kurt[:(n+1)], axis=0)/MySD**4
            MyProb = np.mean(Prob[:(n+1)],axis=0)
            output = pd.DataFrame(list(zip(MyMU,MySD,MyMin, MyMed, MyMax, MySkew,MyKurt,100*MyProb)))
            output.columns = ['Mu','SD','Min','Med', 'Max','Skew','Kurt','rp']
            output.index = mylist
            self.Stats=output
            
            '''output to screen for interactive analysis'''
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)
            pd.set_option('display.float_format', lambda x: '%.1f' % x)
            pd.set_option('display.max_columns',120)
            pd.set_option('display.width',120)
            progress = np.round((n+1)/niter*100, 2)
            print('Time elapsed:',np.round(elapse_time,3),'seconds',end=' ')
            print('with subsample sizes', int(MyN), '.')
            print('Task accomplished: ', progress,
                  '% for a total of ', niter, 'random replications.')
            print('');print(np.round(output, 3));print('')
            print('* Mu: the averaged subsample mean; SD: the averaged subsample standard deviation.')
            print('* Min: the minimum of the subsample minimum; Med: the median of the subsample median.')
            print('* Max: the maximum of the subsample maximum; Kurt: the averaged sample kurtosis.')
            print('* rp: the averaged subsample response probability in percentage (0%~100%).')
            
        self.Stats=output
        
    def corr(self,keep=[],niter=10):
        
        '''check carefully all the pre-conditions'''
        if not isinstance(niter,int): print('check.corr: The niter must be an int.'); return
        if not isinstance(keep,list): print('check.corr: The keep list must be a list.'); return
        if niter<1: print('check.corr: The niter must be no less than one.'); return
        
        '''check whether we have something to stats'''
        df=self.pm.go();
        heads = list(df.columns);ncolumns=len(heads)
        mylist=[each for each in heads if df.dtypes[each]!='object']
        if len(keep)>0: mylist=[each for each in mylist if each in keep]
        if len(mylist)==0: print('check.corr: No variable can be checked!'); return
        
        '''main part for computing statistics'''
        ncov = len(mylist)
        corr_total=np.zeros([ncov,ncov])
        start_time=time.time()
        for n in range(niter):
            '''get data and make it float'''
            df = np.array(self.pm.go()[mylist])
            MyN=df.shape[0] 
            
            '''The 1st bach of stat *without* central'''
            df = df-np.nanmean(df, axis=0)
            SD = np.sqrt(np.nanmean(df**2,axis=0))+1.0e-12
            df = df/SD
            mycorr=np.zeros([ncov,ncov])
            for j1 in range(ncov):
                for j2 in range(ncov):
                    mycorr[j1,j2]=np.nanmean(df[:,j1]*df[:,j2])
            corr_total=corr_total+mycorr
            self.Corr=pd.DataFrame(corr_total/(n+1))*100
            self.Corr.index=['['+str(each)+']'+mylist[each] for each in range(ncov)]
            self.Corr.columns=['['+str(each)+']' for each in range(ncov)]
            
            '''output to screen for interactive analysis'''
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)
            pd.set_option('display.float_format', lambda x: '%.1f' % x)
            pd.set_option('display.max_columns',120)
            pd.set_option('display.width',120)
            progress = np.round((n+1)/niter*100, 2)
            print('Time elapsed:',np.round(elapse_time,3),'seconds',end=' ')
            print('with subsample sizes', int(MyN), '.')
            print('Task accomplished: ', progress,
                  '% for a total of ', niter, 'random replications.')
            print('')
            print(np.round(self.Corr, 1))
            print('')
            print('* the averaged subsample correlation coefficients in percentage (0%~100%).')

        
    def table(self,keep=[],tv=False,niter=10):
        
        '''check carefully all the pre-conditions'''
        if not isinstance(tv,bool): print('check.table: The tv must be a bool'); return
        if not isinstance(niter,int): print('check.table: The niter must be an int.'); return
        if not isinstance(keep,list): print('check.table: The keep list must be a list.'); return
        if niter<1: print('check.table: The niter must be no less than one.'); return
        
        '''check whether we have something to stats'''
        df=self.pm.go();
        heads = list(df.columns);ncolumns=len(heads)
        mylist=[each for each in heads if df.dtypes[each]=='object']
        if len(keep)>0: mylist=[each for each in mylist if each in keep]
        if len(mylist)==0: print('check.table: No variable can be checked!'); return
        
        ncov = len(mylist)

        '''a lists of sets for level values'''
        value_sets = [set() for each in range(ncov)]
        
        '''a list of Series for level counts'''
        counts = [pd.Series() for each in range(ncov)]
        
        start_time=time.time()
        for n in range(niter):
            df = self.pm.go()[mylist]
            for j in range(ncov):
                '''current subsample data computing'''
                new = list(df[mylist[j]].astype('str'))
                value_sets[j] = value_sets[j] | set(new)
                value_list = sorted(list(value_sets[j]))
                value_counts = [new.count(each) for each in value_list]
                
                '''for current count results into Series'''
                pds = pd.Series(value_counts)
                pds.index = value_list
                
                '''merge the current result with the history'''
                current_index = counts[j].index
                pds[current_index] = pds[current_index]+counts[j][current_index]
                counts[j] = pds

            '''for interactive outputs'''
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)
            pd.set_option('display.float_format', lambda x: '%.1f' % x)
            total_counts = int(np.mean([sum(counts[each]) for each in range(ncov)]))
            print('Time elapsed:',int(elapse_time),'seconds.')
            print("Task Completed: ", np.round(100.0*(n+1)/niter, 2), '% for a total of',
                  niter, 'iterations for totally', total_counts, 'counts.')
            print("  ")
            max_str=len(str(ncov))
            max_mylist=np.max([len(each) for each in mylist])
            for j in range(ncov):
                args = np.argsort(-counts[j])
                counts[j] = counts[j][args]
                clevels = list(counts[j].index)
                cvalues = list(counts[j])
                jstr='0'*(max_str-len(str(j)))+str(j)
                myliststr=mylist[j]+' '*(max_mylist-len(mylist[j]))
                print('[', jstr, '] No. of levels detected for *', myliststr,'* is:',len(clevels))
                if tv == True:
                    prob = cvalues/np.sum(cvalues)*100
                    max_output_number = np.min([len(clevels), 100])
                    for k in range(max_output_number):
                        print(clevels[k], '=', np.round(
                            prob[k], 2), '%', end='|')
                    if len(clevels) > 100:
                        print('*** Note: only top 100 levels displayed...')
                    print('')
                    print('')
                    
        self.counts = counts
        self.levels = value_sets
        
        self.Table=pd.Series([len(each) for each in counts])
        self.Table.index=mylist
        
    def hist(self,x='',niter=10,xrange=[99,-99]):
        '''check whether the input is a pump first'''
        df=self.pm.go();heads=list(df.columns) 
        if not isinstance(niter,int): print('check.hist: The niter must be an int.'); return
        if not isinstance(x,str): print('check.hist: The input x should be str.'); return
        if x not in heads: print('check.hist: The input x was not found in pump df.'); return
        xval=list(df[x]);
        if not isinstance(xrange,list): print('check.hist: The xrange must be a list.'); return
        if len(xrange)!=2: print('check.hist: The lenth of xrange must be TWO.'); return
        xmin=xrange[0];xmax=xrange[1]
        if not isinstance(xmin,float)|isinstance(xmin,int): print('check.hist: The xmin must be numeric.'); return
        if not isinstance(xmax,float)|isinstance(xmax,int): print('check.hist: The xmax must be numeric.'); return
        if xmin>xmax: xmin=np.nanmin(xval);xmax=np.nanmax(xval);
        if xmin>=xmax: print('check.hist: The (xmin,xmax) range cannot be produced.'); return
        width=xmax-xmin

        nc=30;nr=20;freq=np.zeros(nc+2)
        start_time=time.time()
        MyMin=np.zeros(niter)
        MyMax=np.zeros(niter)
        for n in range(niter):
            xval=self.pm.go()[x]
            MyMin[n]=np.nanmin(xval)
            MyMax[n]=np.nanmax(xval)
            xval=(xval-xmin)/width
            xval=list(np.round(xval*nc))
            xval=[each+1 for each in xval]
            xval=[np.max([0,each]) for each in xval]
            xval=[np.min([nc+1,each]) for each in xval]
            myfreq=[xval.count(each) for each in range(nc+2)]
            freq=freq+myfreq
            percent=freq/np.max(freq)
            margin=np.floor(nr*(1-percent))
            margin=[int(each) for each in margin]

            '''prepare labs for y-axis'''
            maxp=np.max(freq/np.sum(freq))
            ylab=[(nr-each-1)*maxp/nr for each in range(nr)]
            ylab=[str(round(each*100,1))+'%' for each in ylab]

            '''for the same number of digits'''
            ylab_length=np.max([len(each) for each in ylab])
            ylab=['0'*(ylab_length-len(each))+each for each in ylab]

            '''compute the dynamic range'''
            Min=np.nanmin(MyMin[:(n+1)])
            Max=np.nanmax(MyMax[:(n+1)])

            out=np.array(['*' for each in range((nc+2)*nr)]).reshape([nr,(nc+2)])
            for j in range(nc+2): out[0:margin[j],j]=''
            out=pd.DataFrame(out)
            out.index=ylab
            out.columns =['' for each in range(nc+2)]

            '''output to screen for interactive analysis'''
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)
            pd.set_option('display.float_format', lambda x: '%.1f' % x)
            pd.set_option('display.max_columns',120)
            pd.set_option('display.width',120)
            progress = np.round((n+1)/niter*100, 2)
            print('Dynamic histogram for *',x,'* with time elapsed:',np.round(elapse_time,3),'seconds.')
            print('The static range in use with [xmin,xmax]=[',xmin,',',xmax,'].') 
            print('The dynamic range detected = [',Min,',',Max,'].')
            print('Task accomplished: ', progress,
                  '% for a total of ', niter, 'random replications.')
            print(out)
            
        self.Hist=freq


