"""SEC provider module."""

from capinvest_core.provider.abstract.provider import Provider
from capinvest_sec.models.cik_map import SecCikMapFetcher
from capinvest_sec.models.company_filings import SecCompanyFilingsFetcher
from capinvest_sec.models.compare_company_facts import SecCompareCompanyFactsFetcher
from capinvest_sec.models.equity_ftd import SecEquityFtdFetcher
from capinvest_sec.models.equity_search import SecEquitySearchFetcher
from capinvest_sec.models.etf_holdings import SecEtfHoldingsFetcher
from capinvest_sec.models.form_13FHR import SecForm13FHRFetcher
from capinvest_sec.models.htm_file import SecHtmFileFetcher
from capinvest_sec.models.insider_trading import SecInsiderTradingFetcher
from capinvest_sec.models.institutions_search import SecInstitutionsSearchFetcher
from capinvest_sec.models.latest_financial_reports import SecLatestFinancialReportsFetcher
from capinvest_sec.models.management_discussion_analysis import (
    SecManagementDiscussionAnalysisFetcher,
)
from capinvest_sec.models.rss_litigation import SecRssLitigationFetcher
from capinvest_sec.models.schema_files import SecSchemaFilesFetcher
from capinvest_sec.models.sec_filing import SecFilingFetcher
from capinvest_sec.models.sic_search import SecSicSearchFetcher
from capinvest_sec.models.symbol_map import SecSymbolMapFetcher

sec_provider = Provider(
    name="sec",
    website="https://www.sec.gov/data",
    description="SEC is the public listings regulatory body for the United States.",
    credentials=None,
    fetcher_dict={
        "CikMap": SecCikMapFetcher,
        "CompanyFilings": SecCompanyFilingsFetcher,
        "CompareCompanyFacts": SecCompareCompanyFactsFetcher,
        "EquityFTD": SecEquityFtdFetcher,
        "EquitySearch": SecEquitySearchFetcher,
        "EtfHoldings": SecEtfHoldingsFetcher,
        "Filings": SecCompanyFilingsFetcher,
        "Form13FHR": SecForm13FHRFetcher,
        "SecHtmFile": SecHtmFileFetcher,
        "InsiderTrading": SecInsiderTradingFetcher,
        "InstitutionsSearch": SecInstitutionsSearchFetcher,
        "LatestFinancialReports": SecLatestFinancialReportsFetcher,
        "ManagementDiscussionAnalysis": SecManagementDiscussionAnalysisFetcher,
        "RssLitigation": SecRssLitigationFetcher,
        "SchemaFiles": SecSchemaFilesFetcher,
        "SecFiling": SecFilingFetcher,
        "SicSearch": SecSicSearchFetcher,
        "SymbolMap": SecSymbolMapFetcher,
    },
    repr_name="Securities and Exchange Commission (SEC)",
)
