import asyncio
from types import TracebackType
from typing import IO, Any, AsyncIterator, Iterator, List, Optional, Tuple, Type, TypeVar

import wrapt  # type: ignore
from aiobotocore import parsers as parsers
from botocore.exceptions import ReadTimeoutError
from botocore.model import OperationModel
from requests.models import Response

_R = TypeVar("_R")

class AioReadTimeoutError(ReadTimeoutError, asyncio.TimeoutError): ...

class StreamingBody(wrapt.ObjectProxy):  # type: ignore
    def __init__(self, raw_stream: IO[bytes], content_length: int) -> None: ...
    async def __aenter__(self: _R) -> _R: ...
    async def __aexit__(
        self,
        exc_type: Optional[Type[BaseException]],
        exc_val: Optional[BaseException],
        tb: Optional[TracebackType],
    ) -> None: ...
    def tell(self) -> int: ...
    def readable(self) -> bool: ...
    async def read(self, amt: Optional[int] = ...) -> bytes: ...
    async def readlines(self) -> List[bytes]: ...
    def __aiter__(self) -> AsyncIterator[bytes]: ...
    async def __anext__(self) -> bytes: ...
    anext: Any
    async def iter_lines(self, chunk_size: int = ..., keepends: bool = ...) -> Iterator[bytes]: ...
    async def iter_chunks(self, chunk_size: int = ...) -> Iterator[bytes]: ...

async def get_response(
    operation_model: OperationModel, http_response: Response
) -> Tuple[Response, Any]: ...
