"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * Use an Event Bridge event bus as a Lambda destination.
 *
 * If no event bus is specified, the default event bus is used.
 */
class EventBridgeDestination {
    /**
     * @default - use the default event bus
     */
    constructor(eventBus) {
        this.eventBus = eventBus;
    }
    /**
     * Returns a destination configuration
     */
    bind(_scope, fn) {
        // deduplicated automatically
        events.EventBus.grantPutEvents(fn); // Cannot restrict to a specific resource
        return {
            destination: this.eventBus && this.eventBus.eventBusArn || core_1.Stack.of(fn).formatArn({
                service: 'events',
                resource: 'event-bus',
                resourceName: 'default'
            })
        };
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
//# sourceMappingURL=data:application/json;base64,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