"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use a Lambda function as a Lambda destination
 */
class LambdaDestination {
    constructor(fn) {
        this.fn = fn;
    }
    /**
     * Returns a destination configuration
     */
    bind(_scope, fn) {
        // deduplicated automatically
        this.fn.grantInvoke(fn);
        return {
            destination: this.fn.functionArn
        };
    }
}
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBR0E7O0dBRUc7QUFDSCxNQUFhLGlCQUFpQjtJQUM1QixZQUE2QixFQUFvQjtRQUFwQixPQUFFLEdBQUYsRUFBRSxDQUFrQjtJQUNqRCxDQUFDO0lBRUQ7O09BRUc7SUFDSSxJQUFJLENBQUMsTUFBaUIsRUFBRSxFQUFvQjtRQUNqRCw2QkFBNkI7UUFDN0IsSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsRUFBRSxDQUFDLENBQUM7UUFFeEIsT0FBTztZQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsRUFBRSxDQUFDLFdBQVc7U0FDakMsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQWZELDhDQWVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbi8qKlxuICogVXNlIGEgTGFtYmRhIGZ1bmN0aW9uIGFzIGEgTGFtYmRhIGRlc3RpbmF0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBMYW1iZGFEZXN0aW5hdGlvbiBpbXBsZW1lbnRzIGxhbWJkYS5JRGVzdGluYXRpb24ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGZuOiBsYW1iZGEuSUZ1bmN0aW9uKSB7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIGRlc3RpbmF0aW9uIGNvbmZpZ3VyYXRpb25cbiAgICovXG4gIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0LCBmbjogbGFtYmRhLklGdW5jdGlvbik6IGxhbWJkYS5EZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgLy8gZGVkdXBsaWNhdGVkIGF1dG9tYXRpY2FsbHlcbiAgICB0aGlzLmZuLmdyYW50SW52b2tlKGZuKTtcblxuICAgIHJldHVybiB7XG4gICAgICBkZXN0aW5hdGlvbjogdGhpcy5mbi5mdW5jdGlvbkFyblxuICAgIH07XG4gIH1cbn1cbiJdfQ==