
#
# this file is generated by generate_type_stubs.py
#

from typing import List, Optional, Sequence, Tuple
from chia.types.blockchain_format.sized_bytes import bytes32

ReadableBuffer = Union[bytes, bytearray, memoryview]

def compute_merkle_set_root(items: Sequence[bytes]) -> bytes: ...

def run_generator(
    program: bytes, args: bytes, max_cost: int, flags: int
) -> Tuple[Optional[int], Optional[SpendBundleConditions]]: ...

def run_block_generator(
    program: bytes, args: List[bytes], max_cost: int, flags: int
) -> Tuple[Optional[int], Optional[SpendBundleConditions]]: ...

def run_puzzle(
    puzzle: bytes, solution: bytes, parent_id: bytes32, amount: int, max_cost: int, flags: int
) -> SpendBundleConditions: ...

COND_ARGS_NIL: int = ...
NO_UNKNOWN_CONDS: int = ...
STRICT_ARGS_COUNT: int = ...
LIMIT_HEAP: int = ...
LIMIT_STACK: int = ...
ENABLE_ASSERT_BEFORE: int = ...
MEMPOOL_MODE: int = ...
ELIGIBLE_FOR_DEDUP: int = ...

NO_UNKNOWN_OPS: int = ...

def run_chia_program(
    program: bytes, args: bytes, max_cost: int, flags: int
) -> Pair[int, LazyNode]: ...

class LazyNode:
    def pair() -> Optional[Tuple[LazyNode, LazyNode]]: ...
    def atom() -> bytes: ...

def serialized_length(program: bytes) -> int: ...
def tree_hash(program: ReadableBuffer) -> bytes32: ...
def get_puzzle_and_solution_for_coin(program: bytes, args: bytes, max_cost: int, find_parent: bytes32, find_amount: int, find_ph: bytes32) -> Tuple[bytes, bytes]: ...

class Spend:
    coin_id: bytes
    puzzle_hash: bytes
    height_relative: Optional[int]
    seconds_relative: Optional[int]
    before_height_relative: Optional[int]
    before_seconds_relative: Optional[int]
    birth_height: Optional[int]
    birth_seconds: Optional[int]
    create_coin: List[Tuple[bytes, int, Optional[bytes]]]
    agg_sig_me: List[Tuple[bytes, bytes]]
    flags: int
    def __init__(
        self,
        coin_id: bytes,
        puzzle_hash: bytes,
        height_relative: Optional[int],
        seconds_relative: Optional[int],
        before_height_relative: Optional[int],
        before_seconds_relative: Optional[int],
        birth_height: Optional[int],
        birth_seconds: Optional[int],
        create_coin: Sequence[Tuple[bytes, int, Optional[bytes]]],
        agg_sig_me: Sequence[Tuple[bytes, bytes]],
        flags: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> Spend: ...
    def __copy__(self) -> Spend: ...
    @staticmethod
    def from_bytes(bytes) -> Spend: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[Spend, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> Spend: ...

class SpendBundleConditions:
    spends: List[Spend]
    reserve_fee: int
    height_absolute: int
    seconds_absolute: int
    before_height_absolute: Optional[int]
    before_seconds_absolute: Optional[int]
    agg_sig_unsafe: List[Tuple[bytes, bytes]]
    cost: int
    removal_amount: int
    addition_amount: int
    def __init__(
        self,
        spends: Sequence[Spend],
        reserve_fee: int,
        height_absolute: int,
        seconds_absolute: int,
        before_height_absolute: Optional[int],
        before_seconds_absolute: Optional[int],
        agg_sig_unsafe: Sequence[Tuple[bytes, bytes]],
        cost: int,
        removal_amount: int,
        addition_amount: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> SpendBundleConditions: ...
    def __copy__(self) -> SpendBundleConditions: ...
    @staticmethod
    def from_bytes(bytes) -> SpendBundleConditions: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[SpendBundleConditions, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> SpendBundleConditions: ...

class G1Element:
    a0: bytes48
    def __init__(
        self,
        a0: bytes48
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> G1Element: ...
    def __copy__(self) -> G1Element: ...
    @staticmethod
    def from_bytes(bytes) -> G1Element: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[G1Element, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> G1Element: ...

class G2Element:
    a0: bytes96
    def __init__(
        self,
        a0: bytes96
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> G2Element: ...
    def __copy__(self) -> G2Element: ...
    @staticmethod
    def from_bytes(bytes) -> G2Element: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[G2Element, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> G2Element: ...

class Message:
    msg_type: int
    id: Optional[int]
    data: bytes
    def __init__(
        self,
        msg_type: int,
        id: Optional[int],
        data: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> Message: ...
    def __copy__(self) -> Message: ...
    @staticmethod
    def from_bytes(bytes) -> Message: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[Message, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> Message: ...

class Handshake:
    network_id: String
    protocol_version: String
    software_version: String
    server_port: int
    node_type: int
    capabilities: List[(int, String)]
    def __init__(
        self,
        network_id: String,
        protocol_version: String,
        software_version: String,
        server_port: int,
        node_type: int,
        capabilities: Sequence[(int, String)]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> Handshake: ...
    def __copy__(self) -> Handshake: ...
    @staticmethod
    def from_bytes(bytes) -> Handshake: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[Handshake, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> Handshake: ...

class ClassgroupElement:
    data: bytes100
    def __init__(
        self,
        data: bytes100
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> ClassgroupElement: ...
    def __copy__(self) -> ClassgroupElement: ...
    @staticmethod
    def from_bytes(bytes) -> ClassgroupElement: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[ClassgroupElement, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> ClassgroupElement: ...

class Coin:
    parent_coin_info: bytes32
    puzzle_hash: bytes32
    amount: int
    def name(self) -> bytes32: ...
    def __init__(
        self,
        parent_coin_info: bytes,
        puzzle_hash: bytes,
        amount: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> Coin: ...
    def __copy__(self) -> Coin: ...
    @staticmethod
    def from_bytes(bytes) -> Coin: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[Coin, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> Coin: ...

class CoinSpend:
    coin: Coin
    puzzle_reveal: Program
    solution: Program
    def __init__(
        self,
        coin: Coin,
        puzzle_reveal: Program,
        solution: Program
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> CoinSpend: ...
    def __copy__(self) -> CoinSpend: ...
    @staticmethod
    def from_bytes(bytes) -> CoinSpend: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[CoinSpend, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> CoinSpend: ...

class CoinState:
    coin: Coin
    spent_height: Optional[int]
    created_height: Optional[int]
    def __init__(
        self,
        coin: Coin,
        spent_height: Optional[int],
        created_height: Optional[int]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> CoinState: ...
    def __copy__(self) -> CoinState: ...
    @staticmethod
    def from_bytes(bytes) -> CoinState: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[CoinState, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> CoinState: ...

class EndOfSubSlotBundle:
    challenge_chain: ChallengeChainSubSlot
    infused_challenge_chain: Optional[InfusedChallengeChainSubSlot]
    reward_chain: RewardChainSubSlot
    proofs: SubSlotProofs
    def __init__(
        self,
        challenge_chain: ChallengeChainSubSlot,
        infused_challenge_chain: Optional[InfusedChallengeChainSubSlot],
        reward_chain: RewardChainSubSlot,
        proofs: SubSlotProofs
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> EndOfSubSlotBundle: ...
    def __copy__(self) -> EndOfSubSlotBundle: ...
    @staticmethod
    def from_bytes(bytes) -> EndOfSubSlotBundle: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[EndOfSubSlotBundle, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> EndOfSubSlotBundle: ...

class FeeRate:
    mojos_per_clvm_cost: int
    def __init__(
        self,
        mojos_per_clvm_cost: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> FeeRate: ...
    def __copy__(self) -> FeeRate: ...
    @staticmethod
    def from_bytes(bytes) -> FeeRate: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[FeeRate, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> FeeRate: ...

class FeeEstimate:
    error: Optional[String]
    time_target: int
    estimated_fee_rate: FeeRate
    def __init__(
        self,
        error: Optional[String],
        time_target: int,
        estimated_fee_rate: FeeRate
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> FeeEstimate: ...
    def __copy__(self) -> FeeEstimate: ...
    @staticmethod
    def from_bytes(bytes) -> FeeEstimate: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[FeeEstimate, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> FeeEstimate: ...

class FeeEstimateGroup:
    error: Optional[String]
    estimates: List[FeeEstimate]
    def __init__(
        self,
        error: Optional[String],
        estimates: Sequence[FeeEstimate]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> FeeEstimateGroup: ...
    def __copy__(self) -> FeeEstimateGroup: ...
    @staticmethod
    def from_bytes(bytes) -> FeeEstimateGroup: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[FeeEstimateGroup, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> FeeEstimateGroup: ...

class TransactionsInfo:
    generator_root: bytes32
    generator_refs_root: bytes32
    aggregated_signature: G2Element
    fees: int
    cost: int
    reward_claims_incorporated: List[Coin]
    def __init__(
        self,
        generator_root: bytes,
        generator_refs_root: bytes,
        aggregated_signature: G2Element,
        fees: int,
        cost: int,
        reward_claims_incorporated: Sequence[Coin]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> TransactionsInfo: ...
    def __copy__(self) -> TransactionsInfo: ...
    @staticmethod
    def from_bytes(bytes) -> TransactionsInfo: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[TransactionsInfo, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> TransactionsInfo: ...

class FoliageTransactionBlock:
    prev_transaction_block_hash: bytes32
    timestamp: int
    filter_hash: bytes32
    additions_root: bytes32
    removals_root: bytes32
    transactions_info_hash: bytes32
    def __init__(
        self,
        prev_transaction_block_hash: bytes,
        timestamp: int,
        filter_hash: bytes,
        additions_root: bytes,
        removals_root: bytes,
        transactions_info_hash: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> FoliageTransactionBlock: ...
    def __copy__(self) -> FoliageTransactionBlock: ...
    @staticmethod
    def from_bytes(bytes) -> FoliageTransactionBlock: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[FoliageTransactionBlock, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> FoliageTransactionBlock: ...

class FoliageBlockData:
    unfinished_reward_block_hash: bytes32
    pool_target: PoolTarget
    pool_signature: Optional[G2Element]
    farmer_reward_puzzle_hash: bytes32
    extension_data: bytes32
    def __init__(
        self,
        unfinished_reward_block_hash: bytes,
        pool_target: PoolTarget,
        pool_signature: Optional[G2Element],
        farmer_reward_puzzle_hash: bytes,
        extension_data: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> FoliageBlockData: ...
    def __copy__(self) -> FoliageBlockData: ...
    @staticmethod
    def from_bytes(bytes) -> FoliageBlockData: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[FoliageBlockData, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> FoliageBlockData: ...

class Foliage:
    prev_block_hash: bytes32
    reward_block_hash: bytes32
    foliage_block_data: FoliageBlockData
    foliage_block_data_signature: G2Element
    foliage_transaction_block_hash: Optional[bytes32]
    foliage_transaction_block_signature: Optional[G2Element]
    def __init__(
        self,
        prev_block_hash: bytes,
        reward_block_hash: bytes,
        foliage_block_data: FoliageBlockData,
        foliage_block_data_signature: G2Element,
        foliage_transaction_block_hash: Optional[bytes32],
        foliage_transaction_block_signature: Optional[G2Element]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> Foliage: ...
    def __copy__(self) -> Foliage: ...
    @staticmethod
    def from_bytes(bytes) -> Foliage: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[Foliage, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> Foliage: ...

class FullBlock:
    finished_sub_slots: List[EndOfSubSlotBundle]
    reward_chain_block: RewardChainBlock
    challenge_chain_sp_proof: Optional[VDFProof]
    challenge_chain_ip_proof: VDFProof
    reward_chain_sp_proof: Optional[VDFProof]
    reward_chain_ip_proof: VDFProof
    infused_challenge_chain_ip_proof: Optional[VDFProof]
    foliage: Foliage
    foliage_transaction_block: Optional[FoliageTransactionBlock]
    transactions_info: Optional[TransactionsInfo]
    transactions_generator: Optional[Program]
    transactions_generator_ref_list: List[int]
    def __init__(
        self,
        finished_sub_slots: Sequence[EndOfSubSlotBundle],
        reward_chain_block: RewardChainBlock,
        challenge_chain_sp_proof: Optional[VDFProof],
        challenge_chain_ip_proof: VDFProof,
        reward_chain_sp_proof: Optional[VDFProof],
        reward_chain_ip_proof: VDFProof,
        infused_challenge_chain_ip_proof: Optional[VDFProof],
        foliage: Foliage,
        foliage_transaction_block: Optional[FoliageTransactionBlock],
        transactions_info: Optional[TransactionsInfo],
        transactions_generator: Optional[Program],
        transactions_generator_ref_list: Sequence[int]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> FullBlock: ...
    def __copy__(self) -> FullBlock: ...
    @staticmethod
    def from_bytes(bytes) -> FullBlock: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[FullBlock, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> FullBlock: ...

class HeaderBlock:
    finished_sub_slots: List[EndOfSubSlotBundle]
    reward_chain_block: RewardChainBlock
    challenge_chain_sp_proof: Optional[VDFProof]
    challenge_chain_ip_proof: VDFProof
    reward_chain_sp_proof: Optional[VDFProof]
    reward_chain_ip_proof: VDFProof
    infused_challenge_chain_ip_proof: Optional[VDFProof]
    foliage: Foliage
    foliage_transaction_block: Optional[FoliageTransactionBlock]
    transactions_filter: bytes
    transactions_info: Optional[TransactionsInfo]
    def __init__(
        self,
        finished_sub_slots: Sequence[EndOfSubSlotBundle],
        reward_chain_block: RewardChainBlock,
        challenge_chain_sp_proof: Optional[VDFProof],
        challenge_chain_ip_proof: VDFProof,
        reward_chain_sp_proof: Optional[VDFProof],
        reward_chain_ip_proof: VDFProof,
        infused_challenge_chain_ip_proof: Optional[VDFProof],
        foliage: Foliage,
        foliage_transaction_block: Optional[FoliageTransactionBlock],
        transactions_filter: bytes,
        transactions_info: Optional[TransactionsInfo]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> HeaderBlock: ...
    def __copy__(self) -> HeaderBlock: ...
    @staticmethod
    def from_bytes(bytes) -> HeaderBlock: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[HeaderBlock, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> HeaderBlock: ...

class PoolTarget:
    puzzle_hash: bytes32
    max_height: int
    def __init__(
        self,
        puzzle_hash: bytes,
        max_height: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> PoolTarget: ...
    def __copy__(self) -> PoolTarget: ...
    @staticmethod
    def from_bytes(bytes) -> PoolTarget: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[PoolTarget, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> PoolTarget: ...

class Program:
    a0: bytes
    def __init__(
        self,
        a0: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> Program: ...
    def __copy__(self) -> Program: ...
    @staticmethod
    def from_bytes(bytes) -> Program: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[Program, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> Program: ...

class ProofOfSpace:
    challenge: bytes32
    pool_public_key: Optional[G1Element]
    pool_contract_puzzle_hash: Optional[bytes32]
    plot_public_key: G1Element
    size: int
    proof: bytes
    def __init__(
        self,
        challenge: bytes,
        pool_public_key: Optional[G1Element],
        pool_contract_puzzle_hash: Optional[bytes32],
        plot_public_key: G1Element,
        size: int,
        proof: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> ProofOfSpace: ...
    def __copy__(self) -> ProofOfSpace: ...
    @staticmethod
    def from_bytes(bytes) -> ProofOfSpace: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[ProofOfSpace, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> ProofOfSpace: ...

class RewardChainBlockUnfinished:
    total_iters: int
    signage_point_index: int
    pos_ss_cc_challenge_hash: bytes32
    proof_of_space: ProofOfSpace
    challenge_chain_sp_vdf: Optional[VDFInfo]
    challenge_chain_sp_signature: G2Element
    reward_chain_sp_vdf: Optional[VDFInfo]
    reward_chain_sp_signature: G2Element
    def __init__(
        self,
        total_iters: int,
        signage_point_index: int,
        pos_ss_cc_challenge_hash: bytes,
        proof_of_space: ProofOfSpace,
        challenge_chain_sp_vdf: Optional[VDFInfo],
        challenge_chain_sp_signature: G2Element,
        reward_chain_sp_vdf: Optional[VDFInfo],
        reward_chain_sp_signature: G2Element
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RewardChainBlockUnfinished: ...
    def __copy__(self) -> RewardChainBlockUnfinished: ...
    @staticmethod
    def from_bytes(bytes) -> RewardChainBlockUnfinished: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RewardChainBlockUnfinished, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RewardChainBlockUnfinished: ...

class RewardChainBlock:
    weight: int
    height: int
    total_iters: int
    signage_point_index: int
    pos_ss_cc_challenge_hash: bytes32
    proof_of_space: ProofOfSpace
    challenge_chain_sp_vdf: Optional[VDFInfo]
    challenge_chain_sp_signature: G2Element
    challenge_chain_ip_vdf: VDFInfo
    reward_chain_sp_vdf: Optional[VDFInfo]
    reward_chain_sp_signature: G2Element
    reward_chain_ip_vdf: VDFInfo
    infused_challenge_chain_ip_vdf: Optional[VDFInfo]
    is_transaction_block: bool
    def __init__(
        self,
        weight: int,
        height: int,
        total_iters: int,
        signage_point_index: int,
        pos_ss_cc_challenge_hash: bytes,
        proof_of_space: ProofOfSpace,
        challenge_chain_sp_vdf: Optional[VDFInfo],
        challenge_chain_sp_signature: G2Element,
        challenge_chain_ip_vdf: VDFInfo,
        reward_chain_sp_vdf: Optional[VDFInfo],
        reward_chain_sp_signature: G2Element,
        reward_chain_ip_vdf: VDFInfo,
        infused_challenge_chain_ip_vdf: Optional[VDFInfo],
        is_transaction_block: bool
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RewardChainBlock: ...
    def __copy__(self) -> RewardChainBlock: ...
    @staticmethod
    def from_bytes(bytes) -> RewardChainBlock: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RewardChainBlock, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RewardChainBlock: ...

class ChallengeBlockInfo:
    proof_of_space: ProofOfSpace
    challenge_chain_sp_vdf: Optional[VDFInfo]
    challenge_chain_sp_signature: G2Element
    challenge_chain_ip_vdf: VDFInfo
    def __init__(
        self,
        proof_of_space: ProofOfSpace,
        challenge_chain_sp_vdf: Optional[VDFInfo],
        challenge_chain_sp_signature: G2Element,
        challenge_chain_ip_vdf: VDFInfo
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> ChallengeBlockInfo: ...
    def __copy__(self) -> ChallengeBlockInfo: ...
    @staticmethod
    def from_bytes(bytes) -> ChallengeBlockInfo: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[ChallengeBlockInfo, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> ChallengeBlockInfo: ...

class ChallengeChainSubSlot:
    challenge_chain_end_of_slot_vdf: VDFInfo
    infused_challenge_chain_sub_slot_hash: Optional[bytes32]
    subepoch_summary_hash: Optional[bytes32]
    new_sub_slot_iters: Optional[int]
    new_difficulty: Optional[int]
    def __init__(
        self,
        challenge_chain_end_of_slot_vdf: VDFInfo,
        infused_challenge_chain_sub_slot_hash: Optional[bytes32],
        subepoch_summary_hash: Optional[bytes32],
        new_sub_slot_iters: Optional[int],
        new_difficulty: Optional[int]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> ChallengeChainSubSlot: ...
    def __copy__(self) -> ChallengeChainSubSlot: ...
    @staticmethod
    def from_bytes(bytes) -> ChallengeChainSubSlot: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[ChallengeChainSubSlot, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> ChallengeChainSubSlot: ...

class InfusedChallengeChainSubSlot:
    infused_challenge_chain_end_of_slot_vdf: VDFInfo
    def __init__(
        self,
        infused_challenge_chain_end_of_slot_vdf: VDFInfo
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> InfusedChallengeChainSubSlot: ...
    def __copy__(self) -> InfusedChallengeChainSubSlot: ...
    @staticmethod
    def from_bytes(bytes) -> InfusedChallengeChainSubSlot: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[InfusedChallengeChainSubSlot, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> InfusedChallengeChainSubSlot: ...

class RewardChainSubSlot:
    end_of_slot_vdf: VDFInfo
    challenge_chain_sub_slot_hash: bytes32
    infused_challenge_chain_sub_slot_hash: Optional[bytes32]
    deficit: int
    def __init__(
        self,
        end_of_slot_vdf: VDFInfo,
        challenge_chain_sub_slot_hash: bytes,
        infused_challenge_chain_sub_slot_hash: Optional[bytes32],
        deficit: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RewardChainSubSlot: ...
    def __copy__(self) -> RewardChainSubSlot: ...
    @staticmethod
    def from_bytes(bytes) -> RewardChainSubSlot: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RewardChainSubSlot, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RewardChainSubSlot: ...

class SubSlotProofs:
    challenge_chain_slot_proof: VDFProof
    infused_challenge_chain_slot_proof: Optional[VDFProof]
    reward_chain_slot_proof: VDFProof
    def __init__(
        self,
        challenge_chain_slot_proof: VDFProof,
        infused_challenge_chain_slot_proof: Optional[VDFProof],
        reward_chain_slot_proof: VDFProof
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> SubSlotProofs: ...
    def __copy__(self) -> SubSlotProofs: ...
    @staticmethod
    def from_bytes(bytes) -> SubSlotProofs: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[SubSlotProofs, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> SubSlotProofs: ...

class SpendBundle:
    coin_spends: List[CoinSpend]
    aggregated_signature: bytes96
    def __init__(
        self,
        coin_spends: Sequence[CoinSpend],
        aggregated_signature: bytes96
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> SpendBundle: ...
    def __copy__(self) -> SpendBundle: ...
    @staticmethod
    def from_bytes(bytes) -> SpendBundle: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[SpendBundle, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> SpendBundle: ...

class VDFInfo:
    challenge: bytes32
    number_of_iterations: int
    output: ClassgroupElement
    def __init__(
        self,
        challenge: bytes,
        number_of_iterations: int,
        output: ClassgroupElement
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> VDFInfo: ...
    def __copy__(self) -> VDFInfo: ...
    @staticmethod
    def from_bytes(bytes) -> VDFInfo: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[VDFInfo, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> VDFInfo: ...

class VDFProof:
    witness_type: int
    witness: bytes
    normalized_to_identity: bool
    def __init__(
        self,
        witness_type: int,
        witness: bytes,
        normalized_to_identity: bool
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> VDFProof: ...
    def __copy__(self) -> VDFProof: ...
    @staticmethod
    def from_bytes(bytes) -> VDFProof: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[VDFProof, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> VDFProof: ...

class RequestPuzzleSolution:
    coin_name: bytes32
    height: int
    def __init__(
        self,
        coin_name: bytes,
        height: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RequestPuzzleSolution: ...
    def __copy__(self) -> RequestPuzzleSolution: ...
    @staticmethod
    def from_bytes(bytes) -> RequestPuzzleSolution: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RequestPuzzleSolution, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RequestPuzzleSolution: ...

class PuzzleSolutionResponse:
    coin_name: bytes32
    height: int
    puzzle: Program
    solution: Program
    def __init__(
        self,
        coin_name: bytes,
        height: int,
        puzzle: Program,
        solution: Program
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> PuzzleSolutionResponse: ...
    def __copy__(self) -> PuzzleSolutionResponse: ...
    @staticmethod
    def from_bytes(bytes) -> PuzzleSolutionResponse: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[PuzzleSolutionResponse, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> PuzzleSolutionResponse: ...

class RespondPuzzleSolution:
    response: PuzzleSolutionResponse
    def __init__(
        self,
        response: PuzzleSolutionResponse
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondPuzzleSolution: ...
    def __copy__(self) -> RespondPuzzleSolution: ...
    @staticmethod
    def from_bytes(bytes) -> RespondPuzzleSolution: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondPuzzleSolution, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondPuzzleSolution: ...

class RejectPuzzleSolution:
    coin_name: bytes32
    height: int
    def __init__(
        self,
        coin_name: bytes,
        height: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RejectPuzzleSolution: ...
    def __copy__(self) -> RejectPuzzleSolution: ...
    @staticmethod
    def from_bytes(bytes) -> RejectPuzzleSolution: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RejectPuzzleSolution, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RejectPuzzleSolution: ...

class SendTransaction:
    ransaction: SpendBundle
    def __init__(
        self,
        ransaction: SpendBundle
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> SendTransaction: ...
    def __copy__(self) -> SendTransaction: ...
    @staticmethod
    def from_bytes(bytes) -> SendTransaction: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[SendTransaction, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> SendTransaction: ...

class TransactionAck:
    txid: bytes32
    status: int
    error: Optional[String]
    def __init__(
        self,
        txid: bytes,
        status: int,
        error: Optional[String]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> TransactionAck: ...
    def __copy__(self) -> TransactionAck: ...
    @staticmethod
    def from_bytes(bytes) -> TransactionAck: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[TransactionAck, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> TransactionAck: ...

class NewPeakWallet:
    header_hash: bytes32
    height: int
    weight: int
    fork_point_with_previous_peak: int
    def __init__(
        self,
        header_hash: bytes,
        height: int,
        weight: int,
        fork_point_with_previous_peak: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> NewPeakWallet: ...
    def __copy__(self) -> NewPeakWallet: ...
    @staticmethod
    def from_bytes(bytes) -> NewPeakWallet: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[NewPeakWallet, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> NewPeakWallet: ...

class RequestBlockHeader:
    height: int
    def __init__(
        self,
        height: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RequestBlockHeader: ...
    def __copy__(self) -> RequestBlockHeader: ...
    @staticmethod
    def from_bytes(bytes) -> RequestBlockHeader: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RequestBlockHeader, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RequestBlockHeader: ...

class RespondBlockHeader:
    header_block: HeaderBlock
    def __init__(
        self,
        header_block: HeaderBlock
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondBlockHeader: ...
    def __copy__(self) -> RespondBlockHeader: ...
    @staticmethod
    def from_bytes(bytes) -> RespondBlockHeader: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondBlockHeader, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondBlockHeader: ...

class RejectHeaderRequest:
    height: int
    def __init__(
        self,
        height: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RejectHeaderRequest: ...
    def __copy__(self) -> RejectHeaderRequest: ...
    @staticmethod
    def from_bytes(bytes) -> RejectHeaderRequest: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RejectHeaderRequest, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RejectHeaderRequest: ...

class RequestRemovals:
    height: int
    header_hash: bytes32
    coin_names: Optional[List[bytes32]]
    def __init__(
        self,
        height: int,
        header_hash: bytes,
        coin_names: Optional[Sequence[bytes32]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RequestRemovals: ...
    def __copy__(self) -> RequestRemovals: ...
    @staticmethod
    def from_bytes(bytes) -> RequestRemovals: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RequestRemovals, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RequestRemovals: ...

class RespondRemovals:
    height: int
    header_hash: bytes32
    coins: List[(bytes32, Optional[Coin])]
    proofs: Optional[List[(bytes32, bytes)]]
    def __init__(
        self,
        height: int,
        header_hash: bytes,
        coins: Sequence[(bytes32, Optional[Coin])],
        proofs: Optional[Sequence[(bytes32, bytes)]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondRemovals: ...
    def __copy__(self) -> RespondRemovals: ...
    @staticmethod
    def from_bytes(bytes) -> RespondRemovals: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondRemovals, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondRemovals: ...

class RejectRemovalsRequest:
    height: int
    header_hash: bytes32
    def __init__(
        self,
        height: int,
        header_hash: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RejectRemovalsRequest: ...
    def __copy__(self) -> RejectRemovalsRequest: ...
    @staticmethod
    def from_bytes(bytes) -> RejectRemovalsRequest: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RejectRemovalsRequest, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RejectRemovalsRequest: ...

class RequestAdditions:
    height: int
    header_hash: Optional[bytes32]
    puzzle_hashes: Optional[List[bytes32]]
    def __init__(
        self,
        height: int,
        header_hash: Optional[bytes32],
        puzzle_hashes: Optional[Sequence[bytes32]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RequestAdditions: ...
    def __copy__(self) -> RequestAdditions: ...
    @staticmethod
    def from_bytes(bytes) -> RequestAdditions: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RequestAdditions, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RequestAdditions: ...

class RespondAdditions:
    height: int
    header_hash: bytes32
    coins: List[(bytes32, List[Coin])]
    proofs: Optional[List[(bytes32, bytes, Optional[bytes])]]
    def __init__(
        self,
        height: int,
        header_hash: bytes,
        coins: Sequence[(bytes32, Sequence[Coin])],
        proofs: Optional[Sequence[(bytes32, bytes, Optional[bytes])]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondAdditions: ...
    def __copy__(self) -> RespondAdditions: ...
    @staticmethod
    def from_bytes(bytes) -> RespondAdditions: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondAdditions, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondAdditions: ...

class RejectAdditionsRequest:
    height: int
    header_hash: bytes32
    def __init__(
        self,
        height: int,
        header_hash: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RejectAdditionsRequest: ...
    def __copy__(self) -> RejectAdditionsRequest: ...
    @staticmethod
    def from_bytes(bytes) -> RejectAdditionsRequest: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RejectAdditionsRequest, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RejectAdditionsRequest: ...

class RespondBlockHeaders:
    start_height: int
    end_height: int
    header_blocks: List[HeaderBlock]
    def __init__(
        self,
        start_height: int,
        end_height: int,
        header_blocks: Sequence[HeaderBlock]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondBlockHeaders: ...
    def __copy__(self) -> RespondBlockHeaders: ...
    @staticmethod
    def from_bytes(bytes) -> RespondBlockHeaders: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondBlockHeaders, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondBlockHeaders: ...

class RejectBlockHeaders:
    start_height: int
    end_height: int
    def __init__(
        self,
        start_height: int,
        end_height: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RejectBlockHeaders: ...
    def __copy__(self) -> RejectBlockHeaders: ...
    @staticmethod
    def from_bytes(bytes) -> RejectBlockHeaders: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RejectBlockHeaders, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RejectBlockHeaders: ...

class RequestBlockHeaders:
    start_height: int
    end_height: int
    return_filter: bool
    def __init__(
        self,
        start_height: int,
        end_height: int,
        return_filter: bool
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RequestBlockHeaders: ...
    def __copy__(self) -> RequestBlockHeaders: ...
    @staticmethod
    def from_bytes(bytes) -> RequestBlockHeaders: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RequestBlockHeaders, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RequestBlockHeaders: ...

class RequestHeaderBlocks:
    start_height: int
    end_height: int
    def __init__(
        self,
        start_height: int,
        end_height: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RequestHeaderBlocks: ...
    def __copy__(self) -> RequestHeaderBlocks: ...
    @staticmethod
    def from_bytes(bytes) -> RequestHeaderBlocks: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RequestHeaderBlocks, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RequestHeaderBlocks: ...

class RejectHeaderBlocks:
    start_height: int
    end_height: int
    def __init__(
        self,
        start_height: int,
        end_height: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RejectHeaderBlocks: ...
    def __copy__(self) -> RejectHeaderBlocks: ...
    @staticmethod
    def from_bytes(bytes) -> RejectHeaderBlocks: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RejectHeaderBlocks, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RejectHeaderBlocks: ...

class RespondHeaderBlocks:
    start_height: int
    end_height: int
    header_blocks: List[HeaderBlock]
    def __init__(
        self,
        start_height: int,
        end_height: int,
        header_blocks: Sequence[HeaderBlock]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondHeaderBlocks: ...
    def __copy__(self) -> RespondHeaderBlocks: ...
    @staticmethod
    def from_bytes(bytes) -> RespondHeaderBlocks: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondHeaderBlocks, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondHeaderBlocks: ...

class RegisterForPhUpdates:
    puzzle_hashes: List[bytes32]
    min_height: int
    def __init__(
        self,
        puzzle_hashes: Sequence[bytes32],
        min_height: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RegisterForPhUpdates: ...
    def __copy__(self) -> RegisterForPhUpdates: ...
    @staticmethod
    def from_bytes(bytes) -> RegisterForPhUpdates: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RegisterForPhUpdates, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RegisterForPhUpdates: ...

class RespondToPhUpdates:
    puzzle_hashes: List[bytes32]
    min_height: int
    coin_states: List[CoinState]
    def __init__(
        self,
        puzzle_hashes: Sequence[bytes32],
        min_height: int,
        coin_states: Sequence[CoinState]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondToPhUpdates: ...
    def __copy__(self) -> RespondToPhUpdates: ...
    @staticmethod
    def from_bytes(bytes) -> RespondToPhUpdates: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondToPhUpdates, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondToPhUpdates: ...

class RegisterForCoinUpdates:
    coin_ids: List[bytes32]
    min_height: int
    def __init__(
        self,
        coin_ids: Sequence[bytes32],
        min_height: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RegisterForCoinUpdates: ...
    def __copy__(self) -> RegisterForCoinUpdates: ...
    @staticmethod
    def from_bytes(bytes) -> RegisterForCoinUpdates: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RegisterForCoinUpdates, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RegisterForCoinUpdates: ...

class RespondToCoinUpdates:
    coin_ids: List[bytes32]
    min_height: int
    coin_states: List[CoinState]
    def __init__(
        self,
        coin_ids: Sequence[bytes32],
        min_height: int,
        coin_states: Sequence[CoinState]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondToCoinUpdates: ...
    def __copy__(self) -> RespondToCoinUpdates: ...
    @staticmethod
    def from_bytes(bytes) -> RespondToCoinUpdates: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondToCoinUpdates, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondToCoinUpdates: ...

class CoinStateUpdate:
    height: int
    fork_height: int
    peak_hash: bytes32
    items: List[CoinState]
    def __init__(
        self,
        height: int,
        fork_height: int,
        peak_hash: bytes,
        items: Sequence[CoinState]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> CoinStateUpdate: ...
    def __copy__(self) -> CoinStateUpdate: ...
    @staticmethod
    def from_bytes(bytes) -> CoinStateUpdate: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[CoinStateUpdate, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> CoinStateUpdate: ...

class RequestChildren:
    coin_name: bytes32
    def __init__(
        self,
        coin_name: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RequestChildren: ...
    def __copy__(self) -> RequestChildren: ...
    @staticmethod
    def from_bytes(bytes) -> RequestChildren: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RequestChildren, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RequestChildren: ...

class RespondChildren:
    coin_states: List[CoinState]
    def __init__(
        self,
        coin_states: Sequence[CoinState]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondChildren: ...
    def __copy__(self) -> RespondChildren: ...
    @staticmethod
    def from_bytes(bytes) -> RespondChildren: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondChildren, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondChildren: ...

class RequestSesInfo:
    start_height: int
    end_height: int
    def __init__(
        self,
        start_height: int,
        end_height: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RequestSesInfo: ...
    def __copy__(self) -> RequestSesInfo: ...
    @staticmethod
    def from_bytes(bytes) -> RequestSesInfo: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RequestSesInfo, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RequestSesInfo: ...

class RespondSesInfo:
    reward_chain_hash: List[bytes32]
    heights: List[List[int]]
    def __init__(
        self,
        reward_chain_hash: Sequence[bytes32],
        heights: Sequence[Sequence[int]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondSesInfo: ...
    def __copy__(self) -> RespondSesInfo: ...
    @staticmethod
    def from_bytes(bytes) -> RespondSesInfo: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondSesInfo, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondSesInfo: ...

class RequestFeeEstimates:
    time_targets: List[int]
    def __init__(
        self,
        time_targets: Sequence[int]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RequestFeeEstimates: ...
    def __copy__(self) -> RequestFeeEstimates: ...
    @staticmethod
    def from_bytes(bytes) -> RequestFeeEstimates: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RequestFeeEstimates, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RequestFeeEstimates: ...

class RespondFeeEstimates:
    estimates: FeeEstimateGroup
    def __init__(
        self,
        estimates: FeeEstimateGroup
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondFeeEstimates: ...
    def __copy__(self) -> RespondFeeEstimates: ...
    @staticmethod
    def from_bytes(bytes) -> RespondFeeEstimates: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondFeeEstimates, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondFeeEstimates: ...

class SubSlotData:
    proof_of_space: Optional[ProofOfSpace]
    cc_signage_point: Optional[VDFProof]
    cc_infusion_point: Optional[VDFProof]
    icc_infusion_point: Optional[VDFProof]
    cc_sp_vdf_info: Optional[VDFInfo]
    signage_point_index: Optional[int]
    cc_slot_end: Optional[VDFProof]
    icc_slot_end: Optional[VDFProof]
    cc_slot_end_info: Optional[VDFInfo]
    icc_slot_end_info: Optional[VDFInfo]
    cc_ip_vdf_info: Optional[VDFInfo]
    icc_ip_vdf_info: Optional[VDFInfo]
    total_iters: Optional[int]
    def __init__(
        self,
        proof_of_space: Optional[ProofOfSpace],
        cc_signage_point: Optional[VDFProof],
        cc_infusion_point: Optional[VDFProof],
        icc_infusion_point: Optional[VDFProof],
        cc_sp_vdf_info: Optional[VDFInfo],
        signage_point_index: Optional[int],
        cc_slot_end: Optional[VDFProof],
        icc_slot_end: Optional[VDFProof],
        cc_slot_end_info: Optional[VDFInfo],
        icc_slot_end_info: Optional[VDFInfo],
        cc_ip_vdf_info: Optional[VDFInfo],
        icc_ip_vdf_info: Optional[VDFInfo],
        total_iters: Optional[int]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> SubSlotData: ...
    def __copy__(self) -> SubSlotData: ...
    @staticmethod
    def from_bytes(bytes) -> SubSlotData: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[SubSlotData, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> SubSlotData: ...

class SubEpochChallengeSegment:
    sub_epoch_n: int
    sub_slots: List[SubSlotData]
    rc_slot_end_info: Optional[VDFInfo]
    def __init__(
        self,
        sub_epoch_n: int,
        sub_slots: Sequence[SubSlotData],
        rc_slot_end_info: Optional[VDFInfo]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> SubEpochChallengeSegment: ...
    def __copy__(self) -> SubEpochChallengeSegment: ...
    @staticmethod
    def from_bytes(bytes) -> SubEpochChallengeSegment: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[SubEpochChallengeSegment, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> SubEpochChallengeSegment: ...

class SubEpochSegments:
    challenge_segments: List[SubEpochChallengeSegment]
    def __init__(
        self,
        challenge_segments: Sequence[SubEpochChallengeSegment]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> SubEpochSegments: ...
    def __copy__(self) -> SubEpochSegments: ...
    @staticmethod
    def from_bytes(bytes) -> SubEpochSegments: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[SubEpochSegments, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> SubEpochSegments: ...
