import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [workmail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmail.html).
 *
 * @experimental
 */
export declare class Workmail extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [workmail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmail.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Adds a list of members (users or groups) to a group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toAddMembersToGroup(): this;
    /**
     * (experimental) Adds a member (user or group) to the resource's set of delegates.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_AssociateDelegateToResource.html
     *
     * @experimental
     */
    toAssociateDelegateToResource(): this;
    /**
     * (experimental) Adds a member (user or group) to the group's set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_AssociateMemberToGroup.html
     *
     * @experimental
     */
    toAssociateMemberToGroup(): this;
    /**
     * (experimental) Cancels a currently running mailbox export job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CancelMailboxExportJob.html
     *
     * @experimental
     */
    toCancelMailboxExportJob(): this;
    /**
     * (experimental) Adds an alias to the set of a given member (user or group) of WorkMail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateAlias.html
     *
     * @experimental
     */
    toCreateAlias(): this;
    /**
     * (experimental) Creates a group that can be used in WorkMail by calling the RegisterToWorkMail operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateGroup.html
     *
     * @experimental
     */
    toCreateGroup(): this;
    /**
     * (experimental) Create an inbound email flow rule which will apply to all email sent to an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/create-email-rules.html
     *
     * @experimental
     */
    toCreateInboundMailFlowRule(): this;
    /**
     * (experimental) Creates a mail domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html
     *
     * @experimental
     */
    toCreateMailDomain(): this;
    /**
     * (experimental) Creates a user in the directory and the WorkMail storage but does not enable the user for mail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html
     *
     * @experimental
     */
    toCreateMailUser(): this;
    /**
     * (experimental) Creates a new Amazon WorkMail organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateOrganization.html
     *
     * @experimental
     */
    toCreateOrganization(): this;
    /**
     * (experimental) Create an outbound email flow rule which will apply to all email sent from an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/create-email-rules.html
     *
     * @experimental
     */
    toCreateOutboundMailFlowRule(): this;
    /**
     * (experimental) Creates a new WorkMail resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateResource.html
     *
     * @experimental
     */
    toCreateResource(): this;
    /**
     * (experimental) Register an SMTP device against a WorkMail organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     *
     * @experimental
     */
    toCreateSmtpGateway(): this;
    /**
     * (experimental) Creates a user who can be used in WorkMail by calling the RegisterToWorkMail operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateUser.html
     *
     * @experimental
     */
    toCreateUser(): this;
    /**
     * (experimental) Deletes an access control rule for the specified WorkMail organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteAccessControlRule.html
     *
     * @experimental
     */
    toDeleteAccessControlRule(): this;
    /**
     * (experimental) Remove one or more specified aliases from a set of aliases for a given user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteAlias.html
     *
     * @experimental
     */
    toDeleteAlias(): this;
    /**
     * (experimental) Deletes a group from WorkMail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteGroup.html
     *
     * @experimental
     */
    toDeleteGroup(): this;
    /**
     * (experimental) Remove an inbound email flow rule to no longer apply to emails sent to an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove-email-flow-rule.html
     *
     * @experimental
     */
    toDeleteInboundMailFlowRule(): this;
    /**
     * (experimental) Removes an unused mail domain from an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove_domain.html
     *
     * @experimental
     */
    toDeleteMailDomain(): this;
    /**
     * (experimental) Deletes permissions granted to a member (user or group).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteMailboxPermissions.html
     *
     * @experimental
     */
    toDeleteMailboxPermissions(): this;
    /**
     * (experimental) Removes a mobile device from a user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html#remove_mobile_device
     *
     * @experimental
     */
    toDeleteMobileDevice(): this;
    /**
     * (experimental) Deletes an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of the organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteOrganization.html
     *
     * @experimental
     */
    toDeleteOrganization(): this;
    /**
     * (experimental) Remove an outbound email flow rule to no longer apply to emails sent from an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove-email-flow-rule.html
     *
     * @experimental
     */
    toDeleteOutboundMailFlowRule(): this;
    /**
     * (experimental) Deletes the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteResource.html
     *
     * @experimental
     */
    toDeleteResource(): this;
    /**
     * (experimental) Deletes the retention policy based on the supplied organization and policy identifiers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteRetentionPolicy.html
     *
     * @experimental
     */
    toDeleteRetentionPolicy(): this;
    /**
     * (experimental) Remove an SMTP device from an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     *
     * @experimental
     */
    toDeleteSmtpGateway(): this;
    /**
     * (experimental) Deletes a user from WorkMail and all subsequent systems. The action cannot be undone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteUser.html
     *
     * @experimental
     */
    toDeleteUser(): this;
    /**
     * (experimental) Mark a user, group, or resource as no longer used in WorkMail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeregisterFromWorkMail.html
     *
     * @experimental
     */
    toDeregisterFromWorkMail(): this;
    /**
     * (experimental) Shows a list of directories available for use in creating an organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html
     *
     * @experimental
     */
    toDescribeDirectories(): this;
    /**
     * (experimental) Returns the data available for the group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeGroup.html
     *
     * @experimental
     */
    toDescribeGroup(): this;
    /**
     * (experimental) Returns the details of an inbound mail flow rule configured for an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-actions
     *
     * @experimental
     */
    toDescribeInboundMailFlowRule(): this;
    /**
     * (experimental) Shows a list of KMS Keys available for use in creating an organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html
     *
     * @experimental
     */
    toDescribeKmsKeys(): this;
    /**
     * (experimental) Shows the details of all mail domains associated with the organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/domains_overview.html
     *
     * @experimental
     */
    toDescribeMailDomains(): this;
    /**
     * (experimental) Shows the details of all groups associated with the organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toDescribeMailGroups(): this;
    /**
     * (experimental) Shows the details of all users associated with the orgaization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     *
     * @experimental
     */
    toDescribeMailUsers(): this;
    /**
     * (experimental) Retrieve details of a mailbox export job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeMailboxExportJob.html
     *
     * @experimental
     */
    toDescribeMailboxExportJob(): this;
    /**
     * (experimental) Provides more information regarding a given organization based on its identifier.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeOrganization.html
     *
     * @experimental
     */
    toDescribeOrganization(): this;
    /**
     * (experimental) Shows a summary of all organizations associated with the account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html
     *
     * @experimental
     */
    toDescribeOrganizations(): this;
    /**
     * (experimental) Returns the details of an outbound mail flow rule configured for an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-outbound
     *
     * @experimental
     */
    toDescribeOutboundMailFlowRule(): this;
    /**
     * (experimental) Returns the data available for the resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeResource.html
     *
     * @experimental
     */
    toDescribeResource(): this;
    /**
     * (experimental) Returns the details of an SMTP device registered against an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     *
     * @experimental
     */
    toDescribeSmtpGateway(): this;
    /**
     * (experimental) Provides information regarding the user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeUser.html
     *
     * @experimental
     */
    toDescribeUser(): this;
    /**
     * (experimental) Disable a mail group when it is not being used and, to allow it to be deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove_group.html
     *
     * @experimental
     */
    toDisableMailGroups(): this;
    /**
     * (experimental) Disable a user mailbox when it is no longer being used, and to allow it to be deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-mailboxes.html#delete_user_mailbox
     *
     * @experimental
     */
    toDisableMailUsers(): this;
    /**
     * (experimental) Removes a member from the resource's set of delegates.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DisassociateDelegateFromResource.html
     *
     * @experimental
     */
    toDisassociateDelegateFromResource(): this;
    /**
     * (experimental) Removes a member from a group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DisassociateMemberFromGroup.html
     *
     * @experimental
     */
    toDisassociateMemberFromGroup(): this;
    /**
     * (experimental) Enable a mail domain in the organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html
     *
     * @experimental
     */
    toEnableMailDomain(): this;
    /**
     * (experimental) Enable a mail group after it has been created to allow it to receive mail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/enable_existing_group.html
     *
     * @experimental
     */
    toEnableMailGroups(): this;
    /**
     * (experimental) Enable a user's mailbox after it has been created to allow it to receive mail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html#enable_existing_user
     *
     * @experimental
     */
    toEnableMailUsers(): this;
    /**
     * (experimental) Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access protocol action, or user ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetAccessControlEffect.html
     *
     * @experimental
     */
    toGetAccessControlEffect(): this;
    /**
     * (experimental) Retrieves the retention policy associated at an organizational level.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetDefaultRetentionPolicy.html
     *
     * @experimental
     */
    toGetDefaultRetentionPolicy(): this;
    /**
     * (experimental) Returns journaling and fallback email addresses configured for email journaling.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/journaling_overview.html
     *
     * @experimental
     */
    toGetJournalingRules(): this;
    /**
     * (experimental) Get the details of the mail domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/domains_overview.html
     *
     * @experimental
     */
    toGetMailDomainDetails(): this;
    /**
     * (experimental) Get the details of the mail group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toGetMailGroupDetails(): this;
    /**
     * (experimental) Get the details of the user's mailbox and account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     *
     * @experimental
     */
    toGetMailUserDetails(): this;
    /**
     * (experimental) Returns the details of the user's mailbox.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMailboxDetails.html
     *
     * @experimental
     */
    toGetMailboxDetails(): this;
    /**
     * (experimental) Get the details of the mobile device.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html
     *
     * @experimental
     */
    toGetMobileDeviceDetails(): this;
    /**
     * (experimental) Get a list of the mobile devices associated with the user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html
     *
     * @experimental
     */
    toGetMobileDevicesForUser(): this;
    /**
     * (experimental) Get the details of the mobile device policy associated with the organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/edit_organization_mobile_policy.html
     *
     * @experimental
     */
    toGetMobilePolicyDetails(): this;
    /**
     * (experimental) Lists the access control rules for the specified organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListAccessControlRules.html
     *
     * @experimental
     */
    toListAccessControlRules(): this;
    /**
     * (experimental) Creates a paginated call to list the aliases associated with a given entity.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListAliases.html
     *
     * @experimental
     */
    toListAliases(): this;
    /**
     * (experimental) Returns an overview of the members of a group. Users and groups can be members of a group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListGroupMembers.html
     *
     * @experimental
     */
    toListGroupMembers(): this;
    /**
     * (experimental) Returns summaries of the organization's groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListGroups.html
     *
     * @experimental
     */
    toListGroups(): this;
    /**
     * (experimental) Returns a list of inbound mail flow rules configured for an organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-actions
     *
     * @experimental
     */
    toListInboundMailFlowRules(): this;
    /**
     * (experimental) List mailbox export jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMailboxExportJobs.html
     *
     * @experimental
     */
    toListMailboxExportJobs(): this;
    /**
     * (experimental) Lists the mailbox permissions associated with a user, group, or resource mailbox.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMailboxPermissions.html
     *
     * @experimental
     */
    toListMailboxPermissions(): this;
    /**
     * (experimental) Get a list of all the members in a mail group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toListMembersInMailGroup(): this;
    /**
     * (experimental) Returns summaries of the customer's non-deleted organizations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html
     *
     * @experimental
     */
    toListOrganizations(): this;
    /**
     * (experimental) Returns a list of outbound mail flow rules configured for an organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-outbound
     *
     * @experimental
     */
    toListOutboundMailFlowRules(): this;
    /**
     * (experimental) Lists the delegates associated with a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListResourceDelegates.html
     *
     * @experimental
     */
    toListResourceDelegates(): this;
    /**
     * (experimental) Returns summaries of the organization's resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListResources.html
     *
     * @experimental
     */
    toListResources(): this;
    /**
     * (experimental) Returns a list of SMTP devices registered against the organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     *
     * @experimental
     */
    toListSmtpGateways(): this;
    /**
     * (experimental) Grants permission to list the tags applied to an Amazon WorkMail organization resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Returns summaries of the organization's users.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListUsers.html
     *
     * @experimental
     */
    toListUsers(): this;
    /**
     * (experimental) Adds a new access control rule for the specified organization.
     *
     * The rule allows or denies access to the organization for the specified IPv4 addresses, access protocol actions, and user IDs. Adding a new rule with the same name as an existing rule replaces the older rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutAccessControlRule.html
     *
     * @experimental
     */
    toPutAccessControlRule(): this;
    /**
     * (experimental) Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutMailboxPermissions.html
     *
     * @experimental
     */
    toPutMailboxPermissions(): this;
    /**
     * (experimental) Adds or updates the retention policy for the specified organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutRetentionPolicy.html
     *
     * @experimental
     */
    toPutRetentionPolicy(): this;
    /**
     * (experimental) Registers an existing and disabled user, group, or resource for use by associating a mailbox and calendaring capabilities.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_RegisterToWorkMail.html
     *
     * @experimental
     */
    toRegisterToWorkMail(): this;
    /**
     * (experimental) Remove members from a mail group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toRemoveMembersFromGroup(): this;
    /**
     * (experimental) Allows the administrator to reset the password for a user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ResetPassword.html
     *
     * @experimental
     */
    toResetPassword(): this;
    /**
     * (experimental) Reset the password for a user's account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html#reset_user_password
     *
     * @experimental
     */
    toResetUserPassword(): this;
    /**
     * (experimental) Prefix search to find a specific user in a mail group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toSearchMembers(): this;
    /**
     * (experimental) Mark a user as being an administrator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     *
     * @experimental
     */
    toSetAdmin(): this;
    /**
     * (experimental) Set the default mail domain for the organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html
     *
     * @experimental
     */
    toSetDefaultMailDomain(): this;
    /**
     * (experimental) Set journaling and fallback email addresses for email journaling.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/journaling_overview.html
     *
     * @experimental
     */
    toSetJournalingRules(): this;
    /**
     * (experimental) Set the details of the mail group which has just been created.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_group.html
     *
     * @experimental
     */
    toSetMailGroupDetails(): this;
    /**
     * (experimental) Set the details for the user account which has just been created.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html
     *
     * @experimental
     */
    toSetMailUserDetails(): this;
    /**
     * (experimental) Set the details of a mobile policy associated with the organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/edit_organization_mobile_policy.html
     *
     * @experimental
     */
    toSetMobilePolicyDetails(): this;
    /**
     * (experimental) Start a new mailbox export job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_StartMailboxExportJob.html
     *
     * @experimental
     */
    toStartMailboxExportJob(): this;
    /**
     * (experimental) Grants permission to tag the specified Amazon WorkMail organization resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Test what inbound rules will apply to an email with a given sender and recipient.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/test-email-flow-rule.html
     *
     * @experimental
     */
    toTestInboundMailFlowRules(): this;
    /**
     * (experimental) Test what outbound rules will apply to an email with a given sender and recipient.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/test-email-flow-rule.html
     *
     * @experimental
     */
    toTestOutboundMailFlowRules(): this;
    /**
     * (experimental) Grants permission to untag the specified Amazon WorkMail organization resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Update the details of an inbound email flow rule which will apply to all email sent to an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/modify-email-flow-rule.html
     *
     * @experimental
     */
    toUpdateInboundMailFlowRule(): this;
    /**
     * (experimental) Updates the maximum size (in MB) of the user's mailbox.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateMailboxQuota.html
     *
     * @experimental
     */
    toUpdateMailboxQuota(): this;
    /**
     * (experimental) Update the details of an outbound email flow rule which will apply to all email sent from an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/modify-email-flow-rule.html
     *
     * @experimental
     */
    toUpdateOutboundMailFlowRule(): this;
    /**
     * (experimental) Updates the primary email for a user, group, or resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdatePrimaryEmailAddress.html
     *
     * @experimental
     */
    toUpdatePrimaryEmailAddress(): this;
    /**
     * (experimental) Updates data for the resource. To retrieve the latest information, it must be preceded by a DescribeResource call.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateResource.html
     *
     * @experimental
     */
    toUpdateResource(): this;
    /**
     * (experimental) Update the details of an existing SMTP device registered against an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     *
     * @experimental
     */
    toUpdateSmtpGateway(): this;
    /**
     * (experimental) Remotely wipe the mobile device associated with a user's account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html#remote_wipe_device
     *
     * @experimental
     */
    toWipeMobileDevice(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type organization to the statement.
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onOrganization(resourceId: string, account?: string, region?: string, partition?: string): this;
}
