"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithEffect = exports.Effect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _4_resources_1 = require("./4-resources");
/**
 * (experimental) Policy effects.
 *
 * @experimental
 */
var Effect;
(function (Effect) {
    Effect["ALLOW"] = "Allow";
    Effect["DENY"] = "Deny";
})(Effect = exports.Effect || (exports.Effect = {}));
/**
 * (experimental) Adds "effect" functionality to the Policy Statement.
 *
 * @experimental
 */
class PolicyStatementWithEffect extends _4_resources_1.PolicyStatementWithResources {
    constructor() {
        super(...arguments);
        /**
         * @experimental
         */
        this.effect = Effect.ALLOW;
    }
    /**
     * (experimental) Injects effect into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     *
     * @experimental
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            return super.toJSON();
        }
        const statement = super.toJSON();
        statement.Effect = this.effect;
        return statement;
    }
    /**
     * (experimental) Allow the actions in this statement.
     *
     * @experimental
     */
    allow() {
        this.effect = Effect.ALLOW;
        return this;
    }
    /**
     * (experimental) Deny the actions in this statement.
     *
     * @experimental
     */
    deny() {
        this.effect = Effect.DENY;
        return this;
    }
}
exports.PolicyStatementWithEffect = PolicyStatementWithEffect;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementWithEffect[_a] = { fqn: "iam-floyd.PolicyStatementWithEffect", version: "0.160.0" };
//# sourceMappingURL=data:application/json;base64,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