/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.icao.CscaMasterList;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;
import org.bouncycastle.util.test.SimpleTest;

public class CscaMasterListTest
extends SimpleTest {
    @Override
    public String getName() {
        return "CscaMasterList";
    }

    @Override
    public void performTest() throws Exception {
        byte[] output;
        byte[] input = this.getInput("masterlist-content.data");
        CscaMasterList parsedList = CscaMasterList.getInstance(ASN1Primitive.fromByteArray(input));
        if (parsedList.getCertStructs().length != 3) {
            this.fail("Cert structure parsing failed: incorrect length");
        }
        if (!Arrays.areEqual(input, output = parsedList.getEncoded())) {
            this.fail("Encoding failed after parse");
        }
    }

    private byte[] getInput(String name) throws IOException {
        return Streams.readAll(this.getClass().getResourceAsStream(name));
    }

    public static void main(String[] args) {
        CscaMasterListTest.runTest(new CscaMasterListTest());
    }
}

