/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.util.Date;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmc.PendInfo;
import org.bouncycastle.util.test.SimpleTest;

public class PendInfoTest
extends SimpleTest {
    public static void main(String[] args) {
        PendInfoTest.runTest(new PendInfoTest());
    }

    @Override
    public String getName() {
        return "PendInfoTest";
    }

    @Override
    public void performTest() throws Exception {
        PendInfo info = new PendInfo("".getBytes(), new ASN1GeneralizedTime(new Date()));
        byte[] b = info.getEncoded();
        PendInfo infoResult = PendInfo.getInstance(b);
        this.isTrue("pendToken", this.areEqual(info.getPendToken(), infoResult.getPendToken()));
        this.isEquals("pendTime", info.getPendTime(), infoResult.getPendTime());
        try {
            PendInfo.getInstance(new DERSequence());
            this.fail("Sequence length not 2");
        }
        catch (Throwable t) {
            this.isEquals("Exception type", t.getClass(), IllegalArgumentException.class);
        }
    }
}

