/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.macs.SipHash;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.RNGUtils;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SipHashTest
extends SimpleTest {
    private static final int UPDATE_BYTES = 0;
    private static final int UPDATE_FULL = 1;
    private static final int UPDATE_MIX = 2;

    @Override
    public String getName() {
        return "SipHash";
    }

    @Override
    public void performTest() throws Exception {
        byte[] key = Hex.decode("000102030405060708090a0b0c0d0e0f");
        byte[] input = Hex.decode("000102030405060708090a0b0c0d0e");
        this.runMAC(key, input, 0);
        this.runMAC(key, input, 1);
        this.runMAC(key, input, 2);
        SecureRandom random = new SecureRandom();
        int i = 0;
        while (i < 100) {
            this.randomTest(random);
            ++i;
        }
    }

    private void runMAC(byte[] key, byte[] input, int updateType) throws Exception {
        long expected = -6833708440360172059L;
        SipHash mac = new SipHash();
        mac.init(new KeyParameter(key));
        this.updateMAC(mac, input, updateType);
        long result = mac.doFinal();
        if (expected != result) {
            this.fail("Result does not match expected value for doFinal()");
        }
        byte[] expectedBytes = new byte[8];
        Pack.longToLittleEndian(expected, expectedBytes, 0);
        this.updateMAC(mac, input, updateType);
        byte[] output = new byte[mac.getMacSize()];
        int len = mac.doFinal(output, 0);
        if (len != output.length) {
            this.fail("Result length does not equal getMacSize() for doFinal(byte[],int)");
        }
        if (!this.areEqual(expectedBytes, output)) {
            this.fail("Result does not match expected value for doFinal(byte[],int)");
        }
    }

    private void randomTest(SecureRandom random) {
        byte[] key = new byte[16];
        random.nextBytes(key);
        int length = 1 + RNGUtils.nextInt(random, 1024);
        byte[] input = new byte[length];
        random.nextBytes(input);
        SipHash mac = new SipHash();
        mac.init(new KeyParameter(key));
        this.updateMAC(mac, input, 0);
        long result1 = mac.doFinal();
        this.updateMAC(mac, input, 1);
        long result2 = mac.doFinal();
        this.updateMAC(mac, input, 2);
        long result3 = mac.doFinal();
        if (result1 != result2 || result1 != result3) {
            this.fail("Inconsistent results in random test");
        }
    }

    private void updateMAC(SipHash mac, byte[] input, int updateType) {
        switch (updateType) {
            case 0: {
                int i = 0;
                while (i < input.length) {
                    mac.update(input[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                mac.update(input, 0, input.length);
                break;
            }
            case 2: {
                int step = Math.max(1, input.length / 3);
                int pos = 0;
                while (pos < input.length) {
                    mac.update(input[pos++]);
                    int len = Math.min(input.length - pos, step);
                    mac.update(input, pos, len);
                    pos += len;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public static void main(String[] args) {
        SipHashTest.runTest(new SipHashTest());
    }
}

