/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.symmetric;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.cms.CCMParameters;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.asn1.nsri.NSRIObjectIdentifiers;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.engines.ARIAEngine;
import org.bouncycastle.crypto.engines.ARIAWrapEngine;
import org.bouncycastle.crypto.engines.ARIAWrapPadEngine;
import org.bouncycastle.crypto.engines.RFC3211WrapEngine;
import org.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import org.bouncycastle.crypto.macs.GMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.symmetric.GcmSpecUtil;
import org.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import org.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;

public final class ARIA {
    private ARIA() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for ARIA parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = this.createParametersInstance("ARIA");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "ARIA IV";
        }
    }

    public static class AlgParamsCCM
    extends BaseAlgorithmParameters {
        private CCMParameters ccmParams;

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (GcmSpecUtil.isGcmSpec(paramSpec)) {
                this.ccmParams = CCMParameters.getInstance(GcmSpecUtil.extractGcmParameters(paramSpec));
            } else if (paramSpec instanceof AEADParameterSpec) {
                this.ccmParams = new CCMParameters(((AEADParameterSpec)paramSpec).getNonce(), ((AEADParameterSpec)paramSpec).getMacSizeInBits() / 8);
            } else {
                throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + paramSpec.getClass().getName());
            }
        }

        @Override
        protected void engineInit(byte[] params) throws IOException {
            this.ccmParams = CCMParameters.getInstance(params);
        }

        @Override
        protected void engineInit(byte[] params, String format) throws IOException {
            if (!this.isASN1FormatString(format)) {
                throw new IOException("unknown format specified");
            }
            this.ccmParams = CCMParameters.getInstance(params);
        }

        @Override
        protected byte[] engineGetEncoded() throws IOException {
            return this.ccmParams.getEncoded();
        }

        @Override
        protected byte[] engineGetEncoded(String format) throws IOException {
            if (!this.isASN1FormatString(format)) {
                throw new IOException("unknown format specified");
            }
            return this.ccmParams.getEncoded();
        }

        @Override
        protected String engineToString() {
            return "CCM";
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == AlgorithmParameterSpec.class || GcmSpecUtil.isGcmSpec(paramSpec)) {
                if (GcmSpecUtil.gcmSpecExists()) {
                    return GcmSpecUtil.extractGcmSpec(this.ccmParams.toASN1Primitive());
                }
                return new AEADParameterSpec(this.ccmParams.getNonce(), this.ccmParams.getIcvLen() * 8);
            }
            if (paramSpec == AEADParameterSpec.class) {
                return new AEADParameterSpec(this.ccmParams.getNonce(), this.ccmParams.getIcvLen() * 8);
            }
            if (paramSpec == IvParameterSpec.class) {
                return new IvParameterSpec(this.ccmParams.getNonce());
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
        }
    }

    public static class AlgParamsGCM
    extends BaseAlgorithmParameters {
        private GCMParameters gcmParams;

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (GcmSpecUtil.isGcmSpec(paramSpec)) {
                this.gcmParams = GcmSpecUtil.extractGcmParameters(paramSpec);
            } else if (paramSpec instanceof AEADParameterSpec) {
                this.gcmParams = new GCMParameters(((AEADParameterSpec)paramSpec).getNonce(), ((AEADParameterSpec)paramSpec).getMacSizeInBits() / 8);
            } else {
                throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + paramSpec.getClass().getName());
            }
        }

        @Override
        protected void engineInit(byte[] params) throws IOException {
            this.gcmParams = GCMParameters.getInstance(params);
        }

        @Override
        protected void engineInit(byte[] params, String format) throws IOException {
            if (!this.isASN1FormatString(format)) {
                throw new IOException("unknown format specified");
            }
            this.gcmParams = GCMParameters.getInstance(params);
        }

        @Override
        protected byte[] engineGetEncoded() throws IOException {
            return this.gcmParams.getEncoded();
        }

        @Override
        protected byte[] engineGetEncoded(String format) throws IOException {
            if (!this.isASN1FormatString(format)) {
                throw new IOException("unknown format specified");
            }
            return this.gcmParams.getEncoded();
        }

        @Override
        protected String engineToString() {
            return "GCM";
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == AlgorithmParameterSpec.class || GcmSpecUtil.isGcmSpec(paramSpec)) {
                if (GcmSpecUtil.gcmSpecExists()) {
                    return GcmSpecUtil.extractGcmSpec(this.gcmParams.toASN1Primitive());
                }
                return new AEADParameterSpec(this.gcmParams.getNonce(), this.gcmParams.getIcvLen() * 8);
            }
            if (paramSpec == AEADParameterSpec.class) {
                return new AEADParameterSpec(this.gcmParams.getNonce(), this.gcmParams.getIcvLen() * 8);
            }
            if (paramSpec == IvParameterSpec.class) {
                return new IvParameterSpec(this.gcmParams.getNonce());
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new ARIAEngine()), 128);
        }
    }

    public static class CFB
    extends BaseBlockCipher {
        public CFB() {
            super(new BufferedBlockCipher(new CFBBlockCipher(new ARIAEngine(), 128)), 128);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new ARIAEngine();
                }
            });
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new ARIAEngine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            this(256);
        }

        public KeyGen(int keySize) {
            super("ARIA", keySize, new CipherKeyGenerator());
        }
    }

    public static class KeyGen128
    extends KeyGen {
        public KeyGen128() {
            super(128);
        }
    }

    public static class KeyGen192
    extends KeyGen {
        public KeyGen192() {
            super(192);
        }
    }

    public static class KeyGen256
    extends KeyGen {
        public KeyGen256() {
            super(256);
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = ARIA.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.ARIA", String.valueOf(PREFIX) + "$AlgParams");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters", NSRIObjectIdentifiers.id_aria128_cbc, "ARIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters", NSRIObjectIdentifiers.id_aria192_cbc, "ARIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters", NSRIObjectIdentifiers.id_aria256_cbc, "ARIA");
            provider.addAlgorithm("AlgorithmParameterGenerator.ARIA", String.valueOf(PREFIX) + "$AlgParamGen");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator", NSRIObjectIdentifiers.id_aria128_cbc, "ARIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator", NSRIObjectIdentifiers.id_aria192_cbc, "ARIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator", NSRIObjectIdentifiers.id_aria256_cbc, "ARIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator", NSRIObjectIdentifiers.id_aria128_ofb, "ARIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator", NSRIObjectIdentifiers.id_aria192_ofb, "ARIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator", NSRIObjectIdentifiers.id_aria256_ofb, "ARIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator", NSRIObjectIdentifiers.id_aria128_cfb, "ARIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator", NSRIObjectIdentifiers.id_aria192_cfb, "ARIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator", NSRIObjectIdentifiers.id_aria256_cfb, "ARIA");
            provider.addAlgorithm("Cipher.ARIA", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria128_ecb, String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria192_ecb, String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria256_ecb, String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria128_cbc, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria192_cbc, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria256_cbc, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria128_cfb, String.valueOf(PREFIX) + "$CFB");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria192_cfb, String.valueOf(PREFIX) + "$CFB");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria256_cfb, String.valueOf(PREFIX) + "$CFB");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria128_ofb, String.valueOf(PREFIX) + "$OFB");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria192_ofb, String.valueOf(PREFIX) + "$OFB");
            provider.addAlgorithm("Cipher", NSRIObjectIdentifiers.id_aria256_ofb, String.valueOf(PREFIX) + "$OFB");
            provider.addAlgorithm("Cipher.ARIARFC3211WRAP", String.valueOf(PREFIX) + "$RFC3211Wrap");
            provider.addAlgorithm("Cipher.ARIAWRAP", String.valueOf(PREFIX) + "$Wrap");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria128_kw, "ARIAWRAP");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria192_kw, "ARIAWRAP");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria256_kw, "ARIAWRAP");
            provider.addAlgorithm("Alg.Alias.Cipher.ARIAKW", "ARIAWRAP");
            provider.addAlgorithm("Cipher.ARIAWRAPPAD", String.valueOf(PREFIX) + "$WrapPad");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria128_kwp, "ARIAWRAPPAD");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria192_kwp, "ARIAWRAPPAD");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria256_kwp, "ARIAWRAPPAD");
            provider.addAlgorithm("Alg.Alias.Cipher.ARIAKWP", "ARIAWRAPPAD");
            provider.addAlgorithm("KeyGenerator.ARIA", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria128_kw, String.valueOf(PREFIX) + "$KeyGen128");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria192_kw, String.valueOf(PREFIX) + "$KeyGen192");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria256_kw, String.valueOf(PREFIX) + "$KeyGen256");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria128_kwp, String.valueOf(PREFIX) + "$KeyGen128");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria192_kwp, String.valueOf(PREFIX) + "$KeyGen192");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria256_kwp, String.valueOf(PREFIX) + "$KeyGen256");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria128_ecb, String.valueOf(PREFIX) + "$KeyGen128");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria192_ecb, String.valueOf(PREFIX) + "$KeyGen192");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria256_ecb, String.valueOf(PREFIX) + "$KeyGen256");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria128_cbc, String.valueOf(PREFIX) + "$KeyGen128");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria192_cbc, String.valueOf(PREFIX) + "$KeyGen192");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria256_cbc, String.valueOf(PREFIX) + "$KeyGen256");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria128_cfb, String.valueOf(PREFIX) + "$KeyGen128");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria192_cfb, String.valueOf(PREFIX) + "$KeyGen192");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria256_cfb, String.valueOf(PREFIX) + "$KeyGen256");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria128_ofb, String.valueOf(PREFIX) + "$KeyGen128");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria192_ofb, String.valueOf(PREFIX) + "$KeyGen192");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria256_ofb, String.valueOf(PREFIX) + "$KeyGen256");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria128_ccm, String.valueOf(PREFIX) + "$KeyGen128");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria192_ccm, String.valueOf(PREFIX) + "$KeyGen192");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria256_ccm, String.valueOf(PREFIX) + "$KeyGen256");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria128_gcm, String.valueOf(PREFIX) + "$KeyGen128");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria192_gcm, String.valueOf(PREFIX) + "$KeyGen192");
            provider.addAlgorithm("KeyGenerator", NSRIObjectIdentifiers.id_aria256_gcm, String.valueOf(PREFIX) + "$KeyGen256");
            provider.addAlgorithm("AlgorithmParameterGenerator.ARIACCM", String.valueOf(PREFIX) + "$AlgParamGenCCM");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + NSRIObjectIdentifiers.id_aria128_ccm, "CCM");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + NSRIObjectIdentifiers.id_aria192_ccm, "CCM");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + NSRIObjectIdentifiers.id_aria256_ccm, "CCM");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria128_ccm, "CCM");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria192_ccm, "CCM");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria256_ccm, "CCM");
            provider.addAlgorithm("AlgorithmParameterGenerator.ARIAGCM", String.valueOf(PREFIX) + "$AlgParamGenGCM");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + NSRIObjectIdentifiers.id_aria128_gcm, "GCM");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + NSRIObjectIdentifiers.id_aria192_gcm, "GCM");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + NSRIObjectIdentifiers.id_aria256_gcm, "GCM");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria128_gcm, "GCM");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria192_gcm, "GCM");
            provider.addAlgorithm("Alg.Alias.Cipher", NSRIObjectIdentifiers.id_aria256_gcm, "GCM");
            this.addGMacAlgorithm(provider, "ARIA", String.valueOf(PREFIX) + "$GMAC", String.valueOf(PREFIX) + "$KeyGen");
            this.addPoly1305Algorithm(provider, "ARIA", String.valueOf(PREFIX) + "$Poly1305", String.valueOf(PREFIX) + "$Poly1305KeyGen");
        }
    }

    public static class OFB
    extends BaseBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new OFBBlockCipher(new ARIAEngine(), 128)), 128);
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new org.bouncycastle.crypto.macs.Poly1305(new ARIAEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-ARIA", 256, new Poly1305KeyGenerator());
        }
    }

    public static class RFC3211Wrap
    extends BaseWrapCipher {
        public RFC3211Wrap() {
            super(new RFC3211WrapEngine(new ARIAEngine()), 16);
        }
    }

    public static class Wrap
    extends BaseWrapCipher {
        public Wrap() {
            super(new ARIAWrapEngine());
        }
    }

    public static class WrapPad
    extends BaseWrapCipher {
        public WrapPad() {
            super(new ARIAWrapPadEngine());
        }
    }
}

