/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.params.KDFParameters;

public class BrokenKDF2BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    public BrokenKDF2BytesGenerator(Digest digest) {
        this.digest = digest;
    }

    @Override
    public void init(DerivationParameters param) {
        if (!(param instanceof KDFParameters)) {
            throw new IllegalArgumentException("KDF parameters required for generator");
        }
        KDFParameters p = (KDFParameters)param;
        this.shared = p.getSharedSecret();
        this.iv = p.getIV();
    }

    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (out.length - len < outOff) {
            throw new OutputLengthException("output buffer too small");
        }
        long oBits = (long)len * 8L;
        if (oBits > (long)this.digest.getDigestSize() * 8L * 0x80000000L) {
            new IllegalArgumentException("Output length to large");
        }
        int cThreshold = (int)(oBits / (long)this.digest.getDigestSize());
        byte[] dig = null;
        dig = new byte[this.digest.getDigestSize()];
        int counter = 1;
        while (counter <= cThreshold) {
            this.digest.update(this.shared, 0, this.shared.length);
            this.digest.update((byte)(counter & 0xFF));
            this.digest.update((byte)(counter >> 8 & 0xFF));
            this.digest.update((byte)(counter >> 16 & 0xFF));
            this.digest.update((byte)(counter >> 24 & 0xFF));
            this.digest.update(this.iv, 0, this.iv.length);
            this.digest.doFinal(dig, 0);
            if (len - outOff > dig.length) {
                System.arraycopy(dig, 0, out, outOff, dig.length);
                outOff += dig.length;
            } else {
                System.arraycopy(dig, 0, out, outOff, len - outOff);
            }
            ++counter;
        }
        this.digest.reset();
        return len;
    }
}

