/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ECIESTest
extends SimpleTest {
    ECIESTest() {
    }

    @Override
    public String getName() {
        return "ECIES";
    }

    @Override
    public void performTest() throws Exception {
        KeyPairGenerator g;
        byte[] encoding;
        byte[] derivation;
        block11: {
            IESParameterSpec params;
            IESCipher c2;
            IESCipher c1;
            block10: {
                derivation = Hex.decode("202122232425262728292a2b2c2d2e2f");
                encoding = Hex.decode("303132333435363738393a3b3c3d3e3f");
                c1 = new IESCipher.ECIES();
                c2 = new IESCipher.ECIES();
                params = new IESParameterSpec(derivation, encoding, 128);
                g = KeyPairGenerator.getInstance("EC", "BC");
                this.doTest("ECIES with default", g, "ECIES", params);
                g.initialize(192, new SecureRandom());
                this.doTest("ECIES with 192-bit", g, "ECIES", params);
                g.initialize(256, new SecureRandom());
                this.doTest("ECIES with 256-bit", g, "ECIES", params);
                c1 = new IESCipher(new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), new PaddedBufferedBlockCipher(new DESEngine())));
                c2 = new IESCipher(new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), new PaddedBufferedBlockCipher(new DESEngine())));
                params = new IESParameterSpec(derivation, encoding, 128, 128, Hex.decode("0001020304050607"));
                g = KeyPairGenerator.getInstance("EC", "BC");
                g.initialize(256, new SecureRandom());
                this.doTest("256-bit", g, "ECIESwithDESEDE-CBC", params);
                params = new IESParameterSpec(derivation, encoding, 128, 128, Hex.decode("0001020304050607"));
                g.initialize(256, new SecureRandom());
                this.doTest("256-bit", g, "ECIESwithDESEDE-CBC", params);
                try {
                    params = new IESParameterSpec(derivation, encoding, 128, 128, new byte[10]);
                    g.initialize(256, new SecureRandom());
                    this.doTest("256-bit", g, "ECIESwithDESEDE-CBC", params);
                    this.fail("DESEDE no exception!");
                }
                catch (InvalidAlgorithmParameterException e) {
                    if (e.getMessage().equals("NONCE in IES Parameters needs to be 8 bytes long")) break block10;
                    this.fail("DESEDE wrong message!");
                }
            }
            c1 = new IESCipher.ECIESwithAESCBC();
            c2 = new IESCipher.ECIESwithAESCBC();
            params = new IESParameterSpec(derivation, encoding, 128, 128, Hex.decode("000102030405060708090a0b0c0d0e0f"));
            g.initialize(256, new SecureRandom());
            this.doTest("256-bit", g, "ECIESwithAES-CBC", params);
            params = new IESParameterSpec(derivation, encoding, 128, 128, Hex.decode("000102030405060708090a0b0c0d0e0f"));
            g.initialize(256, new SecureRandom());
            this.doTest("256-bit", g, "ECIESwithAES-CBC", params);
            try {
                params = new IESParameterSpec(derivation, encoding, 128, 128, new byte[10]);
                g.initialize(256, new SecureRandom());
                this.doTest("256-bit", g, "ECIESwithAES-CBC", params);
                this.fail("AES no exception!");
            }
            catch (InvalidAlgorithmParameterException e) {
                if (e.getMessage().equals("NONCE in IES Parameters needs to be 16 bytes long")) break block11;
                this.fail("AES wrong message!");
            }
        }
        KeyPair keyPair = g.generateKeyPair();
        ECPublicKey pub = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey priv = (ECPrivateKey)keyPair.getPrivate();
        Cipher c = Cipher.getInstance("ECIESwithAES-CBC", "BC");
        try {
            c.init(1, (Key)pub, new IESParameterSpec(derivation, encoding, 128, 128, null));
            this.fail("no exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            this.isTrue("message ", "NONCE in IES Parameters needs to be 16 bytes long".equals(e.getMessage()));
        }
        try {
            c.init(2, priv);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isTrue("message ", "cannot handle supplied parameter spec: NONCE in IES Parameters needs to be 16 bytes long".equals(e.getMessage()));
        }
        try {
            c.init(2, (Key)priv, new IESParameterSpec(derivation, encoding, 128, 128, null));
            this.fail("no exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            this.isTrue("message ", "NONCE in IES Parameters needs to be 16 bytes long".equals(e.getMessage()));
        }
        this.sealedObjectTest();
    }

    private void sealedObjectTest() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("ECIES");
        kpg.initialize(new ECGenParameterSpec("secp256r1"));
        KeyPair keyPair = kpg.generateKeyPair();
        Cipher cipher = Cipher.getInstance("ECIES");
        cipher.init(1, keyPair.getPublic());
        String toEncrypt = "Hello";
        cipher.doFinal(toEncrypt.getBytes());
        SealedObject sealedObject = new SealedObject((Serializable)((Object)toEncrypt), cipher);
        cipher.init(2, keyPair.getPrivate());
        String result = (String)sealedObject.getObject(cipher);
        this.isTrue("result wrong", result.equals(toEncrypt));
        result = (String)sealedObject.getObject(keyPair.getPrivate());
        this.isTrue("result wrong", result.equals(toEncrypt));
    }

    public void doTest(String testname, KeyPairGenerator g, String cipher, IESParameterSpec p) throws Exception {
        byte[] message = Hex.decode("0102030405060708090a0b0c0d0e0f10111213141516");
        KeyPair KeyPair2 = g.generateKeyPair();
        ECPublicKey Pub = (ECPublicKey)KeyPair2.getPublic();
        ECPrivateKey Priv = (ECPrivateKey)KeyPair2.getPrivate();
        Cipher c1 = Cipher.getInstance(cipher);
        Cipher c2 = Cipher.getInstance(cipher);
        c1.init(1, (Key)Pub, new SecureRandom());
        c2.init(2, (Key)Priv, c1.getParameters());
        this.isTrue("nonce mismatch", Arrays.areEqual(c1.getIV(), c2.getIV()));
        byte[] out1 = c1.doFinal(message, 0, message.length);
        byte[] out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(String.valueOf(testname) + " test failed with null parameters, DHAES mode false.");
        }
        c1.init(1, (Key)Pub, p, new SecureRandom());
        c2.init(2, (Key)Priv, p);
        out1 = c1.doFinal(message, 0, message.length);
        out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(String.valueOf(testname) + " test failed with non-null parameters, DHAES mode false.");
        }
        int offset = out1.length - (message.length + 8);
        byte[] tmp = new byte[out1.length];
        int i = offset;
        while (i != out1.length) {
            System.arraycopy(out1, 0, tmp, 0, tmp.length);
            tmp[i] = ~tmp[i];
            try {
                c2.doFinal(tmp, 0, tmp.length);
                this.fail("decrypted corrupted data");
            }
            catch (BadPaddingException e) {
                this.isTrue("wrong message: " + e.getMessage(), "unable to process block".equals(e.getMessage()));
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        ECIESTest.runTest(new ECIESTest());
    }
}

