/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import junit.framework.TestCase;
import org.bouncycastle.pqc.crypto.ntru.IndexGenerator;
import org.bouncycastle.util.Arrays;

public class BitStringTest
extends TestCase {
    public void testAppendBitsByteArray() {
        IndexGenerator.BitString bs = new IndexGenerator.BitString();
        bs.appendBits((byte)78);
        this.assertBitStringEquals(bs, new byte[]{78});
        bs.appendBits((byte)-5);
        this.assertBitStringEquals(bs, new byte[]{78, -5});
        bs.appendBits((byte)127);
        this.assertBitStringEquals(bs, new byte[]{78, -5, 127});
        bs.appendBits((byte)0);
        byte[] byArray = new byte[4];
        byArray[0] = 78;
        byArray[1] = -5;
        byArray[2] = 127;
        this.assertBitStringEquals(bs, byArray);
        bs.appendBits((byte)100);
        byte[] byArray2 = new byte[5];
        byArray2[0] = 78;
        byArray2[1] = -5;
        byArray2[2] = 127;
        byArray2[4] = 100;
        this.assertBitStringEquals(bs, byArray2);
    }

    private void assertBitStringEquals(IndexGenerator.BitString bs, byte[] arr) {
        byte[] bsBytes = bs.getBytes();
        BitStringTest.assertTrue((bsBytes.length >= arr.length ? 1 : 0) != 0);
        arr = this.copyOf(arr, bsBytes.length);
        BitStringTest.assertTrue((boolean)Arrays.areEqual(arr, bsBytes));
    }

    public void testGetTrailing() {
        IndexGenerator.BitString bs = new IndexGenerator.BitString();
        bs.appendBits((byte)78);
        IndexGenerator.BitString bs2 = bs.getTrailing(3);
        this.assertBitStringEquals(bs2, new byte[]{6});
        bs = new IndexGenerator.BitString();
        bs.appendBits((byte)78);
        bs.appendBits((byte)-5);
        bs2 = bs.getTrailing(9);
        this.assertBitStringEquals(bs2, new byte[]{78, 1});
        bs2.appendBits((byte)100);
        this.assertBitStringEquals(bs2, new byte[]{78, -55});
        bs = bs2.getTrailing(13);
        this.assertBitStringEquals(bs, new byte[]{78, 9});
        bs2 = bs2.getTrailing(11);
        this.assertBitStringEquals(bs2, new byte[]{78, 1});
        bs2.appendBits((byte)100);
        this.assertBitStringEquals(bs2, new byte[]{78, 33, 3});
        bs2 = bs2.getTrailing(16);
        this.assertBitStringEquals(bs2, new byte[]{78, 33});
    }

    public void testGetLeadingAsInt() {
        IndexGenerator.BitString bs = new IndexGenerator.BitString();
        bs.appendBits((byte)78);
        bs.appendBits((byte)42);
        BitStringTest.assertEquals((int)1, (int)bs.getLeadingAsInt(3));
        BitStringTest.assertEquals((int)84, (int)bs.getLeadingAsInt(9));
        BitStringTest.assertEquals((int)338, (int)bs.getLeadingAsInt(11));
        IndexGenerator.BitString bs2 = bs.getTrailing(11);
        this.assertBitStringEquals(bs2, new byte[]{78, 2});
        BitStringTest.assertEquals((int)590, (int)bs2.getLeadingAsInt(11));
        BitStringTest.assertEquals((int)9, (int)bs2.getLeadingAsInt(5));
        bs2.appendBits((byte)115);
        BitStringTest.assertEquals((int)230, (int)bs2.getLeadingAsInt(9));
        BitStringTest.assertEquals((int)922, (int)bs2.getLeadingAsInt(11));
        bs2.appendBits((byte)-36);
        BitStringTest.assertEquals((int)55, (int)bs2.getLeadingAsInt(6));
    }

    private byte[] copyOf(byte[] src, int length) {
        byte[] tmp;
        System.arraycopy(src, 0, tmp, 0, (tmp = new byte[length]).length > src.length ? src.length : tmp.length);
        return tmp;
    }
}

