/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.IOException;
import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.pqc.crypto.ntru.NTRUEncryptionKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUEncryptionKeyPairGenerator;
import org.bouncycastle.pqc.crypto.ntru.NTRUEncryptionPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUEncryptionPublicKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUEngine;
import org.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.SparseTernaryPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import org.bouncycastle.util.Arrays;

public class NTRUEncryptTest
extends TestCase {
    public void testEncryptDecrypt() throws InvalidCipherTextException {
        NTRUEncryptionKeyGenerationParameters params = NTRUEncryptionKeyGenerationParameters.APR2011_743.clone();
        params.df1 = NTRUEncryptionKeyGenerationParameters.APR2011_743_FAST.df1;
        params.df2 = NTRUEncryptionKeyGenerationParameters.APR2011_743_FAST.df2;
        params.df3 = NTRUEncryptionKeyGenerationParameters.APR2011_743_FAST.df3;
        params.dr1 = NTRUEncryptionKeyGenerationParameters.APR2011_743_FAST.dr1;
        params.dr2 = NTRUEncryptionKeyGenerationParameters.APR2011_743_FAST.dr2;
        params.dr3 = NTRUEncryptionKeyGenerationParameters.APR2011_743_FAST.dr3;
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] values = nArray;
        int i = 0;
        while (i != values.length) {
            int polyType = values[i];
            boolean[] blArray = new boolean[2];
            blArray[0] = true;
            boolean[] booleans = blArray;
            int j = 0;
            while (j != booleans.length) {
                params.polyType = polyType;
                params.fastFp = booleans[j];
                VisibleNTRUEngine ntru = new VisibleNTRUEngine();
                NTRUEncryptionKeyPairGenerator ntruGen = new NTRUEncryptionKeyPairGenerator();
                ntruGen.init(params);
                AsymmetricCipherKeyPair kp = ntruGen.generateKeyPair();
                this.testPolynomial(ntru, kp, params);
                this.testText(ntru, kp, params);
                params.sparse = !params.sparse;
                this.testText(ntru, kp, params);
                params.sparse = !params.sparse;
                this.testEmpty(ntru, kp, params);
                this.testMaxLength(ntru, kp, params);
                this.testTooLong(ntru, kp, params);
                this.testInvalidEncoding(ntru, kp, params);
                ++j;
            }
            ++i;
        }
    }

    private void testPolynomial(VisibleNTRUEngine ntru, AsymmetricCipherKeyPair kp, NTRUEncryptionKeyGenerationParameters params) {
        SecureRandom random = new SecureRandom();
        DenseTernaryPolynomial m = DenseTernaryPolynomial.generateRandom(params.N, random);
        SparseTernaryPolynomial r = SparseTernaryPolynomial.generateRandom(params.N, params.dr, params.dr, random);
        ntru.init(true, kp.getPublic());
        IntegerPolynomial e = ntru.encrypt(m, r, ((NTRUEncryptionPublicKeyParameters)kp.getPublic()).h);
        IntegerPolynomial c = ntru.decrypt(e, ((NTRUEncryptionPrivateKeyParameters)kp.getPrivate()).t, ((NTRUEncryptionPrivateKeyParameters)kp.getPrivate()).fp);
        NTRUEncryptTest.assertTrue((boolean)Arrays.areEqual(m.coeffs, c.coeffs));
    }

    private void testText(NTRUEngine ntru, AsymmetricCipherKeyPair kp, NTRUEncryptionKeyGenerationParameters params) throws InvalidCipherTextException {
        byte[] plainText = "text to encrypt".getBytes();
        ntru.init(true, kp.getPublic());
        byte[] encrypted = ntru.processBlock(plainText, 0, plainText.length);
        ntru.init(false, kp.getPrivate());
        byte[] decrypted = ntru.processBlock(encrypted, 0, encrypted.length);
        NTRUEncryptTest.assertTrue((boolean)Arrays.areEqual(plainText, decrypted));
    }

    private void testEmpty(NTRUEngine ntru, AsymmetricCipherKeyPair kp, NTRUEncryptionKeyGenerationParameters params) throws InvalidCipherTextException {
        byte[] plainText = "".getBytes();
        ntru.init(true, kp.getPublic());
        byte[] encrypted = ntru.processBlock(plainText, 0, plainText.length);
        ntru.init(false, kp.getPrivate());
        byte[] decrypted = ntru.processBlock(encrypted, 0, encrypted.length);
        NTRUEncryptTest.assertTrue((boolean)Arrays.areEqual(plainText, decrypted));
    }

    private void testMaxLength(NTRUEngine ntru, AsymmetricCipherKeyPair kp, NTRUEncryptionKeyGenerationParameters params) throws InvalidCipherTextException {
        byte[] plainText = new byte[params.maxMsgLenBytes];
        System.arraycopy("secret encrypted text".getBytes(), 0, plainText, 0, 21);
        ntru.init(true, kp.getPublic());
        byte[] encrypted = ntru.processBlock(plainText, 0, plainText.length);
        ntru.init(false, kp.getPrivate());
        byte[] decrypted = ntru.processBlock(encrypted, 0, encrypted.length);
        NTRUEncryptTest.assertTrue((boolean)Arrays.areEqual(plainText, decrypted));
    }

    private void testTooLong(NTRUEngine ntru, AsymmetricCipherKeyPair kp, NTRUEncryptionKeyGenerationParameters params) {
        byte[] plainText = new byte[params.maxMsgLenBytes + 1];
        try {
            System.arraycopy("secret encrypted text".getBytes(), 0, plainText, 0, 21);
            ntru.init(true, kp.getPublic());
            byte[] encrypted = ntru.processBlock(plainText, 0, plainText.length);
            ntru.init(false, kp.getPrivate());
            byte[] decrypted = ntru.processBlock(encrypted, 0, encrypted.length);
            NTRUEncryptTest.assertTrue((boolean)Arrays.areEqual(plainText, decrypted));
            NTRUEncryptTest.fail((String)"An exception should have been thrown!");
        }
        catch (DataLengthException ex) {
            NTRUEncryptTest.assertEquals((String)("Message too long: " + plainText.length + ">" + params.maxMsgLenBytes), (String)ex.getMessage());
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
        }
    }

    private void testInvalidEncoding(NTRUEngine ntru, AsymmetricCipherKeyPair kp, NTRUEncryptionKeyGenerationParameters params) {
        try {
            byte[] plainText = "secret encrypted text".getBytes();
            ntru.init(true, kp.getPublic());
            byte[] encrypted = ntru.processBlock(plainText, 0, plainText.length);
            NTRUEncryptionPrivateKeyParameters orig = (NTRUEncryptionPrivateKeyParameters)kp.getPrivate();
            IntegerPolynomial h = (IntegerPolynomial)((NTRUEncryptionPublicKeyParameters)kp.getPublic()).h.clone();
            h.coeffs[0] = (h.coeffs[0] + 111) % params.q;
            NTRUEncryptionPrivateKeyParameters privKey = new NTRUEncryptionPrivateKeyParameters(h, orig.t, orig.fp, params.getEncryptionParameters());
            ntru.init(false, privKey);
            ntru.processBlock(encrypted, 0, encrypted.length);
            NTRUEncryptTest.fail((String)"An exception should have been thrown!");
        }
        catch (InvalidCipherTextException ex) {
            NTRUEncryptTest.assertEquals((String)"Invalid message encoding", (String)ex.getMessage());
        }
    }

    /*
     * Opcode count of 14233 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public void testEncodedKeysSlow() throws IOException, InvalidCipherTextException {
        byte[] plainText = "secret encrypted text".getBytes();
        NTRUEncryptionKeyGenerationParameters params = NTRUEncryptionKeyGenerationParameters.APR2011_743;
        NTRUEngine ntru = new NTRUEngine();
        byte[] privBytes = new byte[]{2, -94, 95, 65, -107, 27, 98, 62, -15, -62, 21, -4, 119, -117, 7, 68, 100, 113, -36, -82, 87, -87, -82, 24, -45, -75, -74, -108, 105, 24, 123, 117, 124, 74, -27, 42, -106, -78, 114, 27, 18, 77, -41, 105, -113, 39, 49, 46, 109, -69, 61, 77, 49, 117, 14, -29, 42, 3, 120, -121, -120, -37, 95, 84, 60, -9, -31, -64, 31, 72, 115, -15, 21, -6, 27, -60, -73, -29, -33, -81, -43, 106, 65, 114, 102, -14, -115, -96, 9, 54, 23, -18, -24, -76, 84, -41, -79, 35, 88, 11, 41, 67, 44, -63, -28, 76, 84, -41, -103, 106, -22, 35, -2, -40, -48, -121, -128, 76, 63, 123, -11, 103, -35, -32, 21, -51, -99, -40, -103, -12, 64, -80, 57, -56, 1, -51, 103, 83, 50, 111, -87, -98, 7, -109, 25, -51, 23, -92};
        byte[] byArray = new byte[1022];
        byArray[0] = 91;
        byArray[1] = -66;
        byArray[2] = -25;
        byArray[3] = -81;
        byArray[4] = -66;
        byArray[5] = -33;
        byArray[6] = 25;
        byArray[7] = -31;
        byArray[8] = 48;
        byArray[9] = 23;
        byArray[10] = -38;
        byArray[11] = 20;
        byArray[12] = -30;
        byArray[13] = -120;
        byArray[14] = -17;
        byArray[15] = 1;
        byArray[16] = 21;
        byArray[17] = 51;
        byArray[18] = -11;
        byArray[19] = 102;
        byArray[20] = -50;
        byArray[21] = 62;
        byArray[22] = 71;
        byArray[23] = 79;
        byArray[24] = 32;
        byArray[25] = -49;
        byArray[26] = -57;
        byArray[27] = 105;
        byArray[28] = 21;
        byArray[29] = -34;
        byArray[30] = -45;
        byArray[31] = -67;
        byArray[32] = 113;
        byArray[33] = -46;
        byArray[34] = -103;
        byArray[35] = 57;
        byArray[36] = 28;
        byArray[37] = -54;
        byArray[38] = -21;
        byArray[39] = 94;
        byArray[40] = -112;
        byArray[41] = -63;
        byArray[42] = 105;
        byArray[43] = -100;
        byArray[44] = -95;
        byArray[45] = 21;
        byArray[46] = -52;
        byArray[47] = 50;
        byArray[48] = 11;
        byArray[49] = -22;
        byArray[50] = -63;
        byArray[51] = -35;
        byArray[52] = -42;
        byArray[53] = 50;
        byArray[54] = 93;
        byArray[55] = -40;
        byArray[56] = 23;
        byArray[58] = 121;
        byArray[59] = 23;
        byArray[60] = -93;
        byArray[61] = 111;
        byArray[62] = -98;
        byArray[63] = -14;
        byArray[64] = 92;
        byArray[65] = -24;
        byArray[66] = -117;
        byArray[67] = -8;
        byArray[68] = -109;
        byArray[69] = -118;
        byArray[70] = -4;
        byArray[71] = -107;
        byArray[72] = -60;
        byArray[73] = 100;
        byArray[74] = -128;
        byArray[75] = -47;
        byArray[76] = -92;
        byArray[77] = -117;
        byArray[78] = -108;
        byArray[79] = 39;
        byArray[80] = -113;
        byArray[81] = 43;
        byArray[82] = 48;
        byArray[83] = 68;
        byArray[84] = 95;
        byArray[85] = 123;
        byArray[86] = -112;
        byArray[87] = 41;
        byArray[88] = -27;
        byArray[89] = -99;
        byArray[90] = 59;
        byArray[91] = 33;
        byArray[92] = -57;
        byArray[93] = -120;
        byArray[94] = -44;
        byArray[95] = 72;
        byArray[96] = -98;
        byArray[97] = -105;
        byArray[98] = -91;
        byArray[99] = -52;
        byArray[100] = -89;
        byArray[101] = 107;
        byArray[102] = 119;
        byArray[103] = 87;
        byArray[104] = -36;
        byArray[105] = -102;
        byArray[106] = -83;
        byArray[107] = 67;
        byArray[108] = -8;
        byArray[109] = 30;
        byArray[110] = -54;
        byArray[111] = 74;
        byArray[112] = 93;
        byArray[113] = 119;
        byArray[114] = -3;
        byArray[115] = 126;
        byArray[116] = 69;
        byArray[117] = -104;
        byArray[118] = -44;
        byArray[119] = -24;
        byArray[120] = 124;
        byArray[121] = 108;
        byArray[122] = -125;
        byArray[123] = 73;
        byArray[124] = 98;
        byArray[125] = 121;
        byArray[126] = -49;
        byArray[127] = -37;
        byArray[128] = -24;
        byArray[129] = 87;
        byArray[130] = -71;
        byArray[131] = 91;
        byArray[132] = 8;
        byArray[133] = -31;
        byArray[134] = -50;
        byArray[135] = 95;
        byArray[136] = 112;
        byArray[137] = 27;
        byArray[138] = 97;
        byArray[139] = -93;
        byArray[140] = 3;
        byArray[141] = -73;
        byArray[142] = -54;
        byArray[143] = -16;
        byArray[144] = -92;
        byArray[145] = -108;
        byArray[146] = -74;
        byArray[147] = 88;
        byArray[148] = -5;
        byArray[149] = 23;
        byArray[150] = 70;
        byArray[151] = 69;
        byArray[152] = -49;
        byArray[153] = -46;
        byArray[154] = -50;
        byArray[155] = 65;
        byArray[156] = 69;
        byArray[157] = -54;
        byArray[158] = -41;
        byArray[159] = 109;
        byArray[160] = 8;
        byArray[161] = -80;
        byArray[162] = -23;
        byArray[163] = -84;
        byArray[164] = 120;
        byArray[165] = -77;
        byArray[166] = 26;
        byArray[167] = 99;
        byArray[168] = -104;
        byArray[169] = -33;
        byArray[170] = 82;
        byArray[171] = 91;
        byArray[172] = 22;
        byArray[173] = -17;
        byArray[174] = 113;
        byArray[175] = -29;
        byArray[176] = 66;
        byArray[177] = -7;
        byArray[178] = -114;
        byArray[179] = -101;
        byArray[180] = -111;
        byArray[181] = -47;
        byArray[182] = -1;
        byArray[183] = -3;
        byArray[184] = -57;
        byArray[185] = 62;
        byArray[186] = 79;
        byArray[187] = -70;
        byArray[188] = -58;
        byArray[189] = 45;
        byArray[190] = 76;
        byArray[191] = 28;
        byArray[192] = -117;
        byArray[193] = 59;
        byArray[194] = -117;
        byArray[195] = 113;
        byArray[196] = 84;
        byArray[197] = -55;
        byArray[198] = 48;
        byArray[199] = 119;
        byArray[200] = 58;
        byArray[201] = -105;
        byArray[202] = -20;
        byArray[203] = 80;
        byArray[204] = 102;
        byArray[205] = 14;
        byArray[206] = -69;
        byArray[207] = -69;
        byArray[208] = 5;
        byArray[209] = 11;
        byArray[210] = -87;
        byArray[211] = 107;
        byArray[212] = 15;
        byArray[213] = 105;
        byArray[214] = -69;
        byArray[215] = -27;
        byArray[216] = -24;
        byArray[217] = 47;
        byArray[218] = -18;
        byArray[219] = -54;
        byArray[220] = -45;
        byArray[221] = -67;
        byArray[222] = 27;
        byArray[223] = -52;
        byArray[224] = -20;
        byArray[225] = -94;
        byArray[226] = 64;
        byArray[227] = -26;
        byArray[228] = -58;
        byArray[229] = 98;
        byArray[230] = 33;
        byArray[231] = -61;
        byArray[232] = 71;
        byArray[233] = -101;
        byArray[234] = 120;
        byArray[235] = 28;
        byArray[236] = 113;
        byArray[237] = 72;
        byArray[238] = 127;
        byArray[239] = 50;
        byArray[240] = 123;
        byArray[241] = 36;
        byArray[242] = -97;
        byArray[243] = 78;
        byArray[244] = 32;
        byArray[245] = -74;
        byArray[246] = 105;
        byArray[247] = 62;
        byArray[248] = 92;
        byArray[249] = 84;
        byArray[250] = -17;
        byArray[251] = 21;
        byArray[252] = -75;
        byArray[253] = 24;
        byArray[254] = -90;
        byArray[255] = -78;
        byArray[256] = -4;
        byArray[257] = -121;
        byArray[258] = 47;
        byArray[259] = -82;
        byArray[260] = 119;
        byArray[261] = 27;
        byArray[262] = -61;
        byArray[263] = 17;
        byArray[264] = -66;
        byArray[265] = 43;
        byArray[266] = 96;
        byArray[267] = -49;
        byArray[268] = -6;
        byArray[269] = 66;
        byArray[270] = -13;
        byArray[271] = -75;
        byArray[272] = -95;
        byArray[273] = 64;
        byArray[274] = -12;
        byArray[275] = -39;
        byArray[276] = 111;
        byArray[277] = 46;
        byArray[278] = -3;
        byArray[279] = -123;
        byArray[280] = 82;
        byArray[281] = 12;
        byArray[282] = -26;
        byArray[283] = -30;
        byArray[284] = -29;
        byArray[285] = 71;
        byArray[286] = -108;
        byArray[287] = -79;
        byArray[288] = -112;
        byArray[289] = 13;
        byArray[290] = 16;
        byArray[291] = -70;
        byArray[292] = 7;
        byArray[293] = 100;
        byArray[294] = 84;
        byArray[295] = 89;
        byArray[296] = -100;
        byArray[297] = 114;
        byArray[298] = 47;
        byArray[299] = 56;
        byArray[300] = 71;
        byArray[301] = 83;
        byArray[302] = 63;
        byArray[303] = -61;
        byArray[304] = -39;
        byArray[305] = -53;
        byArray[306] = -100;
        byArray[307] = 23;
        byArray[308] = -31;
        byArray[309] = -52;
        byArray[310] = -46;
        byArray[311] = 36;
        byArray[312] = -13;
        byArray[313] = 62;
        byArray[314] = 107;
        byArray[315] = 28;
        byArray[316] = -28;
        byArray[317] = 92;
        byArray[318] = 116;
        byArray[319] = -59;
        byArray[320] = 28;
        byArray[321] = -111;
        byArray[322] = -23;
        byArray[323] = -44;
        byArray[324] = 21;
        byArray[325] = -2;
        byArray[326] = 127;
        byArray[327] = -112;
        byArray[328] = 54;
        byArray[329] = -126;
        byArray[330] = 13;
        byArray[331] = -104;
        byArray[332] = 47;
        byArray[333] = -43;
        byArray[334] = -109;
        byArray[335] = -19;
        byArray[336] = 107;
        byArray[337] = -94;
        byArray[338] = -126;
        byArray[339] = 50;
        byArray[340] = 92;
        byArray[341] = -69;
        byArray[342] = 1;
        byArray[343] = 115;
        byArray[344] = -121;
        byArray[345] = -52;
        byArray[346] = -100;
        byArray[347] = 25;
        byArray[348] = 126;
        byArray[349] = -7;
        byArray[350] = 86;
        byArray[351] = 77;
        byArray[352] = 72;
        byArray[353] = -2;
        byArray[354] = -104;
        byArray[355] = -42;
        byArray[356] = 98;
        byArray[357] = -16;
        byArray[358] = 54;
        byArray[359] = -67;
        byArray[360] = 117;
        byArray[361] = 14;
        byArray[362] = -73;
        byArray[363] = 4;
        byArray[364] = 58;
        byArray[365] = 121;
        byArray[366] = 35;
        byArray[367] = 1;
        byArray[368] = 99;
        byArray[369] = -127;
        byArray[370] = -9;
        byArray[371] = -60;
        byArray[372] = 32;
        byArray[373] = -37;
        byArray[374] = -106;
        byArray[375] = 6;
        byArray[376] = -108;
        byArray[377] = -13;
        byArray[378] = -62;
        byArray[379] = 23;
        byArray[380] = -20;
        byArray[381] = -9;
        byArray[382] = 21;
        byArray[383] = 15;
        byArray[384] = 4;
        byArray[385] = 126;
        byArray[386] = -112;
        byArray[387] = 123;
        byArray[388] = 34;
        byArray[389] = -67;
        byArray[390] = -51;
        byArray[391] = 43;
        byArray[392] = -30;
        byArray[393] = -75;
        byArray[394] = 119;
        byArray[395] = -112;
        byArray[396] = -58;
        byArray[397] = -55;
        byArray[398] = -90;
        byArray[399] = 2;
        byArray[400] = -5;
        byArray[401] = -46;
        byArray[402] = -12;
        byArray[403] = 119;
        byArray[404] = 87;
        byArray[405] = 24;
        byArray[406] = -52;
        byArray[407] = 2;
        byArray[408] = -29;
        byArray[409] = 113;
        byArray[410] = 61;
        byArray[411] = -82;
        byArray[412] = -101;
        byArray[413] = 57;
        byArray[414] = -11;
        byArray[415] = -107;
        byArray[416] = -11;
        byArray[417] = 67;
        byArray[418] = -42;
        byArray[419] = -43;
        byArray[420] = -13;
        byArray[421] = 112;
        byArray[422] = -49;
        byArray[423] = 82;
        byArray[424] = 60;
        byArray[425] = 13;
        byArray[426] = -50;
        byArray[427] = 108;
        byArray[428] = 64;
        byArray[429] = -64;
        byArray[430] = 53;
        byArray[431] = -107;
        byArray[432] = -9;
        byArray[433] = 102;
        byArray[434] = -33;
        byArray[435] = 75;
        byArray[436] = -100;
        byArray[437] = -115;
        byArray[438] = 102;
        byArray[439] = -113;
        byArray[440] = -48;
        byArray[441] = 19;
        byArray[442] = -119;
        byArray[443] = -72;
        byArray[444] = -65;
        byArray[445] = 22;
        byArray[446] = -65;
        byArray[447] = -93;
        byArray[448] = 34;
        byArray[449] = -71;
        byArray[450] = 75;
        byArray[451] = 101;
        byArray[452] = 54;
        byArray[453] = 126;
        byArray[454] = 75;
        byArray[455] = 34;
        byArray[456] = -21;
        byArray[457] = -53;
        byArray[458] = -36;
        byArray[459] = 127;
        byArray[460] = -21;
        byArray[461] = 70;
        byArray[462] = 24;
        byArray[463] = 89;
        byArray[464] = -88;
        byArray[465] = 63;
        byArray[466] = -43;
        byArray[467] = -4;
        byArray[468] = 68;
        byArray[469] = 97;
        byArray[470] = -45;
        byArray[471] = -101;
        byArray[472] = -125;
        byArray[473] = -38;
        byArray[474] = 98;
        byArray[475] = -118;
        byArray[476] = -34;
        byArray[477] = -63;
        byArray[478] = 23;
        byArray[479] = 78;
        byArray[480] = 15;
        byArray[481] = 17;
        byArray[482] = 101;
        byArray[483] = -107;
        byArray[484] = 119;
        byArray[485] = -41;
        byArray[486] = 107;
        byArray[487] = 117;
        byArray[488] = 17;
        byArray[489] = 108;
        byArray[490] = 43;
        byArray[491] = -93;
        byArray[492] = -6;
        byArray[493] = -23;
        byArray[494] = -30;
        byArray[495] = 49;
        byArray[496] = -61;
        byArray[497] = 27;
        byArray[498] = 61;
        byArray[499] = -125;
        byArray[500] = -68;
        byArray[501] = 51;
        byArray[502] = 40;
        byArray[503] = -106;
        byArray[504] = -61;
        byArray[505] = 51;
        byArray[506] = 127;
        byArray[507] = 2;
        byArray[508] = 123;
        byArray[509] = 7;
        byArray[510] = -50;
        byArray[511] = -115;
        byArray[512] = -32;
        byArray[513] = -95;
        byArray[514] = -96;
        byArray[515] = 67;
        byArray[516] = 4;
        byArray[517] = 5;
        byArray[518] = 59;
        byArray[519] = -45;
        byArray[520] = 61;
        byArray[521] = 95;
        byArray[522] = 14;
        byArray[523] = 2;
        byArray[524] = -76;
        byArray[525] = -121;
        byArray[526] = 8;
        byArray[527] = 125;
        byArray[528] = 16;
        byArray[529] = -126;
        byArray[530] = 58;
        byArray[531] = 118;
        byArray[532] = -32;
        byArray[533] = 19;
        byArray[534] = -113;
        byArray[535] = -113;
        byArray[536] = 120;
        byArray[537] = -101;
        byArray[538] = 86;
        byArray[539] = 76;
        byArray[540] = -90;
        byArray[541] = 50;
        byArray[542] = -92;
        byArray[543] = 51;
        byArray[544] = -92;
        byArray[545] = 1;
        byArray[546] = 121;
        byArray[547] = -74;
        byArray[548] = -101;
        byArray[549] = -33;
        byArray[550] = 53;
        byArray[551] = -53;
        byArray[552] = -83;
        byArray[553] = 46;
        byArray[554] = 20;
        byArray[555] = -87;
        byArray[556] = -112;
        byArray[557] = -61;
        byArray[558] = -87;
        byArray[559] = 106;
        byArray[560] = -126;
        byArray[561] = 64;
        byArray[562] = 99;
        byArray[563] = -60;
        byArray[564] = 70;
        byArray[565] = 120;
        byArray[566] = 47;
        byArray[567] = -53;
        byArray[568] = 36;
        byArray[569] = 20;
        byArray[570] = -90;
        byArray[571] = 110;
        byArray[572] = 61;
        byArray[573] = -93;
        byArray[574] = 55;
        byArray[575] = -10;
        byArray[576] = 85;
        byArray[577] = 45;
        byArray[578] = 52;
        byArray[579] = 79;
        byArray[580] = 87;
        byArray[581] = 100;
        byArray[582] = -81;
        byArray[583] = -85;
        byArray[584] = 34;
        byArray[585] = 55;
        byArray[586] = -91;
        byArray[587] = 27;
        byArray[588] = 116;
        byArray[589] = -18;
        byArray[590] = -71;
        byArray[591] = -11;
        byArray[592] = 87;
        byArray[593] = -11;
        byArray[594] = 76;
        byArray[595] = 48;
        byArray[596] = 97;
        byArray[597] = -78;
        byArray[598] = 64;
        byArray[599] = -100;
        byArray[600] = -59;
        byArray[601] = -12;
        byArray[602] = 19;
        byArray[603] = -90;
        byArray[604] = 121;
        byArray[605] = 48;
        byArray[606] = -19;
        byArray[607] = 64;
        byArray[608] = 113;
        byArray[609] = -70;
        byArray[610] = -14;
        byArray[611] = -70;
        byArray[612] = 92;
        byArray[613] = 124;
        byArray[614] = 42;
        byArray[615] = 95;
        byArray[616] = 7;
        byArray[617] = -115;
        byArray[618] = 36;
        byArray[619] = 127;
        byArray[620] = 73;
        byArray[621] = 33;
        byArray[622] = 30;
        byArray[623] = 121;
        byArray[624] = 88;
        byArray[625] = 16;
        byArray[626] = -90;
        byArray[627] = 99;
        byArray[628] = 120;
        byArray[629] = -68;
        byArray[630] = 64;
        byArray[631] = -125;
        byArray[632] = -78;
        byArray[633] = 76;
        byArray[634] = 112;
        byArray[635] = 68;
        byArray[636] = 8;
        byArray[637] = 105;
        byArray[638] = 10;
        byArray[639] = -47;
        byArray[640] = -124;
        byArray[641] = 39;
        byArray[642] = -107;
        byArray[643] = -101;
        byArray[644] = 46;
        byArray[645] = -61;
        byArray[646] = 118;
        byArray[647] = -74;
        byArray[648] = 102;
        byArray[649] = -62;
        byArray[650] = -6;
        byArray[651] = -128;
        byArray[652] = 17;
        byArray[653] = -45;
        byArray[654] = 61;
        byArray[655] = 76;
        byArray[656] = 63;
        byArray[657] = -10;
        byArray[658] = -41;
        byArray[659] = 50;
        byArray[660] = -113;
        byArray[661] = 75;
        byArray[662] = -83;
        byArray[663] = -59;
        byArray[664] = -51;
        byArray[665] = -23;
        byArray[666] = -61;
        byArray[667] = 47;
        byArray[668] = 7;
        byArray[669] = -80;
        byArray[670] = 126;
        byArray[671] = -2;
        byArray[672] = 79;
        byArray[673] = -53;
        byArray[674] = 110;
        byArray[675] = -93;
        byArray[676] = -38;
        byArray[677] = -91;
        byArray[678] = -22;
        byArray[679] = 20;
        byArray[680] = -84;
        byArray[681] = -113;
        byArray[682] = -124;
        byArray[683] = -73;
        byArray[684] = 124;
        byArray[686] = 33;
        byArray[687] = -58;
        byArray[688] = 63;
        byArray[689] = -26;
        byArray[690] = 52;
        byArray[691] = 7;
        byArray[692] = 74;
        byArray[693] = 65;
        byArray[694] = 38;
        byArray[695] = -33;
        byArray[696] = 21;
        byArray[697] = -9;
        byArray[698] = -1;
        byArray[699] = 120;
        byArray[700] = -16;
        byArray[701] = 47;
        byArray[702] = -96;
        byArray[703] = 59;
        byArray[704] = -64;
        byArray[705] = 74;
        byArray[706] = 6;
        byArray[707] = 48;
        byArray[708] = -67;
        byArray[709] = -32;
        byArray[710] = -26;
        byArray[711] = 35;
        byArray[712] = 68;
        byArray[713] = 47;
        byArray[714] = 82;
        byArray[715] = 36;
        byArray[716] = 52;
        byArray[717] = 41;
        byArray[718] = 112;
        byArray[719] = -28;
        byArray[720] = -22;
        byArray[721] = -51;
        byArray[722] = -6;
        byArray[723] = -49;
        byArray[724] = 105;
        byArray[725] = 16;
        byArray[726] = -34;
        byArray[727] = 99;
        byArray[728] = -41;
        byArray[729] = 75;
        byArray[730] = 7;
        byArray[731] = 79;
        byArray[732] = -22;
        byArray[733] = -125;
        byArray[734] = -30;
        byArray[735] = -126;
        byArray[736] = 35;
        byArray[737] = 119;
        byArray[738] = -43;
        byArray[739] = -30;
        byArray[740] = 32;
        byArray[741] = 8;
        byArray[742] = 44;
        byArray[743] = -42;
        byArray[744] = -98;
        byArray[745] = 78;
        byArray[746] = -92;
        byArray[747] = -95;
        byArray[748] = -10;
        byArray[749] = -94;
        byArray[750] = -1;
        byArray[751] = -91;
        byArray[752] = -122;
        byArray[753] = 77;
        byArray[755] = 40;
        byArray[756] = -23;
        byArray[757] = 36;
        byArray[758] = 85;
        byArray[759] = 123;
        byArray[760] = -57;
        byArray[761] = -74;
        byArray[762] = -69;
        byArray[763] = -90;
        byArray[764] = 89;
        byArray[765] = 111;
        byArray[766] = -120;
        byArray[767] = 22;
        byArray[768] = 5;
        byArray[769] = -48;
        byArray[770] = 114;
        byArray[771] = 59;
        byArray[772] = 31;
        byArray[773] = 31;
        byArray[774] = -25;
        byArray[775] = -3;
        byArray[776] = 24;
        byArray[777] = 110;
        byArray[778] = -110;
        byArray[779] = 73;
        byArray[780] = -40;
        byArray[781] = 92;
        byArray[782] = -26;
        byArray[783] = -12;
        byArray[784] = 52;
        byArray[785] = 83;
        byArray[786] = -98;
        byArray[787] = -119;
        byArray[788] = -6;
        byArray[789] = -117;
        byArray[790] = -89;
        byArray[791] = 95;
        byArray[792] = 83;
        byArray[793] = -25;
        byArray[794] = 122;
        byArray[795] = -26;
        byArray[796] = 114;
        byArray[797] = 81;
        byArray[798] = 25;
        byArray[799] = 110;
        byArray[800] = 79;
        byArray[801] = -49;
        byArray[802] = -39;
        byArray[803] = 10;
        byArray[804] = -78;
        byArray[805] = -65;
        byArray[806] = 57;
        byArray[807] = -90;
        byArray[808] = -46;
        byArray[809] = -126;
        byArray[810] = 15;
        byArray[811] = -124;
        byArray[812] = -104;
        byArray[813] = -89;
        byArray[814] = -66;
        byArray[815] = -87;
        byArray[816] = 24;
        byArray[817] = -45;
        byArray[818] = 39;
        byArray[819] = -34;
        byArray[820] = -40;
        byArray[821] = -13;
        byArray[822] = 106;
        byArray[823] = 12;
        byArray[824] = -25;
        byArray[825] = -116;
        byArray[826] = -47;
        byArray[827] = 79;
        byArray[828] = -81;
        byArray[829] = 64;
        byArray[830] = -17;
        byArray[831] = -31;
        byArray[832] = -70;
        byArray[833] = 87;
        byArray[834] = 36;
        byArray[835] = 46;
        byArray[836] = 102;
        byArray[837] = 107;
        byArray[838] = 48;
        byArray[839] = 88;
        byArray[840] = 34;
        byArray[841] = 46;
        byArray[842] = 24;
        byArray[843] = 63;
        byArray[844] = -100;
        byArray[845] = 106;
        byArray[846] = 27;
        byArray[847] = 58;
        byArray[848] = -71;
        byArray[849] = 38;
        byArray[850] = 60;
        byArray[851] = -66;
        byArray[852] = 45;
        byArray[853] = -89;
        byArray[854] = 39;
        byArray[855] = -60;
        byArray[856] = -116;
        byArray[857] = -14;
        byArray[858] = -119;
        byArray[859] = 118;
        byArray[861] = -24;
        byArray[862] = -9;
        byArray[863] = 38;
        byArray[864] = -71;
        byArray[865] = -79;
        byArray[866] = 124;
        byArray[867] = -119;
        byArray[868] = -64;
        byArray[869] = -9;
        byArray[870] = 71;
        byArray[871] = -56;
        byArray[872] = -82;
        byArray[873] = -73;
        byArray[874] = -69;
        byArray[875] = 127;
        byArray[876] = -1;
        byArray[877] = -20;
        byArray[878] = 123;
        byArray[879] = 32;
        byArray[880] = -43;
        byArray[881] = 49;
        byArray[882] = 5;
        byArray[883] = 49;
        byArray[884] = 105;
        byArray[885] = -5;
        byArray[886] = -2;
        byArray[887] = 5;
        byArray[888] = -105;
        byArray[889] = -111;
        byArray[890] = 89;
        byArray[891] = -30;
        byArray[892] = -41;
        byArray[893] = -49;
        byArray[894] = 61;
        byArray[895] = 80;
        byArray[896] = 69;
        byArray[897] = 44;
        byArray[898] = -33;
        byArray[899] = -116;
        byArray[900] = -45;
        byArray[901] = -96;
        byArray[902] = 63;
        byArray[903] = 28;
        byArray[904] = -17;
        byArray[905] = -106;
        byArray[906] = -94;
        byArray[907] = 90;
        byArray[908] = -40;
        byArray[909] = -88;
        byArray[910] = 122;
        byArray[911] = 116;
        byArray[912] = 116;
        byArray[913] = 113;
        byArray[914] = -65;
        byArray[915] = 104;
        byArray[916] = 119;
        byArray[917] = -3;
        byArray[918] = 96;
        byArray[919] = -45;
        byArray[920] = 18;
        byArray[921] = -120;
        byArray[922] = -111;
        byArray[923] = 83;
        byArray[924] = 43;
        byArray[925] = -5;
        byArray[926] = 101;
        byArray[927] = 71;
        byArray[928] = 48;
        byArray[929] = 104;
        byArray[930] = -112;
        byArray[931] = -95;
        byArray[932] = -46;
        byArray[933] = 53;
        byArray[934] = -96;
        byArray[935] = -93;
        byArray[936] = -126;
        byArray[937] = 96;
        byArray[938] = 56;
        byArray[939] = 104;
        byArray[940] = -111;
        byArray[941] = 114;
        byArray[942] = -1;
        byArray[943] = -44;
        byArray[944] = -120;
        byArray[945] = -112;
        byArray[946] = -19;
        byArray[947] = 100;
        byArray[948] = 41;
        byArray[949] = -122;
        byArray[950] = 23;
        byArray[951] = -78;
        byArray[952] = 33;
        byArray[953] = -35;
        byArray[954] = 11;
        byArray[955] = 57;
        byArray[956] = -18;
        byArray[957] = 106;
        byArray[958] = -40;
        byArray[959] = 74;
        byArray[960] = 61;
        byArray[961] = 66;
        byArray[962] = 54;
        byArray[963] = -77;
        byArray[964] = 96;
        byArray[965] = 70;
        byArray[966] = 108;
        byArray[967] = -128;
        byArray[968] = 91;
        byArray[969] = -97;
        byArray[970] = -36;
        byArray[971] = -23;
        byArray[972] = -86;
        byArray[973] = -91;
        byArray[974] = 44;
        byArray[975] = 58;
        byArray[976] = 117;
        byArray[977] = 2;
        byArray[978] = 26;
        byArray[979] = 44;
        byArray[980] = 95;
        byArray[981] = 79;
        byArray[982] = -101;
        byArray[983] = -81;
        byArray[984] = -92;
        byArray[985] = 110;
        byArray[986] = -81;
        byArray[987] = -12;
        byArray[988] = -88;
        byArray[989] = -21;
        byArray[990] = -83;
        byArray[991] = 60;
        byArray[992] = 93;
        byArray[993] = -121;
        byArray[994] = -114;
        byArray[995] = -48;
        byArray[996] = -34;
        byArray[997] = -119;
        byArray[998] = -1;
        byArray[999] = 127;
        byArray[1000] = -121;
        byArray[1001] = 54;
        byArray[1002] = -128;
        byArray[1003] = -106;
        byArray[1004] = -39;
        byArray[1005] = -108;
        byArray[1006] = 81;
        byArray[1007] = 17;
        byArray[1008] = -3;
        byArray[1009] = -13;
        byArray[1010] = -57;
        byArray[1011] = 74;
        byArray[1012] = 41;
        byArray[1013] = -122;
        byArray[1014] = -65;
        byArray[1015] = -107;
        byArray[1016] = -118;
        byArray[1017] = -65;
        byArray[1018] = -61;
        byArray[1019] = 103;
        byArray[1020] = -69;
        byArray[1021] = 19;
        byte[] pubBytes = byArray;
        byte[] fullBytes = new byte[pubBytes.length + privBytes.length];
        System.arraycopy(pubBytes, 0, fullBytes, 0, pubBytes.length);
        System.arraycopy(privBytes, 0, fullBytes, pubBytes.length, privBytes.length);
        NTRUEncryptionPrivateKeyParameters priv = new NTRUEncryptionPrivateKeyParameters(fullBytes, params.getEncryptionParameters());
        NTRUEncryptionPublicKeyParameters pub = new NTRUEncryptionPublicKeyParameters(pubBytes, params.getEncryptionParameters());
        AsymmetricCipherKeyPair kp = new AsymmetricCipherKeyPair(pub, priv);
        ntru.init(true, kp.getPublic());
        byte[] encrypted = ntru.processBlock(plainText, 0, plainText.length);
        ntru.init(false, kp.getPrivate());
        NTRUEncryptTest.assertTrue((boolean)Arrays.areEqual(plainText, ntru.processBlock(encrypted, 0, encrypted.length)));
        params = NTRUEncryptionKeyGenerationParameters.EES1499EP1;
        ntru = new NTRUEngine();
        byte[] byArray2 = new byte[297];
        byArray2[0] = 116;
        byArray2[1] = 7;
        byArray2[2] = 118;
        byArray2[3] = 121;
        byArray2[4] = 6;
        byArray2[5] = 77;
        byArray2[6] = -36;
        byArray2[7] = 60;
        byArray2[8] = 65;
        byArray2[9] = 108;
        byArray2[10] = 10;
        byArray2[11] = -106;
        byArray2[12] = 12;
        byArray2[13] = 9;
        byArray2[14] = -22;
        byArray2[15] = -113;
        byArray2[16] = 122;
        byArray2[17] = -31;
        byArray2[18] = -31;
        byArray2[19] = 18;
        byArray2[20] = 120;
        byArray2[21] = 81;
        byArray2[22] = -33;
        byArray2[23] = 5;
        byArray2[24] = 122;
        byArray2[25] = -76;
        byArray2[26] = 109;
        byArray2[27] = -30;
        byArray2[28] = -101;
        byArray2[29] = -45;
        byArray2[30] = 21;
        byArray2[31] = 13;
        byArray2[32] = -11;
        byArray2[33] = -49;
        byArray2[34] = -111;
        byArray2[35] = 46;
        byArray2[36] = 91;
        byArray2[37] = 4;
        byArray2[38] = -28;
        byArray2[39] = -109;
        byArray2[40] = 121;
        byArray2[41] = -119;
        byArray2[42] = -121;
        byArray2[43] = -58;
        byArray2[44] = -113;
        byArray2[45] = -9;
        byArray2[46] = -10;
        byArray2[47] = -25;
        byArray2[48] = -53;
        byArray2[49] = 40;
        byArray2[50] = -86;
        byArray2[51] = -22;
        byArray2[52] = -50;
        byArray2[53] = 42;
        byArray2[54] = 52;
        byArray2[55] = 107;
        byArray2[56] = 119;
        byArray2[57] = 17;
        byArray2[58] = 33;
        byArray2[59] = 125;
        byArray2[60] = -26;
        byArray2[61] = 33;
        byArray2[62] = 55;
        byArray2[63] = 25;
        byArray2[64] = -77;
        byArray2[65] = -65;
        byArray2[66] = -106;
        byArray2[67] = 116;
        byArray2[68] = -67;
        byArray2[69] = 91;
        byArray2[70] = 105;
        byArray2[71] = -7;
        byArray2[72] = 42;
        byArray2[73] = -107;
        byArray2[74] = -54;
        byArray2[75] = 101;
        byArray2[76] = 12;
        byArray2[77] = -12;
        byArray2[78] = 57;
        byArray2[79] = -116;
        byArray2[80] = 45;
        byArray2[81] = -107;
        byArray2[82] = -17;
        byArray2[83] = 110;
        byArray2[84] = 35;
        byArray2[85] = -64;
        byArray2[86] = 19;
        byArray2[87] = -38;
        byArray2[88] = -122;
        byArray2[89] = 115;
        byArray2[90] = -93;
        byArray2[91] = 53;
        byArray2[92] = 69;
        byArray2[93] = 66;
        byArray2[94] = -106;
        byArray2[95] = 17;
        byArray2[96] = 20;
        byArray2[97] = -71;
        byArray2[98] = 121;
        byArray2[99] = 23;
        byArray2[100] = -21;
        byArray2[101] = -45;
        byArray2[102] = 108;
        byArray2[103] = 97;
        byArray2[104] = 23;
        byArray2[105] = -98;
        byArray2[106] = -12;
        byArray2[107] = -41;
        byArray2[108] = -31;
        byArray2[109] = -53;
        byArray2[110] = 30;
        byArray2[111] = -42;
        byArray2[112] = 15;
        byArray2[113] = 85;
        byArray2[114] = -21;
        byArray2[115] = -89;
        byArray2[116] = 118;
        byArray2[117] = 42;
        byArray2[118] = -117;
        byArray2[119] = -39;
        byArray2[120] = 69;
        byArray2[122] = -63;
        byArray2[123] = 83;
        byArray2[124] = 48;
        byArray2[125] = -80;
        byArray2[126] = -14;
        byArray2[127] = -123;
        byArray2[128] = -4;
        byArray2[129] = -116;
        byArray2[130] = -90;
        byArray2[131] = -107;
        byArray2[132] = -89;
        byArray2[133] = 119;
        byArray2[134] = 29;
        byArray2[135] = -30;
        byArray2[136] = 69;
        byArray2[137] = 22;
        byArray2[138] = -84;
        byArray2[139] = 47;
        byArray2[140] = 117;
        byArray2[141] = -123;
        byArray2[142] = 102;
        byArray2[143] = -116;
        byArray2[144] = 35;
        byArray2[145] = 93;
        byArray2[146] = -13;
        byArray2[147] = 84;
        byArray2[148] = -9;
        byArray2[149] = -122;
        byArray2[150] = 58;
        byArray2[151] = 101;
        byArray2[152] = 93;
        byArray2[153] = -106;
        byArray2[154] = -119;
        byArray2[155] = -35;
        byArray2[156] = -75;
        byArray2[157] = 76;
        byArray2[158] = 27;
        byArray2[159] = -125;
        byArray2[160] = -22;
        byArray2[161] = 68;
        byArray2[162] = 101;
        byArray2[163] = 49;
        byArray2[164] = 103;
        byArray2[165] = -13;
        byArray2[166] = -98;
        byArray2[167] = 93;
        byArray2[168] = -56;
        byArray2[169] = -110;
        byArray2[170] = -19;
        byArray2[171] = -12;
        byArray2[172] = 74;
        byArray2[173] = 104;
        byArray2[174] = 7;
        byArray2[175] = 6;
        byArray2[176] = -11;
        byArray2[177] = 47;
        byArray2[178] = 57;
        byArray2[179] = 90;
        byArray2[180] = 75;
        byArray2[181] = -30;
        byArray2[182] = 47;
        byArray2[183] = 66;
        byArray2[184] = -58;
        byArray2[185] = 14;
        byArray2[186] = 14;
        byArray2[187] = 70;
        byArray2[188] = 11;
        byArray2[189] = -119;
        byArray2[190] = -36;
        byArray2[191] = -118;
        byArray2[192] = -55;
        byArray2[193] = -53;
        byArray2[194] = 101;
        byArray2[195] = -73;
        byArray2[196] = -77;
        byArray2[197] = 33;
        byArray2[198] = -29;
        byArray2[199] = 96;
        byArray2[200] = -86;
        byArray2[201] = 38;
        byArray2[202] = 47;
        byArray2[203] = 103;
        byArray2[204] = 19;
        byArray2[205] = -37;
        byArray2[206] = -17;
        byArray2[207] = -50;
        byArray2[208] = -82;
        byArray2[209] = -87;
        byArray2[210] = -119;
        byArray2[211] = 37;
        byArray2[212] = -54;
        byArray2[213] = 77;
        byArray2[214] = -69;
        byArray2[215] = -16;
        byArray2[216] = -48;
        byArray2[217] = -52;
        byArray2[218] = 110;
        byArray2[219] = -26;
        byArray2[220] = 111;
        byArray2[221] = 35;
        byArray2[222] = 26;
        byArray2[223] = -53;
        byArray2[224] = -10;
        byArray2[225] = 9;
        byArray2[226] = -108;
        byArray2[227] = -34;
        byArray2[228] = 102;
        byArray2[229] = 7;
        byArray2[230] = -18;
        byArray2[231] = -72;
        byArray2[232] = -26;
        byArray2[233] = 24;
        byArray2[234] = -50;
        byArray2[235] = -43;
        byArray2[236] = 92;
        byArray2[237] = 56;
        byArray2[238] = -94;
        byArray2[239] = 23;
        byArray2[240] = -36;
        byArray2[241] = 60;
        byArray2[242] = 28;
        byArray2[243] = -121;
        byArray2[244] = 27;
        byArray2[245] = 127;
        byArray2[246] = -93;
        byArray2[247] = -79;
        byArray2[248] = -45;
        byArray2[249] = -60;
        byArray2[250] = 105;
        byArray2[251] = -6;
        byArray2[252] = -88;
        byArray2[253] = 72;
        byArray2[254] = -41;
        byArray2[255] = 47;
        byArray2[256] = -51;
        byArray2[257] = 3;
        byArray2[258] = 91;
        byArray2[259] = 116;
        byArray2[260] = 75;
        byArray2[261] = 122;
        byArray2[262] = -94;
        byArray2[263] = -113;
        byArray2[264] = 28;
        byArray2[265] = -96;
        byArray2[266] = -62;
        byArray2[267] = -29;
        byArray2[268] = -74;
        byArray2[269] = -85;
        byArray2[270] = -93;
        byArray2[271] = 51;
        byArray2[272] = 58;
        byArray2[273] = 72;
        byArray2[274] = 44;
        byArray2[275] = 9;
        byArray2[276] = 18;
        byArray2[277] = -48;
        byArray2[278] = -24;
        byArray2[279] = 73;
        byArray2[280] = 122;
        byArray2[281] = 60;
        byArray2[282] = -23;
        byArray2[283] = 83;
        byArray2[284] = -110;
        byArray2[285] = -7;
        byArray2[286] = -111;
        byArray2[287] = -69;
        byArray2[288] = 106;
        byArray2[289] = 51;
        byArray2[290] = 118;
        byArray2[291] = -83;
        byArray2[292] = -18;
        byArray2[293] = 109;
        byArray2[294] = -32;
        byArray2[295] = 40;
        byArray2[296] = 22;
        privBytes = byArray2;
        byte[] byArray3 = new byte[2062];
        byArray3[0] = -62;
        byArray3[1] = 56;
        byArray3[2] = 59;
        byArray3[3] = -46;
        byArray3[4] = 30;
        byArray3[5] = -19;
        byArray3[6] = 22;
        byArray3[7] = -115;
        byArray3[8] = -20;
        byArray3[9] = 117;
        byArray3[10] = -14;
        byArray3[11] = 3;
        byArray3[12] = 2;
        byArray3[13] = -57;
        byArray3[14] = 85;
        byArray3[15] = -24;
        byArray3[16] = 27;
        byArray3[17] = 57;
        byArray3[18] = 49;
        byArray3[19] = -93;
        byArray3[20] = -52;
        byArray3[21] = 87;
        byArray3[22] = 49;
        byArray3[23] = 96;
        byArray3[24] = 15;
        byArray3[25] = 95;
        byArray3[26] = -95;
        byArray3[27] = -86;
        byArray3[28] = -61;
        byArray3[29] = 50;
        byArray3[30] = -18;
        byArray3[31] = 3;
        byArray3[32] = 109;
        byArray3[33] = -55;
        byArray3[34] = -110;
        byArray3[35] = -57;
        byArray3[36] = 82;
        byArray3[37] = 124;
        byArray3[38] = -5;
        byArray3[39] = -57;
        byArray3[40] = 68;
        byArray3[41] = -18;
        byArray3[42] = 126;
        byArray3[43] = 114;
        byArray3[44] = 6;
        byArray3[45] = -22;
        byArray3[46] = 8;
        byArray3[47] = 121;
        byArray3[48] = 125;
        byArray3[49] = 29;
        byArray3[50] = -16;
        byArray3[51] = 112;
        byArray3[52] = -81;
        byArray3[53] = 27;
        byArray3[54] = -7;
        byArray3[55] = 109;
        byArray3[56] = -44;
        byArray3[57] = -123;
        byArray3[58] = -15;
        byArray3[59] = -14;
        byArray3[60] = 74;
        byArray3[61] = -126;
        byArray3[62] = 95;
        byArray3[63] = -94;
        byArray3[64] = -91;
        byArray3[65] = 119;
        byArray3[66] = 80;
        byArray3[67] = -48;
        byArray3[68] = 41;
        byArray3[69] = 49;
        byArray3[70] = 6;
        byArray3[71] = 104;
        byArray3[72] = 93;
        byArray3[73] = -97;
        byArray3[74] = -108;
        byArray3[75] = -82;
        byArray3[76] = 93;
        byArray3[77] = 70;
        byArray3[78] = -127;
        byArray3[79] = -113;
        byArray3[80] = -22;
        byArray3[81] = -103;
        byArray3[82] = 35;
        byArray3[83] = -115;
        byArray3[84] = 20;
        byArray3[85] = -115;
        byArray3[86] = 63;
        byArray3[87] = 57;
        byArray3[88] = -84;
        byArray3[89] = -18;
        byArray3[90] = -107;
        byArray3[91] = 81;
        byArray3[92] = 44;
        byArray3[93] = -16;
        byArray3[94] = 83;
        byArray3[95] = 71;
        byArray3[96] = -27;
        byArray3[97] = -2;
        byArray3[98] = -125;
        byArray3[99] = 87;
        byArray3[100] = 26;
        byArray3[101] = 100;
        byArray3[102] = -116;
        byArray3[103] = 110;
        byArray3[104] = 94;
        byArray3[105] = -46;
        byArray3[106] = -56;
        byArray3[107] = -82;
        byArray3[108] = 119;
        byArray3[109] = -110;
        byArray3[110] = -127;
        byArray3[111] = -99;
        byArray3[112] = -8;
        byArray3[113] = -118;
        byArray3[114] = 90;
        byArray3[115] = 64;
        byArray3[116] = -29;
        byArray3[117] = 102;
        byArray3[118] = 99;
        byArray3[119] = 92;
        byArray3[120] = 86;
        byArray3[121] = -117;
        byArray3[122] = 26;
        byArray3[123] = -89;
        byArray3[124] = 32;
        byArray3[125] = 17;
        byArray3[126] = 55;
        byArray3[127] = -65;
        byArray3[128] = -10;
        byArray3[129] = -5;
        byArray3[130] = -74;
        byArray3[131] = 19;
        byArray3[132] = 13;
        byArray3[133] = 113;
        byArray3[134] = -15;
        byArray3[135] = -103;
        byArray3[136] = 17;
        byArray3[137] = 10;
        byArray3[138] = -127;
        byArray3[139] = -95;
        byArray3[140] = -79;
        byArray3[141] = 19;
        byArray3[142] = 11;
        byArray3[143] = -24;
        byArray3[144] = 59;
        byArray3[145] = 28;
        byArray3[146] = -70;
        byArray3[147] = -55;
        byArray3[148] = -69;
        byArray3[149] = -105;
        byArray3[150] = -20;
        byArray3[151] = -117;
        byArray3[152] = 66;
        byArray3[153] = 4;
        byArray3[154] = 77;
        byArray3[155] = 116;
        byArray3[156] = -124;
        byArray3[157] = -62;
        byArray3[158] = 19;
        byArray3[159] = 109;
        byArray3[160] = 49;
        byArray3[161] = -120;
        byArray3[162] = 10;
        byArray3[163] = -15;
        byArray3[164] = 108;
        byArray3[165] = 84;
        byArray3[166] = 126;
        byArray3[167] = 122;
        byArray3[168] = -46;
        byArray3[169] = -37;
        byArray3[170] = 114;
        byArray3[171] = -78;
        byArray3[172] = -72;
        byArray3[173] = 34;
        byArray3[174] = -12;
        byArray3[175] = 25;
        byArray3[176] = -104;
        byArray3[177] = -3;
        byArray3[178] = 114;
        byArray3[179] = -94;
        byArray3[180] = 16;
        byArray3[181] = 31;
        byArray3[182] = 31;
        byArray3[183] = -124;
        byArray3[184] = -109;
        byArray3[185] = -64;
        byArray3[186] = 57;
        byArray3[187] = -47;
        byArray3[188] = -113;
        byArray3[189] = -26;
        byArray3[190] = 97;
        byArray3[191] = -58;
        byArray3[192] = 112;
        byArray3[193] = -40;
        byArray3[194] = 49;
        byArray3[195] = 80;
        byArray3[196] = -54;
        byArray3[197] = -115;
        byArray3[198] = -98;
        byArray3[199] = -60;
        byArray3[200] = -123;
        byArray3[201] = 91;
        byArray3[202] = 14;
        byArray3[203] = 75;
        byArray3[204] = -86;
        byArray3[205] = 77;
        byArray3[206] = -93;
        byArray3[207] = 68;
        byArray3[208] = 112;
        byArray3[209] = 82;
        byArray3[210] = 79;
        byArray3[211] = 28;
        byArray3[212] = -25;
        byArray3[213] = 49;
        byArray3[214] = -27;
        byArray3[215] = -112;
        byArray3[216] = 103;
        byArray3[217] = 60;
        byArray3[218] = -128;
        byArray3[219] = 95;
        byArray3[220] = -63;
        byArray3[221] = 2;
        byArray3[222] = -51;
        byArray3[223] = 2;
        byArray3[224] = -107;
        byArray3[225] = 80;
        byArray3[226] = 113;
        byArray3[227] = 18;
        byArray3[228] = 123;
        byArray3[229] = 24;
        byArray3[230] = 70;
        byArray3[231] = 77;
        byArray3[232] = -56;
        byArray3[233] = -48;
        byArray3[234] = 33;
        byArray3[235] = 89;
        byArray3[236] = 88;
        byArray3[237] = 29;
        byArray3[238] = 112;
        byArray3[239] = -102;
        byArray3[240] = -15;
        byArray3[241] = 52;
        byArray3[242] = -96;
        byArray3[243] = 17;
        byArray3[244] = -9;
        byArray3[245] = 6;
        byArray3[246] = -11;
        byArray3[247] = -119;
        byArray3[248] = 29;
        byArray3[249] = -107;
        byArray3[250] = -84;
        byArray3[251] = -19;
        byArray3[252] = 84;
        byArray3[253] = 124;
        byArray3[254] = 19;
        byArray3[255] = 90;
        byArray3[256] = -60;
        byArray3[257] = -41;
        byArray3[258] = 123;
        byArray3[259] = -81;
        byArray3[260] = 96;
        byArray3[261] = -119;
        byArray3[262] = 17;
        byArray3[263] = -61;
        byArray3[264] = 62;
        byArray3[265] = 55;
        byArray3[266] = 95;
        byArray3[267] = -73;
        byArray3[268] = -13;
        byArray3[269] = -60;
        byArray3[270] = 56;
        byArray3[271] = 77;
        byArray3[272] = 24;
        byArray3[273] = -39;
        byArray3[274] = -107;
        byArray3[275] = -78;
        byArray3[276] = 47;
        byArray3[277] = -91;
        byArray3[278] = 88;
        byArray3[279] = 90;
        byArray3[280] = 34;
        byArray3[281] = 112;
        byArray3[282] = -80;
        byArray3[283] = 83;
        byArray3[284] = -58;
        byArray3[285] = 127;
        byArray3[286] = 76;
        byArray3[287] = -97;
        byArray3[288] = -40;
        byArray3[289] = 78;
        byArray3[290] = -20;
        byArray3[291] = -1;
        byArray3[292] = -62;
        byArray3[293] = 19;
        byArray3[294] = 6;
        byArray3[295] = -43;
        byArray3[296] = -46;
        byArray3[297] = -36;
        byArray3[298] = -53;
        byArray3[299] = -22;
        byArray3[300] = -28;
        byArray3[301] = -119;
        byArray3[302] = 8;
        byArray3[303] = 19;
        byArray3[304] = 79;
        byArray3[305] = -9;
        byArray3[306] = -54;
        byArray3[307] = -126;
        byArray3[308] = -3;
        byArray3[309] = -20;
        byArray3[310] = -110;
        byArray3[311] = -82;
        byArray3[312] = 51;
        byArray3[313] = 3;
        byArray3[314] = 1;
        byArray3[315] = -123;
        byArray3[316] = -41;
        byArray3[317] = -40;
        byArray3[318] = -11;
        byArray3[319] = 91;
        byArray3[320] = -52;
        byArray3[321] = 48;
        byArray3[322] = 104;
        byArray3[323] = -11;
        byArray3[324] = -2;
        byArray3[325] = 49;
        byArray3[326] = 45;
        byArray3[327] = 52;
        byArray3[328] = -33;
        byArray3[329] = 109;
        byArray3[330] = -44;
        byArray3[331] = -30;
        byArray3[332] = -44;
        byArray3[333] = -83;
        byArray3[334] = -108;
        byArray3[335] = -10;
        byArray3[336] = 77;
        byArray3[337] = 106;
        byArray3[338] = 82;
        byArray3[339] = 3;
        byArray3[340] = 14;
        byArray3[341] = -48;
        byArray3[342] = -18;
        byArray3[343] = -79;
        byArray3[344] = -64;
        byArray3[345] = -34;
        byArray3[346] = -63;
        byArray3[347] = -18;
        byArray3[348] = 122;
        byArray3[349] = 33;
        byArray3[350] = 25;
        byArray3[351] = 44;
        byArray3[352] = 82;
        byArray3[353] = -112;
        byArray3[354] = 111;
        byArray3[355] = 68;
        byArray3[356] = 97;
        byArray3[357] = -58;
        byArray3[358] = -38;
        byArray3[359] = 25;
        byArray3[360] = 62;
        byArray3[361] = 78;
        byArray3[362] = 97;
        byArray3[363] = -36;
        byArray3[364] = 57;
        byArray3[365] = -19;
        byArray3[366] = 122;
        byArray3[367] = -18;
        byArray3[368] = -74;
        byArray3[369] = 67;
        byArray3[370] = -127;
        byArray3[371] = -24;
        byArray3[372] = 32;
        byArray3[373] = -45;
        byArray3[374] = 67;
        byArray3[375] = -106;
        byArray3[376] = 90;
        byArray3[378] = 1;
        byArray3[379] = 91;
        byArray3[380] = 30;
        byArray3[381] = -80;
        byArray3[382] = 95;
        byArray3[383] = 9;
        byArray3[384] = 78;
        byArray3[385] = -4;
        byArray3[386] = -14;
        byArray3[387] = 16;
        byArray3[388] = 111;
        byArray3[389] = -56;
        byArray3[390] = -102;
        byArray3[391] = -90;
        byArray3[392] = 52;
        byArray3[393] = -1;
        byArray3[394] = 116;
        byArray3[395] = 19;
        byArray3[396] = -127;
        byArray3[397] = -23;
        byArray3[398] = -87;
        byArray3[399] = 103;
        byArray3[400] = -94;
        byArray3[401] = -111;
        byArray3[402] = 118;
        byArray3[403] = 53;
        byArray3[404] = -69;
        byArray3[405] = 77;
        byArray3[406] = 17;
        byArray3[407] = -3;
        byArray3[408] = 31;
        byArray3[409] = -53;
        byArray3[410] = -21;
        byArray3[411] = -78;
        byArray3[412] = 124;
        byArray3[413] = -88;
        byArray3[414] = 52;
        byArray3[415] = 117;
        byArray3[416] = 34;
        byArray3[417] = -52;
        byArray3[418] = -77;
        byArray3[419] = -107;
        byArray3[420] = -38;
        byArray3[421] = -102;
        byArray3[422] = 23;
        byArray3[423] = 73;
        byArray3[424] = -76;
        byArray3[425] = -88;
        byArray3[426] = 95;
        byArray3[427] = 64;
        byArray3[428] = -85;
        byArray3[429] = 12;
        byArray3[430] = 36;
        byArray3[431] = -86;
        byArray3[432] = 86;
        byArray3[433] = -17;
        byArray3[434] = 77;
        byArray3[435] = 121;
        byArray3[436] = 90;
        byArray3[437] = 24;
        byArray3[438] = -49;
        byArray3[439] = -107;
        byArray3[440] = 33;
        byArray3[441] = -116;
        byArray3[442] = 65;
        byArray3[443] = 13;
        byArray3[444] = 91;
        byArray3[445] = 118;
        byArray3[446] = -107;
        byArray3[447] = -21;
        byArray3[448] = 65;
        byArray3[449] = -59;
        byArray3[450] = 18;
        byArray3[451] = 125;
        byArray3[452] = 61;
        byArray3[453] = -65;
        byArray3[454] = -68;
        byArray3[455] = -19;
        byArray3[456] = 23;
        byArray3[457] = 88;
        byArray3[458] = 60;
        byArray3[459] = -6;
        byArray3[460] = 78;
        byArray3[461] = -8;
        byArray3[462] = 69;
        byArray3[463] = -62;
        byArray3[464] = -118;
        byArray3[465] = -93;
        byArray3[466] = 97;
        byArray3[467] = -64;
        byArray3[468] = -67;
        byArray3[469] = 28;
        byArray3[470] = 28;
        byArray3[471] = -87;
        byArray3[472] = -97;
        byArray3[473] = 72;
        byArray3[474] = -125;
        byArray3[475] = -119;
        byArray3[476] = 4;
        byArray3[477] = -43;
        byArray3[478] = 7;
        byArray3[479] = 22;
        byArray3[480] = -15;
        byArray3[481] = 52;
        byArray3[482] = 52;
        byArray3[483] = -82;
        byArray3[484] = -5;
        byArray3[485] = -51;
        byArray3[486] = 99;
        byArray3[487] = 20;
        byArray3[488] = -59;
        byArray3[489] = -2;
        byArray3[490] = -54;
        byArray3[491] = -67;
        byArray3[492] = 40;
        byArray3[493] = -128;
        byArray3[494] = -20;
        byArray3[495] = -37;
        byArray3[496] = 50;
        byArray3[497] = 123;
        byArray3[498] = 32;
        byArray3[499] = 8;
        byArray3[500] = -39;
        byArray3[501] = -105;
        byArray3[502] = 93;
        byArray3[503] = 73;
        byArray3[504] = 77;
        byArray3[505] = 84;
        byArray3[506] = 43;
        byArray3[507] = 89;
        byArray3[508] = 88;
        byArray3[509] = -6;
        byArray3[510] = 7;
        byArray3[511] = -108;
        byArray3[512] = 81;
        byArray3[513] = 27;
        byArray3[514] = 1;
        byArray3[515] = 50;
        byArray3[516] = 16;
        byArray3[517] = -101;
        byArray3[518] = 67;
        byArray3[519] = 95;
        byArray3[520] = 119;
        byArray3[521] = 105;
        byArray3[522] = 70;
        byArray3[523] = 99;
        byArray3[524] = -127;
        byArray3[525] = 22;
        byArray3[526] = 127;
        byArray3[527] = -33;
        byArray3[528] = -19;
        byArray3[529] = -113;
        byArray3[530] = -55;
        byArray3[531] = -100;
        byArray3[532] = 122;
        byArray3[533] = -86;
        byArray3[534] = 98;
        byArray3[535] = 53;
        byArray3[536] = 27;
        byArray3[537] = -95;
        byArray3[538] = 4;
        byArray3[539] = -121;
        byArray3[540] = -96;
        byArray3[541] = 87;
        byArray3[542] = 67;
        byArray3[543] = -98;
        byArray3[544] = -37;
        byArray3[545] = -10;
        byArray3[546] = 92;
        byArray3[547] = 29;
        byArray3[548] = -3;
        byArray3[549] = -115;
        byArray3[550] = -23;
        byArray3[551] = 37;
        byArray3[552] = 8;
        byArray3[553] = -30;
        byArray3[554] = 99;
        byArray3[555] = -117;
        byArray3[556] = 62;
        byArray3[557] = 101;
        byArray3[558] = 83;
        byArray3[559] = 49;
        byArray3[560] = 60;
        byArray3[561] = -83;
        byArray3[562] = -47;
        byArray3[563] = -33;
        byArray3[564] = 41;
        byArray3[565] = -118;
        byArray3[566] = 76;
        byArray3[567] = -7;
        byArray3[568] = 111;
        byArray3[569] = -15;
        byArray3[570] = 123;
        byArray3[571] = -59;
        byArray3[572] = 53;
        byArray3[573] = 2;
        byArray3[574] = -20;
        byArray3[575] = -57;
        byArray3[576] = 24;
        byArray3[577] = 57;
        byArray3[578] = 62;
        byArray3[579] = 84;
        byArray3[580] = -26;
        byArray3[581] = -11;
        byArray3[582] = 93;
        byArray3[583] = -118;
        byArray3[584] = 54;
        byArray3[585] = -13;
        byArray3[586] = 56;
        byArray3[587] = 77;
        byArray3[588] = -66;
        byArray3[589] = 18;
        byArray3[590] = -62;
        byArray3[591] = -76;
        byArray3[592] = 80;
        byArray3[593] = 98;
        byArray3[594] = 26;
        byArray3[595] = 120;
        byArray3[596] = -93;
        byArray3[597] = 55;
        byArray3[598] = 103;
        byArray3[599] = -1;
        byArray3[600] = 78;
        byArray3[601] = -92;
        byArray3[602] = 120;
        byArray3[603] = -23;
        byArray3[604] = -60;
        byArray3[605] = -75;
        byArray3[606] = 11;
        byArray3[607] = 53;
        byArray3[608] = -62;
        byArray3[609] = -94;
        byArray3[610] = -80;
        byArray3[611] = 120;
        byArray3[612] = 113;
        byArray3[613] = 33;
        byArray3[614] = -24;
        byArray3[615] = -64;
        byArray3[616] = -5;
        byArray3[617] = 23;
        byArray3[618] = 120;
        byArray3[619] = -14;
        byArray3[620] = 61;
        byArray3[621] = 26;
        byArray3[622] = -1;
        byArray3[623] = 56;
        byArray3[624] = 79;
        byArray3[625] = 34;
        byArray3[626] = 116;
        byArray3[627] = -16;
        byArray3[628] = -95;
        byArray3[629] = -71;
        byArray3[630] = 40;
        byArray3[631] = -89;
        byArray3[632] = -50;
        byArray3[633] = 71;
        byArray3[634] = -117;
        byArray3[635] = -109;
        byArray3[636] = 2;
        byArray3[637] = -2;
        byArray3[638] = -34;
        byArray3[639] = 94;
        byArray3[640] = -78;
        byArray3[641] = -88;
        byArray3[642] = -27;
        byArray3[643] = 70;
        byArray3[644] = 94;
        byArray3[645] = -86;
        byArray3[646] = 123;
        byArray3[647] = -49;
        byArray3[648] = 107;
        byArray3[649] = -65;
        byArray3[650] = -67;
        byArray3[651] = 84;
        byArray3[652] = 90;
        byArray3[653] = 123;
        byArray3[654] = -61;
        byArray3[655] = -2;
        byArray3[656] = 43;
        byArray3[657] = -119;
        byArray3[658] = -93;
        byArray3[659] = 75;
        byArray3[660] = -4;
        byArray3[661] = -81;
        byArray3[662] = 98;
        byArray3[663] = -36;
        byArray3[664] = 125;
        byArray3[665] = -23;
        byArray3[666] = -37;
        byArray3[667] = 81;
        byArray3[668] = 104;
        byArray3[669] = 90;
        byArray3[670] = -63;
        byArray3[671] = -52;
        byArray3[672] = 88;
        byArray3[673] = -96;
        byArray3[674] = -44;
        byArray3[675] = 25;
        byArray3[676] = 3;
        byArray3[677] = -37;
        byArray3[678] = -123;
        byArray3[679] = -48;
        byArray3[680] = 113;
        byArray3[681] = -76;
        byArray3[682] = -94;
        byArray3[683] = -109;
        byArray3[684] = -115;
        byArray3[685] = 37;
        byArray3[686] = -39;
        byArray3[687] = 104;
        byArray3[688] = -124;
        byArray3[689] = 82;
        byArray3[690] = -73;
        byArray3[691] = 100;
        byArray3[692] = 48;
        byArray3[693] = -54;
        byArray3[694] = -40;
        byArray3[695] = -65;
        byArray3[696] = 81;
        byArray3[697] = 16;
        byArray3[698] = -85;
        byArray3[699] = -41;
        byArray3[700] = 60;
        byArray3[701] = 42;
        byArray3[702] = 117;
        byArray3[703] = 65;
        byArray3[704] = 77;
        byArray3[705] = 14;
        byArray3[706] = -8;
        byArray3[707] = -56;
        byArray3[708] = 52;
        byArray3[709] = -118;
        byArray3[710] = -109;
        byArray3[711] = 125;
        byArray3[712] = 13;
        byArray3[713] = 64;
        byArray3[714] = -20;
        byArray3[715] = 125;
        byArray3[716] = -37;
        byArray3[717] = -74;
        byArray3[718] = -28;
        byArray3[719] = 118;
        byArray3[720] = 112;
        byArray3[721] = -126;
        byArray3[722] = 18;
        byArray3[723] = -101;
        byArray3[724] = 11;
        byArray3[725] = 75;
        byArray3[726] = 30;
        byArray3[727] = -4;
        byArray3[728] = -121;
        byArray3[729] = -13;
        byArray3[730] = -65;
        byArray3[731] = -13;
        byArray3[732] = -122;
        byArray3[733] = -53;
        byArray3[734] = -52;
        byArray3[735] = 20;
        byArray3[736] = -2;
        byArray3[737] = 67;
        byArray3[738] = 18;
        byArray3[739] = -106;
        byArray3[740] = 67;
        byArray3[741] = 83;
        byArray3[742] = -111;
        byArray3[743] = 15;
        byArray3[744] = 106;
        byArray3[745] = 10;
        byArray3[746] = 113;
        byArray3[747] = 53;
        byArray3[748] = -112;
        byArray3[749] = -3;
        byArray3[750] = 118;
        byArray3[751] = 8;
        byArray3[752] = -56;
        byArray3[753] = 40;
        byArray3[754] = 53;
        byArray3[755] = 23;
        byArray3[756] = -123;
        byArray3[757] = 96;
        byArray3[758] = 87;
        byArray3[759] = -118;
        byArray3[760] = -97;
        byArray3[761] = -116;
        byArray3[762] = -47;
        byArray3[763] = 85;
        byArray3[764] = -73;
        byArray3[765] = -85;
        byArray3[766] = -82;
        byArray3[767] = 124;
        byArray3[768] = -55;
        byArray3[769] = 55;
        byArray3[770] = 61;
        byArray3[771] = 46;
        byArray3[772] = 12;
        byArray3[773] = -6;
        byArray3[774] = 34;
        byArray3[775] = 22;
        byArray3[776] = -22;
        byArray3[777] = 3;
        byArray3[778] = 115;
        byArray3[779] = -49;
        byArray3[780] = 102;
        byArray3[781] = 23;
        byArray3[782] = 46;
        byArray3[783] = 39;
        byArray3[785] = 118;
        byArray3[786] = 3;
        byArray3[787] = -45;
        byArray3[788] = 48;
        byArray3[789] = -73;
        byArray3[790] = -38;
        byArray3[791] = 29;
        byArray3[792] = -36;
        byArray3[793] = 11;
        byArray3[794] = -127;
        byArray3[795] = -86;
        byArray3[796] = 30;
        byArray3[797] = 29;
        byArray3[798] = -2;
        byArray3[799] = -108;
        byArray3[800] = -114;
        byArray3[801] = 64;
        byArray3[802] = 110;
        byArray3[803] = 86;
        byArray3[804] = -46;
        byArray3[805] = -91;
        byArray3[806] = -64;
        byArray3[807] = 95;
        byArray3[808] = -40;
        byArray3[809] = -65;
        byArray3[810] = 49;
        byArray3[811] = -79;
        byArray3[812] = -126;
        byArray3[813] = -37;
        byArray3[814] = -103;
        byArray3[815] = -71;
        byArray3[816] = 53;
        byArray3[817] = -85;
        byArray3[818] = 45;
        byArray3[819] = -51;
        byArray3[820] = 33;
        byArray3[821] = -28;
        byArray3[822] = -126;
        byArray3[823] = 36;
        byArray3[824] = -77;
        byArray3[825] = -120;
        byArray3[826] = 55;
        byArray3[827] = -54;
        byArray3[828] = 72;
        byArray3[829] = -21;
        byArray3[830] = 58;
        byArray3[831] = -87;
        byArray3[832] = -73;
        byArray3[833] = 18;
        byArray3[834] = -12;
        byArray3[835] = 20;
        byArray3[836] = -100;
        byArray3[837] = 30;
        byArray3[838] = 118;
        byArray3[839] = -83;
        byArray3[840] = -22;
        byArray3[841] = -90;
        byArray3[842] = 71;
        byArray3[843] = -64;
        byArray3[844] = 108;
        byArray3[845] = 101;
        byArray3[846] = -46;
        byArray3[847] = 36;
        byArray3[848] = 105;
        byArray3[849] = -46;
        byArray3[850] = -91;
        byArray3[851] = 60;
        byArray3[852] = -113;
        byArray3[853] = 72;
        byArray3[854] = 100;
        byArray3[855] = 82;
        byArray3[856] = -90;
        byArray3[857] = 106;
        byArray3[858] = -127;
        byArray3[859] = 65;
        byArray3[860] = -94;
        byArray3[861] = 17;
        byArray3[862] = 77;
        byArray3[863] = -10;
        byArray3[864] = -112;
        byArray3[865] = 46;
        byArray3[866] = 118;
        byArray3[867] = 72;
        byArray3[868] = -84;
        byArray3[869] = 57;
        byArray3[870] = -86;
        byArray3[871] = -114;
        byArray3[872] = 88;
        byArray3[873] = 91;
        byArray3[874] = 79;
        byArray3[875] = 30;
        byArray3[876] = 107;
        byArray3[877] = -35;
        byArray3[878] = 61;
        byArray3[879] = 81;
        byArray3[880] = 71;
        byArray3[881] = 40;
        byArray3[882] = -29;
        byArray3[883] = -6;
        byArray3[884] = -107;
        byArray3[885] = 61;
        byArray3[886] = -62;
        byArray3[887] = -6;
        byArray3[888] = 65;
        byArray3[889] = -68;
        byArray3[890] = 118;
        byArray3[891] = 61;
        byArray3[892] = 110;
        byArray3[893] = -115;
        byArray3[894] = -119;
        byArray3[895] = -73;
        byArray3[896] = 104;
        byArray3[897] = 59;
        byArray3[898] = -66;
        byArray3[899] = -89;
        byArray3[900] = -127;
        byArray3[901] = -8;
        byArray3[902] = -67;
        byArray3[903] = 122;
        byArray3[904] = -38;
        byArray3[905] = 79;
        byArray3[906] = -13;
        byArray3[907] = 93;
        byArray3[908] = 1;
        byArray3[909] = -32;
        byArray3[910] = -47;
        byArray3[911] = -3;
        byArray3[912] = 62;
        byArray3[913] = 88;
        byArray3[914] = -112;
        byArray3[915] = 105;
        byArray3[916] = 73;
        byArray3[917] = 96;
        byArray3[918] = 73;
        byArray3[919] = -104;
        byArray3[920] = -126;
        byArray3[921] = -69;
        byArray3[922] = 21;
        byArray3[923] = -22;
        byArray3[924] = 16;
        byArray3[925] = -85;
        byArray3[926] = 116;
        byArray3[927] = 9;
        byArray3[928] = 82;
        byArray3[929] = 54;
        byArray3[930] = -15;
        byArray3[931] = -55;
        byArray3[932] = -67;
        byArray3[933] = 68;
        byArray3[934] = -23;
        byArray3[935] = 16;
        byArray3[936] = -89;
        byArray3[937] = 48;
        byArray3[938] = -17;
        byArray3[939] = -107;
        byArray3[940] = 60;
        byArray3[941] = -43;
        byArray3[942] = -34;
        byArray3[943] = 66;
        byArray3[944] = -114;
        byArray3[945] = 63;
        byArray3[946] = -3;
        byArray3[947] = -26;
        byArray3[948] = 68;
        byArray3[949] = 68;
        byArray3[950] = -86;
        byArray3[951] = 120;
        byArray3[952] = -111;
        byArray3[953] = 99;
        byArray3[954] = 61;
        byArray3[955] = 101;
        byArray3[956] = 27;
        byArray3[957] = 93;
        byArray3[958] = 31;
        byArray3[959] = 90;
        byArray3[960] = -33;
        byArray3[961] = -94;
        byArray3[962] = 29;
        byArray3[963] = -89;
        byArray3[964] = 41;
        byArray3[965] = -80;
        byArray3[966] = 26;
        byArray3[967] = -23;
        byArray3[968] = -80;
        byArray3[969] = 27;
        byArray3[970] = 107;
        byArray3[971] = 69;
        byArray3[972] = -45;
        byArray3[973] = -123;
        byArray3[974] = 62;
        byArray3[975] = 63;
        byArray3[976] = 80;
        byArray3[977] = 1;
        byArray3[978] = -28;
        byArray3[979] = 52;
        byArray3[980] = -8;
        byArray3[981] = 35;
        byArray3[982] = -86;
        byArray3[983] = -127;
        byArray3[984] = 76;
        byArray3[985] = 102;
        byArray3[986] = 83;
        byArray3[987] = -104;
        byArray3[988] = -79;
        byArray3[989] = -98;
        byArray3[990] = 77;
        byArray3[991] = -28;
        byArray3[992] = 118;
        byArray3[993] = 18;
        byArray3[994] = -15;
        byArray3[995] = -98;
        byArray3[996] = -39;
        byArray3[997] = 2;
        byArray3[998] = -58;
        byArray3[999] = 95;
        byArray3[1000] = 64;
        byArray3[1001] = 105;
        byArray3[1002] = -82;
        byArray3[1003] = -7;
        byArray3[1004] = 96;
        byArray3[1005] = 110;
        byArray3[1006] = 104;
        byArray3[1007] = 127;
        byArray3[1008] = 126;
        byArray3[1009] = -124;
        byArray3[1010] = 26;
        byArray3[1011] = 36;
        byArray3[1012] = 33;
        byArray3[1013] = -42;
        byArray3[1014] = 59;
        byArray3[1015] = 82;
        byArray3[1016] = 127;
        byArray3[1017] = 42;
        byArray3[1018] = -24;
        byArray3[1019] = -61;
        byArray3[1020] = -50;
        byArray3[1021] = -18;
        byArray3[1022] = -87;
        byArray3[1023] = 22;
        byArray3[1024] = -32;
        byArray3[1025] = -125;
        byArray3[1026] = -70;
        byArray3[1027] = 103;
        byArray3[1028] = -121;
        byArray3[1029] = -112;
        byArray3[1030] = -94;
        byArray3[1031] = 58;
        byArray3[1032] = -95;
        byArray3[1033] = -97;
        byArray3[1034] = 53;
        byArray3[1035] = 95;
        byArray3[1036] = -61;
        byArray3[1037] = -83;
        byArray3[1038] = 42;
        byArray3[1039] = 37;
        byArray3[1040] = 80;
        byArray3[1041] = 51;
        byArray3[1042] = -118;
        byArray3[1043] = 125;
        byArray3[1044] = 15;
        byArray3[1045] = 67;
        byArray3[1046] = 41;
        byArray3[1047] = -97;
        byArray3[1048] = 41;
        byArray3[1049] = -121;
        byArray3[1050] = 29;
        byArray3[1051] = -88;
        byArray3[1052] = 100;
        byArray3[1053] = -113;
        byArray3[1054] = 39;
        byArray3[1055] = 101;
        byArray3[1056] = 47;
        byArray3[1057] = 91;
        byArray3[1058] = -36;
        byArray3[1059] = 48;
        byArray3[1060] = -56;
        byArray3[1061] = -13;
        byArray3[1062] = 12;
        byArray3[1063] = 37;
        byArray3[1065] = 81;
        byArray3[1066] = 3;
        byArray3[1067] = -40;
        byArray3[1068] = 8;
        byArray3[1069] = 36;
        byArray3[1070] = -65;
        byArray3[1071] = -11;
        byArray3[1072] = -32;
        byArray3[1073] = 108;
        byArray3[1074] = 62;
        byArray3[1075] = 79;
        byArray3[1076] = 70;
        byArray3[1077] = 91;
        byArray3[1078] = -83;
        byArray3[1079] = 2;
        byArray3[1080] = -47;
        byArray3[1082] = 91;
        byArray3[1083] = 10;
        byArray3[1084] = 87;
        byArray3[1085] = -19;
        byArray3[1086] = -40;
        byArray3[1087] = 96;
        byArray3[1088] = 106;
        byArray3[1089] = 41;
        byArray3[1090] = 120;
        byArray3[1091] = -53;
        byArray3[1092] = 40;
        byArray3[1093] = -114;
        byArray3[1094] = 90;
        byArray3[1095] = 64;
        byArray3[1096] = 59;
        byArray3[1097] = -115;
        byArray3[1098] = 39;
        byArray3[1099] = 2;
        byArray3[1100] = 53;
        byArray3[1101] = -49;
        byArray3[1102] = -72;
        byArray3[1103] = -114;
        byArray3[1104] = 94;
        byArray3[1105] = 5;
        byArray3[1106] = 49;
        byArray3[1107] = 74;
        byArray3[1108] = 13;
        byArray3[1109] = 50;
        byArray3[1110] = -14;
        byArray3[1111] = 76;
        byArray3[1112] = -123;
        byArray3[1113] = -11;
        byArray3[1114] = -81;
        byArray3[1115] = 100;
        byArray3[1116] = 120;
        byArray3[1117] = 16;
        byArray3[1118] = -41;
        byArray3[1119] = -72;
        byArray3[1120] = -118;
        byArray3[1121] = 28;
        byArray3[1122] = 41;
        byArray3[1123] = 98;
        byArray3[1124] = 122;
        byArray3[1125] = 27;
        byArray3[1126] = 18;
        byArray3[1127] = -108;
        byArray3[1128] = -43;
        byArray3[1129] = 51;
        byArray3[1130] = -71;
        byArray3[1131] = 93;
        byArray3[1132] = -13;
        byArray3[1133] = -42;
        byArray3[1134] = -64;
        byArray3[1135] = -118;
        byArray3[1136] = -106;
        byArray3[1137] = 45;
        byArray3[1138] = 108;
        byArray3[1139] = 72;
        byArray3[1140] = -128;
        byArray3[1141] = 58;
        byArray3[1142] = -123;
        byArray3[1143] = -29;
        byArray3[1144] = -114;
        byArray3[1145] = 15;
        byArray3[1146] = 52;
        byArray3[1147] = -72;
        byArray3[1148] = 108;
        byArray3[1149] = -62;
        byArray3[1150] = 75;
        byArray3[1151] = -15;
        byArray3[1152] = 105;
        byArray3[1153] = -89;
        byArray3[1154] = 25;
        byArray3[1155] = 37;
        byArray3[1156] = 13;
        byArray3[1157] = -21;
        byArray3[1158] = -109;
        byArray3[1159] = 68;
        byArray3[1160] = 5;
        byArray3[1161] = -89;
        byArray3[1162] = 69;
        byArray3[1163] = 10;
        byArray3[1164] = -46;
        byArray3[1165] = 18;
        byArray3[1166] = -57;
        byArray3[1167] = 77;
        byArray3[1168] = -103;
        byArray3[1169] = -74;
        byArray3[1170] = 57;
        byArray3[1171] = -43;
        byArray3[1172] = -110;
        byArray3[1173] = 1;
        byArray3[1174] = -80;
        byArray3[1175] = 82;
        byArray3[1176] = 5;
        byArray3[1177] = -9;
        byArray3[1178] = -49;
        byArray3[1179] = -53;
        byArray3[1180] = 83;
        byArray3[1181] = 4;
        byArray3[1182] = 44;
        byArray3[1183] = 64;
        byArray3[1184] = -117;
        byArray3[1185] = -67;
        byArray3[1186] = -11;
        byArray3[1187] = 1;
        byArray3[1188] = -65;
        byArray3[1189] = -81;
        byArray3[1190] = 34;
        byArray3[1191] = -23;
        byArray3[1192] = -71;
        byArray3[1193] = 14;
        byArray3[1194] = 105;
        byArray3[1195] = -93;
        byArray3[1196] = 2;
        byArray3[1197] = -120;
        byArray3[1198] = 90;
        byArray3[1199] = 92;
        byArray3[1200] = -6;
        byArray3[1201] = -128;
        byArray3[1202] = -16;
        byArray3[1203] = -51;
        byArray3[1204] = 27;
        byArray3[1205] = 123;
        byArray3[1206] = 71;
        byArray3[1207] = -117;
        byArray3[1208] = -72;
        byArray3[1209] = -81;
        byArray3[1210] = 26;
        byArray3[1211] = 28;
        byArray3[1212] = 5;
        byArray3[1213] = -117;
        byArray3[1214] = -30;
        byArray3[1215] = 22;
        byArray3[1216] = -72;
        byArray3[1217] = -76;
        byArray3[1218] = -32;
        byArray3[1219] = -14;
        byArray3[1220] = 82;
        byArray3[1221] = 90;
        byArray3[1222] = 69;
        byArray3[1223] = 74;
        byArray3[1224] = -94;
        byArray3[1225] = -72;
        byArray3[1226] = -30;
        byArray3[1227] = -17;
        byArray3[1228] = 12;
        byArray3[1229] = -37;
        byArray3[1230] = -3;
        byArray3[1231] = -80;
        byArray3[1232] = 72;
        byArray3[1233] = 2;
        byArray3[1234] = -40;
        byArray3[1235] = 41;
        byArray3[1237] = -53;
        byArray3[1238] = 48;
        byArray3[1239] = -37;
        byArray3[1240] = -117;
        byArray3[1241] = -128;
        byArray3[1242] = -120;
        byArray3[1243] = -80;
        byArray3[1244] = 28;
        byArray3[1245] = 49;
        byArray3[1246] = -52;
        byArray3[1247] = 114;
        byArray3[1248] = -119;
        byArray3[1249] = 92;
        byArray3[1250] = -42;
        byArray3[1251] = -105;
        byArray3[1252] = 125;
        byArray3[1253] = -95;
        byArray3[1254] = 78;
        byArray3[1255] = 76;
        byArray3[1256] = 123;
        byArray3[1257] = -56;
        byArray3[1258] = 32;
        byArray3[1259] = -66;
        byArray3[1260] = 69;
        byArray3[1261] = -58;
        byArray3[1262] = 57;
        byArray3[1263] = -77;
        byArray3[1264] = -100;
        byArray3[1265] = -70;
        byArray3[1266] = 125;
        byArray3[1267] = 53;
        byArray3[1268] = -115;
        byArray3[1269] = 8;
        byArray3[1270] = 116;
        byArray3[1271] = 88;
        byArray3[1272] = -34;
        byArray3[1273] = 86;
        byArray3[1274] = -75;
        byArray3[1275] = 55;
        byArray3[1276] = 64;
        byArray3[1277] = 79;
        byArray3[1278] = -113;
        byArray3[1279] = -124;
        byArray3[1280] = -91;
        byArray3[1281] = 50;
        byArray3[1282] = -82;
        byArray3[1283] = -119;
        byArray3[1284] = 50;
        byArray3[1285] = 11;
        byArray3[1286] = 87;
        byArray3[1287] = -14;
        byArray3[1288] = -25;
        byArray3[1289] = 15;
        byArray3[1290] = -1;
        byArray3[1291] = -49;
        byArray3[1292] = -127;
        byArray3[1293] = -5;
        byArray3[1294] = -50;
        byArray3[1295] = 72;
        byArray3[1296] = -29;
        byArray3[1297] = -78;
        byArray3[1298] = 101;
        byArray3[1299] = -119;
        byArray3[1300] = -21;
        byArray3[1301] = -15;
        byArray3[1302] = 97;
        byArray3[1303] = -63;
        byArray3[1304] = 57;
        byArray3[1305] = -123;
        byArray3[1306] = -94;
        byArray3[1307] = -24;
        byArray3[1308] = -8;
        byArray3[1309] = 104;
        byArray3[1310] = 86;
        byArray3[1311] = 79;
        byArray3[1312] = 49;
        byArray3[1313] = 102;
        byArray3[1314] = -8;
        byArray3[1315] = -76;
        byArray3[1316] = 8;
        byArray3[1317] = 69;
        byArray3[1318] = 99;
        byArray3[1319] = -64;
        byArray3[1320] = -108;
        byArray3[1321] = 70;
        byArray3[1322] = 36;
        byArray3[1323] = 71;
        byArray3[1324] = -127;
        byArray3[1325] = 56;
        byArray3[1326] = 39;
        byArray3[1327] = 78;
        byArray3[1328] = 109;
        byArray3[1329] = 42;
        byArray3[1330] = -42;
        byArray3[1331] = -2;
        byArray3[1332] = 126;
        byArray3[1333] = 17;
        byArray3[1334] = -88;
        byArray3[1335] = -65;
        byArray3[1336] = -23;
        byArray3[1337] = -64;
        byArray3[1338] = 78;
        byArray3[1339] = 87;
        byArray3[1340] = 7;
        byArray3[1341] = 6;
        byArray3[1342] = -82;
        byArray3[1343] = -98;
        byArray3[1344] = 41;
        byArray3[1345] = -46;
        byArray3[1346] = -10;
        byArray3[1347] = -25;
        byArray3[1348] = 90;
        byArray3[1349] = -73;
        byArray3[1350] = 24;
        byArray3[1351] = 127;
        byArray3[1352] = -27;
        byArray3[1353] = 118;
        byArray3[1354] = -9;
        byArray3[1355] = 81;
        byArray3[1356] = -3;
        byArray3[1357] = 115;
        byArray3[1358] = -4;
        byArray3[1359] = 47;
        byArray3[1360] = 86;
        byArray3[1361] = -30;
        byArray3[1362] = -9;
        byArray3[1363] = -50;
        byArray3[1364] = 32;
        byArray3[1365] = 86;
        byArray3[1366] = 114;
        byArray3[1367] = 58;
        byArray3[1368] = -5;
        byArray3[1369] = 78;
        byArray3[1370] = 74;
        byArray3[1371] = 36;
        byArray3[1372] = 29;
        byArray3[1373] = -126;
        byArray3[1374] = 116;
        byArray3[1375] = 117;
        byArray3[1376] = -114;
        byArray3[1377] = -92;
        byArray3[1378] = -121;
        byArray3[1379] = -36;
        byArray3[1380] = -86;
        byArray3[1381] = -18;
        byArray3[1382] = 55;
        byArray3[1383] = 49;
        byArray3[1384] = 112;
        byArray3[1385] = 43;
        byArray3[1386] = 111;
        byArray3[1387] = -99;
        byArray3[1388] = -116;
        byArray3[1389] = 70;
        byArray3[1390] = 60;
        byArray3[1391] = -63;
        byArray3[1392] = 87;
        byArray3[1393] = -4;
        byArray3[1394] = -35;
        byArray3[1395] = 15;
        byArray3[1396] = 28;
        byArray3[1397] = -27;
        byArray3[1398] = -65;
        byArray3[1399] = 66;
        byArray3[1400] = 115;
        byArray3[1401] = -33;
        byArray3[1402] = 112;
        byArray3[1403] = 94;
        byArray3[1404] = 74;
        byArray3[1405] = -22;
        byArray3[1406] = 104;
        byArray3[1407] = -56;
        byArray3[1408] = -27;
        byArray3[1409] = 39;
        byArray3[1410] = -8;
        byArray3[1411] = -53;
        byArray3[1412] = -120;
        byArray3[1413] = 8;
        byArray3[1414] = -109;
        byArray3[1415] = 73;
        byArray3[1416] = -68;
        byArray3[1417] = 67;
        byArray3[1418] = 40;
        byArray3[1419] = -59;
        byArray3[1420] = 59;
        byArray3[1421] = 121;
        byArray3[1422] = -76;
        byArray3[1423] = -41;
        byArray3[1424] = -80;
        byArray3[1425] = -54;
        byArray3[1426] = -88;
        byArray3[1427] = -120;
        byArray3[1428] = -121;
        byArray3[1429] = -118;
        byArray3[1430] = -58;
        byArray3[1431] = 74;
        byArray3[1432] = -120;
        byArray3[1433] = 82;
        byArray3[1434] = -88;
        byArray3[1435] = -113;
        byArray3[1436] = 30;
        byArray3[1437] = -8;
        byArray3[1438] = 54;
        byArray3[1439] = -126;
        byArray3[1440] = -106;
        byArray3[1441] = 37;
        byArray3[1442] = -43;
        byArray3[1443] = -74;
        byArray3[1444] = -56;
        byArray3[1445] = 40;
        byArray3[1446] = -76;
        byArray3[1447] = 93;
        byArray3[1448] = 91;
        byArray3[1449] = 28;
        byArray3[1450] = -59;
        byArray3[1451] = -30;
        byArray3[1452] = -2;
        byArray3[1453] = 107;
        byArray3[1454] = 6;
        byArray3[1455] = -89;
        byArray3[1456] = -69;
        byArray3[1457] = -121;
        byArray3[1458] = -125;
        byArray3[1459] = -109;
        byArray3[1460] = 5;
        byArray3[1461] = -94;
        byArray3[1462] = -7;
        byArray3[1463] = -2;
        byArray3[1464] = -5;
        byArray3[1465] = -67;
        byArray3[1466] = 54;
        byArray3[1467] = -90;
        byArray3[1468] = 39;
        byArray3[1469] = 5;
        byArray3[1470] = -80;
        byArray3[1471] = 93;
        byArray3[1472] = -99;
        byArray3[1473] = 82;
        byArray3[1474] = -100;
        byArray3[1475] = -128;
        byArray3[1476] = -8;
        byArray3[1477] = -39;
        byArray3[1478] = -109;
        byArray3[1479] = 66;
        byArray3[1480] = -11;
        byArray3[1481] = 99;
        byArray3[1482] = -41;
        byArray3[1483] = 18;
        byArray3[1484] = -32;
        byArray3[1485] = -122;
        byArray3[1486] = 69;
        byArray3[1487] = 6;
        byArray3[1488] = -95;
        byArray3[1489] = -21;
        byArray3[1490] = 9;
        byArray3[1491] = 19;
        byArray3[1492] = -117;
        byArray3[1493] = -34;
        byArray3[1494] = -42;
        byArray3[1495] = 11;
        byArray3[1496] = 20;
        byArray3[1497] = 84;
        byArray3[1498] = 89;
        byArray3[1499] = 91;
        byArray3[1500] = -61;
        byArray3[1501] = -13;
        byArray3[1502] = -7;
        byArray3[1503] = 55;
        byArray3[1504] = 90;
        byArray3[1505] = -15;
        byArray3[1506] = 62;
        byArray3[1507] = 59;
        byArray3[1508] = -4;
        byArray3[1509] = 125;
        byArray3[1510] = -127;
        byArray3[1511] = -24;
        byArray3[1512] = -124;
        byArray3[1513] = -99;
        byArray3[1514] = -63;
        byArray3[1515] = -23;
        byArray3[1516] = 52;
        byArray3[1517] = 111;
        byArray3[1518] = -52;
        byArray3[1519] = -60;
        byArray3[1520] = -113;
        byArray3[1521] = -65;
        byArray3[1522] = -26;
        byArray3[1523] = 127;
        byArray3[1524] = 57;
        byArray3[1525] = 21;
        byArray3[1526] = 102;
        byArray3[1527] = 101;
        byArray3[1528] = -77;
        byArray3[1529] = 66;
        byArray3[1530] = -116;
        byArray3[1531] = 117;
        byArray3[1532] = 80;
        byArray3[1533] = 7;
        byArray3[1534] = 1;
        byArray3[1535] = -96;
        byArray3[1536] = -29;
        byArray3[1537] = -99;
        byArray3[1538] = 75;
        byArray3[1539] = -73;
        byArray3[1540] = 44;
        byArray3[1541] = -99;
        byArray3[1542] = 61;
        byArray3[1543] = -73;
        byArray3[1544] = 15;
        byArray3[1545] = -18;
        byArray3[1546] = 89;
        byArray3[1547] = 95;
        byArray3[1548] = 104;
        byArray3[1549] = -12;
        byArray3[1550] = 94;
        byArray3[1551] = 33;
        byArray3[1552] = 13;
        byArray3[1553] = -49;
        byArray3[1554] = 118;
        byArray3[1555] = -84;
        byArray3[1556] = -122;
        byArray3[1557] = -2;
        byArray3[1558] = -121;
        byArray3[1559] = 62;
        byArray3[1560] = -32;
        byArray3[1561] = -80;
        byArray3[1562] = 11;
        byArray3[1563] = -10;
        byArray3[1564] = 102;
        byArray3[1565] = -67;
        byArray3[1566] = 20;
        byArray3[1567] = -3;
        byArray3[1568] = 25;
        byArray3[1569] = -6;
        byArray3[1570] = 51;
        byArray3[1571] = -17;
        byArray3[1572] = -123;
        byArray3[1573] = -76;
        byArray3[1574] = 103;
        byArray3[1575] = 3;
        byArray3[1576] = 127;
        byArray3[1577] = -107;
        byArray3[1578] = -5;
        byArray3[1579] = 122;
        byArray3[1580] = 65;
        byArray3[1581] = 22;
        byArray3[1582] = 113;
        byArray3[1583] = 120;
        byArray3[1584] = 6;
        byArray3[1585] = -19;
        byArray3[1586] = -110;
        byArray3[1587] = 86;
        byArray3[1588] = 55;
        byArray3[1589] = -88;
        byArray3[1590] = -124;
        byArray3[1592] = -54;
        byArray3[1593] = 17;
        byArray3[1594] = 112;
        byArray3[1595] = 15;
        byArray3[1596] = 105;
        byArray3[1597] = -28;
        byArray3[1598] = 111;
        byArray3[1599] = -93;
        byArray3[1600] = 85;
        byArray3[1601] = -59;
        byArray3[1602] = -88;
        byArray3[1603] = 28;
        byArray3[1604] = 123;
        byArray3[1605] = 55;
        byArray3[1606] = 117;
        byArray3[1607] = 10;
        byArray3[1608] = 76;
        byArray3[1609] = 54;
        byArray3[1610] = -98;
        byArray3[1611] = 116;
        byArray3[1612] = 40;
        byArray3[1613] = -65;
        byArray3[1614] = -53;
        byArray3[1615] = -80;
        byArray3[1616] = 46;
        byArray3[1617] = 66;
        byArray3[1618] = -8;
        byArray3[1619] = -114;
        byArray3[1620] = 102;
        byArray3[1621] = 66;
        byArray3[1622] = 67;
        byArray3[1623] = -117;
        byArray3[1624] = 46;
        byArray3[1625] = 21;
        byArray3[1626] = -116;
        byArray3[1627] = -38;
        byArray3[1628] = 58;
        byArray3[1629] = -105;
        byArray3[1630] = 101;
        byArray3[1631] = 37;
        byArray3[1632] = -16;
        byArray3[1633] = 5;
        byArray3[1634] = 55;
        byArray3[1635] = -33;
        byArray3[1636] = -87;
        byArray3[1637] = 72;
        byArray3[1638] = 122;
        byArray3[1639] = -114;
        byArray3[1640] = -91;
        byArray3[1641] = 41;
        byArray3[1642] = -114;
        byArray3[1643] = 77;
        byArray3[1644] = 50;
        byArray3[1645] = 109;
        byArray3[1646] = 35;
        byArray3[1647] = -61;
        byArray3[1648] = 9;
        byArray3[1649] = -55;
        byArray3[1650] = -118;
        byArray3[1651] = 126;
        byArray3[1652] = -35;
        byArray3[1653] = -108;
        byArray3[1654] = 5;
        byArray3[1655] = 62;
        byArray3[1656] = 125;
        byArray3[1657] = -109;
        byArray3[1658] = -115;
        byArray3[1659] = -55;
        byArray3[1660] = 32;
        byArray3[1661] = -71;
        byArray3[1662] = 69;
        byArray3[1663] = 110;
        byArray3[1664] = 87;
        byArray3[1665] = -82;
        byArray3[1666] = 119;
        byArray3[1667] = 26;
        byArray3[1668] = 103;
        byArray3[1669] = -77;
        byArray3[1670] = -38;
        byArray3[1671] = -13;
        byArray3[1672] = 113;
        byArray3[1673] = 74;
        byArray3[1674] = 69;
        byArray3[1675] = 116;
        byArray3[1676] = 94;
        byArray3[1677] = -21;
        byArray3[1678] = 5;
        byArray3[1679] = 35;
        byArray3[1680] = 73;
        byArray3[1681] = -80;
        byArray3[1682] = -87;
        byArray3[1683] = 80;
        byArray3[1684] = 13;
        byArray3[1685] = 108;
        byArray3[1686] = 1;
        byArray3[1687] = 82;
        byArray3[1688] = -56;
        byArray3[1689] = -35;
        byArray3[1690] = -21;
        byArray3[1691] = -78;
        byArray3[1692] = -98;
        byArray3[1693] = 121;
        byArray3[1694] = 112;
        byArray3[1695] = -117;
        byArray3[1696] = 72;
        byArray3[1697] = 47;
        byArray3[1698] = 76;
        byArray3[1699] = -97;
        byArray3[1700] = -84;
        byArray3[1701] = -110;
        byArray3[1702] = -35;
        byArray3[1703] = -19;
        byArray3[1704] = -120;
        byArray3[1705] = -13;
        byArray3[1706] = 127;
        byArray3[1707] = 5;
        byArray3[1708] = 56;
        byArray3[1709] = 72;
        byArray3[1710] = -22;
        byArray3[1711] = 110;
        byArray3[1712] = -8;
        byArray3[1713] = -71;
        byArray3[1715] = -57;
        byArray3[1716] = -125;
        byArray3[1717] = -101;
        byArray3[1718] = 60;
        byArray3[1719] = -64;
        byArray3[1720] = -32;
        byArray3[1721] = 1;
        byArray3[1722] = 126;
        byArray3[1723] = -109;
        byArray3[1724] = 9;
        byArray3[1725] = 84;
        byArray3[1726] = 117;
        byArray3[1727] = 62;
        byArray3[1728] = -68;
        byArray3[1729] = -106;
        byArray3[1730] = 28;
        byArray3[1731] = -118;
        byArray3[1732] = -52;
        byArray3[1733] = -81;
        byArray3[1734] = 112;
        byArray3[1735] = 11;
        byArray3[1736] = 55;
        byArray3[1737] = 68;
        byArray3[1738] = -86;
        byArray3[1739] = -65;
        byArray3[1740] = 123;
        byArray3[1741] = 83;
        byArray3[1742] = 55;
        byArray3[1743] = -72;
        byArray3[1744] = 110;
        byArray3[1745] = 63;
        byArray3[1746] = -90;
        byArray3[1747] = 31;
        byArray3[1748] = 11;
        byArray3[1749] = 90;
        byArray3[1750] = -60;
        byArray3[1751] = 20;
        byArray3[1752] = 14;
        byArray3[1753] = -36;
        byArray3[1754] = 5;
        byArray3[1755] = -92;
        byArray3[1756] = 11;
        byArray3[1757] = -100;
        byArray3[1758] = 64;
        byArray3[1759] = -57;
        byArray3[1760] = -72;
        byArray3[1761] = -105;
        byArray3[1762] = 7;
        byArray3[1763] = 103;
        byArray3[1764] = 125;
        byArray3[1765] = 99;
        byArray3[1766] = -88;
        byArray3[1767] = 32;
        byArray3[1768] = -5;
        byArray3[1769] = 41;
        byArray3[1770] = -115;
        byArray3[1771] = -11;
        byArray3[1772] = 89;
        byArray3[1773] = 81;
        byArray3[1774] = 77;
        byArray3[1775] = -33;
        byArray3[1776] = -7;
        byArray3[1777] = -123;
        byArray3[1778] = -17;
        byArray3[1779] = 109;
        byArray3[1780] = 59;
        byArray3[1781] = 40;
        byArray3[1782] = -12;
        byArray3[1783] = -61;
        byArray3[1784] = 98;
        byArray3[1785] = -91;
        byArray3[1786] = 19;
        byArray3[1787] = -36;
        byArray3[1788] = 108;
        byArray3[1789] = 118;
        byArray3[1790] = -124;
        byArray3[1791] = -82;
        byArray3[1792] = -40;
        byArray3[1793] = -124;
        byArray3[1794] = -66;
        byArray3[1795] = 19;
        byArray3[1796] = 127;
        byArray3[1797] = -73;
        byArray3[1798] = -39;
        byArray3[1799] = 99;
        byArray3[1800] = 43;
        byArray3[1801] = -16;
        byArray3[1802] = -44;
        byArray3[1803] = -83;
        byArray3[1804] = -77;
        byArray3[1805] = -34;
        byArray3[1806] = 68;
        byArray3[1807] = -118;
        byArray3[1808] = -71;
        byArray3[1809] = -116;
        byArray3[1810] = 114;
        byArray3[1811] = 120;
        byArray3[1812] = -34;
        byArray3[1813] = -105;
        byArray3[1814] = -32;
        byArray3[1815] = -46;
        byArray3[1816] = 102;
        byArray3[1817] = 73;
        byArray3[1818] = -79;
        byArray3[1819] = 7;
        byArray3[1820] = 42;
        byArray3[1821] = 35;
        byArray3[1822] = -66;
        byArray3[1823] = 125;
        byArray3[1824] = 34;
        byArray3[1825] = 113;
        byArray3[1826] = 66;
        byArray3[1827] = 78;
        byArray3[1828] = 71;
        byArray3[1829] = 6;
        byArray3[1830] = 44;
        byArray3[1831] = -17;
        byArray3[1832] = 4;
        byArray3[1833] = -80;
        byArray3[1834] = 38;
        byArray3[1835] = -59;
        byArray3[1836] = 12;
        byArray3[1837] = -8;
        byArray3[1838] = -78;
        byArray3[1839] = 103;
        byArray3[1840] = 8;
        byArray3[1841] = 80;
        byArray3[1842] = 18;
        byArray3[1843] = -74;
        byArray3[1844] = 20;
        byArray3[1845] = 3;
        byArray3[1846] = 56;
        byArray3[1847] = -20;
        byArray3[1848] = 106;
        byArray3[1849] = -1;
        byArray3[1850] = -12;
        byArray3[1851] = 83;
        byArray3[1852] = 4;
        byArray3[1853] = 68;
        byArray3[1854] = -119;
        byArray3[1855] = 84;
        byArray3[1856] = -87;
        byArray3[1857] = 97;
        byArray3[1858] = -53;
        byArray3[1859] = 102;
        byArray3[1860] = 119;
        byArray3[1861] = 34;
        byArray3[1862] = -85;
        byArray3[1863] = 22;
        byArray3[1864] = -26;
        byArray3[1865] = 55;
        byArray3[1866] = -107;
        byArray3[1867] = 96;
        byArray3[1868] = -70;
        byArray3[1869] = 77;
        byArray3[1870] = -68;
        byArray3[1871] = -96;
        byArray3[1872] = -15;
        byArray3[1873] = -22;
        byArray3[1874] = -77;
        byArray3[1875] = -55;
        byArray3[1876] = 5;
        byArray3[1877] = 103;
        byArray3[1878] = -42;
        byArray3[1879] = -87;
        byArray3[1880] = 122;
        byArray3[1881] = -80;
        byArray3[1882] = -103;
        byArray3[1883] = -37;
        byArray3[1884] = -120;
        byArray3[1885] = -56;
        byArray3[1886] = -16;
        byArray3[1887] = -51;
        byArray3[1888] = -7;
        byArray3[1889] = -19;
        byArray3[1890] = -104;
        byArray3[1891] = 120;
        byArray3[1892] = 9;
        byArray3[1893] = 54;
        byArray3[1894] = -85;
        byArray3[1895] = 48;
        byArray3[1896] = -76;
        byArray3[1897] = -38;
        byArray3[1898] = 58;
        byArray3[1899] = -68;
        byArray3[1900] = 116;
        byArray3[1901] = -20;
        byArray3[1902] = -44;
        byArray3[1903] = 22;
        byArray3[1904] = -32;
        byArray3[1905] = 75;
        byArray3[1906] = -46;
        byArray3[1907] = -41;
        byArray3[1908] = 13;
        byArray3[1909] = -100;
        byArray3[1910] = 16;
        byArray3[1911] = -59;
        byArray3[1912] = -93;
        byArray3[1913] = -115;
        byArray3[1914] = 54;
        byArray3[1915] = 22;
        byArray3[1916] = -110;
        byArray3[1917] = -46;
        byArray3[1918] = -119;
        byArray3[1919] = 44;
        byArray3[1920] = -98;
        byArray3[1921] = -48;
        byArray3[1922] = 4;
        byArray3[1923] = -58;
        byArray3[1924] = -115;
        byArray3[1925] = -57;
        byArray3[1926] = 103;
        byArray3[1927] = -56;
        byArray3[1928] = 36;
        byArray3[1929] = -63;
        byArray3[1930] = 104;
        byArray3[1931] = -114;
        byArray3[1932] = -125;
        byArray3[1933] = 92;
        byArray3[1934] = 65;
        byArray3[1935] = 117;
        byArray3[1936] = -21;
        byArray3[1937] = -59;
        byArray3[1938] = -31;
        byArray3[1939] = 56;
        byArray3[1940] = -98;
        byArray3[1941] = -126;
        byArray3[1942] = 56;
        byArray3[1943] = 47;
        byArray3[1944] = -116;
        byArray3[1945] = 100;
        byArray3[1946] = 122;
        byArray3[1947] = -98;
        byArray3[1948] = 4;
        byArray3[1949] = 26;
        byArray3[1950] = -29;
        byArray3[1951] = -127;
        byArray3[1952] = -113;
        byArray3[1953] = 73;
        byArray3[1954] = 48;
        byArray3[1955] = 106;
        byArray3[1956] = 125;
        byArray3[1957] = -69;
        byArray3[1958] = -127;
        byArray3[1959] = 62;
        byArray3[1960] = 56;
        byArray3[1961] = -79;
        byArray3[1962] = 76;
        byArray3[1963] = 84;
        byArray3[1964] = -46;
        byArray3[1965] = -31;
        byArray3[1966] = -17;
        byArray3[1967] = 94;
        byArray3[1968] = -98;
        byArray3[1969] = 62;
        byArray3[1970] = 63;
        byArray3[1971] = 118;
        byArray3[1972] = -24;
        byArray3[1973] = 63;
        byArray3[1974] = 123;
        byArray3[1975] = -93;
        byArray3[1976] = -46;
        byArray3[1977] = 103;
        byArray3[1978] = 117;
        byArray3[1979] = -120;
        byArray3[1980] = -35;
        byArray3[1981] = 19;
        byArray3[1982] = 25;
        byArray3[1983] = 15;
        byArray3[1984] = -110;
        byArray3[1985] = -125;
        byArray3[1986] = 12;
        byArray3[1987] = -75;
        byArray3[1988] = -50;
        byArray3[1989] = 103;
        byArray3[1990] = 49;
        byArray3[1991] = 47;
        byArray3[1992] = 98;
        byArray3[1993] = 92;
        byArray3[1994] = 10;
        byArray3[1995] = -88;
        byArray3[1996] = 54;
        byArray3[1997] = -53;
        byArray3[1998] = 19;
        byArray3[1999] = 25;
        byArray3[2000] = -90;
        byArray3[2001] = 93;
        byArray3[2002] = -49;
        byArray3[2003] = 64;
        byArray3[2004] = 126;
        byArray3[2005] = -106;
        byArray3[2006] = -30;
        byArray3[2007] = -52;
        byArray3[2008] = 58;
        byArray3[2009] = 37;
        byArray3[2010] = 68;
        byArray3[2011] = -18;
        byArray3[2012] = -60;
        byArray3[2013] = 15;
        byArray3[2014] = -27;
        byArray3[2015] = 93;
        byArray3[2016] = -124;
        byArray3[2017] = 88;
        byArray3[2018] = 110;
        byArray3[2019] = -80;
        byArray3[2020] = -106;
        byArray3[2021] = 88;
        byArray3[2022] = 55;
        byArray3[2023] = 108;
        byArray3[2024] = -58;
        byArray3[2025] = -43;
        byArray3[2026] = -70;
        byArray3[2027] = 76;
        byArray3[2028] = 85;
        byArray3[2029] = 98;
        byArray3[2030] = 27;
        byArray3[2031] = -66;
        byArray3[2032] = 18;
        byArray3[2033] = 75;
        byArray3[2034] = 69;
        byArray3[2035] = 114;
        byArray3[2036] = 90;
        byArray3[2037] = -26;
        byArray3[2038] = -10;
        byArray3[2039] = -12;
        byArray3[2040] = -126;
        byArray3[2041] = 84;
        byArray3[2042] = -109;
        byArray3[2043] = 108;
        byArray3[2044] = 15;
        byArray3[2045] = -115;
        byArray3[2046] = 90;
        byArray3[2047] = 11;
        byArray3[2048] = -127;
        byArray3[2049] = 63;
        byArray3[2050] = -7;
        byArray3[2051] = 47;
        byArray3[2052] = 92;
        byArray3[2053] = -72;
        byArray3[2054] = 38;
        byArray3[2055] = -58;
        byArray3[2056] = -35;
        byArray3[2057] = 18;
        byArray3[2058] = 25;
        byArray3[2059] = 12;
        byArray3[2060] = -103;
        pubBytes = byArray3;
        fullBytes = new byte[pubBytes.length + privBytes.length];
        System.arraycopy(pubBytes, 0, fullBytes, 0, pubBytes.length);
        System.arraycopy(privBytes, 0, fullBytes, pubBytes.length, privBytes.length);
        priv = new NTRUEncryptionPrivateKeyParameters(fullBytes, params.getEncryptionParameters());
        pub = new NTRUEncryptionPublicKeyParameters(pubBytes, params.getEncryptionParameters());
        kp = new AsymmetricCipherKeyPair(pub, priv);
        ntru.init(true, kp.getPublic());
        encrypted = ntru.processBlock(plainText, 0, plainText.length);
        ntru.init(false, kp.getPrivate());
        byte[] decrypted = ntru.processBlock(encrypted, 0, encrypted.length);
        NTRUEncryptTest.assertTrue((boolean)Arrays.areEqual(plainText, decrypted));
    }

    public void testEncodedKeysFast() throws IOException, InvalidCipherTextException {
        byte[] plainText = "secret encrypted text".getBytes();
        NTRUEncryptionKeyGenerationParameters params = NTRUEncryptionKeyGenerationParameters.APR2011_743_FAST;
        NTRUEngine ntru = new NTRUEngine();
        byte[] byArray = new byte[106];
        byArray[0] = 10;
        byArray[1] = 16;
        byArray[2] = 2;
        byArray[3] = 30;
        byArray[4] = -40;
        byArray[5] = -63;
        byArray[6] = -109;
        byArray[7] = -77;
        byArray[8] = -72;
        byArray[9] = -122;
        byArray[10] = 66;
        byArray[11] = 23;
        byArray[12] = -30;
        byArray[13] = -44;
        byArray[14] = -82;
        byArray[16] = 95;
        byArray[17] = 64;
        byArray[18] = 68;
        byArray[19] = 48;
        byArray[20] = -62;
        byArray[21] = -14;
        byArray[22] = 26;
        byArray[23] = -19;
        byArray[24] = -72;
        byArray[25] = -25;
        byArray[26] = 72;
        byArray[27] = 123;
        byArray[28] = 98;
        byArray[29] = 84;
        byArray[30] = -83;
        byArray[32] = 7;
        byArray[33] = 40;
        byArray[34] = 65;
        byArray[35] = 35;
        byArray[36] = 68;
        byArray[37] = 113;
        byArray[38] = 12;
        byArray[39] = -112;
        byArray[40] = 32;
        byArray[41] = -123;
        byArray[42] = 58;
        byArray[43] = 85;
        byArray[44] = -30;
        byArray[45] = -109;
        byArray[46] = -74;
        byArray[48] = 34;
        byArray[49] = -8;
        byArray[50] = -126;
        byArray[51] = 57;
        byArray[52] = 30;
        byArray[53] = 98;
        byArray[54] = -107;
        byArray[55] = -45;
        byArray[56] = -88;
        byArray[57] = 102;
        byArray[58] = 68;
        byArray[59] = 42;
        byArray[60] = -30;
        byArray[61] = -108;
        byArray[62] = -89;
        byArray[64] = 38;
        byArray[65] = -40;
        byArray[66] = -61;
        byArray[67] = 37;
        byArray[68] = 82;
        byArray[69] = 113;
        byArray[70] = -115;
        byArray[71] = 123;
        byArray[72] = -100;
        byArray[73] = 5;
        byArray[74] = 46;
        byArray[75] = 125;
        byArray[76] = -23;
        byArray[77] = 78;
        byArray[78] = -111;
        byArray[79] = -76;
        byArray[80] = 36;
        byArray[81] = -90;
        byArray[82] = 67;
        byArray[83] = -31;
        byArray[84] = 10;
        byArray[85] = 2;
        byArray[86] = 96;
        byArray[87] = -127;
        byArray[88] = 21;
        byArray[89] = 50;
        byArray[90] = -79;
        byArray[91] = 13;
        byArray[92] = -125;
        byArray[93] = -124;
        byArray[94] = 38;
        byArray[95] = 55;
        byArray[96] = -67;
        byArray[97] = -95;
        byArray[98] = 81;
        byArray[99] = -107;
        byArray[100] = 12;
        byArray[101] = 117;
        byArray[102] = -86;
        byArray[103] = 99;
        byArray[104] = -127;
        byArray[105] = 11;
        byte[] privBytes = byArray;
        byte[] byArray2 = new byte[1022];
        byArray2[0] = 108;
        byArray2[1] = -76;
        byArray2[2] = -104;
        byArray2[3] = -75;
        byArray2[4] = -87;
        byArray2[5] = -65;
        byArray2[6] = -18;
        byArray2[7] = -5;
        byArray2[8] = 45;
        byArray2[9] = -57;
        byArray2[10] = -100;
        byArray2[11] = -83;
        byArray2[12] = 51;
        byArray2[13] = 99;
        byArray2[14] = 94;
        byArray2[15] = 15;
        byArray2[16] = -73;
        byArray2[17] = 89;
        byArray2[18] = -100;
        byArray2[19] = 40;
        byArray2[20] = -114;
        byArray2[21] = 91;
        byArray2[22] = -107;
        byArray2[23] = 104;
        byArray2[24] = 127;
        byArray2[25] = 22;
        byArray2[26] = 13;
        byArray2[27] = 5;
        byArray2[28] = -16;
        byArray2[29] = 69;
        byArray2[30] = -104;
        byArray2[31] = -126;
        byArray2[32] = -44;
        byArray2[33] = 119;
        byArray2[34] = 47;
        byArray2[35] = -48;
        byArray2[36] = 75;
        byArray2[37] = 66;
        byArray2[38] = 83;
        byArray2[39] = -37;
        byArray2[40] = -66;
        byArray2[41] = -84;
        byArray2[42] = 73;
        byArray2[43] = 52;
        byArray2[44] = 23;
        byArray2[45] = -27;
        byArray2[46] = 53;
        byArray2[47] = 63;
        byArray2[48] = 56;
        byArray2[49] = 14;
        byArray2[50] = -2;
        byArray2[51] = 43;
        byArray2[52] = -59;
        byArray2[53] = -85;
        byArray2[54] = -80;
        byArray2[55] = 46;
        byArray2[56] = 38;
        byArray2[57] = -126;
        byArray2[58] = 75;
        byArray2[59] = -8;
        byArray2[60] = -63;
        byArray2[61] = 88;
        byArray2[62] = 104;
        byArray2[63] = 13;
        byArray2[64] = 72;
        byArray2[65] = -25;
        byArray2[66] = -10;
        byArray2[67] = -58;
        byArray2[68] = -51;
        byArray2[69] = 117;
        byArray2[70] = -84;
        byArray2[71] = 115;
        byArray2[72] = -24;
        byArray2[73] = -53;
        byArray2[74] = 83;
        byArray2[75] = -103;
        byArray2[76] = -97;
        byArray2[77] = 46;
        byArray2[78] = 90;
        byArray2[79] = -82;
        byArray2[80] = -61;
        byArray2[81] = 113;
        byArray2[82] = -49;
        byArray2[83] = -24;
        byArray2[84] = -72;
        byArray2[85] = 24;
        byArray2[86] = -124;
        byArray2[87] = -42;
        byArray2[88] = -36;
        byArray2[89] = 7;
        byArray2[90] = 41;
        byArray2[91] = 8;
        byArray2[92] = 14;
        byArray2[93] = -71;
        byArray2[94] = -75;
        byArray2[95] = -84;
        byArray2[96] = -24;
        byArray2[97] = -39;
        byArray2[98] = 56;
        byArray2[99] = 67;
        byArray2[100] = 88;
        byArray2[101] = 67;
        byArray2[102] = 66;
        byArray2[103] = -13;
        byArray2[104] = 70;
        byArray2[105] = -119;
        byArray2[106] = -64;
        byArray2[107] = 74;
        byArray2[108] = -100;
        byArray2[109] = -58;
        byArray2[110] = 35;
        byArray2[111] = 105;
        byArray2[112] = -20;
        byArray2[113] = 93;
        byArray2[114] = 80;
        byArray2[115] = -116;
        byArray2[116] = -55;
        byArray2[117] = 37;
        byArray2[118] = -52;
        byArray2[119] = 64;
        byArray2[121] = -36;
        byArray2[122] = -71;
        byArray2[123] = 8;
        byArray2[124] = 77;
        byArray2[125] = -10;
        byArray2[126] = -41;
        byArray2[127] = -22;
        byArray2[128] = -73;
        byArray2[129] = 4;
        byArray2[130] = -115;
        byArray2[131] = -74;
        byArray2[132] = -74;
        byArray2[133] = -73;
        byArray2[134] = 23;
        byArray2[135] = -10;
        byArray2[136] = -26;
        byArray2[137] = 48;
        byArray2[138] = 125;
        byArray2[139] = -114;
        byArray2[140] = -32;
        byArray2[141] = -116;
        byArray2[142] = 74;
        byArray2[143] = 19;
        byArray2[144] = -104;
        byArray2[145] = 59;
        byArray2[146] = 43;
        byArray2[147] = 4;
        byArray2[148] = 97;
        byArray2[149] = -84;
        byArray2[150] = 112;
        byArray2[151] = 45;
        byArray2[152] = 16;
        byArray2[153] = 3;
        byArray2[154] = -110;
        byArray2[155] = -13;
        byArray2[156] = 119;
        byArray2[157] = -6;
        byArray2[158] = 29;
        byArray2[159] = -80;
        byArray2[160] = 109;
        byArray2[161] = 82;
        byArray2[162] = -31;
        byArray2[163] = 82;
        byArray2[164] = 30;
        byArray2[165] = 76;
        byArray2[166] = -111;
        byArray2[167] = -122;
        byArray2[168] = -50;
        byArray2[169] = -69;
        byArray2[170] = -41;
        byArray2[171] = -123;
        byArray2[172] = 107;
        byArray2[173] = 78;
        byArray2[174] = -35;
        byArray2[175] = 24;
        byArray2[176] = -121;
        byArray2[177] = -87;
        byArray2[178] = -108;
        byArray2[179] = 13;
        byArray2[180] = 70;
        byArray2[181] = 32;
        byArray2[182] = -74;
        byArray2[183] = 112;
        byArray2[184] = 104;
        byArray2[185] = -40;
        byArray2[186] = -61;
        byArray2[187] = 86;
        byArray2[188] = -125;
        byArray2[189] = 60;
        byArray2[190] = -94;
        byArray2[191] = -5;
        byArray2[192] = -18;
        byArray2[193] = 55;
        byArray2[194] = 54;
        byArray2[195] = -128;
        byArray2[196] = 83;
        byArray2[197] = -88;
        byArray2[198] = 71;
        byArray2[199] = 71;
        byArray2[200] = -66;
        byArray2[201] = 29;
        byArray2[202] = -113;
        byArray2[203] = 120;
        byArray2[204] = 30;
        byArray2[205] = 16;
        byArray2[206] = -38;
        byArray2[207] = 37;
        byArray2[208] = 96;
        byArray2[209] = -90;
        byArray2[210] = 38;
        byArray2[211] = -85;
        byArray2[212] = 88;
        byArray2[213] = 59;
        byArray2[214] = 15;
        byArray2[215] = -69;
        byArray2[216] = 6;
        byArray2[217] = -8;
        byArray2[218] = 1;
        byArray2[219] = 1;
        byArray2[220] = 71;
        byArray2[221] = 12;
        byArray2[222] = 60;
        byArray2[223] = -26;
        byArray2[224] = -110;
        byArray2[225] = 97;
        byArray2[226] = 77;
        byArray2[227] = 33;
        byArray2[228] = 58;
        byArray2[229] = 63;
        byArray2[230] = 104;
        byArray2[231] = 108;
        byArray2[232] = 83;
        byArray2[233] = 72;
        byArray2[234] = -21;
        byArray2[235] = -99;
        byArray2[236] = 115;
        byArray2[237] = -125;
        byArray2[238] = -16;
        byArray2[239] = 12;
        byArray2[240] = 99;
        byArray2[241] = 68;
        byArray2[242] = 39;
        byArray2[243] = -97;
        byArray2[244] = -6;
        byArray2[245] = 17;
        byArray2[246] = 26;
        byArray2[247] = -59;
        byArray2[248] = 123;
        byArray2[249] = -110;
        byArray2[250] = -37;
        byArray2[251] = -71;
        byArray2[252] = 47;
        byArray2[253] = 50;
        byArray2[254] = 5;
        byArray2[255] = 110;
        byArray2[256] = -34;
        byArray2[257] = 89;
        byArray2[258] = -74;
        byArray2[259] = 20;
        byArray2[260] = 79;
        byArray2[261] = -108;
        byArray2[262] = -7;
        byArray2[263] = 42;
        byArray2[264] = 106;
        byArray2[265] = -112;
        byArray2[266] = 44;
        byArray2[267] = 107;
        byArray2[268] = 106;
        byArray2[269] = -50;
        byArray2[270] = 55;
        byArray2[271] = 127;
        byArray2[272] = -124;
        byArray2[273] = 53;
        byArray2[274] = 123;
        byArray2[275] = -119;
        byArray2[276] = -46;
        byArray2[277] = -114;
        byArray2[278] = -52;
        byArray2[279] = -85;
        byArray2[280] = 75;
        byArray2[281] = 34;
        byArray2[282] = -39;
        byArray2[283] = -125;
        byArray2[284] = 58;
        byArray2[285] = -5;
        byArray2[286] = -31;
        byArray2[287] = -81;
        byArray2[288] = -37;
        byArray2[289] = -94;
        byArray2[290] = -123;
        byArray2[291] = 113;
        byArray2[292] = 11;
        byArray2[293] = -104;
        byArray2[294] = -124;
        byArray2[295] = 96;
        byArray2[296] = -103;
        byArray2[297] = 9;
        byArray2[298] = 108;
        byArray2[299] = 115;
        byArray2[300] = 97;
        byArray2[301] = -6;
        byArray2[302] = 98;
        byArray2[303] = -43;
        byArray2[304] = 26;
        byArray2[305] = -89;
        byArray2[306] = -23;
        byArray2[307] = 83;
        byArray2[308] = 60;
        byArray2[309] = 34;
        byArray2[310] = -86;
        byArray2[311] = -54;
        byArray2[312] = 107;
        byArray2[313] = 78;
        byArray2[314] = -48;
        byArray2[315] = 118;
        byArray2[316] = -31;
        byArray2[317] = -19;
        byArray2[318] = 29;
        byArray2[319] = -106;
        byArray2[320] = 108;
        byArray2[321] = 117;
        byArray2[322] = 83;
        byArray2[323] = 119;
        byArray2[324] = 51;
        byArray2[325] = -45;
        byArray2[326] = 115;
        byArray2[327] = 108;
        byArray2[328] = -13;
        byArray2[329] = -89;
        byArray2[330] = -29;
        byArray2[331] = 29;
        byArray2[332] = -120;
        byArray2[333] = 108;
        byArray2[334] = 20;
        byArray2[335] = 22;
        byArray2[336] = -3;
        byArray2[337] = 22;
        byArray2[338] = 78;
        byArray2[339] = -109;
        byArray2[340] = 95;
        byArray2[341] = 3;
        byArray2[342] = -68;
        byArray2[343] = -10;
        byArray2[344] = -53;
        byArray2[345] = -117;
        byArray2[346] = -96;
        byArray2[347] = -49;
        byArray2[348] = 9;
        byArray2[349] = 7;
        byArray2[350] = 38;
        byArray2[351] = 116;
        byArray2[352] = 33;
        byArray2[353] = -65;
        byArray2[354] = 31;
        byArray2[355] = 9;
        byArray2[356] = -5;
        byArray2[357] = -73;
        byArray2[358] = 127;
        byArray2[359] = 52;
        byArray2[360] = 113;
        byArray2[361] = 87;
        byArray2[362] = -39;
        byArray2[363] = 119;
        byArray2[364] = -96;
        byArray2[365] = 74;
        byArray2[366] = -105;
        byArray2[367] = 75;
        byArray2[368] = -89;
        byArray2[369] = 63;
        byArray2[370] = 69;
        byArray2[371] = -109;
        byArray2[372] = -127;
        byArray2[373] = 92;
        byArray2[374] = -54;
        byArray2[375] = 17;
        byArray2[376] = -98;
        byArray2[377] = -23;
        byArray2[378] = -69;
        byArray2[379] = 123;
        byArray2[380] = -125;
        byArray2[381] = 23;
        byArray2[382] = -93;
        byArray2[383] = 44;
        byArray2[384] = -11;
        byArray2[385] = -25;
        byArray2[386] = -101;
        byArray2[387] = 120;
        byArray2[388] = -29;
        byArray2[389] = 113;
        byArray2[390] = -33;
        byArray2[392] = -117;
        byArray2[393] = -100;
        byArray2[394] = -114;
        byArray2[395] = 22;
        byArray2[396] = 41;
        byArray2[397] = -46;
        byArray2[398] = 29;
        byArray2[399] = -109;
        byArray2[400] = 107;
        byArray2[401] = 37;
        byArray2[402] = -94;
        byArray2[403] = 125;
        byArray2[404] = 46;
        byArray2[405] = 17;
        byArray2[406] = 16;
        byArray2[407] = -65;
        byArray2[408] = -14;
        byArray2[409] = 105;
        byArray2[410] = -118;
        byArray2[411] = 51;
        byArray2[412] = -21;
        byArray2[413] = 121;
        byArray2[414] = -5;
        byArray2[415] = 56;
        byArray2[416] = 29;
        byArray2[417] = 30;
        byArray2[418] = -69;
        byArray2[419] = -38;
        byArray2[420] = -10;
        byArray2[421] = -77;
        byArray2[422] = -74;
        byArray2[423] = 6;
        byArray2[424] = -105;
        byArray2[425] = 83;
        byArray2[426] = 110;
        byArray2[427] = 23;
        byArray2[428] = 114;
        byArray2[429] = -11;
        byArray2[430] = -123;
        byArray2[431] = -14;
        byArray2[432] = 30;
        byArray2[433] = -11;
        byArray2[434] = -9;
        byArray2[435] = 84;
        byArray2[436] = -90;
        byArray2[437] = -20;
        byArray2[438] = -29;
        byArray2[439] = 72;
        byArray2[440] = -85;
        byArray2[441] = 97;
        byArray2[442] = -74;
        byArray2[443] = -59;
        byArray2[444] = -112;
        byArray2[445] = -15;
        byArray2[446] = -51;
        byArray2[447] = -105;
        byArray2[448] = 117;
        byArray2[449] = 123;
        byArray2[450] = -17;
        byArray2[451] = -64;
        byArray2[452] = -127;
        byArray2[453] = 127;
        byArray2[454] = -33;
        byArray2[455] = -102;
        byArray2[456] = 88;
        byArray2[457] = 77;
        byArray2[458] = 122;
        byArray2[459] = -127;
        byArray2[460] = -15;
        byArray2[461] = 121;
        byArray2[462] = -125;
        byArray2[463] = -32;
        byArray2[464] = 53;
        byArray2[465] = 113;
        byArray2[466] = 45;
        byArray2[467] = -22;
        byArray2[468] = 84;
        byArray2[469] = -87;
        byArray2[470] = 20;
        byArray2[471] = 36;
        byArray2[472] = 65;
        byArray2[473] = 83;
        byArray2[474] = -84;
        byArray2[475] = -66;
        byArray2[476] = -22;
        byArray2[477] = 4;
        byArray2[478] = 15;
        byArray2[479] = -108;
        byArray2[480] = -92;
        byArray2[481] = 109;
        byArray2[482] = -128;
        byArray2[483] = -48;
        byArray2[484] = 4;
        byArray2[485] = -27;
        byArray2[486] = -13;
        byArray2[487] = 25;
        byArray2[488] = 51;
        byArray2[489] = -10;
        byArray2[490] = 34;
        byArray2[491] = 87;
        byArray2[492] = 88;
        byArray2[493] = 38;
        byArray2[494] = -87;
        byArray2[495] = 89;
        byArray2[496] = -64;
        byArray2[497] = -62;
        byArray2[498] = 20;
        byArray2[499] = 78;
        byArray2[500] = 35;
        byArray2[501] = -26;
        byArray2[502] = -2;
        byArray2[503] = 55;
        byArray2[504] = 3;
        byArray2[505] = -72;
        byArray2[506] = -64;
        byArray2[507] = 30;
        byArray2[508] = 28;
        byArray2[509] = -105;
        byArray2[510] = 6;
        byArray2[511] = -37;
        byArray2[512] = -38;
        byArray2[513] = -8;
        byArray2[514] = 26;
        byArray2[515] = -118;
        byArray2[516] = 105;
        byArray2[517] = -37;
        byArray2[518] = -30;
        byArray2[519] = 85;
        byArray2[520] = -66;
        byArray2[521] = 105;
        byArray2[522] = -46;
        byArray2[523] = -37;
        byArray2[524] = -11;
        byArray2[525] = -72;
        byArray2[526] = 71;
        byArray2[527] = 43;
        byArray2[528] = -65;
        byArray2[529] = -44;
        byArray2[530] = 17;
        byArray2[531] = -79;
        byArray2[532] = 98;
        byArray2[533] = 79;
        byArray2[534] = -77;
        byArray2[535] = -111;
        byArray2[536] = 95;
        byArray2[537] = 74;
        byArray2[538] = 101;
        byArray2[539] = -40;
        byArray2[540] = -106;
        byArray2[541] = 14;
        byArray2[542] = -108;
        byArray2[543] = -112;
        byArray2[544] = 86;
        byArray2[545] = 108;
        byArray2[546] = 49;
        byArray2[547] = 72;
        byArray2[548] = -38;
        byArray2[549] = -103;
        byArray2[550] = -31;
        byArray2[551] = 65;
        byArray2[552] = -119;
        byArray2[553] = 8;
        byArray2[554] = 78;
        byArray2[555] = -89;
        byArray2[556] = 100;
        byArray2[557] = -28;
        byArray2[558] = 116;
        byArray2[559] = 94;
        byArray2[560] = 15;
        byArray2[561] = -18;
        byArray2[562] = 108;
        byArray2[563] = 101;
        byArray2[564] = 85;
        byArray2[565] = 8;
        byArray2[566] = -6;
        byArray2[567] = 111;
        byArray2[568] = -82;
        byArray2[569] = -49;
        byArray2[570] = -66;
        byArray2[571] = -89;
        byArray2[572] = 28;
        byArray2[573] = -84;
        byArray2[574] = -85;
        byArray2[575] = -119;
        byArray2[576] = 111;
        byArray2[577] = 45;
        byArray2[578] = 83;
        byArray2[579] = -60;
        byArray2[580] = -40;
        byArray2[581] = -45;
        byArray2[582] = -101;
        byArray2[583] = -105;
        byArray2[584] = -35;
        byArray2[585] = 123;
        byArray2[586] = -1;
        byArray2[587] = 13;
        byArray2[588] = -112;
        byArray2[589] = 79;
        byArray2[590] = -80;
        byArray2[591] = -85;
        byArray2[592] = -109;
        byArray2[593] = -71;
        byArray2[594] = 69;
        byArray2[595] = 104;
        byArray2[596] = 95;
        byArray2[597] = -93;
        byArray2[598] = 121;
        byArray2[599] = -17;
        byArray2[600] = 83;
        byArray2[601] = 117;
        byArray2[602] = -73;
        byArray2[603] = -63;
        byArray2[604] = -65;
        byArray2[605] = -107;
        byArray2[606] = -72;
        byArray2[607] = 118;
        byArray2[608] = -102;
        byArray2[609] = -56;
        byArray2[610] = 38;
        byArray2[611] = 79;
        byArray2[612] = 121;
        byArray2[613] = -25;
        byArray2[614] = -86;
        byArray2[615] = -81;
        byArray2[616] = -38;
        byArray2[617] = 8;
        byArray2[618] = 122;
        byArray2[619] = 97;
        byArray2[620] = 37;
        byArray2[621] = 82;
        byArray2[622] = -40;
        byArray2[623] = 53;
        byArray2[624] = 11;
        byArray2[625] = 124;
        byArray2[626] = -94;
        byArray2[627] = -76;
        byArray2[628] = -107;
        byArray2[629] = -125;
        byArray2[630] = -9;
        byArray2[631] = -119;
        byArray2[632] = 63;
        byArray2[633] = 52;
        byArray2[634] = -34;
        byArray2[635] = -72;
        byArray2[636] = -21;
        byArray2[637] = 59;
        byArray2[638] = 3;
        byArray2[639] = -100;
        byArray2[640] = -127;
        byArray2[641] = 47;
        byArray2[642] = -102;
        byArray2[643] = 19;
        byArray2[644] = -37;
        byArray2[645] = -45;
        byArray2[646] = -114;
        byArray2[647] = -65;
        byArray2[648] = 39;
        byArray2[649] = -106;
        byArray2[650] = 6;
        byArray2[651] = -127;
        byArray2[652] = -110;
        byArray2[653] = -38;
        byArray2[654] = 96;
        byArray2[655] = -38;
        byArray2[656] = -51;
        byArray2[657] = 110;
        byArray2[658] = -3;
        byArray2[659] = 28;
        byArray2[660] = 8;
        byArray2[661] = 102;
        byArray2[662] = -102;
        byArray2[663] = 96;
        byArray2[664] = -127;
        byArray2[665] = 109;
        byArray2[666] = -56;
        byArray2[667] = -53;
        byArray2[668] = -13;
        byArray2[669] = 59;
        byArray2[670] = -98;
        byArray2[671] = 92;
        byArray2[672] = 80;
        byArray2[673] = 1;
        byArray2[674] = 55;
        byArray2[675] = -91;
        byArray2[676] = -122;
        byArray2[677] = -105;
        byArray2[678] = 28;
        byArray2[679] = 69;
        byArray2[680] = -85;
        byArray2[681] = 109;
        byArray2[682] = -38;
        byArray2[683] = 105;
        byArray2[684] = 87;
        byArray2[685] = -5;
        byArray2[686] = 3;
        byArray2[687] = -102;
        byArray2[688] = 62;
        byArray2[689] = -92;
        byArray2[690] = 60;
        byArray2[691] = 43;
        byArray2[692] = -20;
        byArray2[693] = -7;
        byArray2[694] = -23;
        byArray2[695] = -84;
        byArray2[696] = 106;
        byArray2[697] = 121;
        byArray2[698] = -48;
        byArray2[699] = 123;
        byArray2[700] = -112;
        byArray2[701] = 56;
        byArray2[702] = -17;
        byArray2[703] = -52;
        byArray2[704] = 14;
        byArray2[705] = -123;
        byArray2[706] = -122;
        byArray2[707] = 64;
        byArray2[708] = 14;
        byArray2[709] = -23;
        byArray2[710] = -71;
        byArray2[711] = 60;
        byArray2[712] = 70;
        byArray2[713] = -121;
        byArray2[714] = 6;
        byArray2[715] = 37;
        byArray2[716] = -15;
        byArray2[717] = 77;
        byArray2[718] = 96;
        byArray2[719] = 104;
        byArray2[720] = -34;
        byArray2[721] = 58;
        byArray2[722] = -125;
        byArray2[723] = -61;
        byArray2[724] = 1;
        byArray2[725] = -26;
        byArray2[726] = 118;
        byArray2[727] = -78;
        byArray2[728] = -35;
        byArray2[729] = -1;
        byArray2[731] = 5;
        byArray2[732] = 33;
        byArray2[733] = -98;
        byArray2[734] = -86;
        byArray2[735] = -127;
        byArray2[736] = 25;
        byArray2[737] = 56;
        byArray2[738] = -91;
        byArray2[739] = 82;
        byArray2[740] = -33;
        byArray2[741] = 60;
        byArray2[742] = -64;
        byArray2[743] = -86;
        byArray2[744] = 27;
        byArray2[745] = 31;
        byArray2[746] = -80;
        byArray2[747] = -79;
        byArray2[748] = 118;
        byArray2[749] = -12;
        byArray2[750] = -18;
        byArray2[751] = 40;
        byArray2[752] = -72;
        byArray2[753] = 32;
        byArray2[754] = 119;
        byArray2[755] = -28;
        byArray2[756] = -62;
        byArray2[757] = 100;
        byArray2[758] = -121;
        byArray2[759] = -71;
        byArray2[760] = -79;
        byArray2[761] = -9;
        byArray2[762] = 38;
        byArray2[763] = -37;
        byArray2[764] = 25;
        byArray2[765] = 65;
        byArray2[766] = -46;
        byArray2[767] = 8;
        byArray2[768] = -112;
        byArray2[769] = 37;
        byArray2[770] = 9;
        byArray2[771] = -56;
        byArray2[772] = 123;
        byArray2[773] = -40;
        byArray2[774] = -44;
        byArray2[775] = -90;
        byArray2[776] = -21;
        byArray2[777] = -54;
        byArray2[778] = -2;
        byArray2[779] = -7;
        byArray2[780] = 107;
        byArray2[781] = -93;
        byArray2[782] = 24;
        byArray2[783] = -126;
        byArray2[784] = 69;
        byArray2[785] = 42;
        byArray2[786] = -111;
        byArray2[787] = -84;
        byArray2[788] = 57;
        byArray2[789] = 69;
        byArray2[790] = -119;
        byArray2[791] = 21;
        byArray2[792] = 60;
        byArray2[793] = 57;
        byArray2[794] = -122;
        byArray2[795] = 111;
        byArray2[796] = -99;
        byArray2[797] = 49;
        byArray2[798] = -46;
        byArray2[799] = -119;
        byArray2[800] = 100;
        byArray2[801] = 98;
        byArray2[802] = 24;
        byArray2[803] = -62;
        byArray2[804] = 112;
        byArray2[805] = 122;
        byArray2[806] = 46;
        byArray2[807] = 18;
        byArray2[808] = -35;
        byArray2[809] = -67;
        byArray2[810] = 89;
        byArray2[811] = 104;
        byArray2[812] = 82;
        byArray2[813] = 12;
        byArray2[814] = 125;
        byArray2[815] = 57;
        byArray2[816] = -70;
        byArray2[817] = -112;
        byArray2[818] = -109;
        byArray2[819] = 96;
        byArray2[820] = 51;
        byArray2[821] = -68;
        byArray2[822] = 1;
        byArray2[823] = -101;
        byArray2[824] = -59;
        byArray2[825] = -92;
        byArray2[826] = 54;
        byArray2[827] = 85;
        byArray2[828] = -41;
        byArray2[829] = 17;
        byArray2[830] = 31;
        byArray2[831] = 94;
        byArray2[832] = 75;
        byArray2[833] = -128;
        byArray2[834] = 53;
        byArray2[835] = 84;
        byArray2[837] = -83;
        byArray2[838] = -94;
        byArray2[839] = -123;
        byArray2[840] = 49;
        byArray2[841] = -30;
        byArray2[842] = -24;
        byArray2[843] = 18;
        byArray2[844] = 46;
        byArray2[845] = 48;
        byArray2[846] = -33;
        byArray2[847] = 120;
        byArray2[848] = 66;
        byArray2[849] = -69;
        byArray2[850] = 70;
        byArray2[851] = 23;
        byArray2[852] = -124;
        byArray2[853] = -117;
        byArray2[854] = 81;
        byArray2[855] = 96;
        byArray2[856] = 46;
        byArray2[857] = 47;
        byArray2[858] = -33;
        byArray2[859] = 83;
        byArray2[860] = -13;
        byArray2[861] = -14;
        byArray2[862] = -94;
        byArray2[863] = 49;
        byArray2[864] = 66;
        byArray2[865] = -46;
        byArray2[866] = 84;
        byArray2[867] = -27;
        byArray2[868] = -77;
        byArray2[869] = 6;
        byArray2[871] = -75;
        byArray2[872] = -18;
        byArray2[873] = 86;
        byArray2[874] = -119;
        byArray2[875] = -88;
        byArray2[876] = 82;
        byArray2[877] = -50;
        byArray2[878] = 55;
        byArray2[879] = -20;
        byArray2[880] = 63;
        byArray2[881] = 55;
        byArray2[882] = -57;
        byArray2[883] = 22;
        byArray2[884] = -108;
        byArray2[885] = -103;
        byArray2[886] = -17;
        byArray2[887] = -22;
        byArray2[888] = 64;
        byArray2[889] = 65;
        byArray2[890] = 90;
        byArray2[891] = -34;
        byArray2[892] = -96;
        byArray2[893] = -117;
        byArray2[894] = 51;
        byArray2[895] = 119;
        byArray2[896] = -103;
        byArray2[897] = -35;
        byArray2[898] = 95;
        byArray2[899] = -15;
        byArray2[900] = -118;
        byArray2[901] = 2;
        byArray2[902] = -31;
        byArray2[903] = 31;
        byArray2[904] = -9;
        byArray2[905] = -58;
        byArray2[906] = 84;
        byArray2[907] = -75;
        byArray2[908] = 80;
        byArray2[909] = 39;
        byArray2[910] = -101;
        byArray2[911] = -56;
        byArray2[912] = 16;
        byArray2[913] = -75;
        byArray2[914] = 59;
        byArray2[915] = 48;
        byArray2[916] = -63;
        byArray2[917] = -24;
        byArray2[918] = -95;
        byArray2[919] = 119;
        byArray2[920] = 73;
        byArray2[921] = -110;
        byArray2[922] = -115;
        byArray2[923] = 49;
        byArray2[924] = -18;
        byArray2[925] = 54;
        byArray2[926] = -124;
        byArray2[927] = 112;
        byArray2[928] = -61;
        byArray2[929] = -40;
        byArray2[930] = -105;
        byArray2[931] = -118;
        byArray2[932] = -66;
        byArray2[933] = 15;
        byArray2[934] = -107;
        byArray2[935] = 75;
        byArray2[936] = 82;
        byArray2[937] = -70;
        byArray2[938] = -87;
        byArray2[939] = -11;
        byArray2[940] = -11;
        byArray2[941] = 48;
        byArray2[942] = 41;
        byArray2[943] = 119;
        byArray2[944] = -42;
        byArray2[945] = -34;
        byArray2[946] = -33;
        byArray2[947] = 57;
        byArray2[948] = 23;
        byArray2[949] = -14;
        byArray2[950] = -45;
        byArray2[951] = -125;
        byArray2[952] = -108;
        byArray2[953] = -75;
        byArray2[954] = 3;
        byArray2[955] = 44;
        byArray2[956] = 44;
        byArray2[957] = 58;
        byArray2[958] = 126;
        byArray2[959] = -126;
        byArray2[960] = -20;
        byArray2[961] = -123;
        byArray2[962] = 58;
        byArray2[963] = 114;
        byArray2[964] = 79;
        byArray2[965] = -102;
        byArray2[966] = -115;
        byArray2[967] = 115;
        byArray2[968] = 12;
        byArray2[969] = 66;
        byArray2[970] = 108;
        byArray2[971] = 84;
        byArray2[972] = 43;
        byArray2[973] = -46;
        byArray2[974] = -80;
        byArray2[975] = -41;
        byArray2[976] = -70;
        byArray2[977] = 111;
        byArray2[978] = -114;
        byArray2[979] = 123;
        byArray2[980] = 21;
        byArray2[981] = 1;
        byArray2[982] = 34;
        byArray2[983] = -72;
        byArray2[984] = 23;
        byArray2[985] = 105;
        byArray2[986] = -52;
        byArray2[987] = -39;
        byArray2[988] = -54;
        byArray2[989] = -119;
        byArray2[990] = 45;
        byArray2[991] = 77;
        byArray2[992] = -16;
        byArray2[993] = -66;
        byArray2[994] = -105;
        byArray2[995] = -11;
        byArray2[996] = 91;
        byArray2[997] = -46;
        byArray2[998] = 77;
        byArray2[999] = -104;
        byArray2[1000] = -93;
        byArray2[1001] = 52;
        byArray2[1002] = -3;
        byArray2[1003] = 17;
        byArray2[1004] = 55;
        byArray2[1005] = -10;
        byArray2[1006] = 67;
        byArray2[1007] = -33;
        byArray2[1008] = 43;
        byArray2[1009] = 75;
        byArray2[1010] = -103;
        byArray2[1011] = 106;
        byArray2[1012] = 7;
        byArray2[1013] = -35;
        byArray2[1014] = -65;
        byArray2[1015] = -21;
        byArray2[1016] = 68;
        byArray2[1017] = 118;
        byArray2[1018] = -38;
        byArray2[1019] = 59;
        byArray2[1020] = -115;
        byArray2[1021] = 31;
        byte[] pubBytes = byArray2;
        byte[] fullBytes = new byte[pubBytes.length + privBytes.length];
        System.arraycopy(pubBytes, 0, fullBytes, 0, pubBytes.length);
        System.arraycopy(privBytes, 0, fullBytes, pubBytes.length, privBytes.length);
        NTRUEncryptionPrivateKeyParameters priv = new NTRUEncryptionPrivateKeyParameters(fullBytes, params.getEncryptionParameters());
        NTRUEncryptionPublicKeyParameters pub = new NTRUEncryptionPublicKeyParameters(pubBytes, params.getEncryptionParameters());
        AsymmetricCipherKeyPair kp = new AsymmetricCipherKeyPair(pub, priv);
        ntru.init(true, kp.getPublic());
        byte[] encrypted = ntru.processBlock(plainText, 0, plainText.length);
        NTRUEncryptTest.assertEquals((int)encrypted.length, (int)ntru.getOutputBlockSize());
        ntru.init(false, kp.getPrivate());
        byte[] decrypted = ntru.processBlock(encrypted, 0, encrypted.length);
        NTRUEncryptTest.assertTrue((boolean)Arrays.areEqual(plainText, decrypted));
    }

    private class VisibleNTRUEngine
    extends NTRUEngine {
        private VisibleNTRUEngine() {
        }

        @Override
        public IntegerPolynomial encrypt(IntegerPolynomial m, TernaryPolynomial r, IntegerPolynomial pubKey) {
            return super.encrypt(m, r, pubKey);
        }

        @Override
        public IntegerPolynomial decrypt(IntegerPolynomial e, Polynomial priv_t, IntegerPolynomial priv_fp) {
            return super.decrypt(e, priv_t, priv_fp);
        }
    }
}

