/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.IOException;
import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.pqc.crypto.xmss.XMSSMT;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import org.bouncycastle.util.Arrays;

public class XMSSMTPublicKeyTest
extends TestCase {
    public void testPublicKeyParsingSHA256() throws IOException, ClassNotFoundException {
        XMSSMTParameters params = new XMSSMTParameters(20, 10, new SHA256Digest());
        XMSSMT mt = new XMSSMT(params, new SecureRandom());
        mt.generateKeys();
        byte[] privateKey = mt.exportPrivateKey();
        byte[] publicKey = mt.exportPublicKey();
        mt.importState(privateKey, publicKey);
        XMSSMTPublicKeyTest.assertTrue((boolean)Arrays.areEqual(publicKey, mt.exportPublicKey()));
    }

    public void testConstructor() {
        XMSSMTParameters params = new XMSSMTParameters(20, 10, new SHA256Digest());
        XMSSMTPublicKeyParameters pk = new XMSSMTPublicKeyParameters.Builder(params).build();
        byte[] pkByte = pk.toByteArray();
        int i = 0;
        while (i < pkByte.length) {
            XMSSMTPublicKeyTest.assertEquals((int)0, (int)pkByte[i]);
            ++i;
        }
    }
}

