/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.IOException;
import junit.framework.TestCase;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import org.bouncycastle.util.Arrays;

public class XMSSPrivateKeyTest
extends TestCase {
    public void testPrivateKeyParsing() throws ClassNotFoundException, IOException {
        XMSSParameters params = new XMSSParameters(10, new SHA256Digest());
        byte[] byArray = new byte[32];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 16;
        byArray[17] = 32;
        byArray[18] = 48;
        byArray[19] = 3;
        byArray[20] = 64;
        byArray[21] = 80;
        byArray[22] = 96;
        byArray[23] = 112;
        byArray[24] = -128;
        byArray[25] = -112;
        byArray[26] = -96;
        byArray[27] = -80;
        byArray[28] = -64;
        byArray[29] = -48;
        byArray[30] = -32;
        byArray[31] = -16;
        byte[] root = byArray;
        XMSSPrivateKeyParameters privateKey = new XMSSPrivateKeyParameters.Builder(params).withRoot(root).build();
        byte[] export = privateKey.toByteArray();
        XMSSPrivateKeyParameters privateKey2 = new XMSSPrivateKeyParameters.Builder(params).withPrivateKey(export, params).build();
        XMSSPrivateKeyTest.assertEquals((int)privateKey.getIndex(), (int)privateKey2.getIndex());
        XMSSPrivateKeyTest.assertEquals((boolean)true, (boolean)Arrays.areEqual(privateKey.getSecretKeySeed(), privateKey2.getSecretKeySeed()));
        XMSSPrivateKeyTest.assertEquals((boolean)true, (boolean)Arrays.areEqual(privateKey.getSecretKeyPRF(), privateKey2.getSecretKeyPRF()));
        XMSSPrivateKeyTest.assertEquals((boolean)true, (boolean)Arrays.areEqual(privateKey.getPublicSeed(), privateKey2.getPublicSeed()));
        XMSSPrivateKeyTest.assertEquals((boolean)true, (boolean)Arrays.areEqual(privateKey.getRoot(), privateKey2.getRoot()));
    }
}

