/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.math.BigInteger;
import java.util.Arrays;
import junit.framework.TestCase;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.util.Pack;

public class XMSSUtilTest
extends TestCase {
    public void testLog2() {
        XMSSUtilTest.assertEquals((int)3, (int)XMSSUtil.log2(8));
        XMSSUtilTest.assertEquals((int)3, (int)XMSSUtil.log2(10));
        XMSSUtilTest.assertEquals((int)26, (int)XMSSUtil.log2(100010124));
    }

    public void testIntToBytesBigEndian() {
        byte[] b = XMSSUtil.toBytesBigEndian(1L, 4);
        XMSSUtilTest.assertEquals((int)4, (int)b.length);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[0]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[1]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[2]);
        XMSSUtilTest.assertEquals((byte)1, (byte)b[3]);
        b = XMSSUtil.toBytesBigEndian(1L, 6);
        XMSSUtilTest.assertEquals((int)6, (int)b.length);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[0]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[1]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[2]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[3]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[4]);
        XMSSUtilTest.assertEquals((byte)1, (byte)b[5]);
        b = XMSSUtil.toBytesBigEndian(1L, 32);
        XMSSUtilTest.assertEquals((int)32, (int)b.length);
        int i = 0;
        while (i < 31) {
            XMSSUtilTest.assertEquals((byte)0, (byte)b[i]);
            ++i;
        }
        b = XMSSUtil.toBytesBigEndian(12345L, 5);
        XMSSUtilTest.assertEquals((int)5, (int)b.length);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[0]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[1]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[2]);
        XMSSUtilTest.assertEquals((byte)48, (byte)b[3]);
        XMSSUtilTest.assertEquals((byte)57, (byte)b[4]);
    }

    public void testLongToBytesBigEndian() {
        byte[] b = XMSSUtil.toBytesBigEndian(1L, 8);
        XMSSUtilTest.assertEquals((int)8, (int)b.length);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[0]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[1]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[2]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[3]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[4]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[5]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[6]);
        XMSSUtilTest.assertEquals((byte)1, (byte)b[7]);
        b = XMSSUtil.toBytesBigEndian(1L, 10);
        XMSSUtilTest.assertEquals((int)10, (int)b.length);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[0]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[1]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[2]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[3]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[4]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[5]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[6]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[7]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[8]);
        XMSSUtilTest.assertEquals((byte)1, (byte)b[9]);
        b = XMSSUtil.toBytesBigEndian(1L, 32);
        int i = 0;
        while (i < 31) {
            XMSSUtilTest.assertEquals((byte)0, (byte)b[i]);
            ++i;
        }
        XMSSUtilTest.assertEquals((byte)1, (byte)b[31]);
        b = XMSSUtil.toBytesBigEndian(12345L, 9);
        XMSSUtilTest.assertEquals((int)9, (int)b.length);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[0]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[1]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[2]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[3]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[4]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[5]);
        XMSSUtilTest.assertEquals((byte)0, (byte)b[6]);
        XMSSUtilTest.assertEquals((byte)48, (byte)b[7]);
        XMSSUtilTest.assertEquals((byte)57, (byte)b[8]);
    }

    public void testLongToBytesBigEndianOffsetException() {
        try {
            byte[] in = new byte[8];
            Pack.longToBigEndian(1L, in, 1);
            XMSSUtilTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLongToBytesBigEndianOffset() {
        byte[] in = new byte[32];
        Pack.longToBigEndian(12345L, in, 5);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[0]);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[1]);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[2]);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[3]);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[4]);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[5]);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[6]);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[7]);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[8]);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[9]);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[10]);
        XMSSUtilTest.assertEquals((byte)48, (byte)in[11]);
        XMSSUtilTest.assertEquals((byte)57, (byte)in[12]);
        int i = 14;
        while (i < in.length) {
            XMSSUtilTest.assertEquals((byte)0, (byte)in[i]);
            ++i;
        }
        in = new byte[32];
        Pack.longToBigEndian(12345L, in, 24);
        i = 0;
        while (i < 24) {
            XMSSUtilTest.assertEquals((byte)0, (byte)in[i]);
            ++i;
        }
        XMSSUtilTest.assertEquals((byte)0, (byte)in[28]);
        XMSSUtilTest.assertEquals((byte)0, (byte)in[29]);
        XMSSUtilTest.assertEquals((byte)48, (byte)in[30]);
        XMSSUtilTest.assertEquals((byte)57, (byte)in[31]);
    }

    public void testBytesToIntBigEndianException() {
        byte[] in = new byte[4];
        try {
            Pack.bigEndianToInt(in, 1);
            XMSSUtilTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBytesToIntBigEndian() {
        byte[] byArray = new byte[4];
        byArray[1] = -1;
        byArray[3] = -1;
        byte[] in1 = byArray;
        int out = Pack.bigEndianToInt(in1, 0);
        XMSSUtilTest.assertEquals((int)0xFF00FF, (int)out);
        byte[] in2 = new byte[]{-85, -51, -17, -86};
        out = Pack.bigEndianToInt(in2, 0);
        XMSSUtilTest.assertEquals((String)"2882400170", (String)new BigInteger(1, in2).toString());
        byte[] in3 = new byte[100];
        Arrays.fill(in3, (byte)-86);
        int i = 35;
        while (i < 39) {
            in3[i] = -1;
            ++i;
        }
        out = Pack.bigEndianToInt(in3, 35);
        XMSSUtilTest.assertEquals((Object)new BigInteger("4294967295"), (Object)BigInteger.valueOf((long)out & 0xFFFFFFFFL));
    }

    public void testBytesToLongBigEndianException() {
        byte[] in = new byte[10];
        try {
            Pack.bigEndianToLong(in, 3);
            XMSSUtilTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBytesToLongBigEndian() {
        byte[] byArray = new byte[8];
        byArray[1] = -1;
        byArray[3] = -1;
        byArray[5] = -1;
        byArray[7] = -1;
        byte[] in1 = byArray;
        long out = Pack.bigEndianToLong(in1, 0);
        XMSSUtilTest.assertEquals((long)0xFF00FF00FF00FFL, (long)out);
        byte[] in2 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        out = Pack.bigEndianToLong(in2, 0);
        XMSSUtilTest.assertEquals((String)"18446744073709551615", (String)new BigInteger(1, in2).toString());
    }

    public void testCalculateTau() {
        int height = 10;
        int index = 0;
        while (index < 1024) {
            XMSSUtilTest.assertEquals((int)0, (int)XMSSUtil.calculateTau(index, height));
            index += 2;
        }
        XMSSUtilTest.assertEquals((int)9, (int)XMSSUtil.calculateTau(511, height));
    }
}

