/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import org.bouncycastle.util.Pack;

final class OTSHashAddress
extends XMSSAddress {
    private static final int TYPE = 0;
    private final int otsAddress;
    private final int chainAddress;
    private final int hashAddress;

    private OTSHashAddress(Builder builder) {
        super(builder);
        this.otsAddress = builder.otsAddress;
        this.chainAddress = builder.chainAddress;
        this.hashAddress = builder.hashAddress;
    }

    @Override
    protected byte[] toByteArray() {
        byte[] byteRepresentation = super.toByteArray();
        Pack.intToBigEndian(this.otsAddress, byteRepresentation, 16);
        Pack.intToBigEndian(this.chainAddress, byteRepresentation, 20);
        Pack.intToBigEndian(this.hashAddress, byteRepresentation, 24);
        return byteRepresentation;
    }

    protected int getOTSAddress() {
        return this.otsAddress;
    }

    protected int getChainAddress() {
        return this.chainAddress;
    }

    protected int getHashAddress() {
        return this.hashAddress;
    }

    /* synthetic */ OTSHashAddress(Builder builder, OTSHashAddress oTSHashAddress) {
        this(builder);
    }

    protected static class Builder
    extends XMSSAddress.Builder<Builder> {
        private int otsAddress = 0;
        private int chainAddress = 0;
        private int hashAddress = 0;

        protected Builder() {
            super(0);
        }

        protected Builder withOTSAddress(int val) {
            this.otsAddress = val;
            return this;
        }

        protected Builder withChainAddress(int val) {
            this.chainAddress = val;
            return this;
        }

        protected Builder withHashAddress(int val) {
            this.hashAddress = val;
            return this;
        }

        @Override
        protected XMSSAddress build() {
            return new OTSHashAddress(this, null);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

